/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.fanarttv;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.fanarttv.FanartTv;
import org.tinymediamanager.scraper.fanarttv.entities.Image;
import org.tinymediamanager.scraper.fanarttv.entities.Images;
import org.tinymediamanager.scraper.mediaprovider.IMovieArtworkProvider;
import org.tinymediamanager.scraper.mediaprovider.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.util.ApiKey;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import retrofit2.Response;

@PluginImplementation
public class FanartTvMetadataProvider
implements IMovieArtworkProvider,
ITvShowArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FanartTvMetadataProvider.class);
    private static final String TMM_API_KEY = ApiKey.decryptApikey((String)"2gkQtSYPIxfyThxPXveHiCGXEcqJJwClUDrB5JV60OnQeQ85Ft65kFIk1SBKoge3");
    private static MediaProviderInfo providerInfo = FanartTvMetadataProvider.createMediaProviderInfo();
    private static FanartTv api = null;

    private static MediaProviderInfo createMediaProviderInfo() {
        MediaProviderInfo providerInfo = new MediaProviderInfo("fanarttv", "fanart.tv", "<html><h3>Fanart.tv</h3><br />Fanart.tv provides a huge library of artwork for movies, TV shows and music.<br />Does not provide movie poster</html>", FanartTvMetadataProvider.class.getResource("/fanart_tv.png"));
        providerInfo.setVersion(FanartTvMetadataProvider.class);
        providerInfo.getConfig().addText("clientKey", "", true);
        providerInfo.getConfig().load();
        return providerInfo;
    }

    private static synchronized void initAPI() throws ScrapeException {
        String clientKey;
        if (api == null) {
            try {
                api = new FanartTv();
                api.setApiKey(TMM_API_KEY);
            }
            catch (Exception e) {
                LOGGER.error("FanartTvMetadataProvider", (Throwable)e);
                throw new ScrapeException((Throwable)e);
            }
        }
        if (!(clientKey = providerInfo.getConfig().getValue("clientKey")).equals(api.getClientKey())) {
            api.setClientKey(clientKey);
        }
    }

    public MediaProviderInfo getProviderInfo() {
        return providerInfo;
    }

    public List<MediaArtwork> getArtwork(MediaScrapeOptions options) throws ScrapeException, MissingIdException {
        List<MediaArtwork> artwork;
        LOGGER.debug("getArtwork() - {}", (Object)options);
        FanartTvMetadataProvider.initAPI();
        switch (options.getType()) {
            case MOVIE: 
            case MOVIE_SET: {
                artwork = this.getMovieArtwork(options);
                break;
            }
            case TV_SHOW: {
                artwork = this.getTvShowArtwork(options);
                break;
            }
            default: {
                artwork = new ArrayList<MediaArtwork>(1);
            }
        }
        MediaMetadata md = options.getMetadata();
        if (md != null && !artwork.isEmpty()) {
            md.addMediaArt(artwork);
        }
        return artwork;
    }

    private List<MediaArtwork> getMovieArtwork(MediaScrapeOptions options) throws ScrapeException, MissingIdException {
        MediaArtwork.MediaArtworkType artworkType = options.getArtworkType();
        String language = null;
        if (options.getLanguage() != null) {
            language = options.getLanguage().getLanguage();
            if (StringUtils.isNotBlank((CharSequence)options.getLanguage().getCountry())) {
                language = language + "-" + options.getLanguage().getCountry();
            }
        }
        List<MediaArtwork> returnArtwork = new ArrayList<MediaArtwork>();
        Response images = null;
        String imdbId = options.getImdbId();
        int tmdbId = options.getTmdbId();
        if (tmdbId == 0 && !MetadataUtil.isValidImdbId((String)imdbId)) {
            throw new MissingIdException(new String[]{"imdb", "tmdb"});
        }
        Exception savedException = null;
        if (StringUtils.isNotBlank((CharSequence)imdbId)) {
            try {
                LOGGER.debug("getArtwork with IMDB id: {}", (Object)imdbId);
                images = api.getMovieService().getMovieImages(imdbId).execute();
            }
            catch (Exception e) {
                LOGGER.debug("failed to get artwork: {}", (Object)e.getMessage());
                savedException = e;
            }
        }
        if ((images == null || images.body() == null) && tmdbId != 0) {
            try {
                LOGGER.debug("getArtwork with TMDB id: {}", (Object)tmdbId);
                images = api.getMovieService().getMovieImages(Integer.toString(tmdbId)).execute();
            }
            catch (Exception e) {
                LOGGER.debug("failed to get artwork: {}", (Object)e.getMessage());
                savedException = e;
            }
        }
        if (!(images != null && images.isSuccessful() || savedException == null)) {
            if (savedException instanceof InterruptedException || savedException instanceof InterruptedIOException) {
                return returnArtwork;
            }
            throw new ScrapeException((Throwable)savedException);
        }
        if (images == null) {
            LOGGER.info("got no result");
            return returnArtwork;
        }
        if (!images.isSuccessful()) {
            String message = "";
            try {
                message = images.errorBody().string();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            LOGGER.warn("request was not successful: HTTP/{} - {}", (Object)images.code(), (Object)message);
            return returnArtwork;
        }
        returnArtwork = this.getArtwork((Images)images.body(), artworkType);
        returnArtwork.sort((Comparator<MediaArtwork>)new MediaArtwork.MediaArtworkComparator(language));
        return returnArtwork;
    }

    private List<MediaArtwork> getTvShowArtwork(MediaScrapeOptions options) throws ScrapeException, MissingIdException {
        MediaArtwork.MediaArtworkType artworkType = options.getArtworkType();
        String language = null;
        if (options.getLanguage() != null) {
            language = options.getLanguage().getLanguage();
            if (StringUtils.isNotBlank((CharSequence)options.getLanguage().getCountry())) {
                language = language + "-" + options.getLanguage().getCountry();
            }
        }
        List<MediaArtwork> returnArtwork = new ArrayList<MediaArtwork>();
        int tvdbId = options.getIdAsInt("tvdb");
        if (tvdbId == 0) {
            tvdbId = options.getIdAsInt("tvdb");
        }
        if (tvdbId == 0) {
            throw new MissingIdException(new String[]{"tvdb"});
        }
        Response images = null;
        try {
            LOGGER.debug("getArtwork with TVDB id: {}", (Object)tvdbId);
            images = api.getTvShowService().getTvShowImages(tvdbId).execute();
        }
        catch (Exception e) {
            LOGGER.debug("failed to get artwork: {}", (Object)e.getMessage());
            if (e instanceof InterruptedException || e instanceof InterruptedException) {
                return returnArtwork;
            }
            throw new ScrapeException((Throwable)e);
        }
        if (images == null) {
            LOGGER.info("got no result");
            return returnArtwork;
        }
        if (!images.isSuccessful()) {
            String message = "";
            try {
                message = images.errorBody().string();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            LOGGER.warn("request was not successful: HTTP/{} - {}", (Object)images.code(), (Object)message);
            return returnArtwork;
        }
        returnArtwork = this.getArtwork((Images)images.body(), artworkType);
        returnArtwork.sort((Comparator<MediaArtwork>)new MediaArtwork.MediaArtworkComparator(language));
        return returnArtwork;
    }

    private List<MediaArtwork> getArtwork(Images images, MediaArtwork.MediaArtworkType artworkType) {
        ArrayList<MediaArtwork> artworks = new ArrayList<MediaArtwork>();
        switch (artworkType) {
            case POSTER: {
                artworks.addAll(this.prepareArtwork(images.movieposter, ImageType.MOVIEPOSTER));
                artworks.addAll(this.prepareArtwork(images.tvposter, ImageType.TVPOSTER));
                break;
            }
            case BACKGROUND: {
                artworks.addAll(this.prepareArtwork(images.moviebackground, ImageType.MOVIEBACKGROUND));
                artworks.addAll(this.prepareArtwork(images.showbackground, ImageType.SHOWBACKGROUND));
                break;
            }
            case BANNER: {
                artworks.addAll(this.prepareArtwork(images.moviebanner, ImageType.MOVIEBANNER));
                artworks.addAll(this.prepareArtwork(images.tvbanner, ImageType.TVBANNER));
                break;
            }
            case CLEARART: {
                artworks.addAll(this.prepareArtwork(images.hdmovieclearart, ImageType.HDMOVIECLEARART));
                artworks.addAll(this.prepareArtwork(images.movieart, ImageType.MOVIEART));
                artworks.addAll(this.prepareArtwork(images.hdclearart, ImageType.HDCLEARART));
                artworks.addAll(this.prepareArtwork(images.clearart, ImageType.CLEARART));
                break;
            }
            case DISC: {
                artworks.addAll(this.prepareArtwork(images.moviedisc, ImageType.MOVIEDISC));
                break;
            }
            case LOGO: 
            case CLEARLOGO: {
                artworks.addAll(this.prepareArtwork(images.hdmovielogo, ImageType.HDMOVIELOGO));
                artworks.addAll(this.prepareArtwork(images.movielogo, ImageType.MOVIELOGO));
                artworks.addAll(this.prepareArtwork(images.hdtvlogo, ImageType.HDTVLOGO));
                artworks.addAll(this.prepareArtwork(images.clearlogo, ImageType.CLEARLOGO));
                break;
            }
            case SEASON_POSTER: {
                artworks.addAll(this.prepareArtwork(images.seasonposter, ImageType.SEASONPOSTER));
                break;
            }
            case SEASON_BANNER: {
                artworks.addAll(this.prepareArtwork(images.seasonbanner, ImageType.SEASONBANNER));
                break;
            }
            case SEASON_THUMB: {
                artworks.addAll(this.prepareArtwork(images.seasonthumb, ImageType.SEASONTHUMB));
                break;
            }
            case THUMB: {
                artworks.addAll(this.prepareArtwork(images.moviethumb, ImageType.MOVIETHUMB));
                artworks.addAll(this.prepareArtwork(images.tvthumb, ImageType.TVTHUMB));
                break;
            }
            case CHARACTERART: {
                artworks.addAll(this.prepareArtwork(images.characterart, ImageType.CHARACTERART));
                break;
            }
            case KEYART: {
                artworks.addAll(this.prepareArtwork(images.movieposter, ImageType.MOVIEKEYART));
                artworks.addAll(this.prepareArtwork(images.tvposter, ImageType.TVKEYART));
                break;
            }
            case ALL: {
                artworks.addAll(this.prepareArtwork(images.movieposter, ImageType.MOVIEPOSTER));
                artworks.addAll(this.prepareArtwork(images.tvposter, ImageType.TVPOSTER));
                artworks.addAll(this.prepareArtwork(images.moviebackground, ImageType.MOVIEBACKGROUND));
                artworks.addAll(this.prepareArtwork(images.showbackground, ImageType.SHOWBACKGROUND));
                artworks.addAll(this.prepareArtwork(images.moviebanner, ImageType.MOVIEBANNER));
                artworks.addAll(this.prepareArtwork(images.tvbanner, ImageType.TVBANNER));
                artworks.addAll(this.prepareArtwork(images.hdmovieclearart, ImageType.HDMOVIECLEARART));
                artworks.addAll(this.prepareArtwork(images.movieart, ImageType.MOVIEART));
                artworks.addAll(this.prepareArtwork(images.hdclearart, ImageType.HDCLEARART));
                artworks.addAll(this.prepareArtwork(images.clearart, ImageType.CLEARART));
                artworks.addAll(this.prepareArtwork(images.moviedisc, ImageType.MOVIEDISC));
                artworks.addAll(this.prepareArtwork(images.hdmovielogo, ImageType.HDMOVIELOGO));
                artworks.addAll(this.prepareArtwork(images.movielogo, ImageType.MOVIELOGO));
                artworks.addAll(this.prepareArtwork(images.hdtvlogo, ImageType.HDTVLOGO));
                artworks.addAll(this.prepareArtwork(images.clearlogo, ImageType.CLEARLOGO));
                artworks.addAll(this.prepareArtwork(images.seasonbanner, ImageType.SEASONBANNER));
                artworks.addAll(this.prepareArtwork(images.seasonposter, ImageType.SEASONPOSTER));
                artworks.addAll(this.prepareArtwork(images.seasonthumb, ImageType.SEASONTHUMB));
                artworks.addAll(this.prepareArtwork(images.moviethumb, ImageType.MOVIETHUMB));
                artworks.addAll(this.prepareArtwork(images.tvthumb, ImageType.TVTHUMB));
                artworks.addAll(this.prepareArtwork(images.characterart, ImageType.CHARACTERART));
                artworks.addAll(this.prepareArtwork(images.movieposter, ImageType.MOVIEKEYART));
                artworks.addAll(this.prepareArtwork(images.tvposter, ImageType.TVKEYART));
                break;
            }
        }
        return artworks;
    }

    private List<MediaArtwork> prepareArtwork(List<Image> images, ImageType type) {
        ArrayList<MediaArtwork> artworks = new ArrayList<MediaArtwork>();
        for (Image image : ListUtils.nullSafe(images)) {
            if ((type == ImageType.MOVIEKEYART || type == ImageType.TVKEYART) && !"00".equals(image.lang)) continue;
            MediaArtwork ma = new MediaArtwork(providerInfo.getId(), type.type);
            ma.setDefaultUrl(image.url);
            ma.setPreviewUrl(image.url.replace("/fanart/", "/preview/"));
            ma.setLanguage(image.lang);
            ma.setLikes(image.likes);
            ma.addImageSize(type.width, type.height, image.url);
            ma.setSizeOrder(type.sizeOrder);
            if ("all".equals(image.season)) {
                ma.setSeason(0);
            } else {
                try {
                    ma.setSeason(Integer.valueOf(image.season).intValue());
                }
                catch (Exception e) {
                    LOGGER.trace("could not parse int: {}", (Object)e.getMessage());
                }
            }
            artworks.add(ma);
            if (type.type != MediaArtwork.MediaArtworkType.CLEARLOGO) continue;
            artworks.add(new MediaArtwork(ma, MediaArtwork.MediaArtworkType.LOGO));
        }
        return artworks;
    }

    private static enum ImageType {
        HDMOVIECLEARART(1000, 562, MediaArtwork.MediaArtworkType.CLEARART, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        HDCLEARART(1000, 562, MediaArtwork.MediaArtworkType.CLEARART, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        MOVIETHUMB(1000, 562, MediaArtwork.MediaArtworkType.THUMB, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        SEASONTHUMB(1000, 562, MediaArtwork.MediaArtworkType.SEASON_THUMB, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        TVTHUMB(500, 281, MediaArtwork.MediaArtworkType.THUMB, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        MOVIEBACKGROUND(1920, 1080, MediaArtwork.MediaArtworkType.BACKGROUND, MediaArtwork.FanartSizes.LARGE.getOrder()),
        SHOWBACKGROUND(1920, 1080, MediaArtwork.MediaArtworkType.BACKGROUND, MediaArtwork.FanartSizes.LARGE.getOrder()),
        MOVIEPOSTER(1000, 1426, MediaArtwork.MediaArtworkType.POSTER, MediaArtwork.PosterSizes.LARGE.getOrder()),
        MOVIEKEYART(1000, 1426, MediaArtwork.MediaArtworkType.KEYART, MediaArtwork.PosterSizes.LARGE.getOrder()),
        TVPOSTER(1000, 1426, MediaArtwork.MediaArtworkType.POSTER, MediaArtwork.PosterSizes.LARGE.getOrder()),
        TVKEYART(1000, 1426, MediaArtwork.MediaArtworkType.KEYART, MediaArtwork.PosterSizes.LARGE.getOrder()),
        SEASONPOSTER(1000, 1426, MediaArtwork.MediaArtworkType.SEASON_POSTER, MediaArtwork.PosterSizes.LARGE.getOrder()),
        TVBANNER(1000, 185, MediaArtwork.MediaArtworkType.BANNER, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        MOVIEBANNER(1000, 185, MediaArtwork.MediaArtworkType.BANNER, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        SEASONBANNER(1000, 185, MediaArtwork.MediaArtworkType.SEASON_BANNER, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        HDMOVIELOGO(800, 310, MediaArtwork.MediaArtworkType.CLEARLOGO, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        HDTVLOGO(800, 310, MediaArtwork.MediaArtworkType.CLEARLOGO, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        CLEARLOGO(400, 155, MediaArtwork.MediaArtworkType.CLEARLOGO, MediaArtwork.FanartSizes.SMALL.getOrder()),
        MOVIELOGO(400, 155, MediaArtwork.MediaArtworkType.CLEARLOGO, MediaArtwork.FanartSizes.SMALL.getOrder()),
        CLEARART(500, 281, MediaArtwork.MediaArtworkType.CLEARART, MediaArtwork.FanartSizes.SMALL.getOrder()),
        MOVIEART(500, 281, MediaArtwork.MediaArtworkType.CLEARART, MediaArtwork.FanartSizes.SMALL.getOrder()),
        MOVIEDISC(1000, 1000, MediaArtwork.MediaArtworkType.DISC, MediaArtwork.FanartSizes.MEDIUM.getOrder()),
        CHARACTERART(512, 512, MediaArtwork.MediaArtworkType.CHARACTERART, MediaArtwork.FanartSizes.MEDIUM.getOrder());

        int width;
        int height;
        MediaArtwork.MediaArtworkType type;
        int sizeOrder;

        private ImageType(int width, int height, MediaArtwork.MediaArtworkType type, int sizeOrder) {
            this.width = width;
            this.height = height;
            this.type = type;
            this.sizeOrder = sizeOrder;
        }
    }
}

