/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.filter.Filter;
import com.sun.jna.Platform;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.SplashScreen;
import java.awt.Toolkit;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import org.apache.commons.io.IOUtils;
import org.jdesktop.beansbinding.ELProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.InMemoryAppender;
import org.tinymediamanager.LaunchUtil;
import org.tinymediamanager.Log4jBackstop;
import org.tinymediamanager.PreloadTask;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.ThresholdLoggerFilter;
import org.tinymediamanager.TinyMediaManagerCMD;
import org.tinymediamanager.TmmOsUtils;
import org.tinymediamanager.UpgradeTasks;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.TmmModuleManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.scraper.util.PluginManager;
import org.tinymediamanager.thirdparty.KodiRPC;
import org.tinymediamanager.thirdparty.MediaInfoUtils;
import org.tinymediamanager.thirdparty.upnp.Upnp;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmUILogCollector;
import org.tinymediamanager.ui.TmmWindowSaver;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.dialogs.MessageDialog;
import org.tinymediamanager.ui.dialogs.WhatsNewDialog;
import org.tinymediamanager.ui.plaf.dark.TmmDarkLookAndFeel;
import org.tinymediamanager.ui.plaf.light.TmmLightLookAndFeel;
import org.tinymediamanager.ui.wizard.TinyMediaManagerWizard;

public class TinyMediaManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TinyMediaManager.class);

    public static void main(String[] args) {
        TinyMediaManager.setConsoleLogLevel();
        if (args != null && args.length > 0) {
            LOGGER.debug("TMM started with: " + Arrays.toString(args));
            TinyMediaManagerCMD.parseParams(args);
            System.setProperty("java.awt.headless", "true");
        } else {
            String head = System.getProperty("java.awt.headless");
            if (head != null && head.equals("true")) {
                LOGGER.info("TMM started 'headless', and without params -> displaying syntax ");
                TinyMediaManagerCMD.printSyntax();
                TinyMediaManager.shutdownLogger();
                System.exit(0);
            }
        }
        try {
            RandomAccessFile f = new RandomAccessFile("access.test", "rw");
            f.close();
            Files.deleteIfExists(Paths.get("access.test", new String[0]));
        }
        catch (Exception e2) {
            String msg = "Cannot write to TMM directory, have no rights - exiting.";
            if (!GraphicsEnvironment.isHeadless()) {
                JOptionPane.showMessageDialog(null, msg);
            } else {
                System.out.println(msg);
            }
            TinyMediaManager.shutdownLogger();
            System.exit(1);
        }
        String dir = new File(LaunchUtil.getJVMPath()).getParentFile().getParent();
        File jfx = new File(dir, "lib/ext/jfxrt.jar");
        if (!jfx.exists() && (jfx = new File(dir, "lib/jfxrt.jar")).exists()) {
            try {
                TmmOsUtils.addPath(jfx.getAbsolutePath());
            }
            catch (Exception e) {
                LOGGER.debug("failed to load JavaFX - using old styles...");
            }
        }
        LOGGER.info("=====================================================");
        LOGGER.info("=== tinyMediaManager (c) 2012-2019 Manuel Laggner ===");
        LOGGER.info("=====================================================");
        LOGGER.info("tmm.version      : {}", (Object)ReleaseInfo.getRealVersion());
        LOGGER.info("os.name          : {}", (Object)System.getProperty("os.name"));
        LOGGER.info("os.version       : {}", (Object)System.getProperty("os.version"));
        LOGGER.info("os.arch          : {}", (Object)System.getProperty("os.arch"));
        LOGGER.info("java.version     : {}", (Object)System.getProperty("java.version"));
        LOGGER.info("java.maxMem      : {} MiB", (Object)(Runtime.getRuntime().maxMemory() / 1024L / 1024L));
        if (Globals.isRunningJavaWebStart()) {
            LOGGER.info("java.webstart    : true");
        }
        if (Globals.isRunningWebSwing()) {
            LOGGER.info("java.webswing    : true");
        }
        System.setProperty("file.encoding", "UTF-8");
        System.setProperty("sun.jnu.encoding", "UTF-8");
        TinyMediaManager.debugCharacterEncoding("current encoding : ");
        Locale.setDefault(Utils.getLocaleFromLanguage(Globals.settings.getLanguage()));
        LOGGER.info("System language  : {}_{}", (Object)System.getProperty("user.language"), (Object)System.getProperty("user.country"));
        LOGGER.info("GUI language     : {}_{}", (Object)Locale.getDefault().getLanguage(), (Object)Locale.getDefault().getCountry());
        LOGGER.info("Scraper language : {}", (Object)MovieModuleManager.SETTINGS.getScraperLanguage());
        LOGGER.info("TV Scraper lang  : {}", (Object)TvShowModuleManager.SETTINGS.getScraperLanguage());
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                block37: {
                    boolean newVersion = !Globals.settings.isCurrentVersion();
                    try {
                        Thread.setDefaultUncaughtExceptionHandler(new Log4jBackstop());
                        if (!GraphicsEnvironment.isHeadless()) {
                            Thread.currentThread().setName("main");
                        } else {
                            Thread.currentThread().setName("headless");
                            LOGGER.debug("starting without GUI...");
                        }
                        Toolkit tk = Toolkit.getDefaultToolkit();
                        tk.addAWTEventListener(TmmWindowSaver.getInstance(), 64L);
                        if (!GraphicsEnvironment.isHeadless()) {
                            TinyMediaManager.setLookAndFeel();
                        }
                        this.doStartupTasks();
                        org.jdesktop.beansbinding.util.logging.Logger.getLogger((String)ELProperty.class.getName()).setLevel(java.util.logging.Level.SEVERE);
                        TmmUILogCollector.init();
                        LOGGER.info("=====================================================");
                        SplashScreen splash = null;
                        if (!GraphicsEnvironment.isHeadless()) {
                            splash = SplashScreen.getSplashScreen();
                        }
                        Graphics2D g2 = null;
                        if (splash != null) {
                            g2 = splash.createGraphics();
                            if (g2 != null) {
                                Font font = new Font("Dialog", 0, 11);
                                g2.setFont(font);
                                g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_LCD_HRGB);
                            } else {
                                LOGGER.debug("got no graphics from splash");
                            }
                        } else {
                            LOGGER.debug("no splash found");
                        }
                        if (g2 != null) {
                            this.updateProgress(g2, "starting tinyMediaManager", 0);
                            splash.update();
                        }
                        LOGGER.info("starting tinyMediaManager");
                        String oldVersion = Globals.settings.getVersion();
                        if (newVersion) {
                            if (g2 != null) {
                                this.updateProgress(g2, "upgrading to new version", 10);
                                splash.update();
                            }
                            UpgradeTasks.performUpgradeTasksBeforeDatabaseLoading(oldVersion);
                            Globals.settings.setCurrentVersion();
                            Globals.settings.saveSettings();
                        }
                        if (Globals.settings.useProxy()) {
                            LOGGER.info("setting proxy");
                            Globals.settings.setProxy();
                        }
                        if (g2 != null) {
                            this.updateProgress(g2, "loading MediaInfo libs", 20);
                            splash.update();
                        }
                        MediaInfoUtils.loadMediaInfo();
                        if (g2 != null) {
                            this.updateProgress(g2, "loading movie module", 30);
                            splash.update();
                        }
                        TmmModuleManager.getInstance().startUp();
                        TmmModuleManager.getInstance().registerModule(MovieModuleManager.getInstance());
                        TmmModuleManager.getInstance().enableModule(MovieModuleManager.getInstance());
                        if (g2 != null) {
                            this.updateProgress(g2, "loading TV show module", 40);
                            splash.update();
                        }
                        TmmModuleManager.getInstance().registerModule(TvShowModuleManager.getInstance());
                        TmmModuleManager.getInstance().enableModule(TvShowModuleManager.getInstance());
                        if (g2 != null) {
                            this.updateProgress(g2, "loading plugins", 50);
                            splash.update();
                        }
                        PluginManager.getInstance();
                        if (ReleaseInfo.isGitBuild()) {
                            PluginManager.getInstance().loadClasspathPlugins();
                        }
                        PluginManager.getInstance().afterInitialization();
                        if (g2 != null) {
                            this.updateProgress(g2, "starting services", 60);
                            splash.update();
                        }
                        Upnp u = Upnp.getInstance();
                        if (Globals.settings.isUpnpShareLibrary()) {
                            u.startWebServer();
                            u.createUpnpService();
                            u.startMediaServer();
                        }
                        if (Globals.settings.isUpnpRemotePlay()) {
                            u.createUpnpService();
                            u.sendPlayerSearchRequest();
                            u.startWebServer();
                        }
                        try {
                            KodiRPC.getInstance().connect();
                        }
                        catch (Exception e) {
                            LOGGER.error(e.getMessage());
                        }
                        if (newVersion) {
                            if (g2 != null) {
                                this.updateProgress(g2, "upgrading database to new version", 70);
                                splash.update();
                            }
                            UpgradeTasks.performUpgradeTasksAfterDatabaseLoading(oldVersion);
                        }
                        if (g2 != null) {
                            this.updateProgress(g2, "loading ui", 80);
                            splash.update();
                        }
                        if (!GraphicsEnvironment.isHeadless()) {
                            MainWindow window = new MainWindow("tinyMediaManager / " + ReleaseInfo.getRealVersion());
                            if (g2 != null) {
                                this.updateProgress(g2, "finished starting :)", 100);
                                splash.update();
                            }
                            TmmWindowSaver.getInstance().loadSettings(window);
                            window.setVisible(true);
                            if (Globals.settings.isNewConfig()) {
                                TinyMediaManagerWizard wizard = new TinyMediaManagerWizard();
                                wizard.setVisible(true);
                            }
                            TmmTaskManager.getInstance().addUnnamedTask(new PreloadTask());
                            if (newVersion && !ReleaseInfo.getVersion().equals(oldVersion)) {
                                this.showChangelog();
                            }
                            break block37;
                        }
                        TinyMediaManagerCMD.startCommandLineTasks();
                        while (TmmTaskManager.getInstance().poolRunning()) {
                            Thread.sleep(2000L);
                        }
                        LOGGER.info("bye bye");
                        try {
                            TmmTaskManager.getInstance().shutdown();
                            TmmModuleManager.getInstance().saveSettings();
                            TmmTaskManager.getInstance().shutdownNow();
                            TmmModuleManager.getInstance().shutDown();
                        }
                        catch (Exception ex) {
                            LOGGER.warn(ex.getMessage());
                        }
                        TinyMediaManager.shutdownLogger();
                        System.exit(0);
                    }
                    catch (IllegalStateException e) {
                        LOGGER.error("IllegalStateException", (Throwable)e);
                        if (!GraphicsEnvironment.isHeadless() && e.getMessage().contains("file is locked")) {
                            ResourceBundle bundle = ResourceBundle.getBundle("messages", new UTF8Control());
                            MessageDialog dialog = new MessageDialog(null, bundle.getString("tmm.problemdetected"));
                            dialog.setImage(IconManager.ERROR);
                            dialog.setText(bundle.getString("tmm.nostart"));
                            dialog.setDescription(bundle.getString("tmm.nostart.instancerunning"));
                            dialog.setResizable(true);
                            dialog.pack();
                            dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                            dialog.setAlwaysOnTop(true);
                            dialog.setVisible(true);
                        }
                        TinyMediaManager.shutdownLogger();
                        System.exit(1);
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception while start of tmm", (Throwable)e);
                        if (!GraphicsEnvironment.isHeadless()) {
                            MessageDialog.showExceptionWindow(e);
                        }
                        TinyMediaManager.shutdownLogger();
                        System.exit(1);
                    }
                }
            }

            private void updateProgress(Graphics2D g2, String text, int progress) {
                g2.setComposite(AlphaComposite.Clear);
                g2.fillRect(50, 350, 230, 100);
                g2.setPaintMode();
                g2.setColor(new Color(134, 134, 134));
                g2.drawString(text + "...", 51, 390);
                int l = g2.getFontMetrics().stringWidth(ReleaseInfo.getRealVersion());
                g2.drawString(ReleaseInfo.getRealVersion(), 277 - l, 443);
                g2.setColor(new Color(20, 20, 20));
                g2.fillRoundRect(51, 400, 227, 6, 6, 6);
                g2.setColor(new Color(134, 134, 134));
                g2.fillRoundRect(51, 400, 227 * progress / 100, 6, 6, 6);
                LOGGER.debug("Startup (" + progress + "%) " + text);
            }

            private void doStartupTasks() {
                File desktop;
                UpgradeTasks.renameDownloadedFiles();
                Utils.extractTemplates();
                Utils.cleanOldLogs();
                Path db = Paths.get(Settings.getInstance().getSettingsFolder(), new String[0]);
                Utils.createBackupFile(db);
                Utils.deleteOldBackupFile(db, 5);
                if (Platform.isLinux() && !(desktop = new File("tinyMediaManager.desktop")).exists()) {
                    TmmOsUtils.createDesktopFileForLinux(desktop);
                }
            }

            private void showChangelog() {
                WhatsNewDialog.showChangelog();
            }
        });
    }

    public static void setLookAndFeel() throws Exception {
        String laf;
        String themeDefaultFont = "Dialog";
        String fontFamily = Globals.settings.getFontFamily();
        try {
            fontFamily = Font.decode(fontFamily).getFamily();
        }
        catch (Exception e) {
            try {
                fontFamily = Font.decode(themeDefaultFont).getFamily();
            }
            catch (Exception e1) {
                fontFamily = "Dialog";
            }
        }
        int fontSize = Globals.settings.getFontSize();
        if (fontSize < 12) {
            fontSize = 12;
        }
        String fontString = fontFamily + " " + fontSize;
        Properties props = new Properties();
        props.setProperty("controlTextFont", fontString);
        props.setProperty("systemTextFont", fontString);
        props.setProperty("userTextFont", fontString);
        props.setProperty("menuTextFont", fontString);
        props.setProperty("defaultFontSize", Integer.toString(fontSize));
        if (Globals.settings.isSystemWindowDecoration()) {
            props.setProperty("windowDecoration", "system");
        }
        fontSize = Math.round((float)((double)fontSize * 0.833));
        fontString = fontFamily + " " + fontSize;
        props.setProperty("subTextFont", fontString);
        String themeName = Globals.settings.getTheme();
        if ("Dark".equals(themeName)) {
            TmmDarkLookAndFeel.setTheme((Properties)props);
            laf = "org.tinymediamanager.ui.plaf.dark.TmmDarkLookAndFeel";
        } else {
            TmmLightLookAndFeel.setTheme((Properties)props);
            laf = "org.tinymediamanager.ui.plaf.light.TmmLightLookAndFeel";
        }
        UIManager.setLookAndFeel(laf);
    }

    public static void shutdownLogger() {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        Appender appender = loggerContext.getLogger("ROOT").getAppender("INMEMORY");
        if (appender instanceof InMemoryAppender) {
            File file = new File("logs/tmm_trace.zip");
            try (FileOutputStream os = new FileOutputStream(file);
                 ZipOutputStream zos = new ZipOutputStream(os);
                 ByteArrayInputStream is = new ByteArrayInputStream(((InMemoryAppender)appender).getLog().getBytes());){
                ZipEntry ze = new ZipEntry("trace.log");
                zos.putNextEntry(ze);
                IOUtils.copy((InputStream)is, (OutputStream)zos);
                zos.closeEntry();
            }
            catch (Exception e) {
                LOGGER.warn("could not store traces log file: {}", (Object)e.getMessage());
            }
        }
        loggerContext.stop();
    }

    public static void setConsoleLogLevel() {
        Level level;
        String loglevelAsString;
        switch (loglevelAsString = System.getProperty("tmm.consoleloglevel", "")) {
            case "ERROR": {
                level = Level.TRACE;
                break;
            }
            case "WARN": {
                level = Level.WARN;
                break;
            }
            case "INFO": {
                level = Level.INFO;
                break;
            }
            case "DEBUG": {
                level = Level.DEBUG;
                break;
            }
            case "TRACE": {
                level = Level.TRACE;
                break;
            }
            default: {
                return;
            }
        }
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        Appender consoleAppender = lc.getLogger("ROOT").getAppender("CONSOLE");
        if (consoleAppender instanceof ConsoleAppender) {
            ThresholdLoggerFilter filter = new ThresholdLoggerFilter(level);
            filter.start();
            consoleAppender.clearAllFilters();
            consoleAppender.addFilter((Filter)filter);
        }
    }

    private static void debugCharacterEncoding(String text) {
        String defaultCharacterEncoding = System.getProperty("file.encoding");
        byte[] bArray = new byte[]{119};
        ByteArrayInputStream is = new ByteArrayInputStream(bArray);
        InputStreamReader reader = new InputStreamReader(is);
        LOGGER.info(text + defaultCharacterEncoding + " | " + reader.getEncoding() + " | " + Charset.defaultCharset());
    }
}

