/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager;

import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.TinyMediaManager;

public class TmmOsUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(TmmOsUtils.class);
    public static final String DESKTOP_FILE = "tinyMediaManager.desktop";

    public static void createDesktopFileForLinux(File desktop) {
        if (SystemUtils.IS_OS_WINDOWS || SystemUtils.IS_OS_MAC) {
            return;
        }
        String path = new File(TinyMediaManager.class.getProtectionDomain().getCodeSource().getLocation().getPath()).getParent();
        try {
            path = URLDecoder.decode(path, "UTF-8");
        }
        catch (UnsupportedEncodingException e1) {
            path = URLDecoder.decode(path);
        }
        StringBuilder sb = new StringBuilder(60);
        sb.append("[Desktop Entry]\n");
        sb.append("Type=Application\n");
        sb.append("Name=tinyMediaManager\n");
        sb.append("Path=");
        sb.append(path);
        sb.append('\n');
        sb.append("Exec=/usr/bin/env bash \"");
        sb.append(path);
        sb.append("/tinyMediaManager.sh\"\n");
        sb.append("Icon=");
        sb.append(path);
        sb.append("/tmm.png\n");
        sb.append("Categories=AudioVideo;Video;Database;Java;");
        sb.append("\n");
        try (FileWriterWithEncoding writer = new FileWriterWithEncoding(desktop, "UTF-8");){
            writer.write(sb.toString());
            if (!desktop.setExecutable(true)) {
                LOGGER.warn("could not make {} executable", (Object)desktop.getName());
            }
        }
        catch (IOException e) {
            LOGGER.warn(e.getMessage());
        }
    }

    public static void addPath(String s) throws Exception {
        File f = new File(s);
        URI u = f.toURI();
        URLClassLoader urlClassLoader = (URLClassLoader)ClassLoader.getSystemClassLoader();
        Class<URLClassLoader> urlClass = URLClassLoader.class;
        Method method = urlClass.getDeclaredMethod("addURL", URL.class);
        method.setAccessible(true);
        method.invoke((Object)urlClassLoader, u.toURL());
    }
}

