/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.TimeZone;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.NullKeySerializer;
import org.tinymediamanager.ui.ITmmUIFilter;

@JsonAutoDetect
public abstract class AbstractSettings
extends AbstractModelObject {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractSettings.class);
    @JsonIgnore
    protected static ObjectMapper objectMapper = AbstractSettings.createObjectMapper();
    @JsonIgnore
    protected boolean dirty;
    @JsonIgnore
    protected boolean newConfig = false;
    @JsonIgnore
    protected String settingsFolder;
    @JsonIgnore
    protected ObjectWriter objectWriter = this.createObjectWriter();

    protected static ObjectMapper createObjectMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.configure(MapperFeature.AUTO_DETECT_GETTERS, true);
        objectMapper.configure(MapperFeature.AUTO_DETECT_IS_GETTERS, true);
        objectMapper.configure(MapperFeature.AUTO_DETECT_SETTERS, true);
        objectMapper.configure(MapperFeature.AUTO_DETECT_FIELDS, true);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        objectMapper.enable(SerializationFeature.INDENT_OUTPUT);
        objectMapper.setTimeZone(TimeZone.getDefault());
        objectMapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
        objectMapper.getSerializerProvider().setNullKeySerializer((JsonSerializer)new NullKeySerializer());
        return objectMapper;
    }

    protected void setDirty() {
        this.dirty = true;
    }

    public boolean isNewConfig() {
        return this.newConfig;
    }

    protected abstract ObjectWriter createObjectWriter();

    protected abstract void writeDefaultSettings();

    public String getSettingsFolder() {
        return this.settingsFolder;
    }

    public abstract String getConfigFilename();

    protected abstract Logger getLogger();

    public void saveSettings() {
        if (!this.dirty) {
            return;
        }
        Writer writer = null;
        try {
            String settings = this.objectWriter.writeValueAsString((Object)this);
            writer = new FileWriter(new File(this.getSettingsFolder(), this.getConfigFilename()));
            IOUtils.write((String)settings, (Writer)writer);
        }
        catch (Exception e) {
            this.getLogger().error("saveSettings", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "tmm.settings", "message.config.savesettingserror"));
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception e) {
                    this.getLogger().error("saveSettings", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "tmm.settings", "message.config.savesettingserror"));
                }
            }
        }
        this.dirty = false;
    }

    protected static AbstractSettings getInstance(String folder, String filename, Class clazz) {
        AbstractSettings instance = null;
        Path cfgFolder = Paths.get(folder, new String[0]);
        if (!Files.exists(cfgFolder, new LinkOption[0])) {
            try {
                Files.createDirectories(cfgFolder, new FileAttribute[0]);
            }
            catch (IOException e) {
                LOGGER.warn("could not create config folder: {}", (Object)e.getMessage());
            }
        }
        try {
            try {
                LOGGER.debug("Loading settings ({}) from {}", (Object)filename, (Object)folder);
                FileReader reader = new FileReader(new File(folder, filename));
                String settingsAsJson = IOUtils.toString((Reader)reader);
                ObjectReader objectReader = objectMapper.readerFor(clazz);
                instance = (AbstractSettings)objectReader.readValue(settingsAsJson);
            }
            catch (Exception e) {
                if (!(e instanceof FileNotFoundException)) {
                    LOGGER.error("failed loading settings", (Throwable)e);
                }
                LOGGER.warn("could not load settings - creating default ones...");
                instance = (AbstractSettings)clazz.newInstance();
                instance.settingsFolder = folder;
                instance.newConfig = true;
                instance.dirty = true;
                instance.writeDefaultSettings();
            }
            instance.settingsFolder = folder;
            instance.dirty = false;
        }
        catch (Exception e) {
            LOGGER.error("getInstance", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "tmm.settings", "message.config.loadsettingserror"));
        }
        return instance;
    }

    public static class UIFilters {
        public String id = "";
        public ITmmUIFilter.FilterState state = ITmmUIFilter.FilterState.INACTIVE;
        public String filterValue = "";
    }
}

