/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.jdesktop.observablecollections.ObservableList;
import org.jdesktop.observablecollections.ObservableListListener;

public class ObservableCopyOnWriteArrayList<E>
extends CopyOnWriteArrayList<E>
implements ObservableList<E> {
    private List<ObservableListListener> listeners = new CopyOnWriteArrayList<ObservableListListener>();

    public ObservableCopyOnWriteArrayList() {
    }

    public ObservableCopyOnWriteArrayList(Collection<? extends E> c) {
        super(c);
    }

    @Override
    public E set(int index, E element) {
        E oldValue = super.set(index, element);
        for (ObservableListListener listener : this.listeners) {
            listener.listElementReplaced((ObservableList)this, index, oldValue);
        }
        return oldValue;
    }

    @Override
    public void add(int index, E element) {
        super.add(index, element);
        for (ObservableListListener listener : this.listeners) {
            listener.listElementsAdded((ObservableList)this, index, 1);
        }
    }

    @Override
    public E remove(int index) {
        Object oldValue = super.remove(index);
        for (ObservableListListener listener : this.listeners) {
            listener.listElementsRemoved((ObservableList)this, index, Collections.singletonList(oldValue));
        }
        return oldValue;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.size(), c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (super.addAll(index, c)) {
            for (ObservableListListener listener : this.listeners) {
                listener.listElementsAdded((ObservableList)this, index, c.size());
            }
        }
        return false;
    }

    @Override
    public void clear() {
        ArrayList dup = new ArrayList(this);
        super.clear();
        if (dup.size() != 0) {
            for (ObservableListListener listener : this.listeners) {
                listener.listElementsRemoved((ObservableList)this, 0, dup);
            }
        }
    }

    public void addObservableListListener(ObservableListListener observableListListener) {
        this.listeners.add(observableListListener);
    }

    public void removeObservableListListener(ObservableListListener observableListListener) {
        this.listeners.remove(observableListListener);
    }

    public boolean supportsElementPropertyChanged() {
        return false;
    }
}

