/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public class RecursiveToStringStyle
extends ToStringStyle {
    private static final long serialVersionUID = 1L;
    private static final RecursiveToStringStyle INSTANCE = new RecursiveToStringStyle(13);
    private final int maxDepth;
    private final String tabs;
    private ThreadLocal<MutableInteger> depth = ThreadLocal.withInitial(() -> new MutableInteger(0));

    public static ToStringStyle getInstance() {
        return INSTANCE;
    }

    public static String toString(Object value) {
        StringBuffer sb = new StringBuffer(512);
        INSTANCE.appendDetail(sb, null, value);
        return sb.toString();
    }

    public RecursiveToStringStyle(int maxDepth) {
        this.maxDepth = maxDepth;
        this.tabs = StringUtils.repeat((String)"\t", (int)maxDepth);
        this.setUseShortClassName(true);
        this.setUseIdentityHashCode(false);
        this.setContentStart(" {");
        this.setFieldSeparator(System.lineSeparator());
        this.setFieldSeparatorAtStart(true);
        this.setFieldNameValueSeparator(" = ");
        this.setContentEnd("}");
    }

    private int getDepth() {
        return this.depth.get().get();
    }

    private void padDepth(StringBuffer buffer) {
        buffer.append(this.tabs, 0, this.getDepth());
    }

    private StringBuffer appendTabified(StringBuffer buffer, String value) {
        Matcher matcher = Pattern.compile("\n").matcher(value);
        String replacement = "\n" + this.tabs.substring(0, this.getDepth());
        while (matcher.find()) {
            matcher.appendReplacement(buffer, replacement);
        }
        matcher.appendTail(buffer);
        return buffer;
    }

    protected void appendFieldSeparator(StringBuffer buffer) {
        buffer.append(this.getFieldSeparator());
        this.padDepth(buffer);
    }

    public void appendStart(StringBuffer buffer, Object object) {
        this.depth.get().increment();
        super.appendStart(buffer, object);
    }

    public void appendEnd(StringBuffer buffer, Object object) {
        super.appendEnd(buffer, object);
        buffer.setLength(buffer.length() - this.getContentEnd().length());
        buffer.append(System.lineSeparator());
        this.depth.get().decrement();
        this.padDepth(buffer);
        this.appendContentEnd(buffer);
    }

    protected void removeLastFieldSeparator(StringBuffer buffer) {
        int len = buffer.length();
        int sepLen = this.getFieldSeparator().length() + this.getDepth();
        if (len > 0 && sepLen > 0 && len >= sepLen) {
            buffer.setLength(len - sepLen);
        }
    }

    private boolean noReflectionNeeded(Object value) {
        try {
            return value != null && (value.getClass().getName().startsWith("java.lang.") || value.getClass().getMethod("toString", new Class[0]).getDeclaringClass() != Object.class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, Object value) {
        if (this.getDepth() >= this.maxDepth || this.noReflectionNeeded(value)) {
            this.appendTabified(buffer, String.valueOf(value));
        } else {
            new ReflectionToStringBuilder(value, (ToStringStyle)this, buffer, null, false, false).toString();
        }
    }

    protected void appendDetail(StringBuffer buffer, String fieldName, Collection<?> coll) {
        buffer.append(ReflectionToStringBuilder.toString((Object)coll.toArray(), (ToStringStyle)this, (boolean)true, (boolean)true));
    }

    static class MutableInteger {
        private int value;

        MutableInteger(int value) {
            this.value = value;
        }

        public final int get() {
            return this.value;
        }

        public final void increment() {
            ++this.value;
        }

        public final void decrement() {
            --this.value;
        }
    }
}

