/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.win32.StdCallLibrary;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TmmDateFormat {
    public static final Logger LOGGER = LoggerFactory.getLogger(TmmDateFormat.class);
    public static final DateFormat SHORT_DATE_FORMAT;
    public static final DateFormat MEDIUM_DATE_FORMAT;
    public static final DateFormat LONG_DATE_FORMAT;
    public static final DateFormat SHORT_TIME_FORMAT;
    public static final DateFormat MEDIUM_TIME_FORMAT;
    public static final DateFormat SHORT_DATE_SHORT_TIME_FORMAT;
    public static final DateFormat SHORT_DATE_MEDIUM_TIME_FORMAT;
    public static final DateFormat MEDIUM_DATE_SHORT_TIME_FORMAT;
    public static final DateFormat MEDIUM_DATE_MEDIUM_TIME_FORMAT;
    public static final DateFormat LONG_DATE_SHORT_TIME_FORMAT;
    public static final DateFormat LONG_DATE_MEDIUM_TIME_FORMAT;

    private static DateFormat[] getDateTimeFormats() {
        boolean jnaAvailable = false;
        try {
            int ptrSize = Native.POINTER_SIZE;
            jnaAvailable = true;
        }
        catch (Throwable e) {
            LOGGER.error("could not load JNA: " + e.getMessage());
        }
        DateFormat[] formats = null;
        try {
            if (SystemUtils.IS_OS_MAC && jnaAvailable) {
                formats = TmmDateFormat.getMacFormats();
            } else if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_UNIX) {
                formats = TmmDateFormat.getUnixFormats();
            } else if (SystemUtils.IS_OS_WINDOWS && jnaAvailable) {
                formats = TmmDateFormat.getWindowsFormats();
            }
        }
        catch (Throwable e) {
            LOGGER.error("could not load native date formats: " + e.getMessage());
        }
        if (formats == null || formats.length < 11) {
            formats = new DateFormat[]{DateFormat.getDateInstance(3), DateFormat.getDateInstance(2), DateFormat.getDateInstance(1), DateFormat.getTimeInstance(3), DateFormat.getTimeInstance(2), DateFormat.getDateTimeInstance(3, 3), DateFormat.getDateTimeInstance(3, 2), DateFormat.getDateTimeInstance(2, 3), DateFormat.getDateTimeInstance(2, 2), DateFormat.getDateTimeInstance(1, 3), DateFormat.getDateTimeInstance(1, 2)};
        }
        return formats;
    }

    private static DateFormat[] getMacFormats() {
        CF cf = (CF)Native.load((String)"CoreFoundation", CF.class);
        return new DateFormat[]{TmmDateFormat.getMacFormat(cf, 1L, 0L), TmmDateFormat.getMacFormat(cf, 2L, 0L), TmmDateFormat.getMacFormat(cf, 3L, 0L), TmmDateFormat.getMacFormat(cf, 0L, 1L), TmmDateFormat.getMacFormat(cf, 0L, 3L), TmmDateFormat.getMacFormat(cf, 1L, 1L), TmmDateFormat.getMacFormat(cf, 1L, 2L), TmmDateFormat.getMacFormat(cf, 2L, 1L), TmmDateFormat.getMacFormat(cf, 2L, 2L), TmmDateFormat.getMacFormat(cf, 3L, 1L), TmmDateFormat.getMacFormat(cf, 3L, 2L)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DateFormat getMacFormat(CF cf, long dateStyle, long timeStyle) {
        Pointer formatter = cf.CFDateFormatterCreate(null, null, dateStyle, timeStyle);
        if (formatter == null) {
            throw new IllegalStateException("CFDateFormatterCreate: null");
        }
        try {
            Pointer format = cf.CFDateFormatterGetFormat(formatter);
            int length = (int)cf.CFStringGetLength(format);
            char[] buffer = new char[length];
            cf.CFStringGetCharacters(format, new CF.CFRange(0L, length), buffer);
            DateFormat dateFormat = TmmDateFormat.formatFromString(new String(buffer));
            return dateFormat;
        }
        finally {
            cf.CFRelease(formatter);
        }
    }

    private static DateFormat[] getUnixFormats() {
        String localeStr = System.getenv("LC_TIME");
        if (localeStr == null) {
            return null;
        }
        int p = (localeStr = localeStr.trim()).indexOf(46);
        if (p > 0) {
            localeStr = localeStr.substring(0, p);
        }
        if ((p = localeStr.indexOf(64)) > 0) {
            localeStr = localeStr.substring(0, p);
        }
        Locale locale = (p = localeStr.indexOf(95)) < 0 ? new Locale(localeStr) : new Locale(localeStr.substring(0, p), localeStr.substring(p + 1));
        return new DateFormat[]{DateFormat.getDateInstance(3, locale), DateFormat.getDateInstance(2, locale), DateFormat.getDateInstance(1, locale), DateFormat.getTimeInstance(3, locale), DateFormat.getTimeInstance(2, locale), DateFormat.getDateTimeInstance(3, 3, locale), DateFormat.getDateTimeInstance(3, 2, locale), DateFormat.getDateTimeInstance(2, 3, locale), DateFormat.getDateTimeInstance(2, 2, locale), DateFormat.getDateTimeInstance(1, 3, locale), DateFormat.getDateTimeInstance(1, 2, locale)};
    }

    private static DateFormat[] getWindowsFormats() {
        String shortDate;
        int bufferSize;
        char[] buffer;
        Kernel32 kernel32 = (Kernel32)Native.load((String)"Kernel32", Kernel32.class);
        int rv = kernel32.GetLocaleInfoEx(null, 31, buffer = new char[bufferSize = 128], bufferSize);
        if (rv < 2) {
            throw new IllegalStateException("GetLocaleInfoEx: " + kernel32.GetLastError());
        }
        String mediumDate = shortDate = TmmDateFormat.fixWindowsFormat(new String(buffer, 0, rv - 1));
        rv = kernel32.GetLocaleInfoEx(null, 32, buffer, bufferSize);
        if (rv < 2) {
            throw new IllegalStateException("GetLocaleInfoEx: " + kernel32.GetLastError());
        }
        String longDate = TmmDateFormat.fixWindowsFormat(new String(buffer, 0, rv - 1));
        rv = kernel32.GetLocaleInfoEx(null, 121, buffer, bufferSize);
        if (rv < 2) {
            throw new IllegalStateException("GetLocaleInfoEx: " + kernel32.GetLastError());
        }
        String shortTime = TmmDateFormat.fixWindowsFormat(new String(buffer, 0, rv - 1));
        rv = kernel32.GetLocaleInfoEx(null, 4099, buffer, bufferSize);
        if (rv < 2) {
            throw new IllegalStateException("GetLocaleInfoEx: " + kernel32.GetLastError());
        }
        String mediumTime = TmmDateFormat.fixWindowsFormat(new String(buffer, 0, rv - 1));
        return new DateFormat[]{TmmDateFormat.formatFromString(shortDate), TmmDateFormat.formatFromString(mediumDate), TmmDateFormat.formatFromString(longDate), TmmDateFormat.formatFromString(shortTime), TmmDateFormat.formatFromString(mediumTime), TmmDateFormat.formatFromString(shortDate + " " + shortTime), TmmDateFormat.formatFromString(shortDate + " " + mediumTime), TmmDateFormat.formatFromString(mediumDate + " " + shortTime), TmmDateFormat.formatFromString(mediumDate + " " + mediumTime), TmmDateFormat.formatFromString(longDate + " " + shortTime), TmmDateFormat.formatFromString(longDate + " " + mediumTime)};
    }

    private static String fixWindowsFormat(String format) {
        format = format.replaceAll("g+", "G");
        format = StringUtils.replace((String)format, (String)"tt", (String)"a");
        return format;
    }

    private static DateFormat formatFromString(String format) {
        try {
            return new SimpleDateFormat(format.trim());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("unrecognized format string '" + format + "'");
        }
    }

    static {
        DateFormat[] formats = TmmDateFormat.getDateTimeFormats();
        SHORT_DATE_FORMAT = formats[0];
        MEDIUM_DATE_FORMAT = formats[1];
        LONG_DATE_FORMAT = formats[2];
        SHORT_TIME_FORMAT = formats[3];
        MEDIUM_TIME_FORMAT = formats[4];
        SHORT_DATE_SHORT_TIME_FORMAT = formats[5];
        SHORT_DATE_MEDIUM_TIME_FORMAT = formats[6];
        MEDIUM_DATE_SHORT_TIME_FORMAT = formats[7];
        MEDIUM_DATE_MEDIUM_TIME_FORMAT = formats[8];
        LONG_DATE_SHORT_TIME_FORMAT = formats[9];
        LONG_DATE_MEDIUM_TIME_FORMAT = formats[10];
    }

    private static interface Kernel32
    extends StdCallLibrary {
        public static final int LOCALE_SSHORTDATE = 31;
        public static final int LOCALE_SLONGDATE = 32;
        public static final int LOCALE_SSHORTTIME = 121;
        public static final int LOCALE_STIMEFORMAT = 4099;

        public int GetLocaleInfoEx(String var1, int var2, char[] var3, int var4);

        public int GetLastError();
    }

    private static interface CF
    extends Library {
        public static final long kCFDateFormatterNoStyle = 0L;
        public static final long kCFDateFormatterShortStyle = 1L;
        public static final long kCFDateFormatterMediumStyle = 2L;
        public static final long kCFDateFormatterLongStyle = 3L;

        public Pointer CFDateFormatterCreate(Pointer var1, Pointer var2, long var3, long var5);

        public Pointer CFDateFormatterGetFormat(Pointer var1);

        public long CFStringGetLength(Pointer var1);

        public void CFStringGetCharacters(Pointer var1, CFRange var2, char[] var3);

        public void CFRelease(Pointer var1);

        public static class CFRange
        extends Structure
        implements Structure.ByValue {
            public long location;
            public long length;

            protected List<String> getFieldOrder() {
                return Arrays.asList("location", "length");
            }

            public CFRange(long location, long length) {
                this.location = location;
                this.length = length;
            }
        }
    }
}

