/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileEntry;
import com.github.stephenc.javaisotools.loopfs.iso9660.Iso9660FileSystem;
import com.madgag.gif.fmsware.GifDecoder;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFileAudioStream;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.thirdparty.MediaInfo;
import org.tinymediamanager.thirdparty.MediaInfoXMLParser;

public class MediaFile
extends AbstractModelObject
implements Comparable<MediaFile> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaFile.class);
    private static final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private static final String PATH = "path";
    private static final String FILENAME = "filename";
    private static final String FILESIZE = "filesize";
    private static final String FILESIZE_IN_MB = "filesizeInMegabytes";
    private static final List<String> PLEX_EXTRA_FOLDERS = Arrays.asList("behind the scenes", "behindthescenes", "deleted scenes", "deletedscenes", "featurettes", "interviews", "scenes", "shorts");
    public static final Pattern MOVIESET_ARTWORK_PATTERN = Pattern.compile("(?i)movieset-(poster|fanart|banner|disc|discart|logo|clearlogo|clearart|thumb)\\..{2,4}");
    private static final Pattern POSTER_PATTERN = Pattern.compile("(?i)(.*-poster|poster|folder|movie|.*-cover|cover)\\..{2,4}");
    private static final Pattern FANART_PATTERN = Pattern.compile("(?i)(.*-fanart|.*\\.fanart|fanart)[0-9]{0,2}\\..{2,4}");
    private static final Pattern BANNER_PATTERN = Pattern.compile("(?i)(.*-banner|banner)\\..{2,4}");
    private static final Pattern THUMB_PATTERN = Pattern.compile("(?i)(.*-thumb|thumb|.*-landscape|landscape)[0-9]{0,2}\\..{2,4}");
    private static final Pattern SEASON_POSTER_PATTERN = Pattern.compile("(?i)season([0-9]{1,4}|-specials|-all)(-poster)?\\..{1,4}");
    private static final Pattern SEASON_BANNER_PATTERN = Pattern.compile("(?i)season([0-9]{1,4}|-specials|-all)-banner\\..{1,4}");
    private static final Pattern SEASON_THUMB_PATTERN = Pattern.compile("(?i)season([0-9]{1,4}|-specials|-all)-thumb\\..{1,4}");
    private static final Pattern LOGO_PATTERN = Pattern.compile("(?i)(.*-logo|logo)\\..{2,4}");
    private static final Pattern CLEARLOGO_PATTERN = Pattern.compile("(?i)(.*-clearlogo|clearlogo)\\..{2,4}");
    private static final Pattern CHARACTERART_PATTERN = Pattern.compile("(?i)(.*-characterart|characterart)[0-9]{0,2}\\..{2,4}");
    private static final Pattern DISCART_PATTERN = Pattern.compile("(?i)(.*-discart|discart|.*-disc|disc)\\.(jpg|jpeg|png|tbn)");
    private static final Pattern CLEARART_PATTERN = Pattern.compile("(?i)(.*-clearart|clearart)\\..{2,4}");
    private static final Pattern KEYART_PATTERN = Pattern.compile("(?i)(.*-keyart|keyart)\\..{2,4}");
    public static final String VIDEO_FORMAT_96P = "96p";
    public static final String VIDEO_FORMAT_120P = "120p";
    public static final String VIDEO_FORMAT_144P = "144p";
    public static final String VIDEO_FORMAT_240P = "240p";
    public static final String VIDEO_FORMAT_288P = "288p";
    public static final String VIDEO_FORMAT_360P = "360p";
    public static final String VIDEO_FORMAT_480P = "480p";
    public static final String VIDEO_FORMAT_540P = "540p";
    public static final String VIDEO_FORMAT_576P = "576p";
    public static final String VIDEO_FORMAT_720P = "720p";
    public static final String VIDEO_FORMAT_1080P = "1080p";
    public static final String VIDEO_FORMAT_2160P = "2160p";
    public static final String VIDEO_FORMAT_4320P = "4320p";
    public static final List<String> VIDEO_FORMATS = Arrays.asList("480p", "540p", "576p", "720p", "1080p", "2160p", "4320p");
    public static final String VIDEO_FORMAT_LD = "LD";
    public static final String VIDEO_FORMAT_SD = "SD";
    public static final String VIDEO_FORMAT_HD = "HD";
    public static final String VIDEO_3D = "3D";
    public static final String VIDEO_3D_SBS = "3D SBS";
    public static final String VIDEO_3D_TAB = "3D TAB";
    public static final String VIDEO_3D_HSBS = "3D HSBS";
    public static final String VIDEO_3D_HTAB = "3D HTAB";
    public static final String VIDEO_3D_MVC = "3D MVC";
    @JsonProperty
    private MediaFileType type = MediaFileType.UNKNOWN;
    @JsonProperty
    private String path = "";
    @JsonProperty
    private String filename = "";
    @JsonProperty
    private long filesize = 0L;
    @JsonProperty
    private long filedate = 0L;
    @JsonProperty
    private String videoCodec = "";
    @JsonProperty
    private String containerFormat = "";
    @JsonProperty
    private String exactVideoFormat = "";
    @JsonProperty
    private String video3DFormat = "";
    @JsonProperty
    private int videoWidth = 0;
    @JsonProperty
    private int videoHeight = 0;
    @JsonProperty
    private float aspectRatio = 0.0f;
    @JsonProperty
    private int overallBitRate = 0;
    @JsonProperty
    private int bitDepth = 0;
    @JsonProperty
    private double frameRate = 0.0;
    @JsonProperty
    private int durationInSecs = 0;
    @JsonProperty
    private int stacking = 0;
    @JsonProperty
    private String stackingMarker = "";
    @JsonProperty
    private String title = "";
    @JsonProperty
    private List<MediaFileAudioStream> audioStreams = new CopyOnWriteArrayList<MediaFileAudioStream>();
    @JsonProperty
    private List<MediaFileSubtitle> subtitles = new CopyOnWriteArrayList<MediaFileSubtitle>();
    private MediaInfo mediaInfo;
    private Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot = null;
    private Path file = null;
    private boolean isISO = false;
    @JsonProperty
    private boolean isAnimatedGraphic = false;
    @JsonProperty
    private boolean HDR = false;

    public MediaFile(MediaFile clone) {
        this.path = clone.path;
        this.filename = clone.filename;
        this.filesize = clone.filesize;
        this.filedate = clone.filedate;
        this.videoCodec = clone.videoCodec;
        this.containerFormat = clone.containerFormat;
        this.exactVideoFormat = clone.exactVideoFormat;
        this.video3DFormat = clone.video3DFormat;
        this.videoHeight = clone.videoHeight;
        this.videoWidth = clone.videoWidth;
        this.aspectRatio = clone.aspectRatio;
        this.frameRate = clone.frameRate;
        this.overallBitRate = clone.overallBitRate;
        this.bitDepth = clone.bitDepth;
        this.durationInSecs = clone.durationInSecs;
        this.stacking = clone.stacking;
        this.stackingMarker = clone.stackingMarker;
        this.type = clone.type;
        this.audioStreams.addAll(clone.audioStreams);
        this.subtitles.addAll(clone.subtitles);
        this.title = clone.title;
    }

    public MediaFile() {
        this.path = "";
        this.filename = "";
    }

    public MediaFile(Path f) {
        this(f, null);
    }

    public MediaFile(Path f, MediaFileType type) {
        this.path = f.getParent() == null ? "" : f.getParent().toString();
        this.filename = f.getFileName().toString();
        this.file = f.toAbsolutePath();
        this.type = type == null ? this.parseType() : type;
        if (!this.isValidMediainfoFormat() && StringUtils.isBlank((CharSequence)this.getContainerFormat())) {
            this.setContainerFormat(this.getExtension());
        }
    }

    private void gatherSubtitleInformation() {
        MediaFileSubtitle sub = new MediaFileSubtitle();
        String shortname = this.getBasename().toLowerCase(Locale.ROOT);
        if (shortname.contains("forced")) {
            sub.setForced(true);
            shortname = shortname.replaceAll("\\p{Punct}*forced", "");
        }
        sub.setLanguage(this.parseLanguageFromString(shortname));
        if (sub.getLanguage().isEmpty() && this.filename.endsWith(".sub")) {
            Path idx = Paths.get(this.path, this.filename.replaceFirst("sub$", "idx"));
            try (FileReader fr = new FileReader(idx.toFile());
                 BufferedReader br = new BufferedReader(fr);){
                String line;
                while ((line = br.readLine()) != null) {
                    String lang = "";
                    if (line.startsWith("id:")) {
                        lang = StrgUtils.substr((String)line, (String)"id: (.*?),");
                    }
                    if (line.startsWith("# alt:")) {
                        lang = StrgUtils.substr((String)line, (String)"^# alt: (.*?)$");
                    }
                    if (lang.isEmpty()) continue;
                    sub.setLanguage(LanguageUtils.getIso3LanguageFromLocalizedString((String)lang));
                    break;
                }
            }
            catch (IOException e) {
                LOGGER.debug("could not read idx file: {}", (Object)e.getMessage());
            }
        }
        sub.setCodec(this.getExtension());
        this.subtitles.clear();
        this.subtitles.add(sub);
    }

    public MediaFileType parseType() {
        String ext = this.getExtension().toLowerCase(Locale.ROOT);
        String basename = FilenameUtils.getBaseName((String)this.getFilename());
        String foldername = FilenameUtils.getBaseName((String)this.getPath()).toLowerCase(Locale.ROOT);
        String parentparent = "";
        try {
            parentparent = FilenameUtils.getBaseName((String)this.getFileAsPath().getParent().getParent().toString()).toLowerCase(Locale.ROOT);
        }
        catch (Exception e) {
            LOGGER.debug("way to up");
        }
        if (this.getFilename().contains(".EXTRAS.") || basename.matches("(?i).*[_.-]+extra[s]?$") || basename.matches("(?i).*[-]+extra[s]?[-].*") || foldername.equalsIgnoreCase("extras") || foldername.equalsIgnoreCase("extra") || !parentparent.isEmpty() && parentparent.matches("extra[s]?") || basename.matches("(?i).*[-](behindthescenes|deleted|featurette|interview|scene|short)$") || PLEX_EXTRA_FOLDERS.contains(foldername)) {
            return MediaFileType.EXTRA;
        }
        if (ext.equals("nfo")) {
            return MediaFileType.NFO;
        }
        if (ext.equals("vsmeta")) {
            return MediaFileType.VSMETA;
        }
        if (basename.endsWith("-mediainfo") && "xml".equals(ext)) {
            return MediaFileType.MEDIAINFO;
        }
        if (ext.equals("jpg") || ext.equals("jpeg") || ext.equals("png") || ext.equals("tbn") || ext.equals("gif")) {
            return this.parseImageType();
        }
        if (basename.matches("(?i).*[_.-]+theme\\d*$") || basename.matches("(?i)theme\\d*")) {
            return MediaFileType.THEME;
        }
        if (Globals.settings.getAudioFileType().contains("." + ext)) {
            return MediaFileType.AUDIO;
        }
        if (Globals.settings.getSubtitleFileType().contains("." + ext)) {
            return MediaFileType.SUBTITLE;
        }
        if (Globals.settings.getVideoFileType().contains("." + ext)) {
            if (basename.matches("(?i).*[\\[\\]\\(\\)_.-]*trailer[\\[\\]\\(\\)_.-]?$") || basename.equalsIgnoreCase("movie-trailer") || foldername.equalsIgnoreCase("trailer") || foldername.equalsIgnoreCase("trailers")) {
                return MediaFileType.TRAILER;
            }
            if (basename.matches("(?i).*[\\[\\]\\(\\)_.-]*sample[\\[\\]\\(\\)_.-]?$") || foldername.equalsIgnoreCase("sample")) {
                return MediaFileType.SAMPLE;
            }
            return MediaFileType.VIDEO;
        }
        if (ext.equals("txt")) {
            return MediaFileType.TEXT;
        }
        return MediaFileType.UNKNOWN;
    }

    private MediaFileType parseImageType() {
        String name = this.getFilename();
        String foldername = FilenameUtils.getBaseName((String)this.getPath()).toLowerCase(Locale.ROOT);
        Matcher matcher = MOVIESET_ARTWORK_PATTERN.matcher(name);
        if (matcher.matches()) {
            return MediaFileType.GRAPHIC;
        }
        matcher = SEASON_POSTER_PATTERN.matcher(name);
        if (matcher.matches()) {
            return MediaFileType.SEASON_POSTER;
        }
        matcher = SEASON_BANNER_PATTERN.matcher(name);
        if (matcher.matches()) {
            return MediaFileType.SEASON_BANNER;
        }
        matcher = SEASON_THUMB_PATTERN.matcher(name);
        if (matcher.matches()) {
            return MediaFileType.SEASON_THUMB;
        }
        matcher = POSTER_PATTERN.matcher(name);
        if (matcher.matches()) {
            return MediaFileType.POSTER;
        }
        matcher = FANART_PATTERN.matcher(name);
        if (matcher.matches()) {
            if (this.getPath().endsWith("extrafanart")) {
                return MediaFileType.EXTRAFANART;
            }
            return MediaFileType.FANART;
        }
        matcher = BANNER_PATTERN.matcher(name);
        if (matcher.matches()) {
            return MediaFileType.BANNER;
        }
        matcher = THUMB_PATTERN.matcher(name);
        if (matcher.matches()) {
            if (this.getPath().endsWith("extrathumbs")) {
                return MediaFileType.EXTRATHUMB;
            }
            return MediaFileType.THUMB;
        }
        matcher = CLEARART_PATTERN.matcher(name);
        if (matcher.matches()) {
            return MediaFileType.CLEARART;
        }
        matcher = LOGO_PATTERN.matcher(name);
        if (matcher.matches()) {
            return MediaFileType.LOGO;
        }
        matcher = CLEARLOGO_PATTERN.matcher(name);
        if (matcher.matches()) {
            return MediaFileType.CLEARLOGO;
        }
        matcher = DISCART_PATTERN.matcher(name);
        if (matcher.matches()) {
            return MediaFileType.DISC;
        }
        matcher = CHARACTERART_PATTERN.matcher(name);
        if (matcher.matches()) {
            return MediaFileType.CHARACTERART;
        }
        if (this.getPath().endsWith("characterart")) {
            return MediaFileType.CHARACTERART;
        }
        matcher = KEYART_PATTERN.matcher(name);
        if (matcher.matches()) {
            return MediaFileType.KEYART;
        }
        if (foldername.equalsIgnoreCase("extrafanarts") || foldername.equalsIgnoreCase("extrafanart")) {
            return MediaFileType.EXTRAFANART;
        }
        if (foldername.equalsIgnoreCase("extrathumbs") || foldername.equalsIgnoreCase("extrathumb")) {
            return MediaFileType.EXTRATHUMB;
        }
        return MediaFileType.GRAPHIC;
    }

    public boolean isPacked() {
        String ext = this.getExtension().toLowerCase(Locale.ROOT);
        return ext.equals("zip") || ext.equals("rar") || ext.equals("7z") || ext.matches("r\\d+");
    }

    public boolean isGraphic() {
        switch (this.type) {
            case GRAPHIC: 
            case BANNER: 
            case FANART: 
            case POSTER: 
            case THUMB: 
            case LOGO: 
            case CLEARLOGO: 
            case CLEARART: 
            case CHARACTERART: 
            case KEYART: 
            case SEASON_POSTER: 
            case SEASON_BANNER: 
            case SEASON_THUMB: 
            case EXTRAFANART: 
            case EXTRATHUMB: 
            case DISC: {
                return true;
            }
        }
        return false;
    }

    public boolean isVideo() {
        switch (this.type) {
            case VIDEO: 
            case TRAILER: 
            case SAMPLE: 
            case VIDEO_EXTRA: {
                return true;
            }
            case EXTRA: {
                if (!Globals.settings.getVideoFileType().contains("." + this.getExtension().toLowerCase(Locale.ROOT))) break;
                return true;
            }
        }
        return false;
    }

    public boolean isDiscFile() {
        return this.isBlurayFile() || this.isDVDFile() || this.isHdDVDFile();
    }

    public boolean isDVDFile() {
        String name = this.getFilename().toLowerCase(Locale.ROOT);
        return name.matches("(video_ts|vts_\\d\\d_\\d)\\.(vob|bup|ifo)");
    }

    public boolean isHdDVDFile() {
        String name = this.getFilename().toLowerCase(Locale.ROOT);
        String foldername = FilenameUtils.getBaseName((String)this.getPath()).toLowerCase(Locale.ROOT);
        return "hvdvd_ts".equals(foldername) && name.matches(".*(evo|bup|ifo|map)$");
    }

    public boolean isBlurayFile() {
        String name = this.getFilename().toLowerCase(Locale.ROOT);
        return name.matches("(index\\.bdmv|movieobject\\.bdmv|\\d{5}\\.m2ts)");
    }

    public boolean isMainDiscIdentifierFile() {
        return this.getFilename().equalsIgnoreCase("video_ts.ifo") || this.getFilename().equalsIgnoreCase("index.bdmv") || this.getFilename().equalsIgnoreCase("hv000i01.ifo");
    }

    public Path getFile() {
        return this.getFileAsPath();
    }

    public Path getFileAsPath() {
        if (this.file == null) {
            Path f = Paths.get(this.path, this.filename);
            this.file = f.toAbsolutePath();
        }
        return this.file;
    }

    public void setFile(Path file) {
        this.setFilename(file.getFileName().toString());
        this.setPath(file.toAbsolutePath().getParent().toString());
        this.file = file.toAbsolutePath();
    }

    private void invalidateFileHandle() {
        if (this.file != null) {
            this.file = null;
        }
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String newValue) {
        String oldValue = this.path;
        this.path = newValue;
        this.invalidateFileHandle();
        this.firePropertyChange(PATH, oldValue, newValue);
    }

    public void replacePathForRenamedFolder(Path oldPath, Path newPath) {
        String p = this.getPath();
        p = p.replace(oldPath.toAbsolutePath().toString(), newPath.toAbsolutePath().toString());
        this.setPath(p);
    }

    public String getFilename() {
        return this.filename;
    }

    public String getFilenameWithoutStacking() {
        if (this.stackingMarker.isEmpty()) {
            return this.filename;
        }
        return this.filename.replaceAll("[ _.-]*" + this.stackingMarker, "");
    }

    public void setFilename(String newValue) {
        String oldValue = this.filename;
        this.filename = newValue;
        this.invalidateFileHandle();
        this.firePropertyChange(FILENAME, oldValue, newValue);
    }

    public String getExtension() {
        return FilenameUtils.getExtension((String)this.filename);
    }

    public String getBasename() {
        return FilenameUtils.getBaseName((String)this.filename);
    }

    public long getFiledate() {
        return this.filedate;
    }

    public long getFilesize() {
        return this.filesize;
    }

    public void setFilesize(long newValue) {
        long oldValue = this.filesize;
        this.filesize = newValue;
        this.firePropertyChange(FILESIZE, oldValue, newValue);
        this.firePropertyChange(FILESIZE_IN_MB, oldValue, newValue);
    }

    public String getFilesizeInMegabytes() {
        DecimalFormat df = new DecimalFormat("#0.00");
        return df.format((double)this.filesize / 1048576.0) + " M";
    }

    public MediaFileType getType() {
        return this.type;
    }

    public void setType(MediaFileType type) {
        this.type = type;
    }

    public int getStacking() {
        return this.stacking;
    }

    public void setStacking(int stacking) {
        this.stacking = stacking;
    }

    public String getStackingMarker() {
        return this.stackingMarker;
    }

    public void setStackingMarker(String stackingMarker) {
        this.stackingMarker = stackingMarker;
    }

    public void removeStackingInformation() {
        this.setStacking(0);
        this.setStackingMarker("");
    }

    public void detectStackingInformation() {
        this.stacking = Utils.getStackingNumber(this.filename);
        if (this.stacking == 0) {
            this.stacking = Utils.getStackingNumber(FilenameUtils.getBaseName((String)this.getPath()));
        }
        this.stackingMarker = Utils.getStackingMarker(this.filename);
        if (this.stackingMarker.isEmpty()) {
            this.stackingMarker = Utils.getFolderStackingMarker(FilenameUtils.getBaseName((String)this.getPath()));
        }
    }

    public List<MediaFileSubtitle> getSubtitles() {
        return this.subtitles;
    }

    public String getSubtitlesAsString() {
        StringBuilder sb = new StringBuilder();
        LinkedHashSet<MediaFileSubtitle> cleansub = new LinkedHashSet<MediaFileSubtitle>(this.subtitles);
        for (MediaFileSubtitle sub : cleansub) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(sub.getLanguage());
        }
        return sb.toString();
    }

    public void setSubtitles(List<MediaFileSubtitle> subtitles) {
        this.subtitles = subtitles;
    }

    public void addSubtitle(MediaFileSubtitle subtitle) {
        if (!this.subtitles.contains(subtitle)) {
            this.subtitles.add(subtitle);
        }
    }

    public void clearAllSubtitles() {
        this.subtitles.clear();
    }

    public boolean hasSubtitles() {
        return this.subtitles != null && this.subtitles.size() > 0;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    private void getMediaInfoSnapshot() {
        if (this.mediaInfo == null) {
            this.mediaInfo = new MediaInfo();
        }
        if (this.miSnapshot == null) {
            try {
                readWriteLock.writeLock().lock();
                if (!this.mediaInfo.open(this.getFileAsPath())) {
                    LOGGER.error("Mediainfo could not open file: {}", (Object)this.getFileAsPath());
                } else {
                    this.miSnapshot = this.mediaInfo.snapshot();
                }
            }
            catch (Error | Exception e) {
                LOGGER.error("Mediainfo could not open file: {} - {}", (Object)this.getFileAsPath(), (Object)e.getMessage());
            }
            finally {
                this.closeMediaInfo();
                readWriteLock.writeLock().unlock();
            }
        }
    }

    private void closeMediaInfo() {
        if (this.mediaInfo != null) {
            this.mediaInfo.close();
            this.mediaInfo = null;
        }
    }

    private String getMediaInfo(MediaInfo.StreamKind streamKind, int streamNumber, String ... keys) {
        if (this.miSnapshot == null) {
            this.getMediaInfoSnapshot();
        }
        if (this.miSnapshot != null) {
            for (String key : keys) {
                String value;
                LinkedHashMap info;
                List<Map<String, String>> stream = this.miSnapshot.get((Object)streamKind);
                if (stream == null || (info = (LinkedHashMap)stream.get(streamNumber)) == null || (value = (String)info.get(key)) == null || value.length() <= 0) continue;
                return value;
            }
        }
        return "";
    }

    private String getMediaInfoContains(MediaInfo.StreamKind streamKind, int streamNumber, String search, String ... keys) {
        if (this.miSnapshot == null) {
            this.getMediaInfoSnapshot();
        }
        if (this.miSnapshot != null) {
            for (String key : keys) {
                String value;
                LinkedHashMap info;
                List<Map<String, String>> stream = this.miSnapshot.get((Object)streamKind);
                if (stream == null || (info = (LinkedHashMap)stream.get(streamNumber)) == null || (value = (String)info.get(key)) == null || value.length() <= 0 || !value.toLowerCase(Locale.ROOT).contains(search.toLowerCase(Locale.ROOT))) continue;
                return search;
            }
        }
        return "";
    }

    public static boolean isEmptyValue(Object object) {
        return object == null || object.toString().length() == 0;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getVideoCodec() {
        return this.videoCodec;
    }

    public void setVideoCodec(String newValue) {
        if ("avc".equalsIgnoreCase(newValue) || "x264".equalsIgnoreCase(newValue)) {
            newValue = "h264";
        }
        String oldValue = this.videoCodec;
        this.videoCodec = newValue;
        this.firePropertyChange("videoCodec", oldValue, newValue);
    }

    public String getAudioCodec() {
        String codec = "";
        MediaFileAudioStream highestStream = this.getDefaultOrBestAudioStream();
        if (highestStream != null) {
            codec = highestStream.getCodec();
        }
        return codec;
    }

    public List<String> getAudioCodecList() {
        ArrayList<String> audioCodecs = new ArrayList<String>();
        for (MediaFileAudioStream stream : this.audioStreams) {
            audioCodecs.add(stream.getCodec());
        }
        return audioCodecs;
    }

    private MediaFileAudioStream getBestAudioStream() {
        MediaFileAudioStream highestStream = null;
        for (MediaFileAudioStream stream : this.audioStreams) {
            if (highestStream == null) {
                highestStream = stream;
                continue;
            }
            if (highestStream.getAudioChannels() >= stream.getAudioChannels()) continue;
            highestStream = stream;
        }
        return highestStream;
    }

    public String getAudioLanguage() {
        String language = "";
        MediaFileAudioStream highestStream = this.getDefaultOrBestAudioStream();
        if (highestStream != null) {
            language = highestStream.getLanguage();
        }
        return language;
    }

    public List<String> getAudioLanguagesList() {
        ArrayList<String> audioLanguages = new ArrayList<String>();
        for (MediaFileAudioStream stream : this.audioStreams) {
            audioLanguages.add(stream.getLanguage());
        }
        return audioLanguages;
    }

    public String getContainerFormat() {
        return this.containerFormat;
    }

    public void setContainerFormatDirect() {
        String extensions = this.getMediaInfo(MediaInfo.StreamKind.General, 0, "Codec/Extensions", "Format");
        this.setContainerFormat(this.getFirstEntryViaScanner(extensions).toLowerCase(Locale.ROOT));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getFirstEntryViaScanner(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return "";
        }
        try (Scanner scanner = new Scanner(string);){
            String string2 = scanner.next();
            return string2;
        }
        catch (Exception e) {
            LOGGER.error("could not parse string {} with a Scanner: {}", (Object)string, (Object)e.getMessage());
            return "";
        }
    }

    public void setContainerFormat(String newValue) {
        String oldValue = this.containerFormat;
        this.containerFormat = newValue;
        this.firePropertyChange("containerFormat", oldValue, newValue);
    }

    public static List<String> getVideoFormats() {
        Field[] declaredFields;
        ArrayList<String> videoFormats = new ArrayList<String>();
        for (Field field : declaredFields = MediaFile.class.getDeclaredFields()) {
            if (!Modifier.isStatic(field.getModifiers()) || !field.getName().startsWith("VIDEO_FORMAT_") || field.isAnnotationPresent(Deprecated.class)) continue;
            try {
                videoFormats.add((String)field.get(null));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return videoFormats;
    }

    public String getVideoFormat() {
        int w = this.getVideoWidth();
        int h = this.getVideoHeight();
        if (w == 0 || h == 0) {
            return "";
        }
        if (w <= this.blur(128) && h <= this.blur(96)) {
            return VIDEO_FORMAT_96P;
        }
        if (w <= this.blur(160) && h <= this.blur(120)) {
            return VIDEO_FORMAT_120P;
        }
        if (w <= this.blur(176) && h <= this.blur(144)) {
            return VIDEO_FORMAT_144P;
        }
        if (w <= this.blur(256) && h <= this.blur(144)) {
            return VIDEO_FORMAT_144P;
        }
        if (w <= this.blur(320) && h <= this.blur(240)) {
            return VIDEO_FORMAT_240P;
        }
        if (w <= this.blur(352) && h <= this.blur(240)) {
            return VIDEO_FORMAT_240P;
        }
        if (w <= this.blur(426) && h <= this.blur(240)) {
            return VIDEO_FORMAT_240P;
        }
        if (w <= this.blur(480) && h <= this.blur(272)) {
            return VIDEO_FORMAT_288P;
        }
        if (w <= this.blur(480) && h <= this.blur(360)) {
            return VIDEO_FORMAT_360P;
        }
        if (w <= this.blur(640) && h <= this.blur(360)) {
            return VIDEO_FORMAT_360P;
        }
        if (w <= this.blur(640) && h <= this.blur(480)) {
            return VIDEO_FORMAT_480P;
        }
        if (w <= this.blur(720) && h <= this.blur(480)) {
            return VIDEO_FORMAT_480P;
        }
        if (w <= this.blur(800) && h <= this.blur(480)) {
            return VIDEO_FORMAT_480P;
        }
        if (w <= this.blur(853) && h <= this.blur(480)) {
            return VIDEO_FORMAT_480P;
        }
        if (w <= this.blur(776) && h <= this.blur(592)) {
            return VIDEO_FORMAT_576P;
        }
        if (w <= this.blur(960) && h <= this.blur(544)) {
            return VIDEO_FORMAT_540P;
        }
        if (w <= this.blur(1280) && h <= this.blur(720)) {
            return VIDEO_FORMAT_720P;
        }
        if (w <= this.blur(960) && h <= this.blur(720)) {
            return VIDEO_FORMAT_720P;
        }
        if (w <= this.blur(1080) && h <= this.blur(720)) {
            return VIDEO_FORMAT_720P;
        }
        if (w <= this.blur(1920) && h <= this.blur(1080)) {
            return VIDEO_FORMAT_1080P;
        }
        if (w <= this.blur(1440) && h <= this.blur(1080)) {
            return VIDEO_FORMAT_1080P;
        }
        if (w <= this.blur(1620) && h <= this.blur(1080)) {
            return VIDEO_FORMAT_1080P;
        }
        if (w <= this.blur(3840) && h <= this.blur(2160)) {
            return VIDEO_FORMAT_2160P;
        }
        if (w <= this.blur(3840) && h <= this.blur(1600)) {
            return VIDEO_FORMAT_2160P;
        }
        if (w <= this.blur(4096) && h <= this.blur(2160)) {
            return VIDEO_FORMAT_2160P;
        }
        if (w <= this.blur(4096) && h <= this.blur(1716)) {
            return VIDEO_FORMAT_2160P;
        }
        if (w <= this.blur(3996) && h <= this.blur(2160)) {
            return VIDEO_FORMAT_2160P;
        }
        return VIDEO_FORMAT_4320P;
    }

    private int blur(int res) {
        return res + res / 100;
    }

    public String getExactVideoFormat() {
        return this.exactVideoFormat;
    }

    public void setExactVideoFormat(String newValue) {
        String oldValue = this.exactVideoFormat;
        this.exactVideoFormat = newValue;
        this.firePropertyChange("exactVideoFormat", oldValue, newValue);
    }

    public String getAudioChannels() {
        String channels = "";
        MediaFileAudioStream highestStream = this.getDefaultOrBestAudioStream();
        if (highestStream != null) {
            channels = highestStream.getAudioChannels() + "ch";
        }
        return channels;
    }

    public List<String> getAudioChannelsList() {
        ArrayList<String> audioChannels = new ArrayList<String>();
        for (MediaFileAudioStream stream : this.audioStreams) {
            audioChannels.add(stream.getAudioChannels() + "ch");
        }
        return audioChannels;
    }

    public String getVideoResolution() {
        if (this.videoWidth == 0 || this.videoHeight == 0) {
            return "";
        }
        return this.videoWidth + "x" + this.videoHeight;
    }

    public int getVideoWidth() {
        return this.videoWidth;
    }

    public int getVideoHeight() {
        return this.videoHeight;
    }

    public void setVideoWidth(int newValue) {
        int oldValue = this.videoWidth;
        this.videoWidth = newValue;
        this.firePropertyChange("videoWidth", oldValue, newValue);
        this.firePropertyChange("videoFormat", oldValue, newValue);
    }

    public void setVideoHeight(int newValue) {
        int oldValue = this.videoHeight;
        this.videoHeight = newValue;
        this.firePropertyChange("videoHeight", oldValue, newValue);
        this.firePropertyChange("videoFormat", oldValue, newValue);
    }

    public Boolean isWidescreen() {
        if (this.videoWidth == 0 || this.videoHeight == 0) {
            return false;
        }
        return (float)this.videoWidth / (float)this.videoHeight > 1.37f;
    }

    public void setAspectRatio(float newValue) {
        if (newValue == this.getAspectRatioCalculated()) {
            return;
        }
        float oldValue = this.aspectRatio;
        this.aspectRatio = newValue;
        this.firePropertyChange("aspectRatio", Float.valueOf(oldValue), Float.valueOf(newValue));
    }

    public float getAspectRatio() {
        if (this.aspectRatio > 0.0f) {
            return this.aspectRatio;
        }
        return this.getAspectRatioCalculated();
    }

    public float getAspectRatioCalculated() {
        float ret = 0.0f;
        if (this.videoWidth == 0 || this.videoHeight == 0) {
            return ret;
        }
        float ar = (float)this.videoWidth / (float)this.videoHeight;
        ret = ar < 1.3499f ? 1.33f : (ar < 1.508f ? 1.37f : (ar < 1.719f ? 1.66f : (ar < 1.8147f ? 1.78f : (ar < 2.0174f ? 1.85f : (ar < 2.2738f ? 2.2f : (ar < 2.3749f ? 2.35f : (ar < 2.4739f ? 2.4f : (ar < 2.6529f ? 2.55f : 2.76f))))))));
        return ret;
    }

    public String getVideoDefinitionCategory() {
        if (!this.isVideo()) {
            return "";
        }
        if (this.videoWidth == 0 || this.videoHeight == 0) {
            return "";
        }
        if (this.videoWidth <= 640 && this.videoHeight <= 360) {
            return VIDEO_FORMAT_LD;
        }
        if (this.videoWidth < 1280 && this.videoHeight < 720) {
            return VIDEO_FORMAT_SD;
        }
        return VIDEO_FORMAT_HD;
    }

    public boolean isVideoDefinitionLD() {
        return VIDEO_FORMAT_LD.equals(this.getVideoDefinitionCategory());
    }

    public boolean isVideoDefinitionSD() {
        return VIDEO_FORMAT_SD.equals(this.getVideoDefinitionCategory());
    }

    public boolean isVideoDefinitionHD() {
        return VIDEO_FORMAT_HD.equals(this.getVideoDefinitionCategory());
    }

    public int getOverallBitRate() {
        return this.overallBitRate;
    }

    public void setOverallBitRate(int newValue) {
        int oldValue = this.overallBitRate;
        this.overallBitRate = newValue;
        this.firePropertyChange("overallBitRate", oldValue, newValue);
        this.firePropertyChange("bitRateInKbps", oldValue, newValue);
    }

    public String getBiteRateInKbps() {
        return this.overallBitRate + " kbps";
    }

    public double getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(double frameRate) {
        double oldValue = this.frameRate;
        this.frameRate = frameRate;
        this.firePropertyChange("frameRate", oldValue, frameRate);
    }

    public int getBitDepth() {
        return this.bitDepth;
    }

    public void setBitDepth(int newValue) {
        int oldValue = this.bitDepth;
        this.bitDepth = newValue;
        this.firePropertyChange("bitDepth", oldValue, newValue);
    }

    public String getBitDepthString() {
        return this.bitDepth + " bit";
    }

    public int getDuration() {
        return this.durationInSecs;
    }

    public int getDurationInMinutes() {
        return this.durationInSecs / 60;
    }

    public String getDurationHM() {
        if (this.durationInSecs == 0) {
            return "";
        }
        long h = TimeUnit.SECONDS.toHours(this.durationInSecs);
        long m = TimeUnit.SECONDS.toMinutes((long)this.durationInSecs - TimeUnit.HOURS.toSeconds(h));
        long s = TimeUnit.SECONDS.toSeconds((long)this.durationInSecs - TimeUnit.HOURS.toSeconds(h) - TimeUnit.MINUTES.toSeconds(m));
        if (s > 30L) {
            ++m;
        }
        return String.format("%dh %02dm", h, m);
    }

    public String getDurationHMS() {
        if (this.durationInSecs == 0) {
            return "";
        }
        long h = TimeUnit.SECONDS.toHours(this.durationInSecs);
        long m = TimeUnit.SECONDS.toMinutes((long)this.durationInSecs - TimeUnit.HOURS.toSeconds(h));
        long s = TimeUnit.SECONDS.toSeconds((long)this.durationInSecs - TimeUnit.HOURS.toSeconds(h) - TimeUnit.MINUTES.toSeconds(m));
        return String.format("%dh %02dm %02ds", h, m, s);
    }

    public String getDurationHHMMSS() {
        if (this.durationInSecs == 0) {
            return "";
        }
        long h = TimeUnit.SECONDS.toHours(this.durationInSecs);
        long m = TimeUnit.SECONDS.toMinutes((long)this.durationInSecs - TimeUnit.HOURS.toSeconds(h));
        long s = TimeUnit.SECONDS.toSeconds((long)this.durationInSecs - TimeUnit.HOURS.toSeconds(h) - TimeUnit.MINUTES.toSeconds(m));
        return String.format("%02d:%02d:%02d", h, m, s);
    }

    public String getDurationShort() {
        if (this.durationInSecs == 0) {
            return "";
        }
        long h = TimeUnit.SECONDS.toHours(this.durationInSecs);
        long m = TimeUnit.SECONDS.toMinutes((long)this.durationInSecs - TimeUnit.HOURS.toSeconds(h));
        long s = TimeUnit.SECONDS.toSeconds((long)this.durationInSecs - TimeUnit.HOURS.toSeconds(h) - TimeUnit.MINUTES.toSeconds(m));
        if (h > 0L) {
            return String.format("%d:%02d:%02d", h, m, s);
        }
        if (m > 0L) {
            return String.format("%d:%02d", m, s);
        }
        return String.format("%d", s);
    }

    public void setDuration(int newValue) {
        int oldValue = this.durationInSecs;
        this.durationInSecs = newValue;
        this.firePropertyChange("duration", oldValue, newValue);
        this.firePropertyChange("durationShort", oldValue, newValue);
        this.firePropertyChange("durationHM", oldValue, newValue);
        this.firePropertyChange("durationHHMMSS", oldValue, newValue);
    }

    public List<MediaFileAudioStream> getAudioStreams() {
        return this.audioStreams;
    }

    public MediaFileAudioStream getDefaultOrBestAudioStream() {
        MediaFileAudioStream ret = null;
        for (MediaFileAudioStream as : this.audioStreams) {
            if (ret != null || !as.isDefaultStream()) continue;
            ret = as;
            break;
        }
        if (ret == null) {
            ret = this.getBestAudioStream();
        }
        return ret;
    }

    public void setAudioStreams(List<MediaFileAudioStream> audioStreams) {
        this.audioStreams = audioStreams;
    }

    public String getCombinedCodecs() {
        StringBuilder sb = new StringBuilder(this.videoCodec);
        for (MediaFileAudioStream audioStream : this.audioStreams) {
            if (sb.length() > 0) {
                sb.append(" / ");
            }
            sb.append(audioStream.getCodec());
        }
        return sb.toString();
    }

    public String getVideo3DFormat() {
        return this.video3DFormat;
    }

    public void setVideo3DFormat(String video3DFormat) {
        this.video3DFormat = video3DFormat;
    }

    public boolean isAnimatedGraphic() {
        return this.isAnimatedGraphic;
    }

    public void setAnimatedGraphic(boolean isAnimatedGraphic) {
        this.isAnimatedGraphic = isAnimatedGraphic;
    }

    public boolean isHDR() {
        return this.HDR;
    }

    public void setHDR(boolean hdrange) {
        this.HDR = hdrange;
    }

    public void checkForAnimation() {
        if (this.isGraphic() && this.getExtension().equalsIgnoreCase("gif")) {
            try {
                GifDecoder decoder = new GifDecoder();
                decoder.read(this.getFileAsPath().toString());
                if (decoder.getFrameCount() > 1) {
                    this.setAnimatedGraphic(true);
                }
            }
            catch (Exception e) {
                LOGGER.warn("error checking GIF for animation");
            }
        }
    }

    private long getMediaInfoSnapshotFromISO() {
        Path xmlFile = Paths.get(this.path, this.filename.replaceAll("(?i)\\.iso$", "-mediainfo.xml"));
        if (Files.exists(xmlFile, new LinkOption[0])) {
            try {
                LOGGER.info("ISO: try to parse {}", (Object)xmlFile);
                MediaInfoXMLParser xml = MediaInfoXMLParser.parseXML(xmlFile);
                this.setMiSnapshot(xml.getMainFile().snapshot);
                this.setDuration(Math.max(xml.getMainFile().getDuration(), xml.getRuntimeFromDvdFiles()));
                return 0L;
            }
            catch (Exception e) {
                LOGGER.warn("ISO: Unable to parse " + xmlFile, (Throwable)e);
            }
        }
        if (this.miSnapshot == null) {
            int BUFFER_SIZE = 65536;
            Iso9660FileSystem image = null;
            try {
                LOGGER.trace("ISO: Open");
                image = new Iso9660FileSystem(this.getFileAsPath().toFile(), true);
                int dur = 0;
                long siz = 0L;
                long biggest = 0L;
                for (Iso9660FileEntry entry : image) {
                    MediaFile mf;
                    LOGGER.trace("ISO: got entry " + entry.getName() + " size:" + entry.getSize());
                    siz += entry.getSize();
                    if (entry.getSize() <= 5000L || (mf = new MediaFile(Paths.get(this.getFileAsPath().toString(), entry.getPath()))).getType() != MediaFileType.VIDEO || !mf.isDiscFile()) continue;
                    mf.setFilesize(entry.getSize());
                    MediaInfo fileMI = new MediaInfo();
                    try {
                        int From_Buffer_Size;
                        byte[] From_Buffer = new byte[BUFFER_SIZE];
                        fileMI.openBufferInit(entry.getSize(), 0L);
                        long pos = 0L;
                        do {
                            Long toread;
                            if ((From_Buffer_Size = image.readBytes(entry, pos, From_Buffer, 0, (toread = Long.valueOf(pos + (long)BUFFER_SIZE > entry.getSize() ? entry.getSize() - pos : (long)BUFFER_SIZE)).intValue())) <= 0) continue;
                            pos += (long)From_Buffer_Size;
                            int Result = fileMI.openBufferContinue(From_Buffer, From_Buffer_Size);
                            if ((Result & 8) == 8) break;
                            if (fileMI.openBufferContinueGoToGet() == -1L) continue;
                            pos = fileMI.openBufferContinueGoToGet();
                            LOGGER.trace("ISO: Seek to " + pos);
                            fileMI.openBufferInit(entry.getSize(), pos);
                        } while (From_Buffer_Size > 0);
                        LOGGER.trace("ISO: finalize");
                        fileMI.openBufferFinalize();
                        Map<MediaInfo.StreamKind, List<Map<String, String>>> tempSnapshot = fileMI.snapshot();
                        fileMI.close();
                        mf.setMiSnapshot(tempSnapshot);
                        mf.gatherMediaInformation();
                        if (entry.getSize() > biggest) {
                            biggest = entry.getSize();
                            this.miSnapshot = tempSnapshot;
                        }
                        if (mf.getDuration() > dur) {
                            dur = mf.getDuration();
                        }
                        LOGGER.trace("ISO: file duration: {} - highest dur {} min", (Object)mf.getDurationHHMMSS(), (Object)(dur / 60));
                    }
                    catch (Error | Exception e) {
                        LOGGER.error("Mediainfo could not open file STREAM", e);
                        fileMI.close();
                    }
                }
                this.setDuration(dur);
                LOGGER.trace("ISO: final duration:" + this.getDurationHHMMSS());
                image.close();
                return siz;
            }
            catch (Exception e) {
                LOGGER.error("Mediainfo could not open STREAM - trying fallback", (Throwable)e);
                try {
                    if (image != null) {
                        image.close();
                        image = null;
                    }
                }
                catch (IOException e1) {
                    LOGGER.warn("Uh-oh. Cannot close disc image :(", (Throwable)e);
                }
                this.closeMediaInfo();
                this.getMediaInfoSnapshot();
            }
        }
        return 0L;
    }

    private void setMediaInfo(MediaInfo mediaInfo) {
        this.mediaInfo = mediaInfo;
    }

    private void setMiSnapshot(Map<MediaInfo.StreamKind, List<Map<String, String>>> miSnapshot) {
        this.miSnapshot = miSnapshot;
    }

    public void gatherMediaInformation() {
        this.gatherMediaInformation(false);
    }

    private int parseToInt(String str) {
        try {
            return Integer.parseInt(str.trim());
        }
        catch (Exception ignored) {
            return 0;
        }
    }

    private int getStreamCount(MediaInfo.StreamKind kind) {
        List<Map<String, String>> map = this.miSnapshot.get((Object)kind);
        if (map != null) {
            return map.size();
        }
        return 0;
    }

    private void fetchAudioInformation() {
        int streams = this.parseToInt(this.getMediaInfo(MediaInfo.StreamKind.General, 0, "AudioCount"));
        if (streams == 0) {
            streams = this.getStreamCount(MediaInfo.StreamKind.Audio);
        }
        this.audioStreams.clear();
        for (int i = 0; i < streams; ++i) {
            String def;
            String commName;
            String audioProfile;
            String addFeature;
            String[] acSearch = new String[]{"Format", "Format_Profile", "Format_Commercial", "Format_Commercial_IfAny", "CodecID", "Codec"};
            String audioCodec = this.getMediaInfoContains(MediaInfo.StreamKind.Audio, i, "TrueHD", acSearch);
            if (audioCodec.isEmpty()) {
                audioCodec = this.getMediaInfoContains(MediaInfo.StreamKind.Audio, i, "Atmos", acSearch);
            }
            if (audioCodec.isEmpty()) {
                audioCodec = this.getMediaInfoContains(MediaInfo.StreamKind.Audio, i, "DTS", acSearch);
            }
            if (audioCodec.isEmpty()) {
                audioCodec = this.getMediaInfo(MediaInfo.StreamKind.Audio, i, "Format");
                audioCodec = audioCodec.replaceAll("\\p{Punct}", "");
            }
            if (!(addFeature = this.getMediaInfo(MediaInfo.StreamKind.Audio, i, "Format_AdditionalFeatures")).isEmpty()) {
                if ("dts".equalsIgnoreCase(audioCodec)) {
                    if (addFeature.startsWith("XLL")) {
                        audioCodec = addFeature.endsWith("X") ? "DTS-X" : "DTSHD-MA";
                    }
                    if (addFeature.equals("ES")) {
                        audioCodec = "DTS-ES";
                    }
                    if (addFeature.equals("XBR")) {
                        audioCodec = "DTSHD-HRA";
                    }
                }
                if ("TrueHD".equalsIgnoreCase(audioCodec) && addFeature.equalsIgnoreCase("16-ch")) {
                    audioCodec = "Atmos";
                }
            }
            if (!(audioProfile = this.getMediaInfo(MediaInfo.StreamKind.Audio, i, "Format_Profile", "Format_profile")).isEmpty()) {
                if ("dts".equalsIgnoreCase(audioCodec)) {
                    if (audioProfile.contains("ES")) {
                        audioCodec = "DTS-ES";
                    }
                    if (audioProfile.contains("HRA")) {
                        audioCodec = "DTSHD-HRA";
                    }
                    if (audioProfile.contains("MA")) {
                        audioCodec = "DTSHD-MA";
                    }
                    if (audioProfile.contains("X")) {
                        audioCodec = "DTS-X";
                    }
                }
                if ("TrueHD".equalsIgnoreCase(audioCodec) && audioProfile.contains("Atmos")) {
                    audioCodec = "Atmos";
                }
            }
            if (("ac3".equalsIgnoreCase(audioCodec) || "dts".equalsIgnoreCase(audioCodec) || "TrueHD".equalsIgnoreCase(audioCodec)) && !(commName = this.getMediaInfo(MediaInfo.StreamKind.Audio, i, "Format_Commercial", "Format_Commercial_IfAny").toLowerCase(Locale.ROOT)).isEmpty()) {
                if (commName.contains("master audio")) {
                    audioCodec = "DTSHD-MA";
                }
                if (commName.contains("high resolution audio")) {
                    audioCodec = "DTSHD-HRA";
                }
                if (commName.contains("extended") || commName.contains("es matrix") || commName.contains("es discrete")) {
                    audioCodec = "DTS-ES";
                }
                if (commName.contains("atmos")) {
                    audioCodec = "Atmos";
                }
                if (commName.contains("ex audio")) {
                    audioCodec = "AC3EX";
                }
            }
            MediaFileAudioStream stream = new MediaFileAudioStream();
            stream.setCodec(audioCodec);
            int ch = this.parseChannelsAsInt(this.getMediaInfo(MediaInfo.StreamKind.Audio, i, "Channel(s)"));
            int ch2 = this.parseChannelsAsInt(this.getMediaInfo(MediaInfo.StreamKind.Audio, i, "Channel(s)_Original"));
            if (ch2 > ch) {
                ch = ch2;
            }
            stream.setAudioChannels(ch);
            String br = this.getMediaInfo(MediaInfo.StreamKind.Audio, i, "BitRate", "BitRate_Maximum", "BitRate_Minimum", "BitRate_Nominal");
            try {
                String[] brMode = this.getMediaInfo(MediaInfo.StreamKind.Audio, i, "BitRate_Mode").split("/");
                if (brMode.length > 1) {
                    String[] brChunks = br.split("/");
                    int brMult = 0;
                    for (String brChunk : brChunks) {
                        brMult += this.parseToInt(brChunk.trim());
                    }
                    stream.setBitrate(brMult / 1000);
                } else {
                    stream.setBitrate(Integer.parseInt(br) / 1000);
                }
            }
            catch (Exception brMode) {
                // empty catch block
            }
            String language = this.getMediaInfo(MediaInfo.StreamKind.Audio, i, "Language/String", "Language");
            if (language.isEmpty()) {
                if (!this.isDiscFile()) {
                    String shortname = this.getBasename().toLowerCase(Locale.ROOT);
                    stream.setLanguage(this.parseLanguageFromString(shortname));
                }
            } else {
                stream.setLanguage(this.parseLanguageFromString(language));
            }
            if ((def = this.getMediaInfo(MediaInfo.StreamKind.Audio, i, "Default")).equalsIgnoreCase("yes")) {
                stream.setDefaultStream(true);
            }
            this.audioStreams.add(stream);
        }
    }

    public int parseChannelsAsInt(String channels) {
        int highest = 0;
        if (!channels.isEmpty()) {
            try {
                String[] parts;
                for (String p : parts = channels.split("/")) {
                    String[] c;
                    if (p.toLowerCase(Locale.ROOT).contains("object")) continue;
                    p = p.replaceAll("[a-zA-Z]", "");
                    int ch = 0;
                    for (String s : c = p.split("[^0-9]")) {
                        if (!s.matches("[0-9]+")) continue;
                        ch += Integer.parseInt(s);
                    }
                    if (ch <= highest) continue;
                    highest = ch;
                }
            }
            catch (NumberFormatException e) {
                highest = 0;
            }
        }
        return highest;
    }

    private void fetchVideoInformation() {
        String mvc;
        int height = this.parseToInt(this.getMediaInfo(MediaInfo.StreamKind.Video, 0, "Height"));
        String scanType = this.getMediaInfo(MediaInfo.StreamKind.Video, 0, "ScanType");
        int width = this.parseToInt(this.getMediaInfo(MediaInfo.StreamKind.Video, 0, "Width"));
        String codecId = this.getMediaInfo(MediaInfo.StreamKind.Video, 0, "CodecID");
        String videoCodec = this.getMediaInfo(MediaInfo.StreamKind.Video, 0, "CodecID/Hint", "Format");
        if (StringUtils.containsIgnoreCase((CharSequence)videoCodec, (CharSequence)"Microsoft")) {
            videoCodec = this.getMediaInfo(MediaInfo.StreamKind.Video, 0, "Format");
        }
        if (codecId.equalsIgnoreCase("XVID")) {
            videoCodec = "XVID";
        }
        if (StringUtils.containsIgnoreCase((CharSequence)videoCodec, (CharSequence)"MPEG")) {
            try {
                int version = Integer.parseInt(this.getMediaInfo(MediaInfo.StreamKind.Video, 0, "Format_Version"));
                videoCodec = "MPEG-" + version;
            }
            catch (Exception e) {
                LOGGER.trace("could not parse MPEG version: {}", (Object)e.getMessage());
            }
        }
        String bd = this.getMediaInfo(MediaInfo.StreamKind.Video, 0, "BitDepth");
        this.setBitDepth(this.parseToInt(bd));
        try {
            String fr = this.getMediaInfo(MediaInfo.StreamKind.Video, 0, "FrameRate");
            this.setFrameRate(Double.parseDouble(fr));
        }
        catch (Exception fr) {
            // empty catch block
        }
        if (height == 0 || scanType.isEmpty()) {
            this.setExactVideoFormat("");
        } else {
            this.setExactVideoFormat(height + "" + Character.toLowerCase(scanType.charAt(0)));
        }
        this.setVideoWidth(width);
        this.setVideoHeight(height);
        this.setVideoCodec(this.getFirstEntryViaScanner(videoCodec));
        String extensions = this.getMediaInfo(MediaInfo.StreamKind.General, 0, "Codec/Extensions", "Format");
        this.setContainerFormat(this.getFirstEntryViaScanner(extensions).toLowerCase(Locale.ROOT));
        if (StringUtils.isBlank((CharSequence)this.containerFormat)) {
            this.setContainerFormat(this.getExtension());
        }
        if (!StringUtils.isEmpty((CharSequence)(mvc = this.getMediaInfo(MediaInfo.StreamKind.Video, 0, "MultiView_Count"))) && mvc.equals("2")) {
            this.video3DFormat = VIDEO_3D;
            String mvl = this.getMediaInfo(MediaInfo.StreamKind.Video, 0, "MultiView_Layout").toLowerCase(Locale.ROOT);
            LOGGER.debug("3D detected :) - {}", (Object)mvl);
            if (!StringUtils.isEmpty((CharSequence)mvl) && mvl.contains("top") && mvl.contains("bottom")) {
                this.video3DFormat = VIDEO_3D_HTAB;
                if (height > width) {
                    this.video3DFormat = VIDEO_3D_TAB;
                }
            }
            if (!StringUtils.isEmpty((CharSequence)mvl) && mvl.contains("side")) {
                this.video3DFormat = VIDEO_3D_HSBS;
                if (this.getAspectRatioCalculated() > 3.0f) {
                    this.video3DFormat = VIDEO_3D_SBS;
                }
            }
            if (!StringUtils.isEmpty((CharSequence)mvl) && mvl.contains("laced")) {
                this.video3DFormat = VIDEO_3D_MVC;
            }
        } else if (width == 3840 && height == 1080) {
            this.video3DFormat = VIDEO_3D_SBS;
        } else if (width == 1920 && height == 2160) {
            this.video3DFormat = VIDEO_3D_TAB;
        }
        String hdr = this.getMediaInfo(MediaInfo.StreamKind.Video, 0, "colour_primaries");
        if (hdr.contains("2020")) {
            this.setHDR(true);
        }
    }

    private void fetchSubtitleInformation() {
        int streams = this.parseToInt(this.getMediaInfo(MediaInfo.StreamKind.General, 0, "TextCount")) > 0 ? this.parseToInt(this.getMediaInfo(MediaInfo.StreamKind.General, 0, "TextCount")) : this.parseToInt(this.getMediaInfo(MediaInfo.StreamKind.Text, 0, "StreamCount"));
        this.subtitles.clear();
        for (int i = 0; i < streams; ++i) {
            MediaFileSubtitle stream = new MediaFileSubtitle();
            String codec = this.getMediaInfo(MediaInfo.StreamKind.Text, i, "CodecID/Hint", "Format");
            stream.setCodec(codec.replaceAll("\\p{Punct}", ""));
            String lang = this.getMediaInfo(MediaInfo.StreamKind.Text, i, "Language/String", "Language");
            stream.setLanguage(this.parseLanguageFromString(lang));
            String forced = this.getMediaInfo(MediaInfo.StreamKind.Text, i, "Forced");
            boolean b = forced.equalsIgnoreCase("true") || forced.equalsIgnoreCase("yes");
            stream.setForced(b);
            String def = this.getMediaInfo(MediaInfo.StreamKind.Text, i, "Default");
            if (def.equalsIgnoreCase("yes")) {
                stream.setDefaultStream(true);
            }
            this.subtitles.add(stream);
        }
    }

    private void fetchImageInformation() {
        int height = this.parseToInt(this.getMediaInfo(MediaInfo.StreamKind.Image, 0, "Height"));
        int width = this.parseToInt(this.getMediaInfo(MediaInfo.StreamKind.Image, 0, "Width"));
        String videoCodec = this.getMediaInfo(MediaInfo.StreamKind.Image, 0, "CodecID/Hint", "Format");
        this.checkForAnimation();
        this.setVideoHeight(height);
        this.setVideoWidth(width);
        this.setVideoCodec(this.getFirstEntryViaScanner(videoCodec));
        String extensions = this.getMediaInfo(MediaInfo.StreamKind.General, 0, "Codec/Extensions", "Format");
        this.setContainerFormat(this.getFirstEntryViaScanner(extensions).toLowerCase(Locale.ROOT));
        String bd = this.getMediaInfo(MediaInfo.StreamKind.Image, 0, "BitDepth");
        this.setBitDepth(this.parseToInt(bd));
        if (StringUtils.isBlank((CharSequence)this.containerFormat)) {
            this.setContainerFormat(this.getExtension());
        }
    }

    public void gatherMediaInformation(boolean force) {
        block30: {
            if (!this.isValidMediainfoFormat()) {
                if (StringUtils.isBlank((CharSequence)this.getContainerFormat())) {
                    this.setContainerFormat(this.getExtension());
                }
                return;
            }
            if (!force && !this.getContainerFormat().isEmpty()) {
                return;
            }
            if (this.getType() == MediaFileType.SUBTITLE) {
                this.gatherSubtitleInformation();
            }
            try {
                BasicFileAttributes attrs = Files.readAttributes(this.getFileAsPath(), BasicFileAttributes.class, new LinkOption[0]);
                this.filedate = attrs.lastModifiedTime().toMillis();
                this.setFilesize(attrs.size());
            }
            catch (IOException e) {
                if (this.miSnapshot != null) break block30;
                LOGGER.warn("could not get file information (size/date): {}", (Object)e.getMessage());
            }
        }
        if (this.getFilesize() == 0L) {
            LOGGER.warn("0 Byte file detected: {}", (Object)this.filename);
            this.setContainerFormat(this.getExtension());
            return;
        }
        if (this.type == MediaFileType.SUBTITLE || this.type == MediaFileType.NFO) {
            this.setContainerFormat(this.getExtension());
            return;
        }
        LOGGER.debug("start MediaInfo for {}", (Object)this.getFileAsPath());
        long discFilesSizes = 0L;
        if (this.isISO) {
            discFilesSizes = this.getMediaInfoSnapshotFromISO();
        } else {
            this.getMediaInfoSnapshot();
        }
        if (this.miSnapshot == null) {
            LOGGER.error("error getting MediaInfo for {}", (Object)this.filename);
            this.setContainerFormat(this.getExtension());
            this.closeMediaInfo();
            return;
        }
        LOGGER.trace("got MI");
        switch (this.type) {
            case VIDEO: 
            case TRAILER: 
            case SAMPLE: 
            case EXTRA: {
                this.fetchVideoInformation();
                this.fetchAudioInformation();
                this.fetchSubtitleInformation();
                break;
            }
            case AUDIO: {
                this.fetchAudioInformation();
                break;
            }
            case GRAPHIC: 
            case BANNER: 
            case FANART: 
            case POSTER: 
            case THUMB: 
            case LOGO: 
            case CLEARLOGO: 
            case CLEARART: 
            case CHARACTERART: 
            case KEYART: 
            case SEASON_POSTER: 
            case SEASON_BANNER: 
            case SEASON_THUMB: 
            case EXTRAFANART: 
            case EXTRATHUMB: 
            case DISC: {
                this.fetchImageInformation();
                break;
            }
            case NFO: {
                break;
            }
            default: {
                LOGGER.warn("no mediainformation handling for MediaFile type {} yet.", (Object)this.getType());
            }
        }
        if (this.type == MediaFileType.SUBTITLE) {
            this.setContainerFormat(this.getExtension());
        } else {
            String extensions = this.getMediaInfo(MediaInfo.StreamKind.General, 0, "Codec/Extensions", "Format");
            this.setContainerFormat(this.getFirstEntryViaScanner(extensions).toLowerCase(Locale.ROOT));
            if (StringUtils.isBlank((CharSequence)this.containerFormat)) {
                this.setContainerFormat(this.getExtension());
            }
        }
        switch (this.type) {
            case VIDEO: 
            case TRAILER: 
            case SAMPLE: 
            case EXTRA: 
            case AUDIO: {
                String miTitle;
                String br = this.getMediaInfo(MediaInfo.StreamKind.General, 0, "OverallBitRate");
                if (!br.isEmpty()) {
                    try {
                        this.setOverallBitRate(Integer.parseInt(br) / 1000);
                    }
                    catch (NumberFormatException e) {
                        this.setOverallBitRate(0);
                    }
                }
                if (!(miTitle = this.getMediaInfo(MediaInfo.StreamKind.General, 0, "Title")).isEmpty()) {
                    this.setTitle(miTitle);
                }
                if (!this.isISO) {
                    String dur = this.getMediaInfo(MediaInfo.StreamKind.General, 0, "Duration");
                    if (dur.isEmpty()) break;
                    try {
                        Double d = Double.parseDouble(dur);
                        this.setDuration(d.intValue() / 1000);
                    }
                    catch (NumberFormatException e) {
                        this.setDuration(0);
                    }
                    break;
                }
                if (discFilesSizes <= 0L || this.filesize <= 0L) break;
                long diff = Math.abs(this.filesize - discFilesSizes);
                Double ratio = (double)diff * 100.0 / (double)this.filesize;
                LOGGER.debug("ISO size:" + this.filesize + "  reportedDataSize:" + discFilesSizes + "  = diff:" + diff + " ~" + ratio.intValue() + "%");
                if (!(ratio > 10.0)) break;
                LOGGER.error("ISO file seems to have an invalid structure - ignore duration");
                this.setDuration(0);
            }
        }
        LOGGER.trace("extracted MI");
        this.closeMediaInfo();
        LOGGER.trace("closed MI");
    }

    private String parseLanguageFromString(String shortname) {
        if (StringUtils.isBlank((CharSequence)shortname)) {
            return "";
        }
        Set langArray = LanguageUtils.KEY_TO_LOCALE_MAP.keySet();
        shortname = shortname.replaceAll("(?i)Part [Ii]+", "");
        shortname = StringUtils.split((String)shortname, (char)'/')[0].trim();
        for (String s : langArray) {
            try {
                if (!LanguageUtils.doesStringEndWithLanguage((String)shortname, (String)s)) continue;
                LOGGER.debug("found language '" + s + "' in '" + this.getFilename());
                return LanguageUtils.getIso3LanguageFromLocalizedString((String)s);
            }
            catch (Exception e) {
                LOGGER.warn("Error parsing subtitle language from locale keyset: " + s, (Throwable)e);
            }
        }
        return "";
    }

    private boolean isValidMediainfoFormat() {
        String extension = FilenameUtils.getExtension((String)this.filename).toLowerCase(Locale.ROOT);
        if ("bin".equals(extension) || "dat".equals(extension) || "img".equals(extension) || "nrg".equals(extension) || "disc".equals(extension)) {
            return false;
        }
        if ("iso".equals(extension)) {
            this.isISO = true;
            return true;
        }
        return this.type.equals((Object)MediaFileType.VIDEO) || this.type.equals((Object)MediaFileType.EXTRA) || this.type.equals((Object)MediaFileType.TRAILER) || this.type.equals((Object)MediaFileType.SAMPLE) || this.type.equals((Object)MediaFileType.SUBTITLE) || this.type.equals((Object)MediaFileType.AUDIO) || this.type.equals((Object)MediaFileType.NFO) || this.isGraphic();
    }

    public boolean exists() {
        return Files.exists(this.getFileAsPath(), new LinkOption[0]);
    }

    public boolean deleteSafely(String datasource) {
        return Utils.deleteFileWithBackup(this.getFileAsPath(), datasource);
    }

    public boolean equals(Object mf2) {
        if (mf2 instanceof MediaFile) {
            return this.compareTo((MediaFile)mf2) == 0;
        }
        return false;
    }

    @Override
    public int compareTo(MediaFile mf2) {
        return this.getFileAsPath().compareTo(mf2.getFileAsPath());
    }

    public int hashCode() {
        return this.getFileAsPath().hashCode();
    }
}

