/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.util.UrlUtil;

public class Person
extends AbstractModelObject {
    public static final String ACTOR_DIR = ".actors";
    @JsonProperty
    private Type type = Type.OTHER;
    @JsonProperty
    private String name = "";
    @JsonProperty
    private String role = "";
    @JsonProperty
    private String thumbUrl = "";
    @JsonProperty
    private String profileUrl = "";

    public Person() {
    }

    public Person(Type type) {
        this.type = type;
    }

    public Person(Type type, String name) {
        this.type = type;
        this.name = name;
    }

    public Person(Type type, String name, String role) {
        this.type = type;
        this.name = name;
        this.role = role;
    }

    public Person(Type type, String name, String role, String thumbUrl) {
        this.type = type;
        this.name = name;
        this.role = role;
        this.thumbUrl = thumbUrl;
    }

    public Person(Type type, String name, String role, String thumbUrl, String profileUrl) {
        this.type = type;
        this.name = name;
        this.role = role;
        this.thumbUrl = thumbUrl;
        this.profileUrl = profileUrl;
    }

    public Person(MediaCastMember mediaCastMember) {
        this.name = mediaCastMember.getName();
        this.thumbUrl = mediaCastMember.getImageUrl();
        this.profileUrl = mediaCastMember.getProfileUrl();
        switch (mediaCastMember.getType()) {
            case ACTOR: {
                this.type = Type.ACTOR;
                this.role = mediaCastMember.getCharacter();
                break;
            }
            case DIRECTOR: {
                this.type = Type.DIRECTOR;
                this.role = mediaCastMember.getPart();
                break;
            }
            case WRITER: {
                this.type = Type.WRITER;
                this.role = mediaCastMember.getPart();
                break;
            }
            case PRODUCER: {
                this.type = Type.PRODUCER;
                this.role = mediaCastMember.getPart();
                break;
            }
            default: {
                this.type = Type.OTHER;
                this.role = mediaCastMember.getPart();
            }
        }
    }

    public Person(Person source) {
        this.type = source.type;
        this.name = source.name;
        this.role = source.role;
        this.thumbUrl = source.thumbUrl;
        this.profileUrl = source.profileUrl;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public void setName(String newValue) {
        String oldValue = this.name;
        this.name = newValue;
        this.firePropertyChange("name", oldValue, newValue);
    }

    public String getName() {
        return this.name;
    }

    public String getNameForStorage() {
        String n = this.name.replace(" ", "_");
        n = n.replaceAll("([\"\\\\:<>|/?*])", "");
        String ext = UrlUtil.getExtension((String)this.thumbUrl);
        if (ext.isEmpty()) {
            ext = "jpg";
        }
        return n + "." + ext;
    }

    public String getRole() {
        return this.role;
    }

    public void setRole(String newValue) {
        String oldValue = this.role;
        this.role = newValue;
        this.firePropertyChange("role", oldValue, newValue);
    }

    public String getThumbUrl() {
        return this.thumbUrl;
    }

    public void setThumbUrl(String newValue) {
        String oldValue = this.thumbUrl;
        this.thumbUrl = newValue;
        this.firePropertyChange("thumb", oldValue, newValue);
    }

    public String getProfileUrl() {
        return this.profileUrl;
    }

    public void setProfileUrl(String profileUrl) {
        this.profileUrl = profileUrl;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Person)) {
            return false;
        }
        Person cast = (Person)obj;
        return StringUtils.equals((CharSequence)this.name, (CharSequence)cast.name) && StringUtils.equals((CharSequence)this.role, (CharSequence)cast.role) && StringUtils.equals((CharSequence)this.thumbUrl, (CharSequence)cast.thumbUrl) && StringUtils.equals((CharSequence)this.profileUrl, (CharSequence)cast.profileUrl);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.name).append((Object)this.role).append((Object)this.thumbUrl).build();
    }

    public static enum Type {
        ACTOR,
        DIRECTOR,
        WRITER,
        PRODUCER,
        OTHER;

    }
}

