/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.text.RuleBasedCollator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.scraper.DynaEnum;

public class MovieEdition
extends DynaEnum<MovieEdition> {
    private static final Comparator<MovieEdition> COMPARATOR = new MovieEditionComparator();
    public static final MovieEdition NONE = new MovieEdition("NONE", 0, "", "");
    public static final MovieEdition DIRECTORS_CUT = new MovieEdition("DIRECTORS_CUT", 1, "Director's Cut", ".Director.?s.(Cut|Edition|Version)");
    public static final MovieEdition EXTENDED_EDITION = new MovieEdition("EXTENDED_EDITION", 2, "Extended Edition", ".Extended.(Cut|Edition|Version)?");
    public static final MovieEdition THEATRICAL_EDITION = new MovieEdition("THEATRICAL_EDITION", 3, "Theatrical Edition", ".Theatrical.(Cut|Edition|Version)?");
    public static final MovieEdition UNRATED = new MovieEdition("UNRATED", 4, "Unrated", ".Unrated.(Cut|Edition|Version)?");
    public static final MovieEdition UNCUT = new MovieEdition("UNCUT", 5, "Uncut", ".Uncut.(Cut|Edition|Version)?");
    public static final MovieEdition IMAX = new MovieEdition("IMAX", 6, "IMAX", "^(IMAX|.*?.IMAX).(Cut|Edition|Version)?");
    public static final MovieEdition SPECIAL_EDITION = new MovieEdition("SPECIAL_EDITION", 7, "Special Edition", ".(Special|Remastered|Collectors|Ultimate|Final).(Cut|Edition|Version)");
    private String title;
    private Pattern pattern;

    private MovieEdition(String enumName, int ordinal, String title, String pattern) {
        super(enumName, ordinal);
        this.title = title;
        this.pattern = StringUtils.isBlank((CharSequence)pattern) ? null : Pattern.compile(pattern, 2);
        this.addElement();
    }

    public String toString() {
        return this.title;
    }

    public String getTitle() {
        return this.title;
    }

    @JsonValue
    public String getName() {
        return this.name();
    }

    public static MovieEdition[] values() {
        MovieEdition[] movieEditions = (MovieEdition[])MovieEdition.values(MovieEdition.class);
        Arrays.sort(movieEditions, COMPARATOR);
        return movieEditions;
    }

    public static MovieEdition getMovieEditionFromString(String stringToParse) {
        for (MovieEdition edition : MovieEdition.values()) {
            Matcher matcher;
            if (edition.name().equalsIgnoreCase(stringToParse)) {
                return edition;
            }
            if (edition.pattern == null || !(matcher = edition.pattern.matcher(stringToParse)).find()) continue;
            return edition;
        }
        return NONE;
    }

    @JsonCreator
    public static MovieEdition getMovieEdition(String name) {
        for (MovieEdition edition : MovieEdition.values()) {
            if (edition.name().equals(name)) {
                return edition;
            }
            if (!edition.title.equalsIgnoreCase(name)) continue;
            return edition;
        }
        return new MovieEdition(name, MovieEdition.values().length, name, "");
    }

    public static void addListener(DynaEnum.DynaEnumEventListener listener) {
        MovieEdition.addListener(MovieEdition.class, (DynaEnum.DynaEnumEventListener)listener);
    }

    public static void removeListener(DynaEnum.DynaEnumEventListener listener) {
        MovieEdition.removeListener(MovieEdition.class, (DynaEnum.DynaEnumEventListener)listener);
    }

    public static class MovieEditionComparator
    implements Comparator<MovieEdition> {
        private RuleBasedCollator stringCollator = (RuleBasedCollator)RuleBasedCollator.getInstance();

        @Override
        public int compare(MovieEdition o1, MovieEdition o2) {
            if (o1.toString() == null && o2.toString() == null) {
                return 0;
            }
            if (o1.toString() == null) {
                return 1;
            }
            if (o2.toString() == null) {
                return -1;
            }
            return this.stringCollator.compare(o1.toString().toLowerCase(Locale.ROOT), o2.toString().toLowerCase(Locale.ROOT));
        }
    }
}

