/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlValue;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.MediaGenres;

public enum MovieSearchOptions {
    DUPLICATES,
    WATCHED,
    GENRE,
    CERTIFICATION,
    CAST,
    TAG,
    MOVIESET,
    VIDEO_FORMAT,
    VIDEO_CODEC,
    AUDIO_CODEC,
    DATASOURCE,
    MISSING_METADATA,
    MISSING_ARTWORK,
    MISSING_SUBTITLES,
    NEW_MOVIES,
    MEDIA_SOURCE,
    YEAR,
    VIDEO_3D,
    OFFLINE;


    public static class MovieSearchOptionsEntryType {
        @XmlAttribute
        public String key;
        @XmlValue
        public String value;

        public MovieSearchOptionsEntryType() {
        }

        public MovieSearchOptionsEntryType(String key, String value) {
            this.key = key;
            this.value = value;
        }
    }

    public static class MovieSearchOptionsMapType {
        public List<MovieSearchOptionsEntryType> entries = new ArrayList<MovieSearchOptionsEntryType>();
    }

    public static class MovieSearchOptionsAdapter
    extends XmlAdapter<MovieSearchOptionsMapType, Map<MovieSearchOptions, Object>> {
        public Map<MovieSearchOptions, Object> unmarshal(MovieSearchOptionsMapType v) {
            HashMap<MovieSearchOptions, Object> options = new HashMap<MovieSearchOptions, Object>();
            if (v == null || v.entries == null) {
                return options;
            }
            for (MovieSearchOptionsEntryType entry : v.entries) {
                try {
                    switch (entry.key) {
                        case "DUPLICATES": 
                        case "WATCHED": 
                        case "MOVIESET": 
                        case "MISSING_METADATA": 
                        case "MISSING_ARTWORK": 
                        case "MISSING_SUBTITLES": 
                        case "NEW_MOVIES": 
                        case "VIDEO_3D": 
                        case "OFFLINE": {
                            options.put(MovieSearchOptions.valueOf(entry.key), Boolean.valueOf(entry.value));
                            break;
                        }
                        case "YEAR": {
                            options.put(MovieSearchOptions.valueOf(entry.key), Integer.valueOf(entry.value));
                            break;
                        }
                        case "GENRE": {
                            options.put(MovieSearchOptions.valueOf(entry.key), MediaGenres.getGenre((String)entry.value));
                            break;
                        }
                        case "CERTIFICATION": {
                            options.put(MovieSearchOptions.valueOf(entry.key), Certification.valueOf((String)entry.value));
                            break;
                        }
                        case "MEDIA_SOURCE": {
                            options.put(MovieSearchOptions.valueOf(entry.key), (Object)MediaSource.getMediaSource(entry.value));
                            break;
                        }
                        default: {
                            options.put(MovieSearchOptions.valueOf(entry.key), entry.value);
                            break;
                        }
                    }
                }
                catch (Exception exception) {}
            }
            return options;
        }

        public MovieSearchOptionsMapType marshal(Map<MovieSearchOptions, Object> v) {
            MovieSearchOptionsMapType output = new MovieSearchOptionsMapType();
            block5: for (Map.Entry<MovieSearchOptions, Object> entry : v.entrySet()) {
                switch (entry.getKey()) {
                    case GENRE: {
                        MediaGenres genre = (MediaGenres)entry.getValue();
                        output.entries.add(new MovieSearchOptionsEntryType(entry.getKey().name(), genre.name()));
                        continue block5;
                    }
                    case CERTIFICATION: {
                        Certification cert = (Certification)entry.getValue();
                        output.entries.add(new MovieSearchOptionsEntryType(entry.getKey().name(), cert.name()));
                        continue block5;
                    }
                    case MEDIA_SOURCE: {
                        MediaSource source = (MediaSource)((Object)entry.getValue());
                        output.entries.add(new MovieSearchOptionsEntryType(entry.getKey().name(), source.name()));
                        continue block5;
                    }
                }
                output.entries.add(new MovieSearchOptionsEntryType(entry.getKey().name(), String.valueOf(entry.getValue())));
            }
            return output;
        }
    }
}

