/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.connector;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.file.Path;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieEdition;
import org.tinymediamanager.core.movie.MovieHelpers;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.movie.entities.MovieTrailer;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.scraper.util.MetadataUtil;
import org.tinymediamanager.scraper.util.StrgUtils;

public class MovieNfoParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieNfoParser.class);
    private Element root;
    private final List<String> supportedElements = new ArrayList<String>();
    public String title = "";
    public String originaltitle = "";
    public String sorttitle = "";
    public int year = -1;
    public Set set = null;
    public int top250 = 0;
    public String plot = "";
    public String outline = "";
    public String tagline = "";
    public int runtime = 0;
    public Certification certification = Certification.UNKNOWN;
    public Date releaseDate = null;
    public boolean watched = false;
    public int playcount = 0;
    public String languages = "";
    public MediaSource source = MediaSource.UNKNOWN;
    public MovieEdition edition = MovieEdition.NONE;
    public String trailer = "";
    public Map<String, Object> ids = new HashMap<String, Object>();
    public Map<String, Rating> ratings = new HashMap<String, Rating>();
    public List<String> posters = new ArrayList<String>();
    public List<String> fanarts = new ArrayList<String>();
    public List<MediaGenres> genres = new ArrayList<MediaGenres>();
    public List<String> countries = new ArrayList<String>();
    public List<String> studios = new ArrayList<String>();
    public List<String> tags = new ArrayList<String>();
    public List<Person> actors = new ArrayList<Person>();
    public List<Person> producers = new ArrayList<Person>();
    public List<Person> directors = new ArrayList<Person>();
    public List<Person> credits = new ArrayList<Person>();
    public List<String> unsupportedElements = new ArrayList<String>();
    public Fileinfo fileinfo = null;
    public String epbookmark = "";
    public Date lastplayed = null;
    public String status = "";
    public String code = "";
    public Date dateadded = null;

    private MovieNfoParser(Document document) {
        Elements elements = document.select("movie");
        if (elements.isEmpty()) {
            return;
        }
        document.outputSettings().prettyPrint(false);
        this.root = (Element)elements.get(0);
        this.parseTag(MovieNfoParser::parseTitle);
        this.parseTag(MovieNfoParser::parseOriginalTitle);
        this.parseTag(MovieNfoParser::parseSorttitle);
        this.parseTag(MovieNfoParser::parseRatingAndVotes);
        this.parseTag(MovieNfoParser::parseSet);
        this.parseTag(MovieNfoParser::parseYear);
        this.parseTag(MovieNfoParser::parseTop250);
        this.parseTag(MovieNfoParser::parsePlot);
        this.parseTag(MovieNfoParser::parseOutline);
        this.parseTag(MovieNfoParser::parseTagline);
        this.parseTag(MovieNfoParser::parseRuntime);
        this.parseTag(MovieNfoParser::parsePosters);
        this.parseTag(MovieNfoParser::parseFanarts);
        this.parseTag(MovieNfoParser::parseCertification);
        this.parseTag(MovieNfoParser::parseIds);
        this.parseTag(MovieNfoParser::parseCountry);
        this.parseTag(MovieNfoParser::parseReleaseDate);
        this.parseTag(MovieNfoParser::parseWatchedAndPlaycount);
        this.parseTag(MovieNfoParser::parseGenres);
        this.parseTag(MovieNfoParser::parseStudios);
        this.parseTag(MovieNfoParser::parseCredits);
        this.parseTag(MovieNfoParser::parseDirectors);
        this.parseTag(MovieNfoParser::parseTags);
        this.parseTag(MovieNfoParser::parseActors);
        this.parseTag(MovieNfoParser::parseProducers);
        this.parseTag(MovieNfoParser::parseFileinfo);
        this.parseTag(MovieNfoParser::parseLanguages);
        this.parseTag(MovieNfoParser::parseSource);
        this.parseTag(MovieNfoParser::parseEdition);
        this.parseTag(MovieNfoParser::parseTrailer);
        this.parseTag(MovieNfoParser::parseEpbookmark);
        this.parseTag(MovieNfoParser::parseLastplayed);
        this.parseTag(MovieNfoParser::parseStatus);
        this.parseTag(MovieNfoParser::parseCode);
        this.parseTag(MovieNfoParser::parseDateadded);
        this.parseTag(MovieNfoParser::findUnsupportedElements);
    }

    private void parseTag(Function<MovieNfoParser, Void> function) {
        try {
            function.apply(this);
        }
        catch (Exception e) {
            LOGGER.warn("problem parsing tag (line {}): {}", (Object)e.getStackTrace()[0].getLineNumber(), (Object)e.getMessage());
        }
    }

    public static MovieNfoParser parseNfo(Path path) throws Exception {
        return new MovieNfoParser(Jsoup.parse((InputStream)new FileInputStream(path.toFile()), (String)"UTF-8", (String)"", (Parser)Parser.xmlParser()));
    }

    public static MovieNfoParser parseNfo(String content) {
        return new MovieNfoParser(Jsoup.parse((String)content, (String)"", (Parser)Parser.xmlParser()));
    }

    public boolean isValidNfo() {
        return StringUtils.isNotBlank((CharSequence)this.title);
    }

    private Element getSingleElement(Element parent, String tag) {
        Elements elements = parent.select(parent.tagName() + " > " + tag);
        if (elements.size() != 1) {
            return null;
        }
        return (Element)elements.get(0);
    }

    private Void parseTitle() {
        this.supportedElements.add("title");
        Element element = this.getSingleElement(this.root, "title");
        if (element != null) {
            this.title = element.ownText();
        }
        return null;
    }

    private Void parseOriginalTitle() {
        this.supportedElements.add("originaltitle");
        Element element = this.getSingleElement(this.root, "originaltitle");
        if (element != null) {
            this.originaltitle = element.ownText();
        }
        return null;
    }

    private Void parseSorttitle() {
        this.supportedElements.add("sorttitle");
        Element element = this.getSingleElement(this.root, "sorttitle");
        if (element != null) {
            this.sorttitle = element.ownText();
        }
        return null;
    }

    private Void parseRatingAndVotes() {
        Rating r;
        this.supportedElements.add("rating");
        this.supportedElements.add("userrating");
        this.supportedElements.add("ratings");
        this.supportedElements.add("votes");
        Element element = this.getSingleElement(this.root, "rating");
        if (element != null) {
            r = new Rating();
            r.id = "NFO";
            try {
                r.rating = Float.parseFloat(element.ownText());
            }
            catch (Exception exception) {
                // empty catch block
            }
            element = this.getSingleElement(this.root, "votes");
            if (element != null) {
                try {
                    r.votes = MetadataUtil.parseInt((String)element.ownText());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (r.rating > 0.0f) {
                this.ratings.put(r.id, r);
            }
        }
        if ((element = this.getSingleElement(this.root, "userrating")) != null) {
            try {
                r = new Rating();
                r.id = "user";
                r.rating = Float.parseFloat(element.ownText());
                if (r.rating > 0.0f) {
                    this.ratings.put(r.id, r);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((element = this.getSingleElement(this.root, "ratings")) != null) {
            for (Element ratingChild : element.select(element.tagName() + " > rating")) {
                Rating r2 = new Rating();
                r2.id = ratingChild.attr("name");
                if ("themoviedb".equals(r2.id)) {
                    r2.id = "tmdb";
                }
                try {
                    r2.maxValue = MetadataUtil.parseInt((String)ratingChild.attr("max"));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                for (Element child : ratingChild.children()) {
                    switch (child.tagName()) {
                        case "value": {
                            try {
                                r2.rating = Float.parseFloat(child.ownText());
                            }
                            catch (NumberFormatException numberFormatException) {}
                            break;
                        }
                        case "votes": {
                            try {
                                r2.votes = MetadataUtil.parseInt((String)child.ownText());
                            }
                            catch (Exception exception) {}
                            break;
                        }
                    }
                }
                if (!StringUtils.isNotBlank((CharSequence)r2.id) || !(r2.rating > 0.0f)) continue;
                this.ratings.put(r2.id, r2);
            }
        }
        return null;
    }

    private Void parseSet() {
        this.supportedElements.add("sets");
        this.supportedElements.add("set");
        Element element = this.getSingleElement(this.root, "sets");
        if (element != null) {
            if ((element = this.getSingleElement(element, "set")) != null && StringUtils.isNotBlank((CharSequence)element.ownText())) {
                this.set = new Set();
                this.set.name = element.ownText();
            }
        } else {
            element = this.getSingleElement(this.root, "set");
            if (element == null) {
                element = this.root.select(this.root.tagName() + " > set").first();
            }
            if (element != null && !element.children().isEmpty()) {
                Set tmp = new Set();
                for (Element child : element.children()) {
                    switch (child.tagName()) {
                        case "name": 
                        case "setname": {
                            tmp.name = child.ownText();
                            break;
                        }
                        case "overview": 
                        case "setdescription": {
                            tmp.overview = child.ownText();
                            break;
                        }
                    }
                }
                if (StringUtils.isNotBlank((CharSequence)tmp.name)) {
                    this.set = tmp;
                }
            } else if (element != null && StringUtils.isNotBlank((CharSequence)element.ownText())) {
                this.set = new Set();
                this.set.name = element.ownText();
                this.set.overview = "";
            }
        }
        return null;
    }

    private Void parseYear() {
        this.supportedElements.add("year");
        Element element = this.getSingleElement(this.root, "year");
        if (element != null) {
            try {
                this.year = MetadataUtil.parseInt((String)element.ownText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Void parseTop250() {
        this.supportedElements.add("top250");
        Element element = this.getSingleElement(this.root, "top250");
        if (element != null) {
            try {
                this.top250 = MetadataUtil.parseInt((String)element.ownText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Void parsePlot() {
        this.supportedElements.add("plot");
        Element element = this.getSingleElement(this.root, "plot");
        if (element != null) {
            this.plot = element.ownText();
        }
        return null;
    }

    private Void parseOutline() {
        this.supportedElements.add("outline");
        Element element = this.getSingleElement(this.root, "outline");
        if (element != null) {
            this.outline = element.ownText();
        }
        return null;
    }

    private Void parseTagline() {
        this.supportedElements.add("tagline");
        Element element = this.getSingleElement(this.root, "tagline");
        if (element != null) {
            this.tagline = element.ownText();
        }
        return null;
    }

    private Void parseRuntime() {
        this.supportedElements.add("runtime");
        Element element = this.getSingleElement(this.root, "runtime");
        if (element != null) {
            try {
                this.runtime = MetadataUtil.parseInt((String)element.ownText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Void parsePosters() {
        this.supportedElements.add("thumb");
        Elements thumbs = this.root.select(this.root.tagName() + " > thumb");
        if (!thumbs.isEmpty()) {
            for (Element element : thumbs) {
                if (element.hasAttr("aspect") && !element.attr("aspect").equals("poster") || !StringUtils.isNotBlank((CharSequence)element.ownText()) || !element.ownText().matches("https?://.*")) continue;
                this.posters.add(element.ownText());
            }
        }
        return null;
    }

    private Void parseFanarts() {
        this.supportedElements.add("fanart");
        Element fanart = this.getSingleElement(this.root, "fanart");
        if (fanart != null) {
            Elements thumbs = fanart.select(fanart.tagName() + " > thumb");
            if (!thumbs.isEmpty()) {
                for (Element element : thumbs) {
                    if (!StringUtils.isNotBlank((CharSequence)element.ownText()) || !element.ownText().matches("https?://.*")) continue;
                    this.fanarts.add(element.ownText());
                }
            } else if (StringUtils.isNotBlank((CharSequence)fanart.ownText()) && fanart.ownText().matches("https?://.*")) {
                this.fanarts.add(fanart.ownText());
            }
        }
        return null;
    }

    private Void parseCertification() {
        this.supportedElements.add("certification");
        this.supportedElements.add("mpaa");
        Element element = this.getSingleElement(this.root, "certification");
        if (element == null || StringUtils.isBlank((CharSequence)element.ownText())) {
            element = this.getSingleElement(this.root, "mpaa");
        }
        if (element != null) {
            this.certification = MovieHelpers.parseCertificationStringForMovieSetupCountry(element.ownText());
        }
        return null;
    }

    private Void parseIds() {
        Elements children;
        this.supportedElements.add("id");
        this.supportedElements.add("imdb");
        this.supportedElements.add("tmdbid");
        this.supportedElements.add("ids");
        this.supportedElements.add("uniqueid");
        Element element = this.getSingleElement(this.root, "id");
        if (element != null && MetadataUtil.isValidImdbId((String)element.ownText())) {
            this.ids.put("imdb", element.ownText());
        }
        if ((element = this.getSingleElement(this.root, "imdb")) != null && MetadataUtil.isValidImdbId((String)element.ownText())) {
            this.ids.put("imdb", element.ownText());
        }
        if ((element = this.getSingleElement(this.root, "tmdbId")) != null) {
            try {
                this.ids.put("tmdb", MetadataUtil.parseInt((String)element.ownText()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        Elements elements = this.root.select(this.root.tagName() + " > uniqueid");
        for (Element id : elements) {
            try {
                String value;
                String key = id.attr("type");
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key, value = id.ownText()})) continue;
                try {
                    this.ids.put(key, MetadataUtil.parseInt((String)value));
                }
                catch (Exception e) {
                    this.ids.put(key, value);
                }
            }
            catch (Exception key) {}
        }
        element = this.getSingleElement(this.root, "ids");
        if (element != null) {
            children = element.select(element.tagName() + " > entry");
            for (Element entry : children) {
                Element key = this.getSingleElement(entry, "key");
                Element value = this.getSingleElement(entry, "value");
                if (key == null || value == null || !StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{key.ownText(), value.ownText()})) continue;
                try {
                    this.ids.put(key.ownText(), MetadataUtil.parseInt((String)value.ownText()));
                }
                catch (Exception e) {
                    this.ids.put(key.ownText(), value.ownText());
                }
            }
        }
        if ((element = this.getSingleElement(this.root, "ids")) != null) {
            children = element.children();
            for (Element entry : children) {
                if (!StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{entry.tagName(), entry.ownText()})) continue;
                try {
                    this.ids.put(entry.tagName(), MetadataUtil.parseInt((String)entry.ownText()));
                }
                catch (Exception e) {
                    this.ids.put(entry.tagName(), entry.ownText());
                }
            }
        }
        return null;
    }

    private Void parseCountry() {
        this.supportedElements.add("country");
        Elements elements = this.root.select(this.root.tagName() + " > country");
        if (elements.size() == 1) {
            try {
                this.countries.addAll(MovieNfoParser.split(((Element)elements.get(0)).ownText()));
            }
            catch (Exception exception) {}
        } else {
            for (Element element : elements) {
                if (!StringUtils.isNotBlank((CharSequence)element.ownText())) continue;
                this.countries.add(element.ownText());
            }
        }
        return null;
    }

    private Void parseReleaseDate() {
        Date date2;
        this.supportedElements.add("premiered");
        this.supportedElements.add("aired");
        Element element = this.getSingleElement(this.root, "premiered");
        if (element != null) {
            try {
                date2 = StrgUtils.parseDate((String)element.ownText());
                if (date2 != null) {
                    this.releaseDate = date2;
                }
            }
            catch (ParseException date2) {
                // empty catch block
            }
        }
        if (this.releaseDate == null && (element = this.getSingleElement(this.root, "aired")) != null) {
            try {
                date2 = StrgUtils.parseDate((String)element.ownText());
                if (date2 != null) {
                    this.releaseDate = date2;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    private Void parseWatchedAndPlaycount() {
        this.supportedElements.add("watched");
        this.supportedElements.add("playcount");
        Element element = this.getSingleElement(this.root, "watched");
        if (element != null) {
            try {
                this.watched = Boolean.parseBoolean(element.ownText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((element = this.getSingleElement(this.root, "playcount")) != null) {
            try {
                this.playcount = MetadataUtil.parseInt((String)element.ownText());
                if (this.playcount > 0 && !this.watched) {
                    this.watched = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Void parseGenres() {
        this.supportedElements.add("genres");
        this.supportedElements.add("genre");
        Elements elements = null;
        Element element = this.getSingleElement(this.root, "genres");
        elements = element != null ? element.select(element.tagName() + " > genre") : this.root.select(this.root.tagName() + " > genre");
        if (elements != null && !elements.isEmpty()) {
            for (Element genre : elements) {
                if (!StringUtils.isNotBlank((CharSequence)genre.ownText())) continue;
                for (String sp : MovieNfoParser.split(genre.ownText())) {
                    this.genres.add(MediaGenres.getGenre((String)sp.trim()));
                }
            }
        }
        return null;
    }

    private Void parseStudios() {
        this.supportedElements.add("studio");
        Elements elements = this.root.select(this.root.tagName() + " > studio");
        if (elements.size() == 1) {
            try {
                this.studios.addAll(MovieNfoParser.split(((Element)elements.get(0)).ownText()));
            }
            catch (Exception exception) {}
        } else {
            for (Element element : elements) {
                if (!StringUtils.isNotBlank((CharSequence)element.ownText())) continue;
                this.studios.add(element.ownText());
            }
        }
        return null;
    }

    private Void parseCredits() {
        this.supportedElements.add("credits");
        Elements elements = this.root.select(this.root.tagName() + " > credits");
        if (elements.size() == 1) {
            try {
                for (String credit : MovieNfoParser.split(((Element)elements.get(0)).ownText())) {
                    Person person = new Person();
                    person.name = credit;
                    this.credits.add(person);
                }
            }
            catch (Exception exception) {}
        } else {
            for (Element element : elements) {
                if (!StringUtils.isNotBlank((CharSequence)element.ownText())) continue;
                Person person = new Person();
                person.name = element.ownText();
                this.credits.add(person);
            }
        }
        return null;
    }

    private Void parseDirectors() {
        this.supportedElements.add("director");
        Elements elements = this.root.select(this.root.tagName() + " > director");
        if (elements.size() == 1) {
            try {
                for (String director : MovieNfoParser.split(((Element)elements.get(0)).ownText())) {
                    Person person = new Person();
                    person.name = director;
                    this.directors.add(person);
                }
            }
            catch (Exception exception) {}
        } else {
            for (Element element : elements) {
                if (!StringUtils.isNotBlank((CharSequence)element.ownText())) continue;
                Person person = new Person();
                person.name = element.ownText();
                this.directors.add(person);
            }
        }
        return null;
    }

    private Void parseTags() {
        this.supportedElements.add("tag");
        Elements elements = this.root.select(this.root.tagName() + " > tag");
        for (Element element : elements) {
            if (!StringUtils.isNotBlank((CharSequence)element.ownText())) continue;
            this.tags.add(element.ownText());
        }
        return null;
    }

    private Void parseActors() {
        this.supportedElements.add("actor");
        Elements elements = this.root.select(this.root.tagName() + " > actor");
        for (Element element : elements) {
            Person actor = new Person();
            for (Element child : element.children()) {
                switch (child.tagName()) {
                    case "name": {
                        actor.name = child.ownText();
                        break;
                    }
                    case "role": {
                        actor.role = child.ownText();
                        break;
                    }
                    case "thumb": {
                        actor.thumb = child.ownText();
                        break;
                    }
                    case "profile": {
                        actor.profile = child.ownText();
                        break;
                    }
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)actor.name)) continue;
            this.actors.add(actor);
        }
        return null;
    }

    private Void parseProducers() {
        this.supportedElements.add("producer");
        Elements elements = this.root.select(this.root.tagName() + " > producer");
        for (Element element : elements) {
            Person producer = new Person();
            for (Element child : element.children()) {
                switch (child.tagName().toLowerCase(Locale.ROOT)) {
                    case "name": {
                        producer.name = child.ownText();
                        break;
                    }
                    case "role": {
                        producer.role = child.ownText();
                        break;
                    }
                    case "thumb": {
                        producer.thumb = child.ownText();
                        break;
                    }
                }
            }
            if (!StringUtils.isNotBlank((CharSequence)producer.name)) continue;
            this.producers.add(producer);
        }
        return null;
    }

    private Void parseFileinfo() {
        this.supportedElements.add("fileinfo");
        Element element = this.getSingleElement(this.root, "fileinfo");
        if (element != null && (element = this.getSingleElement(element, "streamdetails")) != null) {
            this.fileinfo = new Fileinfo();
            for (Element child : element.children()) {
                switch (child.tagName().toLowerCase(Locale.ROOT)) {
                    case "video": {
                        Video video = this.parseVideo(child);
                        if (video == null) break;
                        this.fileinfo.videos.add(video);
                        break;
                    }
                    case "audio": {
                        Audio audio = this.parseAudio(child);
                        if (audio == null) break;
                        this.fileinfo.audios.add(audio);
                        break;
                    }
                    case "subtitle": {
                        Subtitle subtitle = this.parseSubtitle(child);
                        if (subtitle == null) break;
                        this.fileinfo.subtitles.add(subtitle);
                        break;
                    }
                }
            }
        }
        return null;
    }

    private Video parseVideo(Element element) {
        Video video = new Video();
        for (Element child : element.children()) {
            switch (child.tagName().toLowerCase(Locale.ROOT)) {
                case "codec": {
                    video.codec = child.ownText();
                    break;
                }
                case "aspect": {
                    try {
                        video.aspect = Float.parseFloat(child.ownText());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "width": {
                    try {
                        video.width = MetadataUtil.parseInt((String)child.ownText());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "height": {
                    try {
                        video.height = MetadataUtil.parseInt((String)child.ownText());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "durationinseconds": {
                    try {
                        video.durationinseconds = MetadataUtil.parseInt((String)child.ownText());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
                case "stereomode": {
                    video.stereomode = child.ownText();
                    break;
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)video.codec)) {
            return video;
        }
        return null;
    }

    private Audio parseAudio(Element element) {
        Audio audio = new Audio();
        for (Element child : element.children()) {
            switch (child.tagName().toLowerCase(Locale.ROOT)) {
                case "codec": {
                    audio.codec = child.ownText();
                    break;
                }
                case "language": {
                    audio.language = child.ownText();
                    break;
                }
                case "channels": {
                    try {
                        audio.channels = MetadataUtil.parseInt((String)child.ownText());
                    }
                    catch (NumberFormatException numberFormatException) {}
                    break;
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)audio.codec)) {
            return audio;
        }
        return null;
    }

    private Subtitle parseSubtitle(Element element) {
        Subtitle subtitle = new Subtitle();
        for (Element child : element.children()) {
            switch (child.tagName().toLowerCase(Locale.ROOT)) {
                case "language": {
                    subtitle.language = child.ownText();
                    break;
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)subtitle.language)) {
            return subtitle;
        }
        return null;
    }

    private Void parseLanguages() {
        this.supportedElements.add("languages");
        this.supportedElements.add("language");
        Element element = this.getSingleElement(this.root, "languages");
        if (element == null) {
            element = this.getSingleElement(this.root, "language");
        }
        if (element != null) {
            this.languages = element.ownText();
        }
        if (StringUtils.isNotBlank((CharSequence)this.languages)) {
            ArrayList<String> languages = new ArrayList<String>();
            for (String langu : MovieNfoParser.split(this.languages)) {
                String languIso = LanguageUtils.getIso2LanguageFromLocalizedString((String)(langu = langu.trim()));
                if (StringUtils.isNotBlank((CharSequence)languIso)) {
                    languages.add(languIso);
                    continue;
                }
                languages.add(langu);
            }
            this.languages = StringUtils.join((Object[])languages.toArray(), (String)", ");
        }
        return null;
    }

    private Void parseSource() {
        this.supportedElements.add("source");
        Element element = this.getSingleElement(this.root, "source");
        if (element != null) {
            try {
                this.source = MediaSource.getMediaSource(element.ownText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Void parseEdition() {
        this.supportedElements.add("edition");
        Element element = this.getSingleElement(this.root, "edition");
        if (element != null) {
            try {
                this.edition = MovieEdition.getMovieEditionFromString(element.ownText());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private Void parseTrailer() {
        this.supportedElements.add("trailer");
        Element element = this.getSingleElement(this.root, "trailer");
        if (element != null) {
            Pattern pattern = Pattern.compile("plugin://plugin.video.youtube/\\?action=play_video&videoid=(.*)$");
            Matcher matcher = pattern.matcher(element.ownText());
            if (matcher.matches()) {
                this.trailer = "http://www.youtube.com/watch?v=" + matcher.group(1);
            } else {
                pattern = Pattern.compile("plugin://plugin.video.hdtrailers_net/video/.*\\?/(.*)$");
                matcher = pattern.matcher(element.ownText());
                if (matcher.matches()) {
                    try {
                        this.trailer = URLDecoder.decode(matcher.group(1), "UTF-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        // empty catch block
                    }
                }
            }
            if (StringUtils.isNotBlank((CharSequence)element.ownText()) && element.ownText().matches("https?://.*")) {
                this.trailer = element.ownText();
            }
        }
        return null;
    }

    private Void parseEpbookmark() {
        this.supportedElements.add("epbookmark");
        Element element = this.getSingleElement(this.root, "epbookmark");
        if (element != null) {
            this.epbookmark = element.ownText();
        }
        return null;
    }

    private Void parseLastplayed() {
        this.supportedElements.add("lastplayed");
        Element element = this.getSingleElement(this.root, "lastplayed");
        if (element != null) {
            try {
                Date date = StrgUtils.parseDate((String)element.ownText());
                if (date != null) {
                    this.lastplayed = date;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    private Void parseStatus() {
        this.supportedElements.add("status");
        Element element = this.getSingleElement(this.root, "status");
        if (element != null) {
            this.status = element.ownText();
        }
        return null;
    }

    private Void parseCode() {
        this.supportedElements.add("code");
        Element element = this.getSingleElement(this.root, "code");
        if (element != null) {
            this.code = element.ownText();
        }
        return null;
    }

    private Void parseDateadded() {
        this.supportedElements.add("dateadded");
        Element element = this.getSingleElement(this.root, "dateadded");
        if (element != null) {
            try {
                Date date = StrgUtils.parseDate((String)element.ownText());
                if (date != null) {
                    this.dateadded = date;
                }
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return null;
    }

    private Void findUnsupportedElements() {
        for (Element element : this.root.children()) {
            if (this.supportedElements.contains(element.tagName().toLowerCase(Locale.ROOT))) continue;
            String elementText = element.toString().replaceAll(">\\r?\\n\\s*<", "><");
            this.unsupportedElements.add(elementText);
        }
        return null;
    }

    public static List<String> split(String source) {
        ArrayList<String> result = new ArrayList<String>();
        for (String string : source.split("\\s*[;,\\/|]\\s*")) {
            if (!StringUtils.isNotBlank((CharSequence)string)) continue;
            result.add(string);
        }
        return result;
    }

    public Movie toMovie() {
        Movie movie = new Movie();
        movie.setTitle(this.title);
        movie.setOriginalTitle(this.originaltitle);
        for (Map.Entry<String, Rating> entry : this.ratings.entrySet()) {
            Rating r = entry.getValue();
            movie.setRating(new org.tinymediamanager.core.entities.Rating(r.id, r.rating, r.votes, r.maxValue));
        }
        if (this.year > -1) {
            movie.setYear(this.year);
        }
        movie.setTop250(this.top250);
        movie.setReleaseDate(this.releaseDate);
        if (this.dateadded != null) {
            movie.setDateAdded(this.dateadded);
        }
        movie.setPlot(this.plot);
        movie.setTagline(this.tagline);
        movie.setRuntime(this.runtime);
        if (!this.posters.isEmpty()) {
            movie.setArtworkUrl(this.posters.get(0), MediaFileType.POSTER);
        }
        if (!this.fanarts.isEmpty()) {
            movie.setArtworkUrl(this.fanarts.get(0), MediaFileType.FANART);
        }
        for (Map.Entry<String, Object> entry : this.ids.entrySet()) {
            movie.setId(entry.getKey(), entry.getValue());
        }
        String studio = StringUtils.join(this.studios, (String)" / ");
        if (studio == null) {
            movie.setProductionCompany("");
        } else {
            movie.setProductionCompany(studio);
        }
        String string = StringUtils.join(this.countries, (String)"/");
        if (string == null) {
            movie.setCountry("");
        } else {
            movie.setCountry(string);
        }
        movie.setCertification(this.certification);
        movie.setWatched(this.watched);
        if (this.playcount > 0) {
            movie.setWatched(true);
        }
        movie.setSpokenLanguages(this.languages);
        movie.setMediaSource(this.source);
        movie.setEdition(this.edition);
        if (this.set != null && StringUtils.isNotEmpty((CharSequence)this.set.name)) {
            MovieSet movieSet;
            Iterator<Person> movieList = MovieList.getInstance();
            int tmdbSetId = 0;
            if (this.ids.get("tmdbSet") != null) {
                try {
                    tmdbSetId = Integer.parseInt(this.ids.get("tmdbSet").toString());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if ((movieSet = ((MovieList)((Object)movieList)).getMovieSet(this.set.name, tmdbSetId)) != null) {
                if (StringUtils.isBlank((CharSequence)movieSet.getPlot())) {
                    movieSet.setPlot(this.set.overview);
                }
                movie.setMovieSet(movieSet);
            }
        }
        movie.setSortTitle(this.sorttitle);
        for (Person actor : this.actors) {
            movie.addActor(this.morphPerson(Person.Type.ACTOR, actor));
        }
        for (Person producer : this.producers) {
            movie.addProducer(this.morphPerson(Person.Type.PRODUCER, producer));
        }
        for (Person director : this.directors) {
            if (StringUtils.isBlank((CharSequence)director.role)) {
                director.role = "Director";
            }
            movie.addDirector(this.morphPerson(Person.Type.DIRECTOR, director));
        }
        for (Person writer : this.credits) {
            if (StringUtils.isBlank((CharSequence)writer.role)) {
                writer.role = "Writer";
            }
            movie.addWriter(this.morphPerson(Person.Type.WRITER, writer));
        }
        for (MediaGenres genre : this.genres) {
            movie.addGenre(genre);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.trailer) && !this.trailer.startsWith("file")) {
            MovieTrailer trailer = new MovieTrailer();
            trailer.setName("fromNFO");
            trailer.setProvider("from NFO");
            trailer.setQuality("unknown");
            trailer.setUrl(this.trailer);
            trailer.setInNfo(true);
            movie.addTrailer(trailer);
        }
        for (String tag : this.tags) {
            movie.addToTags(tag);
        }
        return movie;
    }

    private org.tinymediamanager.core.entities.Person morphPerson(Person.Type type, Person nfoPerson) {
        org.tinymediamanager.core.entities.Person person = new org.tinymediamanager.core.entities.Person(type);
        person.setName(nfoPerson.name);
        person.setRole(nfoPerson.role);
        person.setThumbUrl(nfoPerson.thumb);
        person.setProfileUrl(nfoPerson.profile);
        return person;
    }

    public static class Subtitle {
        public String language;
    }

    public static class Audio {
        public String codec = "";
        public String language = "";
        public int channels = 0;
    }

    public static class Video {
        public String codec = "";
        public float aspect = 0.0f;
        public int width = 0;
        public int height = 0;
        public int durationinseconds;
        public String stereomode = "";
    }

    public static class Fileinfo {
        public List<Video> videos = new ArrayList<Video>();
        public List<Audio> audios = new ArrayList<Audio>();
        public List<Subtitle> subtitles = new ArrayList<Subtitle>();
    }

    public static class Person {
        public String name = "";
        public String role = "";
        public String thumb = "";
        public String profile = "";
    }

    public static class Rating {
        public String id = "";
        public float rating = 0.0f;
        public int votes = 0;
        public int maxValue = 10;
    }

    public static class Set {
        public String name = "";
        public String overview = "";
    }
}

