/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.entities;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.IMediaInformation;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.entities.Rating;
import org.tinymediamanager.core.movie.MovieArtworkHelper;
import org.tinymediamanager.core.movie.MovieEdition;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieMediaFileComparator;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieRenamer;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.MovieTrailerQuality;
import org.tinymediamanager.core.movie.MovieTrailerSources;
import org.tinymediamanager.core.movie.connector.MovieConnectors;
import org.tinymediamanager.core.movie.connector.MovieGenericXmlConnector;
import org.tinymediamanager.core.movie.connector.MovieToKodiConnector;
import org.tinymediamanager.core.movie.connector.MovieToMpLegacyConnector;
import org.tinymediamanager.core.movie.connector.MovieToMpMovingPicturesConnector;
import org.tinymediamanager.core.movie.connector.MovieToMpMyVideoConnector;
import org.tinymediamanager.core.movie.connector.MovieToXbmcConnector;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.movie.entities.MovieTrailer;
import org.tinymediamanager.core.movie.filenaming.MovieNfoNaming;
import org.tinymediamanager.core.movie.filenaming.MovieTrailerNaming;
import org.tinymediamanager.core.movie.tasks.MovieActorImageFetcherTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.entities.MediaRating;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.exceptions.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.mediaprovider.IMovieSetMetadataProvider;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.StrgUtils;

public class Movie
extends MediaEntity
implements IMediaInformation {
    @XmlTransient
    private static final Logger LOGGER = LoggerFactory.getLogger(Movie.class);
    private static final Comparator<MediaFile> MEDIA_FILE_COMPARATOR = new MovieMediaFileComparator();
    private static final Comparator<MovieTrailer> TRAILER_QUALITY_COMPARATOR = new MovieTrailer.QualityComparator();
    @JsonProperty
    private String sortTitle = "";
    @JsonProperty
    private String tagline = "";
    @JsonProperty
    private int runtime = 0;
    @JsonProperty
    private boolean watched = false;
    @JsonProperty
    private boolean isDisc = false;
    @JsonProperty
    private String spokenLanguages = "";
    @JsonProperty
    private boolean subtitles = false;
    @JsonProperty
    private String country = "";
    @JsonProperty
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private Date releaseDate = null;
    @JsonProperty
    private boolean multiMovieDir = false;
    @JsonProperty
    private int top250 = 0;
    @JsonProperty
    private MediaSource mediaSource = MediaSource.UNKNOWN;
    @JsonProperty
    private boolean videoIn3D = false;
    @JsonProperty
    private Certification certification = Certification.UNKNOWN;
    @JsonProperty
    private UUID movieSetId;
    @JsonProperty
    private MovieEdition edition = MovieEdition.NONE;
    @JsonProperty
    private boolean stacked = false;
    @JsonProperty
    private boolean offline = false;
    @JsonProperty
    private List<MediaGenres> genres = new CopyOnWriteArrayList<MediaGenres>();
    @JsonProperty
    private List<String> tags = new CopyOnWriteArrayList<String>();
    @JsonProperty
    private List<String> extraThumbs = new CopyOnWriteArrayList<String>();
    @JsonProperty
    private List<String> extraFanarts = new CopyOnWriteArrayList<String>();
    @JsonProperty
    private List<Person> actors = new CopyOnWriteArrayList<Person>();
    @JsonProperty
    private List<Person> producers = new CopyOnWriteArrayList<Person>();
    @JsonProperty
    private List<Person> directors = new CopyOnWriteArrayList<Person>();
    @JsonProperty
    private List<Person> writers = new CopyOnWriteArrayList<Person>();
    @JsonProperty
    private List<MovieTrailer> trailer = new CopyOnWriteArrayList<MovieTrailer>();
    private MovieSet movieSet;
    private String titleSortable = "";
    private String originalTitleSortable = "";
    private Date lastWatched = null;

    public void merge(Movie other) {
        this.merge(other, false);
    }

    public void forceMerge(Movie other) {
        this.merge(other, true);
    }

    void merge(Movie other, boolean force) {
        if (other == null) {
            return;
        }
        super.merge(other, force);
        this.setSortTitle(StringUtils.isEmpty((CharSequence)this.sortTitle) || force ? other.sortTitle : this.sortTitle);
        this.setTagline(StringUtils.isEmpty((CharSequence)this.tagline) || force ? other.tagline : this.tagline);
        this.setSpokenLanguages(StringUtils.isEmpty((CharSequence)this.spokenLanguages) || force ? other.spokenLanguages : this.spokenLanguages);
        this.setCountry(StringUtils.isEmpty((CharSequence)this.country) || force ? other.country : this.country);
        this.setWatched(!this.watched || force ? other.watched : this.watched);
        this.setRuntime(this.runtime == 0 || force ? other.runtime : this.runtime);
        this.setTop250(this.top250 == 0 || force ? other.top250 : this.top250);
        this.setReleaseDate(this.releaseDate == null || force ? other.releaseDate : this.releaseDate);
        this.setMovieSet(this.movieSet == null || force ? other.movieSet : this.movieSet);
        this.setMediaSource(this.mediaSource == MediaSource.UNKNOWN || force ? other.mediaSource : this.mediaSource);
        this.setCertification(this.certification == Certification.UNKNOWN || force ? other.certification : this.certification);
        this.setEdition(this.edition == MovieEdition.NONE || force ? other.edition : this.edition);
        if (force) {
            this.genres.clear();
            this.actors.clear();
            this.producers.clear();
            this.directors.clear();
            this.writers.clear();
            this.tags.clear();
            this.trailer.clear();
            this.extraFanarts.clear();
            this.extraThumbs.clear();
        }
        this.setGenres(other.genres);
        this.setActors(other.actors);
        this.setProducers(other.producers);
        this.setDirectors(other.directors);
        this.setWriters(other.writers);
        this.setTags(other.tags);
        this.setExtraFanarts(other.extraFanarts);
        this.setExtraThumbs(other.extraThumbs);
        ArrayList<MovieTrailer> mergedTrailers = new ArrayList<MovieTrailer>(this.trailer);
        ListUtils.mergeLists(mergedTrailers, other.trailer);
        this.setTrailers(mergedTrailers);
    }

    @Override
    protected Comparator<MediaFile> getMediaFileComparator() {
        return MEDIA_FILE_COMPARATOR;
    }

    @Override
    public boolean isScraped() {
        return this.scraped || this.getHasMetadata() != false;
    }

    public String getSortTitle() {
        return this.sortTitle;
    }

    public void setSortTitle(String newValue) {
        String oldValue = this.sortTitle;
        this.sortTitle = newValue;
        this.firePropertyChange("sortTitle", oldValue, newValue);
    }

    public String getTitleSortable() {
        if (StringUtils.isBlank((CharSequence)this.titleSortable)) {
            this.titleSortable = Utils.getSortableName(this.getTitle());
        }
        return this.titleSortable;
    }

    public String getOriginalTitleSortable() {
        if (StringUtils.isBlank((CharSequence)this.originalTitleSortable)) {
            this.originalTitleSortable = Utils.getSortableName(this.getOriginalTitle());
        }
        return this.originalTitleSortable;
    }

    public void clearTitleSortable() {
        this.titleSortable = "";
        this.originalTitleSortable = "";
    }

    public Boolean getHasNfoFile() {
        List<MediaFile> mf = this.getMediaFiles(MediaFileType.NFO);
        return mf != null && mf.size() > 0;
    }

    public Boolean getHasMetadata() {
        return !this.plot.isEmpty() && this.year != 0;
    }

    public Boolean getHasImages() {
        for (MediaArtwork.MediaArtworkType type : MovieModuleManager.SETTINGS.getCheckImagesMovie()) {
            if (!StringUtils.isEmpty((CharSequence)this.getArtworkFilename(MediaFileType.getMediaFileType(type)))) continue;
            return false;
        }
        return true;
    }

    public Boolean getHasTrailer() {
        if (this.trailer != null && this.trailer.size() > 0) {
            return true;
        }
        if (!this.getMediaFiles(MediaFileType.TRAILER).isEmpty()) {
            return true;
        }
        return false;
    }

    public String getTitleForUi() {
        String titleForUi = this.title;
        if (this.year > 0) {
            titleForUi = titleForUi + " (" + this.year + ")";
        }
        return titleForUi;
    }

    @Override
    public void initializeAfterLoading() {
        super.initializeAfterLoading();
        Utils.removeEmptyStringsFromList(this.tags);
        if (this.movieSetId != null) {
            this.movieSet = MovieList.getInstance().lookupMovieSet(this.movieSetId);
        }
    }

    public List<MovieTrailer> getTrailer() {
        return this.trailer;
    }

    public void addTrailer(MovieTrailer obj) {
        this.trailer.add(obj);
        this.firePropertyChange("trailer", null, this.trailer);
    }

    public void removeAllTrailers() {
        this.trailer.clear();
        this.firePropertyChange("trailer", null, this.trailer);
    }

    public void addToTags(String newTag) {
        if (StringUtils.isBlank((CharSequence)newTag)) {
            return;
        }
        if (this.tags.contains(newTag)) {
            return;
        }
        this.tags.add(newTag);
        this.firePropertyChange("tag", null, newTag);
        this.firePropertyChange("tagsAsString", null, newTag);
    }

    public void removeFromTags(String removeTag) {
        this.tags.remove(removeTag);
        this.firePropertyChange("tag", null, removeTag);
        this.firePropertyChange("tagsAsString", null, removeTag);
    }

    @JsonSetter
    public void setTags(List<String> newTags) {
        ListUtils.mergeLists(this.tags, newTags);
        Utils.removeEmptyStringsFromList(this.tags);
        this.firePropertyChange("tag", null, newTags);
        this.firePropertyChange("tagsAsString", null, newTags);
    }

    public String getTagsAsString() {
        StringBuilder sb = new StringBuilder();
        for (String tag : this.tags) {
            if (!StringUtils.isEmpty((CharSequence)sb)) {
                sb.append(", ");
            }
            sb.append(tag);
        }
        return sb.toString();
    }

    public List<String> getTags() {
        return this.tags;
    }

    public void removeAllTags() {
        this.tags.clear();
        this.firePropertyChange("tag", null, this.tags);
        this.firePropertyChange("tagsAsString", null, this.tags);
    }

    public boolean hasSubtitles() {
        if (this.subtitles) {
            return true;
        }
        if (this.getMediaFiles(MediaFileType.SUBTITLE).size() > 0) {
            return true;
        }
        for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
            if (!mf.hasSubtitles()) continue;
            return true;
        }
        return false;
    }

    public void setSubtitles(boolean sub) {
        this.subtitles = sub;
    }

    public String getImdbId() {
        return this.getIdAsString("imdb");
    }

    public int getTmdbId() {
        return this.getIdAsInt("tmdb");
    }

    public void setTmdbId(int newValue) {
        this.setId("tmdb", newValue);
    }

    public int getRuntime() {
        int runtimeFromMi = this.getRuntimeFromMediaFilesInMinutes();
        if (MovieModuleManager.SETTINGS.isRuntimeFromMediaInfo() && runtimeFromMi > 0) {
            return runtimeFromMi;
        }
        return this.runtime == 0 ? runtimeFromMi : this.runtime;
    }

    public String getTagline() {
        return this.tagline;
    }

    public boolean hasFile(String filename) {
        if (StringUtils.isEmpty((CharSequence)filename)) {
            return false;
        }
        for (MediaFile file : new ArrayList<MediaFile>(this.getMediaFiles())) {
            if (filename.compareTo(file.getFilename()) != 0) continue;
            return true;
        }
        return false;
    }

    public List<String> getExtraThumbs() {
        return this.extraThumbs;
    }

    @JsonSetter
    public void setExtraThumbs(List<String> extraThumbs) {
        ListUtils.mergeLists(this.extraThumbs, extraThumbs);
    }

    public List<String> getExtraFanarts() {
        return this.extraFanarts;
    }

    @JsonSetter
    public void setExtraFanarts(List<String> extraFanarts) {
        ListUtils.mergeLists(this.extraFanarts, extraFanarts);
    }

    public void setImdbId(String newValue) {
        this.setId("imdb", newValue);
    }

    public void setMetadata(MediaMetadata metadata, MovieScraperMetadataConfig config) {
        if (metadata == null) {
            LOGGER.error("metadata was null");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)metadata.getTitle())) {
            LOGGER.warn("wanted to save empty metadata for " + this.getTitle());
            return;
        }
        this.setIds(metadata.getIds());
        if (config.isTitle()) {
            if (MovieModuleManager.SETTINGS.getCapitalWordsInTitles()) {
                this.setTitle(WordUtils.capitalize((String)metadata.getTitle()));
            } else {
                this.setTitle(metadata.getTitle());
            }
        }
        if (config.isOriginalTitle()) {
            if (MovieModuleManager.SETTINGS.getCapitalWordsInTitles()) {
                this.setOriginalTitle(WordUtils.capitalize((String)metadata.getOriginalTitle()));
            } else {
                this.setOriginalTitle(metadata.getOriginalTitle());
            }
        }
        if (config.isTagline()) {
            this.setTagline(metadata.getTagline());
        }
        if (config.isPlot()) {
            this.setPlot(metadata.getPlot());
        }
        if (config.isYear()) {
            this.setYear(metadata.getYear());
            this.setReleaseDate(metadata.getReleaseDate());
        }
        if (config.isRating()) {
            this.clearRatings();
            for (MediaRating mediaRating : metadata.getRatings()) {
                this.setRating(new Rating(mediaRating));
            }
            this.setTop250(metadata.getTop250());
        }
        if (config.isRuntime()) {
            this.setRuntime(metadata.getRuntime());
        }
        this.setSpokenLanguages(StringUtils.join((Iterable)metadata.getSpokenLanguages(), (String)", "));
        if (config.isCertification() && metadata.getCertifications() != null && metadata.getCertifications().size() > 0) {
            this.setCertification((Certification)metadata.getCertifications().get(0));
        }
        if (config.isCountry()) {
            this.setCountry(StringUtils.join((Iterable)metadata.getCountries(), (String)", "));
        }
        if (config.isStudio()) {
            this.setProductionCompany(StringUtils.join((Iterable)metadata.getProductionCompanies(), (String)", "));
        }
        if (config.isCast()) {
            ArrayList actors = new ArrayList();
            ArrayList<Person> producers = new ArrayList<Person>();
            ArrayList<Person> directors = new ArrayList<Person>();
            ArrayList<Person> writers = new ArrayList<Person>();
            for (MediaCastMember member : metadata.getCastMembers()) {
                switch (member.getType()) {
                    case ACTOR: {
                        actors.add(new Person(member));
                        break;
                    }
                    case DIRECTOR: {
                        directors.add(new Person(member));
                        break;
                    }
                    case WRITER: {
                        writers.add(new Person(member));
                        break;
                    }
                    case PRODUCER: {
                        producers.add(new Person(member));
                        break;
                    }
                }
            }
            this.setActors(actors);
            this.setDirectors(directors);
            this.setWriters(writers);
            this.setProducers(producers);
        }
        if (config.isGenres()) {
            this.setGenres(metadata.getGenres());
        }
        if (config.isTags()) {
            for (String tag : metadata.getTags()) {
                this.addToTags(tag);
            }
        }
        this.setScraped(true);
        if (config.isCollection()) {
            int col = 0;
            try {
                col = (Integer)metadata.getId("tmdbSet");
            }
            catch (Exception tag) {
                // empty catch block
            }
            if (col != 0) {
                MovieSet movieSet = MovieList.getInstance().getMovieSet(metadata.getCollectionName(), col);
                if (movieSet != null && movieSet.getTmdbId() == 0) {
                    movieSet.setTmdbId(col);
                    try {
                        List<MediaScraper> sets = MediaScraper.getMediaScrapers(ScraperType.MOVIE_SET);
                        if (sets != null && sets.size() > 0) {
                            MediaScraper first = sets.get(0);
                            IMovieSetMetadataProvider mp = (IMovieSetMetadataProvider)first.getMediaProvider();
                            MediaScrapeOptions options = new MediaScrapeOptions(MediaType.MOVIE_SET);
                            options.setTmdbId(col);
                            options.setLanguage(MovieModuleManager.SETTINGS.getScraperLanguage().toLocale());
                            options.setCountry(MovieModuleManager.SETTINGS.getCertificationCountry());
                            MediaMetadata info = mp.getMetadata(options);
                            if (info != null && StringUtils.isNotBlank((CharSequence)info.getTitle())) {
                                movieSet.setTitle(info.getTitle());
                                movieSet.setPlot(info.getPlot());
                                if (!info.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).isEmpty()) {
                                    movieSet.setArtworkUrl(((MediaArtwork)info.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).get(0)).getDefaultUrl(), MediaFileType.POSTER);
                                }
                                if (!info.getMediaArt(MediaArtwork.MediaArtworkType.BACKGROUND).isEmpty()) {
                                    movieSet.setArtworkUrl(((MediaArtwork)info.getMediaArt(MediaArtwork.MediaArtworkType.BACKGROUND).get(0)).getDefaultUrl(), MediaFileType.FANART);
                                }
                            }
                        }
                    }
                    catch (ScrapeException e) {
                        LOGGER.error("getMovieSet", (Throwable)e);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this, "message.scrape.metadatamoviesetfailed", new String[]{":", e.getLocalizedMessage()}));
                    }
                    catch (MissingIdException | NothingFoundException | UnsupportedMediaTypeException throwable) {
                        // empty catch block
                    }
                }
                if (movieSet != null) {
                    this.setMovieSet(null);
                    this.setMovieSet(movieSet);
                    movieSet.insertMovie(this);
                    movieSet.saveToDb();
                }
            }
        }
        this.writeNFO();
        this.saveToDb();
        if (MovieModuleManager.SETTINGS.isRenameAfterScrape()) {
            MovieRenamer.renameMovie(this);
        }
        if (config.isCast()) {
            this.writeActorImages();
        }
    }

    @JsonSetter
    public void setTrailers(List<MovieTrailer> trailers) {
        MovieTrailer preferredTrailer = null;
        this.removeAllTrailers();
        if (MovieModuleManager.SETTINGS.isUseTrailerPreference()) {
            MovieTrailerQuality desiredQuality = MovieModuleManager.SETTINGS.getTrailerQuality();
            MovieTrailerSources desiredSource = MovieModuleManager.SETTINGS.getTrailerSource();
            for (MovieTrailer trailer : trailers) {
                if (!desiredQuality.containsQuality(trailer.getQuality()) || !desiredSource.containsSource(trailer.getProvider())) continue;
                trailer.setInNfo(Boolean.TRUE);
                preferredTrailer = trailer;
                break;
            }
            if (preferredTrailer == null) {
                for (MovieTrailer trailer : trailers) {
                    if (!desiredQuality.containsQuality(trailer.getQuality())) continue;
                    trailer.setInNfo(Boolean.TRUE);
                    preferredTrailer = trailer;
                    break;
                }
            }
            if (preferredTrailer == null) {
                ArrayList<MovieTrailer> sortedTrailers = new ArrayList<MovieTrailer>(trailers);
                sortedTrailers.sort(TRAILER_QUALITY_COMPARATOR);
                for (MovieTrailer trailer : sortedTrailers) {
                    if (desiredQuality.ordinal() < MovieTrailerQuality.getMovieTrailerQuality(trailer.getQuality()).ordinal()) continue;
                    trailer.setInNfo(Boolean.TRUE);
                    preferredTrailer = trailer;
                    break;
                }
            }
        }
        if (preferredTrailer == null && !trailers.isEmpty()) {
            ArrayList<MovieTrailer> sortedTrailers = new ArrayList<MovieTrailer>(trailers);
            sortedTrailers.sort(TRAILER_QUALITY_COMPARATOR);
            preferredTrailer = (MovieTrailer)sortedTrailers.get(0);
            preferredTrailer.setInNfo(Boolean.TRUE);
        }
        if (preferredTrailer != null) {
            this.addTrailer(preferredTrailer);
        }
        for (MovieTrailer trailer : trailers) {
            if (preferredTrailer != null && preferredTrailer == trailer) continue;
            if (preferredTrailer == null && this.trailer.size() == 0 && !trailer.getUrl().startsWith("file")) {
                trailer.setInNfo(Boolean.TRUE);
            }
            this.addTrailer(trailer);
        }
    }

    public void setArtwork(MediaMetadata md, MovieScraperMetadataConfig config) {
        this.setArtwork(md.getMediaArt(MediaArtwork.MediaArtworkType.ALL), config);
    }

    public void setArtwork(List<MediaArtwork> artwork, MovieScraperMetadataConfig config) {
        if (config.isArtwork()) {
            MovieArtworkHelper.setArtwork(this, artwork);
        }
    }

    @Override
    public void setTitle(String newValue) {
        String oldValue = this.title;
        super.setTitle(newValue);
        this.firePropertyChange("titleForUi", oldValue, newValue);
        oldValue = this.titleSortable;
        this.titleSortable = "";
        this.firePropertyChange("titleSortable", oldValue, this.titleSortable);
    }

    @Override
    public void setOriginalTitle(String newValue) {
        String oldValue = this.originalTitle;
        super.setOriginalTitle(newValue);
        this.firePropertyChange("titleForUi", oldValue, newValue);
        oldValue = this.originalTitleSortable;
        this.originalTitleSortable = "";
        this.firePropertyChange("titleSortable", oldValue, this.originalTitleSortable);
    }

    public void setRuntime(int newValue) {
        int oldValue = this.runtime;
        this.runtime = newValue;
        this.firePropertyChange("runtime", oldValue, newValue);
    }

    public void setTagline(String newValue) {
        String oldValue = this.tagline;
        this.tagline = newValue;
        this.firePropertyChange("tagline", oldValue, newValue);
    }

    @Override
    public void setYear(int newValue) {
        int oldValue = this.year;
        super.setYear(newValue);
        this.firePropertyChange("titleForUi", oldValue, newValue);
    }

    public String getNfoFilename(MovieNfoNaming nfo) {
        List<MediaFile> mfs = this.getMediaFiles(MediaFileType.VIDEO);
        if (mfs != null && mfs.size() > 0) {
            String name = mfs.get(0).getFilename();
            if (this.isStacked()) {
                name = Utils.cleanStackingMarkers(name);
            }
            return this.getNfoFilename(nfo, name);
        }
        return this.getNfoFilename(nfo, "");
    }

    public String getNfoFilename(MovieNfoNaming nfo, String newMovieFilename) {
        String filename = "";
        switch (nfo) {
            case FILENAME_NFO: {
                filename = this.isDisc() ? FilenameUtils.removeExtension((String)this.findDiscMainFile()) : FilenameUtils.removeExtension((String)newMovieFilename);
                if (filename.isEmpty()) break;
                filename = filename + ".nfo";
                break;
            }
            case MOVIE_NFO: {
                filename = "movie.nfo";
                break;
            }
            default: {
                filename = "";
            }
        }
        return filename;
    }

    public String getTrailerFilename(MovieTrailerNaming trailer) {
        List<MediaFile> mfs = this.getMediaFiles(MediaFileType.VIDEO);
        if (mfs != null && mfs.size() > 0) {
            String name = mfs.get(0).getFilename();
            if (this.isStacked()) {
                name = Utils.cleanStackingMarkers(name);
            }
            return this.getTrailerFilename(trailer, name);
        }
        return this.getTrailerFilename(trailer, "");
    }

    public String getTrailerFilename(MovieTrailerNaming trailer, String newMovieFilename) {
        String filename = "";
        switch (trailer) {
            case FILENAME_TRAILER: {
                filename = this.isDisc() ? FilenameUtils.removeExtension((String)this.findDiscMainFile()) : FilenameUtils.removeExtension((String)newMovieFilename);
                if (filename.isEmpty()) break;
                filename = filename + "-trailer";
                break;
            }
            case MOVIE_TRAILER: {
                filename = "movie-trailer";
                break;
            }
            default: {
                filename = "";
            }
        }
        return filename;
    }

    public void downloadArtwork(MediaFileType type) {
        MovieArtworkHelper.downloadArtwork(this, type);
    }

    public void writeActorImages() {
        if (!MovieModuleManager.SETTINGS.isWriteActorImages() || this.isMultiMovieDir()) {
            return;
        }
        MovieActorImageFetcherTask task = new MovieActorImageFetcherTask(this);
        TmmTaskManager.getInstance().addImageDownloadTask(task);
    }

    public void writeNFO() {
        if (MovieModuleManager.SETTINGS.getNfoFilenames().isEmpty()) {
            LOGGER.info("Not writing any NFO file, because NFO filename preferences were empty...");
            return;
        }
        MovieGenericXmlConnector connector = null;
        switch (MovieModuleManager.SETTINGS.getMovieConnector()) {
            case MP: {
                connector = new MovieToMpLegacyConnector(this);
                break;
            }
            case MP_MP: {
                connector = new MovieToMpMovingPicturesConnector(this);
                break;
            }
            case MP_MV: {
                connector = new MovieToMpMyVideoConnector(this);
                break;
            }
            case KODI: {
                connector = new MovieToKodiConnector(this);
                break;
            }
            default: {
                connector = new MovieToXbmcConnector(this);
            }
        }
        if (connector != null) {
            ArrayList<MovieNfoNaming> nfonames = new ArrayList<MovieNfoNaming>();
            if (this.isMultiMovieDir()) {
                nfonames.add(MovieNfoNaming.FILENAME_NFO);
            } else if (this.isDisc()) {
                nfonames.add(MovieNfoNaming.FILENAME_NFO);
                nfonames.add(MovieNfoNaming.MOVIE_NFO);
            } else {
                nfonames = MovieModuleManager.SETTINGS.getNfoFilenames();
            }
            connector.write(nfonames);
            this.firePropertyChange("hasNfoFile", false, true);
        }
    }

    public List<MediaGenres> getGenres() {
        return this.genres;
    }

    public void addGenre(MediaGenres newValue) {
        if (!this.genres.contains(newValue)) {
            this.genres.add(newValue);
            this.firePropertyChange("genre", null, newValue);
            this.firePropertyChange("genresAsString", null, newValue);
        }
    }

    @JsonSetter
    public void setGenres(List<MediaGenres> newGenres) {
        ListUtils.mergeLists(this.genres, newGenres);
        this.firePropertyChange("genre", null, this.genres);
        this.firePropertyChange("genresAsString", null, this.genres);
    }

    public void removeGenre(MediaGenres genre) {
        if (this.genres.contains(genre)) {
            this.genres.remove(genre);
            this.firePropertyChange("genre", null, genre);
            this.firePropertyChange("genresAsString", null, genre);
        }
    }

    public void removeAllGenres() {
        this.genres.clear();
        this.firePropertyChange("genre", null, this.genres);
        this.firePropertyChange("genresAsString", null, this.genres);
    }

    @Override
    public Certification getCertification() {
        return this.certification;
    }

    public void setCertification(Certification newValue) {
        this.certification = newValue;
        this.firePropertyChange("certification", null, newValue);
    }

    @Override
    public Rating getRating() {
        Rating rating = null;
        if (MovieModuleManager.SETTINGS.getPreferPersonalRating()) {
            rating = (Rating)this.ratings.get("user");
        }
        if (rating == null && StringUtils.isNotBlank((CharSequence)MovieModuleManager.SETTINGS.getPreferredRating())) {
            rating = (Rating)this.ratings.get(MovieModuleManager.SETTINGS.getPreferredRating());
        }
        if (rating == null) {
            rating = (Rating)this.ratings.get("NFO");
        }
        if (rating == null) {
            rating = (Rating)this.ratings.get("default");
        }
        if (rating == null && !this.ratings.isEmpty()) {
            rating = (Rating)this.ratings.values().iterator().next();
        }
        if (rating == null) {
            rating = new Rating();
        }
        return rating;
    }

    public boolean getHasRating() {
        return !this.ratings.isEmpty() || this.scraped;
    }

    public String getGenresAsString() {
        StringBuilder sb = new StringBuilder();
        for (MediaGenres genre : this.genres) {
            if (!StringUtils.isEmpty((CharSequence)sb)) {
                sb.append(", ");
            }
            sb.append(genre != null ? genre.getLocalizedName() : "null");
        }
        return sb.toString();
    }

    public boolean isWatched() {
        return this.watched;
    }

    public void setWatched(boolean newValue) {
        boolean oldValue = this.watched;
        this.watched = newValue;
        this.firePropertyChange("watched", oldValue, newValue);
    }

    public boolean isMultiMovieDir() {
        return this.multiMovieDir;
    }

    public void setMultiMovieDir(boolean multiDir) {
        this.multiMovieDir = multiDir;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public MovieSet getMovieSet() {
        return this.movieSet;
    }

    public void setMovieSet(MovieSet newValue) {
        MovieSet oldValue = this.movieSet;
        this.movieSet = newValue;
        this.movieSetId = newValue == null ? null : newValue.getDbId();
        this.firePropertyChange("movieset", oldValue, newValue);
        this.firePropertyChange("movieSetTitle", oldValue, newValue);
    }

    public void movieSetTitleChanged() {
        this.firePropertyChange("movieSetTitle", null, "");
    }

    public String getMovieSetTitle() {
        if (this.movieSet != null) {
            return this.movieSet.getTitle();
        }
        return "";
    }

    public void removeFromMovieSet() {
        if (this.movieSet != null) {
            this.movieSet.removeMovie(this, true);
        }
        this.setMovieSet(null);
    }

    public boolean isDisc() {
        return this.isDisc;
    }

    public void setDisc(boolean isDisc) {
        this.isDisc = isDisc;
    }

    public String findDiscMainFile() {
        String ret = "";
        for (MediaFile video : this.getMediaFiles(MediaFileType.VIDEO)) {
            if (!video.isMainDiscIdentifierFile()) continue;
            ret = Utils.relPath(this.getPathNIO(), video.getFileAsPath());
        }
        return ret;
    }

    public int getMediaInfoVideoBitrate() {
        return this.getMainVideoFile().getOverallBitRate();
    }

    @Override
    public int getMediaInfoVideoBitDepth() {
        return this.getMainVideoFile().getBitDepth();
    }

    public String getMediaInfoAudioCodecAndChannels() {
        MediaFile mf = this.getMainVideoFile();
        if (!mf.getAudioCodec().isEmpty()) {
            return mf.getAudioCodec() + "_" + mf.getAudioChannels();
        }
        return "";
    }

    public void setSpokenLanguages(String newValue) {
        String oldValue = this.spokenLanguages;
        this.spokenLanguages = newValue;
        this.firePropertyChange("spokenLanguages", oldValue, newValue);
    }

    public String getSpokenLanguages() {
        return this.spokenLanguages;
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String newValue) {
        String oldValue = this.country;
        this.country = newValue;
        this.firePropertyChange("country", oldValue, newValue);
    }

    public MediaSource getMediaSource() {
        return this.mediaSource;
    }

    public void setMediaSource(MediaSource newValue) {
        MediaSource oldValue = this.mediaSource;
        this.mediaSource = newValue;
        this.firePropertyChange("mediaSource", (Object)oldValue, (Object)newValue);
    }

    public List<MediaFile> getImagesToCache() {
        ArrayList<MediaFile> filesToCache = new ArrayList<MediaFile>();
        for (MediaFile mf : this.getMediaFiles()) {
            if (!mf.isGraphic()) continue;
            filesToCache.add(mf);
        }
        if (!this.isMultiMovieDir()) {
            filesToCache.addAll(this.listActorFiles());
        }
        return filesToCache;
    }

    private List<MediaFile> listActorFiles() {
        ArrayList<MediaFile> fileNames = new ArrayList<MediaFile>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.getPathNIO().resolve(".actors"));){
            for (Path path : directoryStream) {
                MediaFile mf;
                if (!Utils.isRegularFile(path) || !(mf = new MediaFile(path)).isGraphic()) continue;
                fileNames.add(mf);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Cannot get actors: {}", (Object)this.getPathNIO().resolve(".actors"));
        }
        return fileNames;
    }

    public List<MediaFile> getMediaFilesContainingAudioStreams() {
        ArrayList<MediaFile> mediaFilesWithAudioStreams = new ArrayList<MediaFile>(1);
        List<MediaFile> videoFiles = this.getMediaFiles(MediaFileType.VIDEO);
        if (videoFiles.size() > 0) {
            MediaFile videoFile = videoFiles.get(0);
            mediaFilesWithAudioStreams.add(videoFile);
        }
        mediaFilesWithAudioStreams.addAll(this.getMediaFiles(MediaFileType.AUDIO));
        return mediaFilesWithAudioStreams;
    }

    public List<MediaFile> getMediaFilesContainingSubtitles() {
        ArrayList<MediaFile> mediaFilesWithSubtitles = new ArrayList<MediaFile>(1);
        for (MediaFile mediaFile : this.getMediaFiles(MediaFileType.VIDEO, MediaFileType.SUBTITLE)) {
            if (!mediaFile.hasSubtitles()) continue;
            mediaFilesWithSubtitles.add(mediaFile);
        }
        return mediaFilesWithSubtitles;
    }

    private int getRuntimeFromDvdFiles() {
        int rtifo = 0;
        MediaFile ifo = null;
        for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
            if (!mf.getFilename().toLowerCase(Locale.ROOT).endsWith("ifo") || mf.getDuration() <= rtifo) continue;
            rtifo = mf.getDuration();
            ifo = mf;
        }
        if (ifo != null) {
            LOGGER.trace("Found longest IFO:{} duration:{}", (Object)ifo.getFilename(), (Object)this.runtime);
            String prefix = StrgUtils.substr((String)ifo.getFilename(), (String)"(?i)^(VTS_\\d+).*");
            if (prefix.isEmpty()) {
                prefix = StrgUtils.substr((String)ifo.getFilename(), (String)"(?i)^(HV\\d+)I.*");
            }
            if (!prefix.isEmpty()) {
                int rtvob = 0;
                for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
                    if (!mf.getFilename().startsWith(prefix) || ifo.getFilename().equals(mf.getFilename())) continue;
                    LOGGER.trace("VOB:{} duration:{} accumulated:{}", new Object[]{mf.getFilename(), mf.getDuration(), rtvob += mf.getDuration()});
                }
                if (rtvob > rtifo) {
                    rtifo = rtvob;
                }
            } else {
                LOGGER.trace("TODO: bluray");
            }
        }
        return rtifo;
    }

    public int getRuntimeFromMediaFiles() {
        int runtime = 0;
        if (this.isDisc) {
            runtime = this.getRuntimeFromDvdFiles();
        }
        if (runtime < 10) {
            for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
                if (mf.isMainDiscIdentifierFile() || mf.getFilename().toLowerCase(Locale.ROOT).endsWith("ifo")) continue;
                runtime += mf.getDuration();
            }
        }
        return runtime;
    }

    public int getRuntimeFromMediaFilesInMinutes() {
        return this.getRuntimeFromMediaFiles() / 60;
    }

    public Date getReleaseDate() {
        return this.releaseDate;
    }

    @JsonIgnore
    public void setReleaseDate(Date newValue) {
        Date oldValue = this.releaseDate;
        this.releaseDate = newValue;
        this.firePropertyChange("releaseDate", oldValue, newValue);
        this.firePropertyChange("releaseDateAsString", oldValue, newValue);
    }

    public String getReleaseDateFormatted() {
        if (this.releaseDate == null) {
            return "";
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(this.releaseDate);
    }

    public String getReleaseDateAsString() {
        if (this.releaseDate == null) {
            return "";
        }
        return TmmDateFormat.SHORT_DATE_FORMAT.format(this.releaseDate);
    }

    public void setReleaseDate(String dateAsString) {
        try {
            this.setReleaseDate(StrgUtils.parseDate((String)dateAsString));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public Date getLastWatched() {
        return this.lastWatched;
    }

    public void setLastWatched(Date lastWatched) {
        this.lastWatched = lastWatched;
    }

    @Override
    public void saveToDb() {
        MovieList.getInstance().persistMovie(this);
    }

    @Override
    public void deleteFromDb() {
        MovieList.getInstance().removeMovieFromDb(this);
    }

    @Override
    public synchronized void callbackForWrittenArtwork(MediaArtwork.MediaArtworkType type) {
        if (MovieModuleManager.SETTINGS.getMovieConnector() == MovieConnectors.MP) {
            this.writeNFO();
        }
    }

    public List<MediaFile> getVideoFiles() {
        return this.getMediaFiles(MediaFileType.VIDEO);
    }

    public String getVideoBasenameWithoutStacking() {
        MediaFile mf = this.getMediaFiles(MediaFileType.VIDEO).get(0);
        return FilenameUtils.getBaseName((String)mf.getFilenameWithoutStacking());
    }

    public int getTop250() {
        return this.top250;
    }

    public void setVideoIn3D(boolean newValue) {
        boolean oldValue = this.videoIn3D;
        this.videoIn3D = newValue;
        this.firePropertyChange("videoIn3D", oldValue, newValue);
    }

    @Override
    public boolean isVideoIn3D() {
        String video3DFormat = "";
        List<MediaFile> videos = this.getMediaFiles(MediaFileType.VIDEO);
        if (videos.size() > 0) {
            MediaFile mediaFile = videos.get(0);
            video3DFormat = mediaFile.getVideo3DFormat();
        }
        return this.videoIn3D || StringUtils.isNotBlank((CharSequence)video3DFormat);
    }

    public void setTop250(int newValue) {
        int oldValue = this.top250;
        this.top250 = newValue;
        this.firePropertyChange("top250", oldValue, newValue);
    }

    public void addActor(Person actor) {
        if (actor.getType() != Person.Type.ACTOR) {
            return;
        }
        this.actors.add(actor);
        this.firePropertyChange("actors", null, this.getActors());
    }

    public void removeActor(Person actor) {
        this.actors.remove(actor);
        this.firePropertyChange("actors", null, this.getActors());
    }

    @JsonSetter
    public void setActors(List<Person> newActors) {
        ListUtils.mergeLists(this.actors, newActors);
        this.firePropertyChange("actors", null, this.getActors());
    }

    public List<Person> getActors() {
        return this.actors;
    }

    public void addProducer(Person producer) {
        if (producer.getType() != Person.Type.PRODUCER) {
            return;
        }
        this.producers.add(producer);
        this.firePropertyChange("producers", null, this.producers);
    }

    public void removeProducer(Person producer) {
        this.producers.remove(producer);
        this.firePropertyChange("producers", null, this.producers);
    }

    @JsonSetter
    public void setProducers(List<Person> newProducers) {
        ListUtils.mergeLists(this.producers, newProducers);
        this.firePropertyChange("producers", null, this.producers);
    }

    public List<Person> getProducers() {
        return this.producers;
    }

    public void addDirector(Person director) {
        if (director.getType() != Person.Type.DIRECTOR) {
            return;
        }
        this.directors.add(director);
        this.firePropertyChange("directors", null, this.getDirectors());
        this.firePropertyChange("directorsAsString", null, this.getDirectorsAsString());
    }

    public void removeDirector(Person director) {
        this.directors.remove(director);
        this.firePropertyChange("directors", null, this.getDirectors());
        this.firePropertyChange("directorsAsString", null, this.getDirectorsAsString());
    }

    @JsonSetter
    public void setDirectors(List<Person> newDirectors) {
        ListUtils.mergeLists(this.directors, newDirectors);
        this.firePropertyChange("directors", null, this.getDirectors());
        this.firePropertyChange("directorsAsString", null, this.getDirectorsAsString());
    }

    public List<Person> getDirectors() {
        return this.directors;
    }

    public String getDirectorsAsString() {
        ArrayList<String> directorNames = new ArrayList<String>();
        for (Person director : this.directors) {
            directorNames.add(director.getName());
        }
        return StringUtils.join(directorNames, (String)", ");
    }

    public void addWriter(Person writer) {
        if (writer.getType() != Person.Type.WRITER) {
            return;
        }
        this.writers.add(writer);
        this.firePropertyChange("writers", null, this.getWriters());
        this.firePropertyChange("writersAsString", null, this.getWritersAsString());
    }

    public void removeWriter(Person writer) {
        this.writers.remove(writer);
        this.firePropertyChange("writers", null, this.getWriters());
        this.firePropertyChange("writersAsString", null, this.getWritersAsString());
    }

    @JsonSetter
    public void setWriters(List<Person> newWriters) {
        ListUtils.mergeLists(this.writers, newWriters);
        this.firePropertyChange("writers", null, this.getWriters());
        this.firePropertyChange("writersAsString", null, this.getWritersAsString());
    }

    public List<Person> getWriters() {
        return this.writers;
    }

    public String getWritersAsString() {
        ArrayList<String> writerNames = new ArrayList<String>();
        for (Person writer : this.writers) {
            writerNames.add(writer.getName());
        }
        return StringUtils.join(writerNames, (String)", ");
    }

    public boolean isStacked() {
        return this.stacked;
    }

    public void setStacked(boolean stacked) {
        this.stacked = stacked;
    }

    public void reEvaluateStacking() {
        List<MediaFile> mfs = this.getMediaFiles(MediaFileType.VIDEO);
        if (mfs.size() > 1 && !this.isDisc()) {
            this.setStacked(true);
            for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO, MediaFileType.AUDIO, MediaFileType.SUBTITLE)) {
                mf.detectStackingInformation();
            }
        } else {
            this.setStacked(false);
            for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO, MediaFileType.AUDIO, MediaFileType.SUBTITLE)) {
                mf.removeStackingInformation();
            }
        }
    }

    public boolean deleteFilesSafely() {
        if (this.isMultiMovieDir()) {
            boolean ok = true;
            for (MediaFile mf : this.getMediaFiles()) {
                if (mf.deleteSafely(this.getDataSource())) continue;
                ok = false;
            }
            return ok;
        }
        return Utils.deleteDirectorySafely(this.getPathNIO(), this.getDataSource());
    }

    @Override
    public MediaFile getMainVideoFile() {
        MediaFile vid = new MediaFile();
        if (this.stacked) {
            vid = this.getMediaFiles(MediaFileType.VIDEO).stream().min(Comparator.comparingInt(MediaFile::getStacking)).orElse(new MediaFile());
        } else if (this.isDisc()) {
            vid = this.getMainDVDVideoFile();
        }
        if (vid == null || vid.getFilename().isEmpty()) {
            vid = this.getBiggestMediaFile(MediaFileType.VIDEO);
        }
        if (vid != null) {
            return vid;
        }
        LOGGER.warn("Movie without video file? {}", (Object)this.getPathNIO());
        return new MediaFile();
    }

    public MediaFile getMainDVDVideoFile() {
        MediaFile vid = null;
        for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
            if (!mf.getExtension().equalsIgnoreCase("ifo") || vid != null && mf.getDuration() <= vid.getDuration()) continue;
            vid = mf;
        }
        if (vid == null) {
            return vid;
        }
        for (MediaFile mf : this.getMediaFiles(MediaFileType.VIDEO)) {
            if (!mf.getExtension().equalsIgnoreCase("vob") || !mf.getBasename().equalsIgnoreCase(vid.getBasename())) continue;
            vid = mf;
            break;
        }
        return vid;
    }

    @Override
    public String getMediaInfoVideoResolution() {
        return this.getMainVideoFile().getVideoResolution();
    }

    @Override
    public String getMediaInfoVideoFormat() {
        return this.getMainVideoFile().getVideoFormat();
    }

    @Override
    public String getMediaInfoVideoCodec() {
        return this.getMainVideoFile().getVideoCodec();
    }

    @Override
    public double getMediaInfoFrameRate() {
        return this.getMainVideoFile().getFrameRate();
    }

    @Override
    public float getMediaInfoAspectRatio() {
        return this.getMainVideoFile().getAspectRatio();
    }

    @Override
    public String getMediaInfoAudioCodec() {
        return this.getMainVideoFile().getAudioCodec();
    }

    @Override
    public List<String> getMediaInfoAudioCodecList() {
        return this.getMainVideoFile().getAudioCodecList();
    }

    @Override
    public String getMediaInfoAudioChannels() {
        return this.getMainVideoFile().getAudioChannels();
    }

    @Override
    public List<String> getMediaInfoAudioChannelList() {
        return this.getMainVideoFile().getAudioChannelsList();
    }

    @Override
    public String getMediaInfoAudioLanguage() {
        return this.getMainVideoFile().getAudioLanguage();
    }

    @Override
    public List<String> getMediaInfoAudioLanguageList() {
        return this.getMainVideoFile().getAudioLanguagesList();
    }

    @Override
    public String getMediaInfoContainerFormat() {
        return this.getMainVideoFile().getContainerFormat();
    }

    @Override
    public MediaSource getMediaInfoSource() {
        return this.getMediaSource();
    }

    public String getVideo3DFormat() {
        MediaFile mediaFile = this.getMainVideoFile();
        if (StringUtils.isNotBlank((CharSequence)mediaFile.getVideo3DFormat())) {
            return mediaFile.getVideo3DFormat();
        }
        if (this.isVideoIn3D()) {
            return "3D";
        }
        return "";
    }

    @Override
    public String getVideoHDRFormat() {
        return this.getMainVideoFile().isHDR() ? "HDR" : "";
    }

    public MovieEdition getEdition() {
        return this.edition;
    }

    public String getEditionAsString() {
        return this.edition.toString();
    }

    public void setOffline(boolean newValue) {
        boolean oldValue = this.offline;
        this.offline = newValue;
        this.firePropertyChange("offline", oldValue, newValue);
    }

    public boolean isOffline() {
        return this.offline;
    }

    public void setEdition(MovieEdition newValue) {
        MovieEdition oldValue = this.edition;
        this.edition = newValue;
        this.firePropertyChange("edition", (Object)oldValue, (Object)newValue);
        this.firePropertyChange("editionAsString", (Object)oldValue, (Object)newValue);
    }
}

