/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.entities.MediaArtwork;

public class MovieExtraImageFetcherTask
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieExtraImageFetcherTask.class);
    private Movie movie;
    private MediaFileType type;

    public MovieExtraImageFetcherTask(Movie movie, MediaFileType type) {
        this.movie = movie;
        this.type = type;
    }

    @Override
    public void run() {
        try {
            block8: {
                block7: {
                    if (this.movie.isMultiMovieDir()) break block7;
                    switch (this.type) {
                        case EXTRATHUMB: {
                            this.downloadExtraThumbs();
                            break block8;
                        }
                        case EXTRAFANART: {
                            this.downloadExtraFanart();
                            break block8;
                        }
                        default: {
                            return;
                        }
                    }
                }
                LOGGER.info("Movie '{}' is within a multi-movie-directory - skip downloading of {} images.", (Object)this.movie.getTitle(), (Object)this.type.name());
            }
            if (Thread.interrupted()) {
                return;
            }
            this.movie.callbackForWrittenArtwork(MediaArtwork.MediaArtworkType.ALL);
            this.movie.saveToDb();
        }
        catch (Exception e) {
            LOGGER.error("Thread crashed: ", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.movie, "message.extraimage.threadcrashed"));
        }
    }

    private void downloadExtraFanart() {
        List<String> fanarts = this.movie.getExtraFanarts();
        if (fanarts.isEmpty()) {
            return;
        }
        Path folder = this.movie.getPathNIO().resolve("extrafanart");
        try {
            if (Files.isDirectory(folder, new LinkOption[0])) {
                Utils.deleteDirectorySafely(folder, this.movie.getDataSource());
                this.movie.removeAllMediaFiles(MediaFileType.EXTRAFANART);
            }
            Files.createDirectory(folder, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("could not create extrafanarts folder: {}", (Object)e.getMessage());
            return;
        }
        int i = 1;
        for (String urlAsString : fanarts) {
            try {
                String filename = "fanart" + i + "." + FilenameUtils.getExtension((String)urlAsString);
                Path destFile = ImageUtils.downloadImage(urlAsString, folder, filename);
                MediaFile mf = new MediaFile(destFile, MediaFileType.EXTRAFANART);
                mf.gatherMediaInformation();
                this.movie.addToMediaFiles(mf);
                ImageCache.cacheImageSilently(destFile);
                ++i;
            }
            catch (InterruptedIOException | InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (Exception e) {
                LOGGER.warn("problem downloading extrafanart {} - {} ", (Object)urlAsString, (Object)e.getMessage());
            }
        }
    }

    private void downloadExtraThumbs() {
        List<String> thumbs = this.movie.getExtraThumbs();
        if (thumbs.isEmpty()) {
            return;
        }
        Path folder = this.movie.getPathNIO().resolve("extrathumbs");
        try {
            if (Files.isDirectory(folder, new LinkOption[0])) {
                Utils.deleteDirectorySafely(folder, this.movie.getDataSource());
                this.movie.removeAllMediaFiles(MediaFileType.EXTRATHUMB);
            }
            Files.createDirectory(folder, new FileAttribute[0]);
        }
        catch (IOException e) {
            LOGGER.error("could not create extrathumbs folder: {}", (Object)e.getMessage());
            return;
        }
        int i = 1;
        for (String urlAsString : thumbs) {
            try {
                String filename = "thumb" + i + ".";
                filename = MovieModuleManager.SETTINGS.isImageExtraThumbsResize() ? filename + "jpg" : filename + FilenameUtils.getExtension((String)urlAsString);
                Path destFile = ImageUtils.downloadImage(urlAsString, folder, filename, MovieModuleManager.SETTINGS.isImageExtraThumbsResize(), MovieModuleManager.SETTINGS.getImageExtraThumbsSize());
                MediaFile mf = new MediaFile(destFile, MediaFileType.EXTRATHUMB);
                mf.gatherMediaInformation();
                this.movie.addToMediaFiles(mf);
                ImageCache.cacheImageSilently(destFile);
                if (Thread.interrupted()) {
                    return;
                }
                ++i;
            }
            catch (Exception e) {
                LOGGER.warn("problem downloading extrathumb {} - {}", (Object)urlAsString, (Object)e.getMessage());
            }
        }
    }
}

