/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.tasks;

import java.nio.file.Path;
import java.util.ResourceBundle;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieTrailer;
import org.tinymediamanager.core.movie.filenaming.MovieTrailerNaming;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.scraper.util.youtube.YoutubeHelper;
import org.tinymediamanager.scraper.util.youtube.model.Extension;
import org.tinymediamanager.scraper.util.youtube.model.YoutubeMedia;
import org.tinymediamanager.scraper.util.youtube.model.formats.AudioFormat;
import org.tinymediamanager.scraper.util.youtube.model.formats.Format;
import org.tinymediamanager.scraper.util.youtube.model.formats.VideoFormat;
import org.tinymediamanager.scraper.util.youtube.model.quality.VideoQuality;
import org.tinymediamanager.scraper.util.youtube.muxer.TmmMuxer;
import org.tinymediamanager.ui.UTF8Control;

public class YoutubeDownloadTask
extends TmmTask {
    private static final Logger LOGGER = LoggerFactory.getLogger(YoutubeDownloadTask.class);
    private static final char[] ILLEGAL_FILENAME_CHARACTERS = new char[]{'/', '\n', '\r', '\t', '\u0000', '\f', '`', '?', '*', '\\', '<', '>', '|', '\"', ':'};
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private MovieTrailer movieTrailer;
    private Movie movie;
    private YoutubeMedia mediaDetails;
    private long timestamp1 = System.nanoTime();
    private long length;
    private long bytesDone = 0L;
    private long bytesDonePrevious = 0L;
    private double speed = 0.0;

    public YoutubeDownloadTask(MovieTrailer movieTrailer, Movie movie) {
        super(BUNDLE.getString("task.download") + " " + movieTrailer.getName(), 100, TmmTaskHandle.TaskType.BACKGROUND_TASK);
        this.movieTrailer = movieTrailer;
        this.movie = movie;
        this.setTaskDescription(movieTrailer.getName());
    }

    @Override
    protected void doInBackground() {
        try {
            String trailerFilename = this.movie.getTrailerFilename(MovieTrailerNaming.FILENAME_TRAILER) + "." + Extension.MP4.getText();
            this.mediaDetails = new YoutubeMedia(YoutubeHelper.extractId(this.movieTrailer.getUrl()));
            this.mediaDetails.parseVideo();
            VideoFormat videoFormat = this.mediaDetails.findVideo(VideoQuality.getVideoQuality(this.movieTrailer.getQuality()), Extension.MP4);
            AudioFormat audioFormat = this.mediaDetails.findBestAudio(Extension.MP4);
            if (videoFormat == null || audioFormat == null) {
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"Youtube trailer downloader", "message.trailer.unsupported", new String[]{this.movie.getTitle()}));
                LOGGER.error("Could not download movieTrailer for {}", (Object)this.movie.getTitle());
                return;
            }
            ExecutorService executorService = Executors.newFixedThreadPool(2);
            Future<Path> futureVideo = executorService.submit(() -> {
                try {
                    LOGGER.debug("Downloading video....");
                    return this.download(videoFormat);
                }
                catch (Exception e) {
                    LOGGER.error("Could not download video stream: {}", (Object)e.getMessage());
                    return null;
                }
            });
            Future<Path> futureAudio = executorService.submit(() -> {
                try {
                    LOGGER.debug("Downloading audio....");
                    return this.download(audioFormat);
                }
                catch (Exception e) {
                    LOGGER.error("Could not download audio stream: {}", (Object)e.getMessage());
                    return null;
                }
            });
            Path videoFile = futureVideo.get();
            Path audioFile = futureAudio.get();
            if (videoFile != null && audioFile != null) {
                LOGGER.debug("Muxing...");
                TmmMuxer muxer = new TmmMuxer(audioFile, videoFile);
                Path trailer = this.movie.getPathNIO().resolve(trailerFilename);
                muxer.mergeAudioVideo(trailer);
                LOGGER.debug("Muxing finished");
                MediaFile mf = new MediaFile(trailer, MediaFileType.TRAILER);
                mf.gatherMediaInformation();
                this.movie.removeFromMediaFiles(mf);
                this.movie.addToMediaFiles(mf);
                this.movie.saveToDb();
            }
            Utils.deleteFileSafely(videoFile);
            Utils.deleteFileSafely(audioFile);
        }
        catch (Exception e) {
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"Youtube trailer downloader", "message.trailer.downloadfailed", new String[]{this.movie.getTitle()}));
            LOGGER.error("download of movieTrailer {} failed", (Object)this.movieTrailer.getUrl());
        }
    }

    /*
     * Exception decompiling
     */
    public Path download(Format format) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private synchronized void addContentLength(long length) {
        this.length += length;
    }

    private synchronized void addBytesDone(long count) {
        this.bytesDone += count;
        long timestamp2 = System.nanoTime();
        if (timestamp2 - this.timestamp1 > 250000000L) {
            this.speed = (this.speed + (double)(this.bytesDone - this.bytesDonePrevious) / ((double)(timestamp2 - this.timestamp1) / 1.0E9)) / 2.0;
            this.timestamp1 = timestamp2;
            this.bytesDonePrevious = this.bytesDone;
            if (this.length > 0L) {
                this.publishState(this.formatBytesForOutput(this.bytesDone) + "/" + this.formatBytesForOutput(this.length) + " @" + this.formatSpeedForOutput(this.speed), (int)(this.bytesDone * 100L / this.length));
            } else {
                this.setWorkUnits(0);
                this.publishState(this.formatBytesForOutput(this.bytesDone) + " @" + this.formatSpeedForOutput(this.speed), 0);
            }
        }
    }

    private String formatBytesForOutput(long bytes) {
        return String.format("%.2fM", (double)bytes / 1048576.0);
    }

    private String formatSpeedForOutput(double speed) {
        return String.format("%.2fkB/s", speed / 1024.0);
    }

    private static String cleanFilename(String filename) {
        for (char c : ILLEGAL_FILENAME_CHARACTERS) {
            filename = filename.replace(c, '_');
        }
        return filename;
    }
}

