/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.EmptyFileException;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.ui.UTF8Control;

public class ImageCacheTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageCacheTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private List<MediaFile> filesToCache = new ArrayList<MediaFile>();

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    public ImageCacheTask(List<MediaFile> files) {
        super(BUNDLE.getString("tmm.rebuildimagecache"));
        this.filesToCache.addAll(files);
    }

    @Override
    protected void doInBackground() {
        int threadCount = Runtime.getRuntime().availableProcessors() - 1;
        if (threadCount < 2) {
            threadCount = 2;
        }
        this.initThreadPool(threadCount, "imageCache");
        for (MediaFile fileToCache : this.filesToCache) {
            if (this.cancel) {
                return;
            }
            this.submitTask(new CacheTask(fileToCache));
        }
        this.waitForCompletionOrCancel();
    }

    private class CacheTask
    implements Callable<Object> {
        private final MediaFile fileToCache;

        CacheTask(MediaFile fileToCache) {
            this.fileToCache = fileToCache;
        }

        @Override
        public Object call() {
            try {
                Thread.sleep(50L);
                ImageCache.cacheImage(this.fileToCache);
            }
            catch (EmptyFileException e) {
                LOGGER.warn("failed to cache file (file is empty): {}", (Object)this.fileToCache);
            }
            catch (Exception e) {
                LOGGER.warn("failed to cache file: {} - {}", (Object)this.fileToCache, (Object)e);
            }
            return null;
        }
    }
}

