/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;

public class MediaFileInformationFetcherTask
implements Callable<Object> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaFileInformationFetcherTask.class);
    private List<MediaFile> mediaFiles;
    private MediaEntity mediaEntity;
    private long uniqueId;
    private boolean forceUpdate;

    public MediaFileInformationFetcherTask(MediaFile mediaFile, MediaEntity mediaEntity, boolean forceUpdate) {
        this.mediaFiles = new ArrayList<MediaFile>();
        this.mediaFiles.add(mediaFile);
        this.mediaEntity = mediaEntity;
        this.forceUpdate = forceUpdate;
        this.uniqueId = TmmTaskManager.getInstance().GLOB_THRD_CNT.incrementAndGet();
    }

    @Deprecated
    public MediaFileInformationFetcherTask(List<MediaFile> mediaFiles, MediaEntity mediaEntity, boolean forceUpdate) {
        this.mediaFiles = mediaFiles;
        this.mediaEntity = mediaEntity;
        this.forceUpdate = forceUpdate;
        this.uniqueId = TmmTaskManager.getInstance().GLOB_THRD_CNT.incrementAndGet();
    }

    @Override
    public String call() {
        try {
            String name = Thread.currentThread().getName();
            if (!name.contains("-G")) {
                name = name + "-G0";
            }
            name = name.replaceAll("\\-G\\d+", "-G" + this.uniqueId);
            Thread.currentThread().setName(name);
            for (MediaFile mediaFile : this.mediaFiles) {
                mediaFile.gatherMediaInformation(this.forceUpdate);
                if (this.mediaEntity instanceof Movie && mediaFile.hasSubtitles()) {
                    Movie movie = (Movie)this.mediaEntity;
                    movie.setSubtitles(true);
                }
                if (!(this.mediaEntity instanceof TvShowEpisode) || !mediaFile.hasSubtitles()) continue;
                TvShowEpisode episode = (TvShowEpisode)this.mediaEntity;
                episode.setSubtitles(true);
            }
        }
        catch (Exception e) {
            LOGGER.error("Thread crashed: ", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MediaInformation", "message.mediainfo.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
        }
        if (this.mediaEntity != null) {
            this.mediaEntity.saveToDb();
            this.mediaEntity.firePropertyChange("mediaInformation", false, true);
            return "getting MediaInfo from " + this.mediaEntity.getTitle();
        }
        return "getting MediaInfo";
    }
}

