/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.threading;

import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskListener;
import org.tinymediamanager.core.threading.TmmTaskManager;

public abstract class TmmTask
implements Runnable,
TmmTaskHandle {
    private final Set<TmmTaskListener> listeners = new CopyOnWriteArraySet<TmmTaskListener>();
    private TmmTaskHandle.TaskType type;
    protected TmmTaskHandle.TaskState state = TmmTaskHandle.TaskState.CREATED;
    protected String taskName;
    protected String taskDescription;
    protected int workUnits;
    protected int progressDone;
    protected boolean cancel;
    private long uniqueId;

    protected TmmTask(String taskName, int workUnits, TmmTaskHandle.TaskType type) {
        this.taskName = taskName;
        this.workUnits = workUnits;
        this.taskDescription = "";
        this.progressDone = 0;
        this.type = type;
        this.uniqueId = TmmTaskManager.getInstance().GLOB_THRD_CNT.incrementAndGet();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    @Override
    public final String getTaskName() {
        return this.taskName;
    }

    @Override
    public final int getWorkUnits() {
        return this.workUnits;
    }

    @Override
    public final int getProgressDone() {
        return this.progressDone;
    }

    @Override
    public final String getTaskDescription() {
        return this.taskDescription;
    }

    @Override
    public final TmmTaskHandle.TaskState getState() {
        return this.state;
    }

    protected void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    protected void setWorkUnits(int workUnits) {
        this.workUnits = workUnits;
    }

    protected void setProgressDone(int progressDone) {
        this.progressDone = progressDone;
    }

    protected void setTaskDescription(String taskDescription) {
        this.taskDescription = taskDescription;
    }

    public final void addListener(TmmTaskListener listener) {
        this.listeners.add(listener);
    }

    void setState(TmmTaskHandle.TaskState newState) {
        this.state = newState;
        this.informListeners();
    }

    public final void removeListener(TmmTaskListener listener) {
        this.listeners.remove(listener);
    }

    protected void informListeners() {
        for (TmmTaskListener listener : this.listeners) {
            listener.processTaskEvent(this);
        }
    }

    @Override
    public final void run() {
        if (this.cancel) {
            return;
        }
        Thread.currentThread().setName(Thread.currentThread().getName() + "-G" + this.uniqueId);
        this.start();
        try {
            this.doInBackground();
        }
        finally {
            this.finish();
        }
    }

    @Override
    public void cancel() {
        this.cancel = true;
        this.setState(TmmTaskHandle.TaskState.CANCELLED);
    }

    protected void start() {
        this.setState(TmmTaskHandle.TaskState.STARTED);
    }

    protected void publishState(String taskDescription, int progress) {
        this.taskDescription = taskDescription;
        this.progressDone = progress;
        this.informListeners();
    }

    protected void publishState(int progress) {
        this.progressDone = progress;
        this.informListeners();
    }

    protected void publishState() {
        this.informListeners();
    }

    protected void finish() {
        this.setState(TmmTaskHandle.TaskState.FINISHED);
    }

    @Override
    public final TmmTaskHandle.TaskType getType() {
        return this.type;
    }

    protected abstract void doInBackground();
}

