/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import java.text.Collator;
import java.text.Normalizer;
import java.text.RuleBasedCollator;
import java.util.Comparator;
import java.util.Locale;
import org.tinymediamanager.core.tvshow.entities.TvShow;

public class TvShowComparator
implements Comparator<TvShow> {
    private Collator stringCollator;

    public TvShowComparator() {
        RuleBasedCollator defaultCollator = (RuleBasedCollator)RuleBasedCollator.getInstance();
        try {
            this.stringCollator = new RuleBasedCollator(defaultCollator.getRules().replace("<'_'", "<' '<'_'"));
        }
        catch (Exception e) {
            this.stringCollator = defaultCollator;
        }
    }

    @Override
    public int compare(TvShow tvShow1, TvShow tvShow2) {
        if (this.stringCollator != null) {
            String titleTvShow1 = Normalizer.normalize(tvShow1.getTitleSortable().toLowerCase(Locale.ROOT), Normalizer.Form.NFD);
            String titleTvShow2 = Normalizer.normalize(tvShow2.getTitleSortable().toLowerCase(Locale.ROOT), Normalizer.Form.NFD);
            return this.stringCollator.compare(titleTvShow1, titleTvShow2);
        }
        return tvShow1.getTitleSortable().toLowerCase(Locale.ROOT).compareTo(tvShow2.getTitleSortable().toLowerCase(Locale.ROOT));
    }
}

