/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.entities;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import java.awt.Dimension;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.text.WordUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.IMediaInformation;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.entities.Rating;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.tvshow.TvShowArtworkHelper;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowMediaFileComparator;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.connector.TvShowGenericXmlConnector;
import org.tinymediamanager.core.tvshow.connector.TvShowToKodiConnector;
import org.tinymediamanager.core.tvshow.connector.TvShowToXbmcConnector;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;
import org.tinymediamanager.core.tvshow.filenaming.TvShowNfoNaming;
import org.tinymediamanager.core.tvshow.tasks.TvShowActorImageFetcherTask;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.MediaAiredStatus;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.entities.MediaRating;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.MapUtils;
import org.tinymediamanager.scraper.util.StrgUtils;

public class TvShow
extends MediaEntity
implements IMediaInformation {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShow.class);
    private static final Comparator<MediaFile> MEDIA_FILE_COMPARATOR = new TvShowMediaFileComparator();
    private static final Pattern SEASON_NUMBER = Pattern.compile("(?i)season([0-9]{1,4}).*");
    private static final Pattern SEASON_FOLDER_NUMBER = Pattern.compile("(?i).*([0-9]{1,4}).*");
    @JsonProperty
    private int runtime = 0;
    @JsonProperty
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd")
    private Date firstAired = null;
    @JsonProperty
    private MediaAiredStatus status = MediaAiredStatus.UNKNOWN;
    @JsonProperty
    private String sortTitle = "";
    @JsonProperty
    private Certification certification = Certification.UNKNOWN;
    @JsonProperty
    private String country = "";
    @JsonProperty
    private List<MediaGenres> genres = new CopyOnWriteArrayList<MediaGenres>();
    @JsonProperty
    private List<String> tags = new CopyOnWriteArrayList<String>();
    @JsonProperty
    private HashMap<Integer, String> seasonPosterUrlMap = new HashMap(0);
    @JsonProperty
    private HashMap<Integer, String> seasonBannerUrlMap = new HashMap(0);
    @JsonProperty
    private HashMap<Integer, String> seasonThumbUrlMap = new HashMap(0);
    @JsonProperty
    private List<Person> actors = new CopyOnWriteArrayList<Person>();
    @JsonProperty
    private List<TvShowEpisode> dummyEpisodes = new CopyOnWriteArrayList<TvShowEpisode>();
    @JsonProperty
    private List<String> extraFanartUrls = new CopyOnWriteArrayList<String>();
    private List<TvShowEpisode> episodes = new CopyOnWriteArrayList<TvShowEpisode>();
    private HashMap<Integer, MediaFile> seasonPosters = new HashMap(0);
    private HashMap<Integer, MediaFile> seasonBanners = new HashMap(0);
    private HashMap<Integer, MediaFile> seasonThumbs = new HashMap(0);
    private List<TvShowSeason> seasons = new CopyOnWriteArrayList<TvShowSeason>();
    private String titleSortable = "";
    private Date lastWatched = null;
    private PropertyChangeListener propertyChangeListener = evt -> {
        if (evt.getSource() instanceof TvShowEpisode) {
            TvShowEpisode episode = (TvShowEpisode)evt.getSource();
            switch (evt.getPropertyName()) {
                case "tag": {
                    this.firePropertyChange(evt);
                    break;
                }
                case "season": {
                    for (TvShowSeason season : this.seasons) {
                        if (!season.getEpisodes().contains(episode) || season.getSeason() == episode.getSeason()) continue;
                        season.removeEpisode(episode);
                    }
                    this.addToSeason(episode);
                }
            }
        }
    };

    @Override
    protected Comparator<MediaFile> getMediaFileComparator() {
        return MEDIA_FILE_COMPARATOR;
    }

    @Override
    public void initializeAfterLoading() {
        super.initializeAfterLoading();
        Utils.removeEmptyStringsFromList(this.tags);
        for (TvShowEpisode episode : this.dummyEpisodes) {
            episode.setTvShow(this);
            if (episode.getSeason() == 0 && !TvShowModuleManager.SETTINGS.isDisplayMissingSpecials() || !TvShowModuleManager.SETTINGS.isDisplayMissingEpisodes()) continue;
            this.addToSeason(episode);
        }
        for (MediaFile mf : this.getMediaFiles(MediaFileType.SEASON_POSTER, MediaFileType.SEASON_BANNER, MediaFileType.SEASON_THUMB)) {
            int season = -1;
            try {
                if (mf.getFilename().startsWith("season-specials")) {
                    season = 0;
                } else if (mf.getFilename().startsWith("season-all")) {
                    season = -1;
                } else {
                    Matcher matcher = SEASON_NUMBER.matcher(mf.getFilename());
                    if (matcher.matches()) {
                        season = Integer.parseInt(matcher.group(1));
                    }
                    if (season == -1 && (matcher = SEASON_NUMBER.matcher(mf.getFileAsPath().getParent().toString())).matches()) {
                        season = Integer.parseInt(matcher.group(1));
                    }
                    if (season == -1 && (matcher = SEASON_FOLDER_NUMBER.matcher(mf.getFileAsPath().getParent().toString())).matches()) {
                        season = Integer.parseInt(matcher.group(1));
                    }
                }
                if (season == -1) {
                    throw new IllegalStateException("did not find a season number");
                }
                switch (mf.getType()) {
                    case SEASON_BANNER: {
                        this.seasonBanners.put(season, mf);
                        break;
                    }
                    case SEASON_POSTER: {
                        this.seasonPosters.put(season, mf);
                        break;
                    }
                    case SEASON_THUMB: {
                        this.seasonThumbs.put(season, mf);
                        break;
                    }
                }
            }
            catch (Exception e) {
                LOGGER.warn("could not parse season number: {} MF: {}", (Object)e.getMessage(), (Object)mf.getFileAsPath().toAbsolutePath());
            }
        }
        for (TvShowEpisode episode : this.episodes) {
            episode.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    public void merge(TvShow other) {
        this.merge(other, false);
    }

    public void forceMerge(TvShow other) {
        this.merge(other, true);
    }

    void merge(TvShow other, boolean force) {
        if (other == null) {
            return;
        }
        super.merge(other, force);
        this.setSortTitle(StringUtils.isEmpty((CharSequence)this.sortTitle) || force ? other.sortTitle : this.sortTitle);
        this.setRuntime(this.runtime == 0 || force ? other.runtime : this.runtime);
        this.setFirstAired(this.firstAired == null || force ? other.firstAired : this.firstAired);
        this.setStatus(this.status == MediaAiredStatus.UNKNOWN || force ? other.status : this.status);
        this.setCertification(this.certification == Certification.NOT_RATED || force ? other.certification : this.certification);
        this.setCountry(StringUtils.isEmpty((CharSequence)this.country) || force ? other.country : this.country);
        if (force) {
            this.genres.clear();
            this.tags.clear();
            this.actors.clear();
            this.extraFanartUrls.clear();
            this.seasonPosterUrlMap.clear();
            this.seasonBannerUrlMap.clear();
            this.seasonThumbUrlMap.clear();
        }
        this.setGenres(other.genres);
        this.setTags(other.tags);
        this.setActors(other.actors);
        this.setExtraFanartUrls(other.extraFanartUrls);
        for (Integer season : other.seasonPosterUrlMap.keySet()) {
            if (this.seasonPosterUrlMap.containsKey(season)) continue;
            this.seasonPosterUrlMap.put(season, other.seasonPosterUrlMap.get(season));
        }
        for (Integer season : other.seasonBannerUrlMap.keySet()) {
            if (this.seasonBannerUrlMap.containsKey(season)) continue;
            this.seasonBannerUrlMap.put(season, other.seasonBannerUrlMap.get(season));
        }
        for (Integer season : other.seasonThumbUrlMap.keySet()) {
            if (this.seasonThumbUrlMap.containsKey(season)) continue;
            this.seasonThumbUrlMap.put(season, other.seasonThumbUrlMap.get(season));
        }
        for (TvShowEpisode ep : this.episodes) {
            TvShowEpisode otherEP = other.getEpisode(ep.getSeason(), ep.getEpisode());
            ep.merge(otherEP, force);
        }
        for (TvShowEpisode otherEp : other.getEpisodes()) {
            TvShowEpisode ourEP = this.getEpisode(otherEp.getSeason(), otherEp.getEpisode());
            if (ourEP != null) continue;
            TvShowEpisode clone = new TvShowEpisode(otherEp);
            clone.setTvShow(this);
            this.addEpisode(clone);
        }
    }

    @Override
    public void setTitle(String newValue) {
        String oldValue = this.title;
        super.setTitle(newValue);
        oldValue = this.titleSortable;
        this.titleSortable = "";
        this.firePropertyChange("titleSortable", oldValue, this.titleSortable);
    }

    public String getTitleSortable() {
        if (StringUtils.isEmpty((CharSequence)this.titleSortable)) {
            this.titleSortable = Utils.getSortableName(this.getTitle());
        }
        return this.titleSortable;
    }

    public void clearTitleSortable() {
        this.titleSortable = "";
    }

    public String getSortTitle() {
        return this.sortTitle;
    }

    public void setSortTitle(String newValue) {
        String oldValue = this.sortTitle;
        this.sortTitle = newValue;
        this.firePropertyChange("sortTitle", oldValue, newValue);
    }

    @Override
    public Rating getRating() {
        Rating rating = null;
        if (TvShowModuleManager.SETTINGS.getPreferPersonalRating()) {
            rating = (Rating)this.ratings.get("user");
        }
        if (rating == null) {
            rating = (Rating)this.ratings.get(TvShowModuleManager.SETTINGS.getPreferredRating());
        }
        if (rating == null) {
            rating = (Rating)this.ratings.get("NFO");
        }
        if (rating == null) {
            rating = (Rating)this.ratings.get("default");
        }
        if (rating == null && !this.ratings.isEmpty()) {
            rating = (Rating)this.ratings.values().iterator().next();
        }
        if (rating == null) {
            rating = new Rating();
        }
        return rating;
    }

    public List<TvShowEpisode> getEpisodes() {
        return this.episodes;
    }

    public void addEpisode(TvShowEpisode episode) {
        int oldValue = this.episodes.size();
        this.episodes.add(episode);
        episode.addPropertyChangeListener(this.propertyChangeListener);
        this.addToSeason(episode);
        this.episodes.sort(TvShowEpisode::compareTo);
        this.firePropertyChange("addedEpisode", null, episode);
        this.firePropertyChange("episodeCount", oldValue, this.episodes.size());
    }

    public List<TvShowEpisode> getDummyEpisodes() {
        return this.dummyEpisodes;
    }

    public void setDummyEpisodes(List<TvShowEpisode> dummyEpisodes) {
        this.dummyEpisodes.clear();
        this.dummyEpisodes.addAll(dummyEpisodes);
        if (TvShowModuleManager.SETTINGS.isDisplayMissingEpisodes()) {
            for (TvShowEpisode episode : dummyEpisodes) {
                episode.setTvShow(this);
                if (episode.getSeason() == 0 && !TvShowModuleManager.SETTINGS.isDisplayMissingSpecials()) continue;
                TvShowSeason season = this.getSeasonForEpisode(episode);
                boolean found = false;
                for (TvShowEpisode e : season.getEpisodesForDisplay()) {
                    if (e.getSeason() != episode.getSeason() || e.getEpisode() != episode.getEpisode()) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                season.addEpisode(episode);
                this.firePropertyChange("addedEpisode", null, episode);
            }
        }
        this.dummyEpisodes.sort(TvShowEpisode::compareTo);
        this.firePropertyChange("dummyEpisodes", null, dummyEpisodes);
        this.firePropertyChange("episodeCount", 0, this.episodes.size());
    }

    public List<TvShowEpisode> getEpisodesForDisplay() {
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>(this.getEpisodes());
        if (TvShowModuleManager.SETTINGS.isDisplayMissingEpisodes()) {
            HashSet<String> availableEpisodes = new HashSet<String>();
            for (TvShowEpisode episode : episodes) {
                availableEpisodes.add(episode.getSeason() + "." + episode.getEpisode());
            }
            for (TvShowEpisode episode : this.getDummyEpisodes()) {
                if (episode.getSeason() == 0 && !TvShowModuleManager.SETTINGS.isDisplayMissingSpecials() || availableEpisodes.contains(episode.getSeason() + "." + episode.getEpisode())) continue;
                episodes.add(episode);
            }
        }
        return episodes;
    }

    public int getEpisodeCount() {
        return this.episodes.size();
    }

    public int getDummyEpisodeCount() {
        int count = 0;
        for (TvShowSeason season : this.seasons) {
            for (TvShowEpisode episode : season.getEpisodesForDisplay()) {
                if (!episode.isDummy() || episode.getSeason() == 0 && !TvShowModuleManager.SETTINGS.isDisplayMissingSpecials()) continue;
                ++count;
            }
        }
        return count;
    }

    private void addToSeason(TvShowEpisode episode) {
        TvShowSeason season = this.getSeasonForEpisode(episode);
        season.addEpisode(episode);
    }

    private void removeFromSeason(TvShowEpisode episode) {
        TvShowSeason season = this.getSeasonForEpisode(episode);
        season.removeEpisode(episode);
    }

    public synchronized TvShowSeason getSeasonForEpisode(TvShowEpisode episode) {
        TvShowSeason season = null;
        for (TvShowSeason s : this.seasons) {
            if (s.getSeason() != episode.getSeason()) continue;
            season = s;
            break;
        }
        if (season == null) {
            int oldValue = this.seasons.size();
            season = new TvShowSeason(episode.getSeason(), this);
            this.seasons.add(season);
            this.firePropertyChange("addedSeason", null, season);
            this.firePropertyChange("seasonCount", oldValue, this.seasons.size());
        }
        return season;
    }

    public int getSeasonCount() {
        int count = 0;
        for (TvShowSeason season : this.seasons) {
            if (season.isDummy()) continue;
            ++count;
        }
        return count;
    }

    public TvShowSeason getSeason(int seasonNumber) {
        for (TvShowSeason season : this.seasons) {
            if (season.getSeason() != seasonNumber) continue;
            return season;
        }
        return null;
    }

    public void removeAllEpisodes() {
        int oldValue = this.episodes.size();
        if (this.episodes.size() > 0) {
            for (int i = this.episodes.size() - 1; i >= 0; --i) {
                TvShowEpisode episode = this.episodes.get(i);
                this.episodes.remove(episode);
                episode.removePropertyChangeListener(this.propertyChangeListener);
                TvShowList.getInstance().removeEpisodeFromDb(episode);
            }
        }
        this.firePropertyChange("episodeCount", oldValue, this.episodes.size());
    }

    public void removeEpisode(TvShowEpisode episode) {
        if (this.episodes.contains(episode)) {
            int oldValue = this.episodes.size();
            this.episodes.remove(episode);
            episode.removePropertyChangeListener(this.propertyChangeListener);
            this.removeFromSeason(episode);
            TvShowList.getInstance().removeEpisodeFromDb(episode);
            this.saveToDb();
            this.firePropertyChange("removedEpisode", null, episode);
            this.firePropertyChange("episodeCount", oldValue, this.episodes.size());
            if (TvShowModuleManager.SETTINGS.isDisplayMissingEpisodes()) {
                for (TvShowEpisode dummy : this.dummyEpisodes) {
                    if (dummy.getSeason() == 0 && !TvShowModuleManager.SETTINGS.isDisplayMissingSpecials() || dummy.getSeason() != episode.getSeason() || dummy.getEpisode() != episode.getEpisode()) continue;
                    this.addToSeason(dummy);
                    this.firePropertyChange("addedEpisode", null, dummy);
                    break;
                }
            }
        } else if (this.dummyEpisodes.contains(episode)) {
            this.removeFromSeason(episode);
            this.firePropertyChange("removedEpisode", null, episode);
            this.firePropertyChange("episodeCount", 0, this.episodes.size());
        }
    }

    public void deleteEpisode(TvShowEpisode episode) {
        if (this.episodes.contains(episode)) {
            int oldValue = this.episodes.size();
            episode.deleteFilesSafely();
            this.episodes.remove(episode);
            episode.removePropertyChangeListener(this.propertyChangeListener);
            this.removeFromSeason(episode);
            TvShowList.getInstance().removeEpisodeFromDb(episode);
            this.saveToDb();
            this.firePropertyChange("removedEpisode", null, episode);
            this.firePropertyChange("episodeCount", oldValue, this.episodes.size());
        }
    }

    public List<TvShowSeason> getSeasons() {
        return this.seasons;
    }

    public List<MediaGenres> getGenres() {
        return this.genres;
    }

    public void addGenre(MediaGenres newValue) {
        if (!this.genres.contains(newValue)) {
            this.genres.add(newValue);
            this.firePropertyChange("genre", null, newValue);
            this.firePropertyChange("genresAsString", null, newValue);
        }
    }

    @JsonSetter
    public void setGenres(List<MediaGenres> newGenres) {
        ListUtils.mergeLists(this.genres, newGenres);
        this.firePropertyChange("genre", null, this.genres);
        this.firePropertyChange("genresAsString", null, this.genres);
    }

    public void removeGenre(MediaGenres genre) {
        if (this.genres.contains(genre)) {
            this.genres.remove(genre);
            this.firePropertyChange("genre", null, genre);
            this.firePropertyChange("genresAsString", null, genre);
        }
    }

    public String getGenresAsString() {
        StringBuilder sb = new StringBuilder();
        for (MediaGenres genre : this.genres) {
            if (!StringUtils.isEmpty((CharSequence)sb)) {
                sb.append(", ");
            }
            sb.append(genre != null ? genre.getLocalizedName() : "null");
        }
        return sb.toString();
    }

    public void setMetadata(MediaMetadata metadata, TvShowScraperMetadataConfig config) {
        if (metadata == null) {
            LOGGER.error("metadata was null");
            return;
        }
        if (StringUtils.isEmpty((CharSequence)metadata.getTitle())) {
            LOGGER.warn("wanted to save empty metadata for " + this.getTitle());
            return;
        }
        for (Map.Entry entry : metadata.getIds().entrySet()) {
            this.setId((String)entry.getKey(), entry.getValue().toString());
        }
        if (config.isTitle()) {
            if (TvShowModuleManager.SETTINGS.getCapitalWordsInTitles()) {
                this.setTitle(WordUtils.capitalize((String)metadata.getTitle()));
                this.setOriginalTitle(WordUtils.capitalize((String)metadata.getOriginalTitle()));
            } else {
                this.setTitle(metadata.getTitle());
                this.setOriginalTitle(metadata.getOriginalTitle());
            }
        }
        if (config.isPlot()) {
            this.setPlot(metadata.getPlot());
        }
        if (config.isYear()) {
            this.setYear(metadata.getYear());
        }
        if (config.isRating()) {
            this.clearRatings();
            for (MediaRating mediaRating : metadata.getRatings()) {
                this.setRating(new Rating(mediaRating));
            }
        }
        if (config.isAired()) {
            this.setFirstAired(metadata.getReleaseDate());
        }
        if (config.isStatus()) {
            this.setStatus(metadata.getStatus());
        }
        if (config.isRuntime()) {
            this.setRuntime(metadata.getRuntime());
        }
        if (config.isCountry()) {
            this.setCountry(StringUtils.join((Iterable)metadata.getCountries(), (String)", "));
        }
        if (config.isStudio()) {
            this.setProductionCompany(StringUtils.join((Iterable)metadata.getProductionCompanies(), (String)", "));
        }
        if (config.isCast()) {
            ArrayList<Person> actors = new ArrayList<Person>();
            for (MediaCastMember member : metadata.getCastMembers()) {
                switch (member.getType()) {
                    case ACTOR: {
                        actors.add(new Person(member));
                        break;
                    }
                }
            }
            this.setActors(actors);
            this.writeActorImages();
        }
        if (config.isCertification() && metadata.getCertifications().size() > 0) {
            this.setCertification((Certification)metadata.getCertifications().get(0));
        }
        if (config.isGenres()) {
            this.setGenres(metadata.getGenres());
        }
        this.setScraped(true);
        this.writeNFO();
        this.saveToDb();
        if (TvShowModuleManager.SETTINGS.isRenameAfterScrape()) {
            TvShowRenamer.renameTvShowRoot(this);
        }
    }

    public void setArtwork(List<MediaArtwork> artwork, TvShowScraperMetadataConfig config) {
        if (config.isArtwork()) {
            TvShowArtworkHelper.setArtwork(this, artwork);
        }
    }

    public void downloadArtwork(MediaFileType type) {
        TvShowArtworkHelper.downloadArtwork(this, type);
    }

    public void downloadSeasonArtwork(int season, MediaArtwork.MediaArtworkType artworkType) {
        TvShowArtworkHelper.downloadSeasonArtwork(this, season, artworkType);
    }

    public void writeNFO() {
        TvShowGenericXmlConnector connector;
        List<TvShowNfoNaming> nfoNamings = TvShowModuleManager.SETTINGS.getNfoFilenames();
        if (nfoNamings.isEmpty()) {
            return;
        }
        switch (TvShowModuleManager.SETTINGS.getTvShowConnector()) {
            case KODI: {
                connector = new TvShowToKodiConnector(this);
                break;
            }
            default: {
                connector = new TvShowToXbmcConnector(this);
            }
        }
        connector.write(nfoNamings);
        this.firePropertyChange("hasNfoFile", false, true);
    }

    public Boolean getHasNfoFile() {
        List<MediaFile> nfos = this.getMediaFiles(MediaFileType.NFO);
        return nfos != null && nfos.size() > 0;
    }

    public Boolean getHasImages() {
        for (MediaArtwork.MediaArtworkType type : TvShowModuleManager.SETTINGS.getTvShowCheckImages()) {
            if (!StringUtils.isBlank((CharSequence)this.getArtworkFilename(MediaFileType.getMediaFileType(type)))) continue;
            return false;
        }
        return true;
    }

    public Boolean getHasSeasonAndEpisodeImages() {
        for (TvShowSeason season : this.seasons) {
            if (season.getHasImages().booleanValue() && season.getHasEpisodeImages().booleanValue()) continue;
            return false;
        }
        return true;
    }

    public Boolean getHasEpisodeNfoFiles() {
        boolean nfo = true;
        for (TvShowEpisode episode : this.episodes) {
            if (episode.getHasNfoFile().booleanValue()) continue;
            nfo = false;
            break;
        }
        return nfo;
    }

    public String getImdbId() {
        return this.getIdAsString("imdb");
    }

    public void setImdbId(String newValue) {
        this.setId("imdb", newValue);
    }

    public String getTvdbId() {
        return this.getIdAsString("tvdb");
    }

    public void setTvdbId(String newValue) {
        this.setId("tvdb", newValue);
    }

    public int getTraktId() {
        return this.getIdAsInt("trakt");
    }

    public void setTraktId(int newValue) {
        this.setId("trakt", newValue);
    }

    public Date getFirstAired() {
        return this.firstAired;
    }

    @JsonIgnore
    public void setFirstAired(Date newValue) {
        Date oldValue = this.firstAired;
        this.firstAired = newValue;
        this.firePropertyChange("firstAired", oldValue, newValue);
        this.firePropertyChange("firstAiredAsString", oldValue, newValue);
    }

    public String getFirstAiredFormatted() {
        if (this.firstAired == null) {
            return "";
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(this.firstAired);
    }

    public String getFirstAiredAsString() {
        if (this.firstAired == null) {
            return "";
        }
        return TmmDateFormat.SHORT_DATE_FORMAT.format(this.firstAired);
    }

    public void setFirstAired(String aired) {
        try {
            this.setFirstAired(StrgUtils.parseDate((String)aired));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public MediaAiredStatus getStatus() {
        return this.status;
    }

    public void setStatus(MediaAiredStatus newValue) {
        MediaAiredStatus oldValue = this.status;
        this.status = newValue;
        this.firePropertyChange("status", oldValue, newValue);
    }

    public void addToTags(String newTag) {
        if (StringUtils.isBlank((CharSequence)newTag)) {
            return;
        }
        for (String tag : this.tags) {
            if (!tag.equals(newTag)) continue;
            return;
        }
        this.tags.add(newTag);
        this.firePropertyChange("tag", null, newTag);
        this.firePropertyChange("tagsAsString", null, newTag);
    }

    public void removeFromTags(String removeTag) {
        this.tags.remove(removeTag);
        this.firePropertyChange("tag", null, removeTag);
        this.firePropertyChange("tagsAsString", null, removeTag);
    }

    @JsonSetter
    public void setTags(List<String> newTags) {
        ListUtils.mergeLists(this.tags, newTags);
        this.firePropertyChange("tag", null, newTags);
        this.firePropertyChange("tagsAsString", null, newTags);
    }

    public String getTagsAsString() {
        StringBuilder sb = new StringBuilder();
        for (String tag : this.tags) {
            if (!StringUtils.isEmpty((CharSequence)sb)) {
                sb.append(", ");
            }
            sb.append(tag);
        }
        return sb.toString();
    }

    public List<String> getTags() {
        return this.tags;
    }

    public int getRuntime() {
        return this.runtime;
    }

    public void setRuntime(int newValue) {
        int oldValue = this.runtime;
        this.runtime = newValue;
        this.firePropertyChange("runtime", oldValue, newValue);
    }

    public void addActor(Person obj) {
        this.actors.add(obj);
        this.firePropertyChange("actors", null, this.getActors());
    }

    public List<Person> getActors() {
        return this.actors;
    }

    public void removeActor(Person obj) {
        this.actors.remove(obj);
        this.firePropertyChange("actors", null, this.getActors());
    }

    @JsonSetter
    public void setActors(List<Person> newActors) {
        ListUtils.mergeLists(this.actors, newActors);
        this.firePropertyChange("actors", null, this.getActors());
    }

    @Override
    public Certification getCertification() {
        return this.certification;
    }

    public void setCertification(Certification newValue) {
        this.certification = newValue;
        this.firePropertyChange("certification", null, newValue);
    }

    public String getCountry() {
        return this.country;
    }

    public void setCountry(String newValue) {
        String oldValue = this.country;
        this.country = newValue;
        this.firePropertyChange("country", oldValue, newValue);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public List<TvShowEpisode> getEpisodesToScrape() {
        ArrayList<TvShowEpisode> episodes = new ArrayList<TvShowEpisode>();
        for (TvShowEpisode episode : this.episodes) {
            if (episode.getFirstAired() == null && (episode.getSeason() <= -1 || episode.getEpisode() <= -1)) continue;
            episodes.add(episode);
        }
        return episodes;
    }

    public boolean isWatched() {
        boolean watched = true;
        for (TvShowEpisode episode : this.episodes) {
            if (episode.isWatched()) continue;
            watched = false;
            break;
        }
        return watched;
    }

    public boolean hasEpisodeSubtitles() {
        boolean subtitles = true;
        for (TvShowEpisode episode : this.episodes) {
            if (episode.hasSubtitles()) continue;
            subtitles = false;
            break;
        }
        return subtitles;
    }

    public Date getLastWatched() {
        return this.lastWatched;
    }

    public void setLastWatched(Date lastWatched) {
        this.lastWatched = lastWatched;
    }

    public void setSeasonArtworkUrl(int season, String url, MediaArtwork.MediaArtworkType artworkType) {
        switch (artworkType) {
            case SEASON_POSTER: {
                this.seasonPosterUrlMap.put(season, url);
                break;
            }
            case SEASON_BANNER: {
                this.seasonBannerUrlMap.put(season, url);
                break;
            }
            case SEASON_THUMB: {
                this.seasonThumbUrlMap.put(season, url);
                break;
            }
            default: {
                return;
            }
        }
    }

    public String getSeasonArtworkUrl(int season, MediaArtwork.MediaArtworkType artworkType) {
        String url = null;
        switch (artworkType) {
            case SEASON_POSTER: {
                url = this.seasonPosterUrlMap.get(season);
                break;
            }
            case SEASON_BANNER: {
                url = this.seasonBannerUrlMap.get(season);
                break;
            }
            case SEASON_THUMB: {
                url = this.seasonThumbUrlMap.get(season);
                break;
            }
        }
        if (StringUtils.isBlank(url)) {
            return "";
        }
        return url;
    }

    public Map<Integer, String> getSeasonArtworkUrls(MediaArtwork.MediaArtworkType artworkType) {
        switch (artworkType) {
            case SEASON_POSTER: {
                return MapUtils.sortByKey(this.seasonPosterUrlMap);
            }
            case SEASON_BANNER: {
                return MapUtils.sortByKey(this.seasonBannerUrlMap);
            }
            case SEASON_THUMB: {
                return MapUtils.sortByKey(this.seasonThumbUrlMap);
            }
        }
        return new HashMap<Integer, String>(0);
    }

    public String getSeasonArtwork(int season, MediaArtwork.MediaArtworkType artworkType) {
        MediaFile artworkFile = null;
        switch (artworkType) {
            case SEASON_POSTER: {
                artworkFile = this.seasonPosters.get(season);
                break;
            }
            case SEASON_BANNER: {
                artworkFile = this.seasonBanners.get(season);
                break;
            }
            case SEASON_THUMB: {
                artworkFile = this.seasonThumbs.get(season);
                break;
            }
        }
        if (artworkFile != null) {
            return artworkFile.getFile().toString();
        }
        return "";
    }

    public Map<Integer, MediaFile> getSeasonArtworks(MediaArtwork.MediaArtworkType artworkType) {
        switch (artworkType) {
            case SEASON_POSTER: {
                return MapUtils.sortByKey(this.seasonPosters);
            }
            case SEASON_BANNER: {
                return MapUtils.sortByKey(this.seasonBanners);
            }
            case SEASON_THUMB: {
                return MapUtils.sortByKey(this.seasonThumbs);
            }
        }
        return new HashMap<Integer, MediaFile>(0);
    }

    Dimension getSeasonArtworkSize(int season, MediaArtwork.MediaArtworkType type) {
        MediaFile artworkFile = null;
        switch (type) {
            case SEASON_POSTER: {
                artworkFile = this.seasonPosters.get(season);
                break;
            }
            case SEASON_BANNER: {
                artworkFile = this.seasonBanners.get(season);
                break;
            }
            case SEASON_THUMB: {
                artworkFile = this.seasonThumbs.get(season);
                break;
            }
        }
        if (artworkFile != null) {
            return new Dimension(artworkFile.getVideoWidth(), artworkFile.getVideoHeight());
        }
        return new Dimension(0, 0);
    }

    public void setSeasonArtwork(int season, MediaArtwork.MediaArtworkType artworkType, Path file) {
        MediaFile mf = new MediaFile(file, MediaFileType.getMediaFileType(artworkType));
        this.setSeasonArtwork(season, mf);
    }

    public void setSeasonArtwork(int season, MediaFile mf) {
        MediaFile oldMf = null;
        MediaArtwork.MediaArtworkType artworkType = MediaFileType.getMediaArtworkType(mf.getType());
        switch (artworkType) {
            case SEASON_POSTER: {
                oldMf = this.seasonPosters.get(season);
                break;
            }
            case SEASON_BANNER: {
                oldMf = this.seasonBanners.get(season);
                break;
            }
            case SEASON_THUMB: {
                oldMf = this.seasonThumbs.get(season);
                break;
            }
            default: {
                return;
            }
        }
        if (oldMf != null && oldMf.equals(mf)) {
            return;
        }
        mf.gatherMediaInformation();
        this.addToMediaFiles(mf);
        switch (artworkType) {
            case SEASON_POSTER: {
                this.seasonPosters.put(season, mf);
                break;
            }
            case SEASON_BANNER: {
                this.seasonBanners.put(season, mf);
                break;
            }
            case SEASON_THUMB: {
                this.seasonThumbs.put(season, mf);
                break;
            }
        }
    }

    void clearSeasonArtwork(int season, MediaArtwork.MediaArtworkType artworkType) {
        MediaFile mf = null;
        switch (artworkType) {
            case SEASON_POSTER: {
                mf = this.seasonPosters.get(season);
                this.seasonPosters.remove(season);
                break;
            }
            case SEASON_BANNER: {
                mf = this.seasonBanners.get(season);
                this.seasonBanners.remove(season);
                break;
            }
            case SEASON_THUMB: {
                mf = this.seasonThumbs.get(season);
                this.seasonThumbs.remove(season);
                break;
            }
            default: {
                return;
            }
        }
        if (mf != null) {
            this.removeFromMediaFiles(mf);
        }
    }

    void clearSeasonArtworkUrl(int season, MediaArtwork.MediaArtworkType artworkType) {
        switch (artworkType) {
            case SEASON_POSTER: {
                this.seasonPosterUrlMap.remove(season);
                break;
            }
            case SEASON_BANNER: {
                this.seasonBannerUrlMap.remove(season);
                break;
            }
            case SEASON_THUMB: {
                this.seasonThumbUrlMap.remove(season);
                break;
            }
            default: {
                return;
            }
        }
    }

    public List<String> getExtraFanartUrls() {
        return this.extraFanartUrls;
    }

    @JsonSetter
    public void setExtraFanartUrls(List<String> extraFanartUrls) {
        ListUtils.mergeLists(this.extraFanartUrls, extraFanartUrls);
    }

    public List<MediaFile> getEpisodesMediaFiles() {
        ArrayList<MediaFile> mediaFiles = new ArrayList<MediaFile>();
        for (TvShowEpisode episode : this.episodes) {
            for (MediaFile mf : episode.getMediaFiles()) {
                if (mediaFiles.contains(mf)) continue;
                mediaFiles.add(mf);
            }
        }
        return mediaFiles;
    }

    public List<MediaFile> getImagesToCache() {
        ArrayList<MediaFile> filesToCache = new ArrayList<MediaFile>();
        for (MediaFile mf : this.getMediaFiles()) {
            if (!mf.isGraphic()) continue;
            filesToCache.add(mf);
        }
        filesToCache.addAll(this.listActorFiles());
        for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(this.episodes)) {
            filesToCache.addAll(episode.getImagesToCache());
        }
        return filesToCache;
    }

    @Override
    public synchronized void callbackForWrittenArtwork(MediaArtwork.MediaArtworkType type) {
    }

    @Override
    public void saveToDb() {
        TvShowList.getInstance().persistTvShow(this);
    }

    @Override
    public void deleteFromDb() {
        TvShowList.getInstance().removeTvShow(this);
    }

    public TvShowEpisode getEpisode(int season, int episode) {
        TvShowEpisode ep = null;
        for (TvShowEpisode e : new ArrayList<TvShowEpisode>(this.episodes)) {
            if (e.getSeason() != season || e.getEpisode() != episode) continue;
            ep = e;
            break;
        }
        return ep;
    }

    public boolean hasNewlyAddedEpisodes() {
        for (TvShowEpisode episode : new ArrayList<TvShowEpisode>(this.episodes)) {
            if (!episode.isNewlyAdded()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isScraped() {
        if (!this.scraped && !this.plot.isEmpty() && this.year != 0 && this.genres != null && this.genres.size() != 0 && this.actors != null && this.actors.size() != 0) {
            return true;
        }
        return this.scraped;
    }

    public void writeActorImages() {
        if (!TvShowModuleManager.SETTINGS.isWriteActorImages()) {
            return;
        }
        TvShowActorImageFetcherTask task = new TvShowActorImageFetcherTask(this);
        TmmTaskManager.getInstance().addImageDownloadTask(task);
    }

    private List<MediaFile> listActorFiles() {
        ArrayList<MediaFile> fileNames = new ArrayList<MediaFile>();
        try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.getPathNIO().resolve(".actors"));){
            for (Path path : directoryStream) {
                MediaFile mf;
                if (!Utils.isRegularFile(path) || !(mf = new MediaFile(path)).isGraphic()) continue;
                fileNames.add(mf);
            }
        }
        catch (IOException e) {
            LOGGER.warn("Cannot get actors: {}", (Object)this.getPathNIO().resolve(".actors"));
        }
        return fileNames;
    }

    public boolean deleteFilesSafely() {
        return Utils.deleteDirectorySafely(this.getPathNIO(), this.getDataSource());
    }

    @Override
    public MediaFile getMainVideoFile() {
        return new MediaFile();
    }

    @Override
    public String getMediaInfoVideoFormat() {
        return "";
    }

    @Override
    public String getMediaInfoVideoResolution() {
        return "";
    }

    @Override
    public float getMediaInfoAspectRatio() {
        return 0.0f;
    }

    @Override
    public String getMediaInfoVideoCodec() {
        return "";
    }

    @Override
    public double getMediaInfoFrameRate() {
        return 0.0;
    }

    @Override
    public String getVideoHDRFormat() {
        return "";
    }

    @Override
    public boolean isVideoIn3D() {
        return false;
    }

    @Override
    public String getMediaInfoAudioCodec() {
        return "";
    }

    @Override
    public List<String> getMediaInfoAudioCodecList() {
        return new ArrayList<String>();
    }

    @Override
    public String getMediaInfoAudioChannels() {
        return "";
    }

    @Override
    public List<String> getMediaInfoAudioChannelList() {
        return new ArrayList<String>();
    }

    @Override
    public String getMediaInfoAudioLanguage() {
        return "";
    }

    @Override
    public List<String> getMediaInfoAudioLanguageList() {
        return new ArrayList<String>();
    }

    @Override
    public String getMediaInfoContainerFormat() {
        return "";
    }

    @Override
    public int getMediaInfoVideoBitDepth() {
        return 0;
    }

    @Override
    public MediaSource getMediaInfoSource() {
        return MediaSource.UNKNOWN;
    }
}

