/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.filenaming;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.tvshow.ITvShowSeasonFileNaming;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;

public enum TvShowSeasonBannerNaming implements ITvShowSeasonFileNaming
{
    SEASON_BANNER{

        @Override
        public String getFilename(TvShow tvShow, int season, String extension) {
            if (season == 0 && TvShowModuleManager.SETTINGS.isSpecialSeason()) {
                return "season-specials-banner." + extension;
            }
            if (season > -1) {
                return String.format("season%02d-banner.%s", season, extension);
            }
            return "";
        }
    }
    ,
    SEASON_FOLDER{

        @Override
        public String getFilename(TvShow tvShow, int season, String extension) {
            TvShowEpisode episode = new TvShowEpisode();
            episode.setSeason(season);
            String seasonFoldername = TvShowRenamer.getSeasonFoldername(tvShow, episode);
            if (StringUtils.isBlank((CharSequence)seasonFoldername)) {
                return SEASON_BANNER.getFilename(tvShow, season, extension);
            }
            String filename = seasonFoldername + File.separator;
            if (season == 0 && TvShowModuleManager.SETTINGS.isSpecialSeason()) {
                filename = filename + "season-specials-banner";
            } else if (season > -1) {
                filename = filename + String.format("season%02d-banner", season);
            } else {
                return "";
            }
            return filename + "." + extension;
        }
    };

}

