/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.tasks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.core.threading.TmmThreadPool;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.TvShowScraperMetadataConfig;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.core.tvshow.tasks.TvShowEpisodeScrapeTask;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.exceptions.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.mediaprovider.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.mediaprovider.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.trakttv.SyncTraktTvTask;
import org.tinymediamanager.ui.UTF8Control;

public class TvShowScrapeTask
extends TmmThreadPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowScrapeTask.class);
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private List<TvShow> tvShowsToScrape;
    private boolean doSearch;
    private TvShowSearchAndScrapeOptions options;

    public TvShowScrapeTask(List<TvShow> tvShowsToScrape, boolean doSearch, TvShowSearchAndScrapeOptions options) {
        super(BUNDLE.getString("tvshow.scraping"));
        this.tvShowsToScrape = tvShowsToScrape;
        this.doSearch = doSearch;
        this.options = options;
    }

    @Override
    protected void doInBackground() {
        LOGGER.debug("start scraping tv shows...");
        this.start();
        this.initThreadPool(3, "scrape");
        for (TvShow tvShow : this.tvShowsToScrape) {
            this.submitTask(new Worker(tvShow));
        }
        this.waitForCompletionOrCancel();
        if (TvShowModuleManager.SETTINGS.getSyncTrakt()) {
            SyncTraktTvTask task = new SyncTraktTvTask(null, this.tvShowsToScrape);
            TmmTaskManager.getInstance().addUnnamedTask(task);
        }
        LOGGER.debug("done scraping tv shows...");
    }

    @Override
    public void callback(Object obj) {
        this.publishState(this.progressDone);
    }

    private class Worker
    implements Runnable {
        private TvShowList tvShowList = TvShowList.getInstance();
        private TvShow tvShow;

        public Worker(TvShow tvShow) {
            this.tvShow = tvShow;
        }

        @Override
        public void run() {
            block29: {
                try {
                    TvShowScraperMetadataConfig scraperMetadataConfig = TvShowScrapeTask.this.options.getScraperMetadataConfig();
                    MediaScraper mediaMetadataScraper = TvShowScrapeTask.this.options.getMetadataScraper();
                    List<MediaScraper> artworkScrapers = TvShowScrapeTask.this.options.getArtworkScrapers();
                    MediaSearchResult result1 = null;
                    if (TvShowScrapeTask.this.doSearch) {
                        List<MediaSearchResult> results = this.tvShowList.searchTvShow(this.tvShow.getTitle(), this.tvShow, mediaMetadataScraper);
                        if (results != null && !results.isEmpty()) {
                            result1 = results.get(0);
                            if (results.size() > 1) {
                                MediaSearchResult result2 = results.get(1);
                                if (result1.getScore() == 1.0f && result2.getScore() == 1.0f) {
                                    LOGGER.info("two 100% results, can't decide which to take - ignore result");
                                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.tvShow, "tvshow.scrape.nomatchfound"));
                                    return;
                                }
                                if ((double)result1.getScore() < 0.75) {
                                    LOGGER.info("score is lower than 0.75 (" + result1.getScore() + ") - ignore result");
                                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.tvShow, "tvshow.scrape.nomatchfound"));
                                    return;
                                }
                            }
                        } else {
                            LOGGER.info("no result found for " + this.tvShow.getTitle());
                            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.tvShow, "tvshow.scrape.nomatchfound"));
                        }
                    }
                    if ((!TvShowScrapeTask.this.doSearch || result1 == null) && TvShowScrapeTask.this.doSearch) break block29;
                    try {
                        List<TvShowEpisode> list;
                        MediaScrapeOptions options = new MediaScrapeOptions(MediaType.TV_SHOW);
                        options.setResult(result1);
                        options.setLanguage(TvShowModuleManager.SETTINGS.getScraperLanguage().toLocale());
                        options.setCountry(TvShowModuleManager.SETTINGS.getCertificationCountry());
                        if (!TvShowScrapeTask.this.doSearch) {
                            for (Map.Entry entry : this.tvShow.getIds().entrySet()) {
                                options.setId((String)entry.getKey(), entry.getValue().toString());
                            }
                        }
                        mediaMetadataScraper = this.tvShowList.getMediaScraperById(result1.getProviderId());
                        MediaMetadata md = null;
                        if (scraperMetadataConfig.isCast() || scraperMetadataConfig.isCertification() || scraperMetadataConfig.isGenres() || scraperMetadataConfig.isAired() || scraperMetadataConfig.isPlot() || scraperMetadataConfig.isRating() || scraperMetadataConfig.isRuntime() || scraperMetadataConfig.isStatus() || scraperMetadataConfig.isTitle() || scraperMetadataConfig.isYear()) {
                            LOGGER.info("=====================================================");
                            LOGGER.info("Scraper metadata with scraper: " + mediaMetadataScraper.getMediaProvider().getProviderInfo().getId() + ", " + mediaMetadataScraper.getMediaProvider().getProviderInfo().getVersion());
                            LOGGER.info(options.toString());
                            LOGGER.info("=====================================================");
                            md = ((ITvShowMetadataProvider)mediaMetadataScraper.getMediaProvider()).getMetadata(options);
                            this.tvShow.setMetadata(md, scraperMetadataConfig);
                        }
                        if (scraperMetadataConfig.isEpisodeList()) {
                            ArrayList<TvShowEpisode> arrayList = new ArrayList<TvShowEpisode>();
                            try {
                                for (MediaMetadata me : ((ITvShowMetadataProvider)mediaMetadataScraper.getMediaProvider()).getEpisodeList(options)) {
                                    TvShowEpisode ep = new TvShowEpisode();
                                    ep.setEpisode(me.getEpisodeNumber());
                                    ep.setSeason(me.getSeasonNumber());
                                    ep.setDvdEpisode(me.getDvdEpisodeNumber());
                                    ep.setDvdSeason(me.getDvdSeasonNumber());
                                    ep.setTitle(me.getTitle());
                                    ep.setOriginalTitle(me.getOriginalTitle());
                                    ep.setPlot(me.getPlot());
                                    ArrayList<Person> actors = new ArrayList<Person>();
                                    ArrayList<Person> directors = new ArrayList<Person>();
                                    ArrayList<Person> writers = new ArrayList<Person>();
                                    for (MediaCastMember member : me.getCastMembers()) {
                                        switch (member.getType()) {
                                            case ACTOR: {
                                                actors.add(new Person(member));
                                                break;
                                            }
                                            case DIRECTOR: {
                                                directors.add(new Person(member));
                                                break;
                                            }
                                            case WRITER: {
                                                writers.add(new Person(member));
                                                break;
                                            }
                                        }
                                    }
                                    ep.setActors(actors);
                                    ep.setDirectors(directors);
                                    ep.setWriters(writers);
                                    arrayList.add(ep);
                                }
                            }
                            catch (ScrapeException e) {
                                LOGGER.error("searchMovieFallback", (Throwable)e);
                                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.tvShow, "message.scrape.episodelistfailed", new String[]{":", e.getLocalizedMessage()}));
                            }
                            catch (MissingIdException e) {
                                LOGGER.warn("missing id for scrape");
                                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.tvShow, "scraper.error.missingid"));
                            }
                            catch (UnsupportedMediaTypeException e) {
                                // empty catch block
                            }
                            this.tvShow.setDummyEpisodes(arrayList);
                            this.tvShow.saveToDb();
                        }
                        if (scraperMetadataConfig.isEpisodes() && !(list = this.tvShow.getEpisodesToScrape()).isEmpty()) {
                            TvShowEpisodeScrapeTask task = new TvShowEpisodeScrapeTask(list, mediaMetadataScraper, scraperMetadataConfig);
                            TmmTaskManager.getInstance().addUnnamedTask(task);
                        }
                        if (scraperMetadataConfig.isArtwork()) {
                            this.tvShow.setArtwork(this.getArtwork(this.tvShow, md, artworkScrapers), scraperMetadataConfig);
                        }
                    }
                    catch (ScrapeException e) {
                        LOGGER.error("getTvShowMetadata", (Throwable)e);
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.tvShow, "message.scrape.metadatatvshowfailed", new String[]{":", e.getLocalizedMessage()}));
                    }
                    catch (MissingIdException e) {
                        LOGGER.warn("missing id for scrape");
                        MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, this.tvShow, "scraper.error.missingid"));
                    }
                    catch (NothingFoundException | UnsupportedMediaTypeException throwable) {}
                }
                catch (Exception e) {
                    LOGGER.error("Thread crashed", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"TvShowScraper", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
                }
            }
        }

        public List<MediaArtwork> getArtwork(TvShow tvShow, MediaMetadata metadata, List<MediaScraper> artworkScrapers) {
            ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
            MediaScrapeOptions options = new MediaScrapeOptions(MediaType.TV_SHOW);
            options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
            options.setMetadata(metadata);
            options.setLanguage(TvShowModuleManager.SETTINGS.getScraperLanguage().toLocale());
            options.setCountry(TvShowModuleManager.SETTINGS.getCertificationCountry());
            for (Map.Entry<String, Object> entry : tvShow.getIds().entrySet()) {
                options.setId(entry.getKey(), entry.getValue().toString());
            }
            for (MediaScraper artworkScraper : artworkScrapers) {
                ITvShowArtworkProvider artworkProvider = (ITvShowArtworkProvider)artworkScraper.getMediaProvider();
                try {
                    artwork.addAll(artworkProvider.getArtwork(options));
                }
                catch (ScrapeException e) {
                    LOGGER.error("getArtwork", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)tvShow, "message.scrape.tvshowartworkfailed", new String[]{":", e.getLocalizedMessage()}));
                }
                catch (MissingIdException missingIdException) {}
            }
            return artwork;
        }
    }
}

