/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.mediaprovider.IKodiMetadataProvider;
import org.tinymediamanager.scraper.mediaprovider.IMediaProvider;
import org.tinymediamanager.scraper.mediaprovider.IMediaSubtitleProvider;
import org.tinymediamanager.scraper.mediaprovider.IMovieArtworkProvider;
import org.tinymediamanager.scraper.mediaprovider.IMovieMetadataProvider;
import org.tinymediamanager.scraper.mediaprovider.IMovieSetMetadataProvider;
import org.tinymediamanager.scraper.mediaprovider.IMovieTrailerProvider;
import org.tinymediamanager.scraper.mediaprovider.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.mediaprovider.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.util.PluginManager;
import org.tinymediamanager.ui.UTF8Control;

public class MediaScraper {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private String id = "";
    private String version = "";
    private String name = "";
    private String summary = "";
    private String description;
    private URL logoUrl;
    private ScraperType type;
    private IMediaProvider mediaProvider;
    private boolean enabled = true;

    public MediaScraper(ScraperType type, IMediaProvider mediaProvider) {
        this.mediaProvider = mediaProvider;
        this.type = type;
        MediaProviderInfo mpi = mediaProvider.getProviderInfo();
        this.id = mpi.getId();
        this.name = mpi.getName();
        this.version = mpi.getVersion();
        this.description = mpi.getDescription();
        this.summary = mpi.getDescription();
        this.logoUrl = mpi.getProviderLogo();
    }

    public String toString() {
        return this.name;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public ScraperType getType() {
        return this.type;
    }

    public void setType(ScraperType type) {
        this.type = type;
    }

    public IMediaProvider getMediaProvider() {
        return this.mediaProvider;
    }

    public URL getLogoURL() {
        return this.logoUrl;
    }

    public static List<MediaScraper> getMediaScrapers(ScraperType type) {
        ArrayList<MediaScraper> scraper = new ArrayList<MediaScraper>();
        ArrayList plugins = new ArrayList();
        switch (type) {
            case MOVIE: {
                plugins.addAll(PluginManager.getInstance().getPluginsForInterface(IMovieMetadataProvider.class));
                break;
            }
            case TV_SHOW: {
                plugins.addAll(PluginManager.getInstance().getPluginsForInterface(ITvShowMetadataProvider.class));
                break;
            }
            case MOVIE_SET: {
                plugins.addAll(PluginManager.getInstance().getPluginsForInterface(IMovieSetMetadataProvider.class));
                break;
            }
            case MOVIE_ARTWORK: {
                plugins.addAll(PluginManager.getInstance().getPluginsForInterface(IMovieArtworkProvider.class));
                break;
            }
            case TV_SHOW_ARTWORK: {
                plugins.addAll(PluginManager.getInstance().getPluginsForInterface(ITvShowArtworkProvider.class));
                break;
            }
            case MOVIE_TRAILER: {
                plugins.addAll(PluginManager.getInstance().getPluginsForInterface(IMovieTrailerProvider.class));
                break;
            }
            case SUBTITLE: {
                plugins.addAll(PluginManager.getInstance().getPluginsForInterface(IMediaSubtitleProvider.class));
                break;
            }
        }
        for (IMediaProvider p : plugins) {
            MediaScraper ms = new MediaScraper(type, p);
            scraper.add(ms);
        }
        for (IKodiMetadataProvider kodi : PluginManager.getInstance().getPluginsForInterface(IKodiMetadataProvider.class)) {
            try {
                for (IMediaProvider p : kodi.getPluginsForType(MediaType.toMediaType((String)type.name()))) {
                    MediaScraper ms = new MediaScraper(type, p);
                    scraper.add(ms);
                }
            }
            catch (Exception exception) {
            }
        }
        return scraper;
    }

    public static MediaScraper getMediaScraperById(String id, ScraperType type) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        List<MediaScraper> scrapers = MediaScraper.getMediaScrapers(type);
        for (MediaScraper scraper : scrapers) {
            if (!scraper.id.equals(id)) continue;
            return scraper;
        }
        return null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MediaScraper other = (MediaScraper)obj;
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return this.type == other.type;
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

