/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util.youtube.model;

import java.util.ArrayList;
import java.util.List;
import org.tinymediamanager.scraper.util.youtube.model.quality.AudioQuality;
import org.tinymediamanager.scraper.util.youtube.model.quality.VideoQuality;

public enum Itag {
    UNKNOWN{

        @Override
        public void setId(int id) {
            this.id = id;
        }
    }
    ,
    I_5(VideoQuality.SMALL, AudioQuality.UNKNOWN),
    I_6(VideoQuality.SMALL, AudioQuality.UNKNOWN),
    I_17(VideoQuality.TINY, AudioQuality.UNKNOWN),
    I_18(VideoQuality.MEDIUM, AudioQuality.UNKNOWN),
    I_22(VideoQuality.HD_720, AudioQuality.UNKNOWN),
    I_34(VideoQuality.MEDIUM, AudioQuality.UNKNOWN),
    I_35(VideoQuality.LARGE, AudioQuality.UNKNOWN),
    I_36(VideoQuality.TINY, AudioQuality.UNKNOWN),
    I_37(VideoQuality.HD_1080, AudioQuality.UNKNOWN),
    I_38(VideoQuality.HIGHRES, AudioQuality.UNKNOWN),
    I_43(VideoQuality.MEDIUM, AudioQuality.UNKNOWN),
    I_44(VideoQuality.LARGE, AudioQuality.UNKNOWN),
    I_45(VideoQuality.HD_720, AudioQuality.UNKNOWN),
    I_46(VideoQuality.HD_1080, AudioQuality.UNKNOWN),
    I_82(VideoQuality.MEDIUM, AudioQuality.UNKNOWN, true),
    I_83(VideoQuality.LARGE, AudioQuality.UNKNOWN, true),
    I_84(VideoQuality.HD_720, AudioQuality.UNKNOWN, true),
    I_85(VideoQuality.HD_1080, AudioQuality.UNKNOWN, true),
    I_92(VideoQuality.SMALL, AudioQuality.UNKNOWN, true),
    I_93(VideoQuality.MEDIUM, AudioQuality.UNKNOWN, true),
    I_94(VideoQuality.LARGE, AudioQuality.UNKNOWN, true),
    I_95(VideoQuality.HD_720, AudioQuality.UNKNOWN, true),
    I_96(VideoQuality.HD_1080, AudioQuality.UNKNOWN),
    I_100(VideoQuality.MEDIUM, AudioQuality.UNKNOWN, true),
    I_101(VideoQuality.LARGE, AudioQuality.UNKNOWN, true),
    I_102(VideoQuality.HD_720, AudioQuality.UNKNOWN, true),
    I_132(VideoQuality.SMALL, AudioQuality.UNKNOWN),
    I_133(VideoQuality.SMALL),
    I_134(VideoQuality.MEDIUM),
    I_135(VideoQuality.LARGE),
    I_136(VideoQuality.HD_720),
    I_137(VideoQuality.HD_1080),
    I_138(VideoQuality.HD_2160),
    I_139(AudioQuality.LOW),
    I_140(AudioQuality.MEDIUM),
    I_141(AudioQuality.HIGH),
    I_151(VideoQuality.TINY, AudioQuality.UNKNOWN),
    I_160(VideoQuality.TINY),
    I_167(VideoQuality.MEDIUM),
    I_168(VideoQuality.LARGE),
    I_169(VideoQuality.HD_1080),
    I_171(AudioQuality.MEDIUM),
    I_218(VideoQuality.LARGE),
    I_219(VideoQuality.TINY),
    I_242(VideoQuality.SMALL),
    I_243(VideoQuality.MEDIUM),
    I_244(VideoQuality.LARGE),
    I_245(VideoQuality.LARGE),
    I_246(VideoQuality.LARGE),
    I_247(VideoQuality.HD_720),
    I_248(VideoQuality.HD_1080),
    I_249(AudioQuality.LOW),
    I_250(AudioQuality.MEDIUM),
    I_251(AudioQuality.MEDIUM),
    I_264(VideoQuality.HD_1440),
    I_266(VideoQuality.HD_2160),
    I_271(VideoQuality.HD_1440),
    I_272(VideoQuality.HIGHRES),
    I_278(VideoQuality.TINY),
    I_298(VideoQuality.HD_720),
    I_299(VideoQuality.HD_1080),
    I_302(VideoQuality.HD_720),
    I_303(VideoQuality.HD_1080),
    I_308(VideoQuality.HD_1440),
    I_313(VideoQuality.HD_2160),
    I_315(VideoQuality.HD_2160),
    I_330(VideoQuality.TINY),
    I_331(VideoQuality.SMALL),
    I_332(VideoQuality.MEDIUM),
    I_333(VideoQuality.LARGE),
    I_334(VideoQuality.HD_720),
    I_335(VideoQuality.HD_1080),
    I_336(VideoQuality.HD_1440),
    I_337(VideoQuality.HD_2160),
    I_394(VideoQuality.TINY),
    I_395(VideoQuality.SMALL),
    I_396(VideoQuality.MEDIUM),
    I_397(VideoQuality.LARGE),
    I_398(VideoQuality.HD_720),
    I_399(VideoQuality.HD_1080);

    protected int id;
    private VideoQuality videoQuality;
    private AudioQuality audioQuality;
    private boolean isVRor3D;

    private Itag() {
        this.videoQuality = VideoQuality.UNKNOWN;
        this.audioQuality = AudioQuality.UNKNOWN;
    }

    private Itag(VideoQuality videoQuality) {
        this(videoQuality, AudioQuality.NO_AUDIO, false);
    }

    private Itag(AudioQuality audioQuality) {
        this(VideoQuality.NO_VIDEO, audioQuality, false);
    }

    private Itag(VideoQuality videoQuality, AudioQuality audioQuality) {
        this(videoQuality, audioQuality, false);
    }

    private Itag(VideoQuality videoQuality, AudioQuality audioQuality, boolean isVRor3D) {
        this.setId(Integer.parseInt(this.name().substring(2)));
        this.videoQuality = videoQuality;
        this.audioQuality = audioQuality;
        this.isVRor3D = isVRor3D;
    }

    public void setId(int id) {
        this.id = id;
    }

    public int id() {
        return this.id;
    }

    public VideoQuality videoQuality() {
        return this.videoQuality;
    }

    public AudioQuality audioQuality() {
        return this.audioQuality;
    }

    public boolean isVideo() {
        return this.videoQuality != VideoQuality.NO_VIDEO;
    }

    public boolean isAudio() {
        return this.audioQuality != AudioQuality.NO_AUDIO;
    }

    public boolean isVRor3D() {
        return this.isVRor3D;
    }

    public static Itag findItag(int number) {
        try {
            return Itag.valueOf("I_" + number);
        }
        catch (ExceptionInInitializerError exceptionInInitializerError) {
            return null;
        }
    }

    public static List<AudioQuality> getAudioQualityList() {
        ArrayList<AudioQuality> list = new ArrayList<AudioQuality>();
        list.add(AudioQuality.HIGH);
        list.add(AudioQuality.MEDIUM);
        list.add(AudioQuality.LOW);
        return list;
    }

    public static List<VideoQuality> getVideoQualityList() {
        ArrayList<VideoQuality> list = new ArrayList<VideoQuality>();
        list.add(VideoQuality.HIGHRES);
        list.add(VideoQuality.HD_2160);
        list.add(VideoQuality.HD_1440);
        list.add(VideoQuality.HD_1080);
        list.add(VideoQuality.HD_720);
        list.add(VideoQuality.LARGE);
        list.add(VideoQuality.MEDIUM);
        list.add(VideoQuality.SMALL);
        list.add(VideoQuality.TINY);
        return list;
    }

    public String toString() {
        return String.valueOf(this.id);
    }
}

