/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util.youtube.model.formats;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Objects;
import org.tinymediamanager.scraper.util.youtube.YoutubeHelper;
import org.tinymediamanager.scraper.util.youtube.model.Extension;
import org.tinymediamanager.scraper.util.youtube.model.Itag;

public abstract class Format {
    protected final Itag itag;
    private final String url;
    private final String mimeType;
    private final Extension extension;
    private final Integer bitrate;
    private final Long contentLength;
    private final Long lastModified;

    protected Format(JsonNode json, Itag itag) {
        this.itag = itag;
        this.url = Objects.requireNonNull(YoutubeHelper.getString(json, "url")).replace("\\u0026", "&");
        this.mimeType = YoutubeHelper.getString(json, "type");
        this.bitrate = Integer.valueOf(Objects.requireNonNull(YoutubeHelper.getString(json, "bitrate")));
        this.contentLength = Long.valueOf(Objects.requireNonNull(YoutubeHelper.getString(json, "clen")));
        this.lastModified = Long.valueOf(Objects.requireNonNull(YoutubeHelper.getString(json, "lmt")));
        this.extension = Objects.requireNonNull(this.mimeType).contains(Extension.MP4.getText()) ? Extension.MP4 : (this.mimeType.contains(Extension.WEBM.getText()) ? Extension.WEBM : (this.mimeType.contains(Extension.FLV.getText()) ? Extension.FLV : (this.mimeType.contains(Extension.HLS.getText()) ? Extension.HLS : (this.mimeType.contains(Extension.THREEGP.getText()) ? Extension.THREEGP : (this.mimeType.contains(Extension.M4A.getText()) ? Extension.MP4 : Extension.UNKNOWN)))));
    }

    public abstract String type();

    public Itag itag() {
        return this.itag;
    }

    public Integer bitrate() {
        return this.bitrate;
    }

    public String mimeType() {
        return this.mimeType;
    }

    public String url() {
        return this.url;
    }

    public Long contentLength() {
        return this.contentLength;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public Extension extension() {
        return this.extension;
    }
}

