/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.util.youtube.model.formats;

import com.fasterxml.jackson.databind.JsonNode;
import org.tinymediamanager.scraper.util.youtube.YoutubeHelper;
import org.tinymediamanager.scraper.util.youtube.model.Itag;
import org.tinymediamanager.scraper.util.youtube.model.formats.Format;
import org.tinymediamanager.scraper.util.youtube.model.quality.VideoQuality;

public class VideoFormat
extends Format {
    private final Integer fps;
    private final String qualityLabel;
    private final Integer width;
    private final Integer height;

    public VideoFormat(JsonNode json, Itag itag) {
        super(json, itag);
        this.fps = YoutubeHelper.getInt(json, "fps");
        this.qualityLabel = YoutubeHelper.getString(json, "quality_label");
        if (json.has("size")) {
            String[] split = YoutubeHelper.getString(json, "size").split("x");
            this.width = Integer.parseInt(split[0]);
            this.height = Integer.parseInt(split[1]);
        } else {
            this.width = YoutubeHelper.getInt(json, "width");
            this.height = YoutubeHelper.getInt(json, "height");
        }
    }

    @Override
    public String type() {
        return "video";
    }

    public int fps() {
        return this.fps;
    }

    public VideoQuality videoQuality() {
        return this.itag.videoQuality();
    }

    public String qualityLabel() {
        return this.qualityLabel;
    }

    public Integer width() {
        return this.width;
    }

    public Integer height() {
        return this.height;
    }
}

