/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty;

import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.thirdparty.MediaInfo;

public class MediaInfoXMLParser {
    private final List<MiFile> files = new ArrayList<MiFile>();
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaInfoXMLParser.class);
    private static Pattern DURATION_HOUR_PATTERN = Pattern.compile("(\\d*?) h");
    private static Pattern DURATION_MINUTE_PATTERN = Pattern.compile("(\\d*?) min");
    private static Pattern DURATION_SECOND_PATTERN = Pattern.compile("(\\d*?) s");

    public static MediaInfoXMLParser parseXML(Path path) throws Exception {
        return new MediaInfoXMLParser(Jsoup.parse((InputStream)new FileInputStream(path.toFile()), (String)"UTF-8", (String)"", (Parser)Parser.xmlParser()));
    }

    private MediaInfoXMLParser(Document document) throws Exception {
        Elements rootElements = document.select("MediaInfo");
        if (rootElements.isEmpty()) {
            throw new InvalidXmlException("Invalid/unparseable XML");
        }
        Element root = (Element)rootElements.get(0);
        Elements fileElements = root.select("media");
        if (fileElements.isEmpty()) {
            fileElements = root.select("file");
        }
        for (Element file : fileElements) {
            MiFile miFile = new MiFile();
            miFile.filename = "/tmp/dummy.bdmv";
            if (StringUtils.isNotBlank((CharSequence)file.attr("ref")) && file.attr("ref").length() > 5) {
                miFile.filename = file.attr("ref");
            }
            for (Element track : file.select("track")) {
                MiTrack miTrack = new MiTrack();
                miTrack.type = track.attr("type");
                miTrack.elements.addAll((Collection<Element>)track.children());
                miFile.tracks.add(miTrack);
            }
            miFile.createSnapshot();
            MediaFile mf = new MediaFile(Paths.get(miFile.filename, new String[0]));
            if (!mf.isVideo() && !mf.getExtension().equalsIgnoreCase("mpls")) continue;
            miFile.filename = mf.getFilename();
            this.files.add(miFile);
        }
    }

    public MiFile getMainFile() {
        long biggest = 0L;
        long longest = 0L;
        MiFile mainFile = null;
        if (mainFile == null) {
            for (MiFile f : this.files) {
                if (f.getFilename().toLowerCase(Locale.ROOT).endsWith("ifo")) {
                    // empty if block
                }
                if ((long)f.getDuration() <= longest) continue;
                mainFile = f;
                longest = f.getDuration();
            }
        }
        if (mainFile == null) {
            mainFile = new MiFile();
        }
        LOGGER.trace("Returning main video file: {}", (Object)mainFile.getFilename());
        return mainFile;
    }

    public int getRuntimeFromDvdFiles() {
        int rtifo = 0;
        MiFile ifo = null;
        if (this.files.size() <= 1) {
            return 0;
        }
        for (MiFile mf : this.files) {
            if (!mf.getFilename().toLowerCase(Locale.ROOT).endsWith("ifo") || mf.getDuration() <= rtifo) continue;
            rtifo = mf.getDuration();
            ifo = mf;
        }
        if (ifo != null) {
            LOGGER.trace("Found longest IFO:{} duration:{}", (Object)ifo.getFilename(), (Object)rtifo);
            String prefix = StrgUtils.substr((String)ifo.getFilename(), (String)"(?i)^(VTS_\\d+).*");
            if (prefix.isEmpty()) {
                prefix = StrgUtils.substr((String)ifo.getFilename(), (String)"(?i)^(HV\\d+)I.*");
            }
            if (!prefix.isEmpty()) {
                int rtvob = 0;
                for (MiFile mf : this.files) {
                    if (!mf.getFilename().startsWith(prefix) || ifo.getFilename().equals(mf.getFilename())) continue;
                    LOGGER.trace("VOB:{} duration:{} accumulated:{}", new Object[]{mf.getFilename(), mf.getDuration(), rtvob += mf.getDuration()});
                }
                if (rtvob > rtifo) {
                    rtifo = rtvob;
                }
            } else {
                LOGGER.trace("TODO: bluray");
            }
        }
        return rtifo;
    }

    public static class InvalidXmlException
    extends Exception {
        public InvalidXmlException(String message) {
            super(message);
        }
    }

    public static class MiTrack {
        public String type;
        public final List<Element> elements = new ArrayList<Element>();
    }

    public static class MiFile {
        public final Map<MediaInfo.StreamKind, List<Map<String, String>>> snapshot;
        private final List<MiTrack> tracks = new ArrayList<MiTrack>();
        private int duration = 0;
        private long filesize = 0L;
        private String filename = "";

        private MiFile() {
            this.snapshot = new EnumMap<MediaInfo.StreamKind, List<Map<String, String>>>(MediaInfo.StreamKind.class);
        }

        public String getFilename() {
            return this.filename;
        }

        public long getFilesize() {
            return this.filesize;
        }

        public int getDuration() {
            return this.duration;
        }

        private void createSnapshot() {
            Path p;
            MediaInfo.StreamKind currentKind = null;
            ArrayList streamInfoList = new ArrayList(this.tracks.size());
            LinkedHashMap<String, String> generalStreamInfo = null;
            long kindFilesize = 0L;
            long kindStreamsize = 0L;
            int kindDuration = 0;
            for (MiTrack track : this.tracks) {
                if (MediaInfo.StreamKind.valueOf(track.type) != currentKind) {
                    if (kindDuration > this.duration) {
                        this.duration = kindDuration;
                    }
                    if (kindFilesize > this.filesize) {
                        this.filesize = kindFilesize;
                    }
                    if (kindStreamsize > this.filesize) {
                        this.filesize = kindStreamsize;
                    }
                    streamInfoList = new ArrayList(this.tracks.size());
                    kindFilesize = 0L;
                    kindStreamsize = 0L;
                    kindDuration = 0;
                }
                LinkedHashMap<String, String> streamInfo = new LinkedHashMap<String, String>();
                currentKind = MediaInfo.StreamKind.valueOf(track.type);
                if (currentKind == MediaInfo.StreamKind.General) {
                    generalStreamInfo = streamInfo;
                }
                for (Element elem : track.elements) {
                    int i = 0;
                    String ename = elem.tagName();
                    String key = this.getMappedKey(ename);
                    while (streamInfo.containsKey(key)) {
                        key = ename + "/String";
                        if (i > 0) {
                            key = key + i;
                        }
                        ++i;
                    }
                    String value = elem.ownText();
                    if (value.isEmpty()) continue;
                    if (key.equals("Width") || key.equals("Height")) {
                        value = value.replace("pixels", "").trim();
                    }
                    if (key.equals("FileSize")) {
                        try {
                            kindFilesize += this.parseSize(value);
                            value = String.valueOf(kindFilesize);
                        }
                        catch (NumberFormatException ignored) {
                            LOGGER.trace("could not parse filesize", (Throwable)ignored);
                        }
                    }
                    if (key.equals("Stream_size")) {
                        try {
                            kindStreamsize += this.parseSize(value);
                            value = String.valueOf(kindStreamsize);
                        }
                        catch (NumberFormatException ignored) {
                            LOGGER.trace("could not parse streamsize", (Throwable)ignored);
                        }
                    }
                    if (key.equals("Complete_name") && MediaInfo.StreamKind.General == currentKind && value.length() > 5) {
                        this.filename = value;
                    }
                    if (key.equals("Duration") && MediaInfo.StreamKind.General == currentKind) {
                        try {
                            Double d = Double.parseDouble(value.replace(".", ""));
                            value = String.valueOf(kindDuration += d.intValue() / 1000);
                        }
                        catch (NumberFormatException e) {
                            try {
                                int hours = 0;
                                int minutes = 0;
                                int seconds = 0;
                                Matcher matcher = DURATION_HOUR_PATTERN.matcher(value);
                                if (matcher.find()) {
                                    hours = Integer.parseInt(matcher.group(1));
                                }
                                if ((matcher = DURATION_MINUTE_PATTERN.matcher(value)).find()) {
                                    minutes = Integer.parseInt(matcher.group(1));
                                }
                                if ((matcher = DURATION_SECOND_PATTERN.matcher(value)).find()) {
                                    seconds = Integer.parseInt(matcher.group(1));
                                }
                                value = String.valueOf(kindDuration += hours * 3600 + minutes * 60 + seconds);
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                        }
                    }
                    streamInfo.put(key, value);
                    if (key.equals(this.getMappedKey(key))) continue;
                    streamInfo.put(this.getMappedKey(key), value);
                }
                streamInfoList.add(streamInfo);
                this.snapshot.put(MediaInfo.StreamKind.valueOf(track.type), streamInfoList);
            }
            if (generalStreamInfo != null) {
                if (generalStreamInfo.get("VideoCount") == null && this.snapshot.get((Object)MediaInfo.StreamKind.Video) != null) {
                    generalStreamInfo.put("VideoCount", String.valueOf(this.snapshot.get((Object)MediaInfo.StreamKind.Video).size()));
                }
                if (generalStreamInfo.get("AudioCount") == null && this.snapshot.get((Object)MediaInfo.StreamKind.Audio) != null) {
                    generalStreamInfo.put("AudioCount", String.valueOf(this.snapshot.get((Object)MediaInfo.StreamKind.Audio).size()));
                }
                if (generalStreamInfo.get("TextCount") == null && this.snapshot.get((Object)MediaInfo.StreamKind.Text) != null) {
                    generalStreamInfo.put("TextCount", String.valueOf(this.snapshot.get((Object)MediaInfo.StreamKind.Text).size()));
                }
            }
            if (!this.filename.isEmpty() && (p = Paths.get(this.filename, new String[0])).getNameCount() == 0) {
                p = p.resolve("/iso/dummy.vob");
            }
        }

        private String getMappedKey(String key) {
            String k = key;
            switch (key) {
                case "Codec/String": {
                    k = "CodecID/Hint";
                    break;
                }
                case "Count_of_audio_streams": {
                    k = "AudioCount";
                    break;
                }
                case "Count_of_text_streams": {
                    k = "TextCount";
                    break;
                }
                case "Count_of_video_streams": {
                    k = "VideoCount";
                    break;
                }
                case "Count_of_menu_streams": {
                    k = "MenuCount";
                    break;
                }
                case "Channel_s_": 
                case "Channels": {
                    k = "Channel(s)";
                    break;
                }
                case "Bit_rate": {
                    k = "BitRate";
                    break;
                }
                case "File_size": {
                    k = "FileSize";
                    break;
                }
                case "Overall_bit_rate": {
                    k = "OverallBitRate";
                    break;
                }
                case "Count_of_stream_of_this_kind": {
                    k = "StreamCount";
                    break;
                }
                case "Codec_Extensions_usually_used": {
                    k = "Codec/Extensions";
                    break;
                }
                case "Scan_type": {
                    k = "ScanType";
                    break;
                }
            }
            return k;
        }

        private long parseSize(String size) {
            long s = 0L;
            size = size.replaceAll("\\(.*$", "").trim();
            int factor = 1;
            if (size.toLowerCase(Locale.ROOT).endsWith("kib")) {
                factor = 1024;
            }
            if (size.toLowerCase(Locale.ROOT).endsWith("mib")) {
                factor = 0x100000;
            }
            if (size.toLowerCase(Locale.ROOT).endsWith("gib")) {
                factor = 0x40000000;
            }
            size = size.replaceAll("\\s.*$", "");
            Double d = Double.parseDouble(size);
            s = d.longValue();
            return s *= (long)factor;
        }
    }
}

