/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.awt.Color;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.tinymediamanager.Globals;
import org.tinymediamanager.ui.plaf.TmmIcons;

public class IconManager {
    private static final Map<URI, ImageIcon> ICON_CACHE = new HashMap<URI, ImageIcon>();
    private static final int DEFAULT_FONT_SIZE = Globals.settings.getFontSize();
    private static final Color ICON_COLOR = UIManager.getColor("Focus.color");
    public static final ImageIcon TOOLBAR_ABOUT = IconManager.loadImage("icn_about.png");
    public static final ImageIcon TOOLBAR_ABOUT_HOVER = IconManager.loadImage("icn_about_hover.png");
    public static final ImageIcon TOOLBAR_ADD_MOVIE_SET = IconManager.loadImage("icn_add_collection.png");
    public static final ImageIcon TOOLBAR_ADD_MOVIE_SET_HOVER = IconManager.loadImage("icn_add_collection_hover.png");
    public static final ImageIcon TOOLBAR_DONATE = IconManager.loadImage("icn_donate.png");
    public static final ImageIcon TOOLBAR_DONATE_HOVER = IconManager.loadImage("icn_donate_hover.png");
    public static final ImageIcon TOOLBAR_EDIT = IconManager.loadImage("icn_edit.png");
    public static final ImageIcon TOOLBAR_EDIT_HOVER = IconManager.loadImage("icn_edit_hover.png");
    public static final ImageIcon TOOLBAR_EXPORT = IconManager.loadImage("icn_export.png");
    public static final ImageIcon TOOLBAR_EXPORT_HOVER = IconManager.loadImage("icn_export_hover.png");
    public static final ImageIcon TOOLBAR_LOGO = IconManager.loadImage("icn_logo_toolbar.png");
    public static final ImageIcon TOOLBAR_REFRESH = IconManager.loadImage("icn_refresh.png");
    public static final ImageIcon TOOLBAR_REFRESH_HOVER = IconManager.loadImage("icn_refresh_hover.png");
    public static final ImageIcon TOOLBAR_RENAME = IconManager.loadImage("icn_rename.png");
    public static final ImageIcon TOOLBAR_RENAME_HOVER = IconManager.loadImage("icn_rename_hover.png");
    public static final ImageIcon TOOLBAR_SEARCH = IconManager.loadImage("icn_search.png");
    public static final ImageIcon TOOLBAR_SEARCH_HOVER = IconManager.loadImage("icn_search_hover.png");
    public static final ImageIcon TOOLBAR_SETTINGS = IconManager.loadImage("icn_settings.png");
    public static final ImageIcon TOOLBAR_SETTINGS_HOVER = IconManager.loadImage("icn_settings_hover.png");
    public static final ImageIcon TOOLBAR_TOOLS = IconManager.loadImage("icn_tools.png");
    public static final ImageIcon TOOLBAR_TOOLS_HOVER = IconManager.loadImage("icn_tools_hover.png");
    public static final ImageIcon STAR_FILLED = IconManager.loadImage("star-filled.png");
    public static final ImageIcon STAR_EMPTY = IconManager.loadImage("star-empty.png");
    public static final ImageIcon UNWATCHED = IconManager.loadImage("unwatched.png");
    public static final ImageIcon ADD = TmmIcons.createFontAwesomeIcon((char)'\uf067', (Color)ICON_COLOR);
    public static final ImageIcon BUG = TmmIcons.createFontAwesomeIcon((char)'\uf188', (Color)ICON_COLOR);
    public static final ImageIcon DELETE = TmmIcons.createFontAwesomeIcon((char)'\uf00d', (Color)ICON_COLOR);
    public static final ImageIcon DELETE_FOREVER = TmmIcons.createFontAwesomeIcon((char)'\uf2ed', (Color)ICON_COLOR);
    public static final ImageIcon DOWNLOAD = TmmIcons.createFontAwesomeIcon((char)'\uf019', (Color)ICON_COLOR);
    public static final ImageIcon FEEDBACK = TmmIcons.createFontAwesomeIcon((char)'\uf0e0', (Color)ICON_COLOR);
    public static final ImageIcon EDIT = TmmIcons.createFontAwesomeIcon((char)'\uf044', (Color)ICON_COLOR);
    public static final ImageIcon EXPORT = TmmIcons.createFontAwesomeIcon((char)'\uf14d', (Color)ICON_COLOR);
    public static final ImageIcon HINT = TmmIcons.createFontAwesomeIcon((char)'\uf05a', (Color)ICON_COLOR);
    public static final ImageIcon IMAGE = TmmIcons.createFontAwesomeIcon((char)'\uf03e', (Color)ICON_COLOR);
    public static final ImageIcon MEDIAINFO = TmmIcons.createFontAwesomeIcon((char)'\uf129', (Color)ICON_COLOR);
    public static final ImageIcon PLAY = TmmIcons.createFontAwesomeIcon((char)'\uf04b', (Color)ICON_COLOR);
    public static final ImageIcon REFRESH = TmmIcons.createFontAwesomeIcon((char)'\uf01e', (Color)ICON_COLOR);
    public static final ImageIcon REMOVE = TmmIcons.createFontAwesomeIcon((char)'\uf068', (Color)ICON_COLOR);
    public static final ImageIcon SEARCH = TmmIcons.createFontAwesomeIcon((char)'\uf002', (Color)ICON_COLOR);
    public static final ImageIcon SUBTITLE = TmmIcons.createFontAwesomeIcon((char)'\uf086', (Color)ICON_COLOR);
    public static final ImageIcon SYNC = TmmIcons.createFontAwesomeIcon((char)'\uf021', (Color)ICON_COLOR);
    public static final ImageIcon TABLE_OK = TmmIcons.createFontAwesomeIcon((char)'\uf00c', (Color)new Color(31, 187, 0));
    public static final ImageIcon TABLE_PROBLEM = TmmIcons.createFontAwesomeIcon((char)'\uf071', (Color)new Color(204, 120, 50));
    public static final ImageIcon TABLE_NOT_OK = TmmIcons.createFontAwesomeIcon((char)'\uf00d', (Color)new Color(204, 2, 2));
    public static final ImageIcon CANCEL = TmmIcons.createFontAwesomeIcon((char)'\uf057');
    public static final ImageIcon CARET_UP = TmmIcons.createFontAwesomeIcon((char)'\uf0d8');
    public static final ImageIcon CARET_DOWN = TmmIcons.createFontAwesomeIcon((char)'\uf0d7');
    public static final ImageIcon CLEAR_GREY = TmmIcons.createFontAwesomeIcon((char)'\uf057');
    public static final ImageIcon COLLAPSED = TmmIcons.createFontAwesomeIcon((char)'\uf329');
    public static final ImageIcon CONFIGURE = TmmIcons.createFontAwesomeIcon((char)'\uf0ad');
    public static final ImageIcon ERROR = TmmIcons.createFontAwesomeIcon((char)'\uf057');
    public static final ImageIcon EXPANDED = TmmIcons.createFontAwesomeIcon((char)'\uf32b');
    public static final ImageIcon WARN = TmmIcons.createFontAwesomeIcon((char)'\uf071');
    public static final ImageIcon WARN_INTENSIFIED = TmmIcons.createFontAwesomeIcon((char)'\uf071', (Color)Color.RED);
    public static final ImageIcon INFO = TmmIcons.createFontAwesomeIcon((char)'\uf05a');
    public static final ImageIcon FILTER_ACTIVE = TmmIcons.createFontAwesomeIcon((char)'\uf672', (Color)new Color(255, 119, 0));
    public static final ImageIcon NEW = TmmIcons.createTextIcon((String)"new", (int)DEFAULT_FONT_SIZE, (Color)new Color(31, 187, 0));
    public static final ImageIcon PLAY_LARGE = TmmIcons.createFontAwesomeIcon((char)'\uf144', (int)28);
    public static final ImageIcon SEARCH_GREY = TmmIcons.createFontAwesomeIcon((char)'\uf002');
    public static final ImageIcon STOP = TmmIcons.createFontAwesomeIcon((char)'\uf28d');
    public static final ImageIcon UNDO_GREY = TmmIcons.createFontAwesomeIcon((char)'\uf0e2');
    public static final ImageIcon ADD_INV = TmmIcons.createFontAwesomeIcon((char)'\uf067', (Color)UIManager.getColor("Button.foreground"));
    public static final ImageIcon ARROW_UP_INV = TmmIcons.createFontAwesomeIcon((char)'\uf077', (Color)UIManager.getColor("Button.foreground"));
    public static final ImageIcon ARROW_DOWN_INV = TmmIcons.createFontAwesomeIcon((char)'\uf078', (Color)UIManager.getColor("Button.foreground"));
    public static final ImageIcon APPLY_INV = TmmIcons.createFontAwesomeIcon((char)'\uf058', (Color)UIManager.getColor("Button.foreground"));
    public static final ImageIcon BACK_INV = TmmIcons.createFontAwesomeIcon((char)'\uf137', (Color)UIManager.getColor("Button.foreground"));
    public static final ImageIcon CANCEL_INV = TmmIcons.createFontAwesomeIcon((char)'\uf057', (Color)UIManager.getColor("Button.foreground"));
    public static final ImageIcon CHECK_ALL = TmmIcons.createFontAwesomeIcon((char)'\uf14a', (Color)UIManager.getColor("Button.foreground"));
    public static final ImageIcon CLEAR_ALL = TmmIcons.createFontAwesomeIcon((char)'\uf0c8', (Color)UIManager.getColor("Button.foreground"));
    public static final ImageIcon COPY_INV = TmmIcons.createFontAwesomeIcon((char)'\uf24d', (Color)UIManager.getColor("Button.foreground"));
    public static final ImageIcon DATE_PICKER = TmmIcons.createFontAwesomeIcon((char)'\uf073', (Color)UIManager.getColor("Button.foreground"));
    public static final ImageIcon DELETE_INV = TmmIcons.createFontAwesomeIcon((char)'\uf2ed', (Color)UIManager.getColor("Button.foreground"));
    public static final ImageIcon FILTER_INV = TmmIcons.createFontAwesomeIcon((char)'\uf0b0', (Color)UIManager.getColor("Button.foreground"));
    public static final ImageIcon FILE_OPEN_INV = TmmIcons.createFontAwesomeIcon((char)'\uf07c', (Color)UIManager.getColor("Button.foreground"));
    public static final ImageIcon IMAGE_INV = TmmIcons.createFontAwesomeIcon((char)'\uf03e', (Color)UIManager.getColor("Button.foreground"));
    public static final ImageIcon PLAY_INV = TmmIcons.createFontAwesomeIcon((char)'\uf04b', (Color)UIManager.getColor("Button.foreground"));
    public static final ImageIcon REMOVE_INV = TmmIcons.createFontAwesomeIcon((char)'\uf068', (Color)UIManager.getColor("Button.foreground"));
    public static final ImageIcon SEARCH_INV = TmmIcons.createFontAwesomeIcon((char)'\uf002', (Color)UIManager.getColor("Button.foreground"));
    public static final ImageIcon STOP_INV = TmmIcons.createFontAwesomeIcon((char)'\uf28d', (Color)UIManager.getColor("Button.foreground"));
    public static final ImageIcon AUDIO = TmmIcons.createFontAwesomeIcon((char)'\uf028', (int)16);
    public static final ImageIcon CERTIFICATION = TmmIcons.createFontAwesomeIcon((char)'\uf29a', (int)16);
    public static final ImageIcon COUNT = TmmIcons.createFontAwesomeIcon((char)'\uf292', (int)16);
    public static final ImageIcon DATE_ADDED = TmmIcons.createFontAwesomeIcon((char)'\uf271', (int)16);
    public static final ImageIcon EDITION = TmmIcons.createFontAwesomeIcon((char)'\uf51f', (int)16);
    public static final ImageIcon EDIT_HEADER = TmmIcons.createFontAwesomeIcon((char)'\uf044', (int)16);
    public static final ImageIcon EPISODES = TmmIcons.createTextIcon((String)"E", (int)18);
    public static final ImageIcon FILE_SIZE = TmmIcons.createFontAwesomeIcon((char)'\uf0c7', (int)16);
    public static final ImageIcon IMAGES = TmmIcons.createFontAwesomeIcon((char)'\uf302', (int)16);
    public static final ImageIcon IDCARD = TmmIcons.createFontAwesomeIcon((char)'\uf2c2', (int)16);
    public static final ImageIcon NFO = TmmIcons.createFontAwesomeIcon((char)'\uf15c', (int)16);
    public static final ImageIcon RATING = TmmIcons.createFontAwesomeIcon((char)'\uf005', (int)16);
    public static final ImageIcon SEASONS = TmmIcons.createTextIcon((String)"S", (int)18);
    public static final ImageIcon SOURCE = TmmIcons.createFontAwesomeIcon((char)'\uf601', (int)16);
    public static final ImageIcon SUBTITLES = TmmIcons.createFontAwesomeIcon((char)'\uf086', (int)16);
    public static final ImageIcon TRAILER = TmmIcons.createFontAwesomeIcon((char)'\uf008', (int)16);
    public static final ImageIcon VIDEO_3D = TmmIcons.createFontAwesomeIcon((char)'\uf1b2', (int)16);
    public static final ImageIcon VIDEO_FORMAT = TmmIcons.createFontAwesomeIcon((char)'\uf320', (int)16);
    public static final ImageIcon VOTES = TmmIcons.createFontAwesomeIcon((char)'\uf164', (int)16);
    public static final ImageIcon WATCHED = TmmIcons.createFontAwesomeIcon((char)'\uf04b', (int)16);

    public static ImageIcon loadImage(String name) {
        URL file = IconManager.class.getResource("images/interface/" + name);
        if (file != null) {
            return new ImageIcon(file);
        }
        return TmmIcons.EMPTY_IMAGE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ImageIcon loadImageFromURL(URL url) {
        URI uri = null;
        if (url == null) {
            return TmmIcons.EMPTY_IMAGE;
        }
        try {
            uri = url.toURI();
            if (uri == null) {
                return TmmIcons.EMPTY_IMAGE;
            }
        }
        catch (Exception e) {
            return TmmIcons.EMPTY_IMAGE;
        }
        ImageIcon icon = ICON_CACHE.get(uri);
        if (icon == null) {
            try {
                icon = new ImageIcon(url);
            }
            catch (Exception exception) {
            }
            finally {
                if (icon == null) {
                    icon = TmmIcons.EMPTY_IMAGE;
                }
            }
            ICON_CACHE.put(uri, icon);
        }
        return icon;
    }
}

