/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.Graphics;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.swing.SwingWorker;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.ImageCache;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.ui.components.ImageLabel;

public class ActorImageLabel
extends ImageLabel {
    private static final long serialVersionUID = -1768796209645569296L;
    private SwingWorker<Void, Void> actorWorker = null;
    private Person actor = null;

    public void setActor(MediaEntity mediaEntity, Person actor) {
        this.clearImage();
        if (mediaEntity != null && actor != null && actor != this.actor) {
            if (this.actorWorker != null && !this.actorWorker.isDone()) {
                this.actorWorker.cancel(true);
            }
            this.actorWorker = new ActorImageLoader(actor, mediaEntity);
            this.actorWorker.execute();
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        if (this.isShowing() && !this.isLoading() && this.scaledImage == null) {
            if (StringUtils.isNotBlank((CharSequence)this.imagePath)) {
                if (this.worker != null && !this.worker.isDone()) {
                    this.worker.cancel(true);
                }
                this.worker = new ImageLabel.ImageLoader(this.imagePath, this.getSize());
                this.worker.execute();
                return;
            }
            if (StringUtils.isNotBlank((CharSequence)this.imageUrl)) {
                this.worker = new ImageLabel.ImageFetcher(this.getSize());
                this.worker.execute();
                return;
            }
        }
        super.paintComponent(g);
    }

    @Override
    protected boolean isLoading() {
        return this.worker != null && !this.worker.isDone() || this.actorWorker != null && !this.actorWorker.isDone();
    }

    protected class ActorImageLoader
    extends SwingWorker<Void, Void> {
        private Person actor;
        private MediaEntity mediaEntity;
        private Path imagePath = null;

        private ActorImageLoader(Person actor, MediaEntity mediaEntity) {
            this.actor = actor;
            this.mediaEntity = mediaEntity;
        }

        @Override
        protected Void doInBackground() {
            Path p;
            String actorImageFilename = this.actor.getNameForStorage();
            if (StringUtils.isNotBlank((CharSequence)actorImageFilename)) {
                Path file = null;
                if (ActorImageLabel.this.preferCache) {
                    file = ImageCache.getCachedFile(Paths.get(this.mediaEntity.getPath(), ".actors", actorImageFilename));
                }
                if (file == null) {
                    file = Paths.get(this.mediaEntity.getPath(), ".actors", actorImageFilename);
                }
                if (!(file != null && Files.exists(file, new LinkOption[0]) || ActorImageLabel.this.preferCache)) {
                    file = ImageCache.getCachedFile(Paths.get(this.mediaEntity.getPath(), ".actors", actorImageFilename));
                }
                if (file != null && Files.exists(file, new LinkOption[0])) {
                    this.imagePath = file;
                    return null;
                }
            }
            if (ActorImageLabel.this.isShowing() && (p = ImageCache.getCachedFile(this.actor.getThumbUrl())) != null) {
                this.imagePath = p;
            }
            return null;
        }

        @Override
        protected void done() {
            if (this.isCancelled()) {
                return;
            }
            if (this.imagePath != null) {
                ActorImageLabel.this.setImagePath(this.imagePath.toString());
            } else if (StringUtils.isNotBlank((CharSequence)this.actor.getThumbUrl())) {
                ActorImageLabel.this.setImageUrl(this.actor.getThumbUrl());
            } else {
                ActorImageLabel.this.clearImage();
            }
        }
    }
}

