/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;

public class EnhancedTextField
extends JTextField
implements FocusListener {
    private static final long serialVersionUID = 5397356153111919435L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    protected JLabel lblIcon;
    private String textWhenNotFocused;
    private Insets dummyInsets;

    public EnhancedTextField() {
        this(null, null);
    }

    public EnhancedTextField(String textWhenNotFocused) {
        this(textWhenNotFocused, null);
    }

    public EnhancedTextField(Icon icon) {
        this(null, icon);
    }

    public EnhancedTextField(String textWhenNotFocused, Icon icon) {
        if (icon != null) {
            this.setLayout(new BorderLayout());
            this.lblIcon = new JLabel(icon);
            this.add((Component)this.lblIcon, "East");
        }
        this.textWhenNotFocused = textWhenNotFocused != null ? textWhenNotFocused : "";
        if (StringUtils.isNotBlank((CharSequence)textWhenNotFocused)) {
            this.addFocusListener(this);
        }
        Border border = UIManager.getBorder("TextField.border");
        JTextField dummy = new JTextField();
        this.dummyInsets = border.getBorderInsets(dummy);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        int textX = 2;
        this.setMargin(new Insets(2, textX, 2, 2));
        if (!this.hasFocus() && StringUtils.isEmpty((CharSequence)this.getText())) {
            int height = this.getHeight();
            Font prev = g.getFont();
            Font italic = prev.deriveFont(2);
            Color prevColor = g.getColor();
            g.setFont(italic);
            g.setColor(UIManager.getColor("textInactiveText"));
            int h = g.getFontMetrics().getHeight();
            int textBottom = (height - h) / 2 + h - 4;
            int x = this.getInsets().left;
            Graphics2D g2d = (Graphics2D)g;
            RenderingHints hints = g2d.getRenderingHints();
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            g2d.drawString(this.textWhenNotFocused, x, textBottom);
            g2d.setRenderingHints(hints);
            g.setFont(prev);
            g.setColor(prevColor);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.repaint();
    }

    public void setIconToolTipText(String tooltip) {
        if (this.lblIcon != null && StringUtils.isNotBlank((CharSequence)tooltip)) {
            this.lblIcon.setToolTipText(tooltip);
        }
    }

    public void addIconMouseListener(MouseListener mouseListener) {
        if (this.lblIcon != null && mouseListener != null) {
            this.lblIcon.setCursor(Cursor.getPredefinedCursor(12));
            this.lblIcon.addMouseListener(mouseListener);
        }
    }

    public static EnhancedTextField createSearchTextField() {
        final EnhancedTextField textField = new EnhancedTextField(BUNDLE.getString("tmm.searchfield"), IconManager.SEARCH_GREY);
        textField.addIconMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (StringUtils.isNotBlank((CharSequence)textField.getText())) {
                    textField.setText("");
                }
            }
        });
        textField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                this.changeIcon();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                this.changeIcon();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                this.changeIcon();
            }

            private void changeIcon() {
                if (StringUtils.isBlank((CharSequence)textField.getText())) {
                    textField.lblIcon.setIcon(IconManager.SEARCH_GREY);
                } else {
                    textField.lblIcon.setIcon(IconManager.CLEAR_GREY);
                }
            }
        });
        return textField;
    }
}

