/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import java.awt.Font;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.UIManager;

public class TmmLabel
extends JLabel {
    private double scaleFactor = 1.0;

    public TmmLabel() {
    }

    public TmmLabel(String text) {
        super(text);
    }

    public TmmLabel(String text, double scaleFactor) {
        super(text);
        this.scaleFactor = scaleFactor;
        this.setFont(this.scale(UIManager.getFont("Label.font").deriveFont(1), scaleFactor));
    }

    public TmmLabel(String text, double scaleFactor, boolean drawBorder) {
        super(text);
        this.scaleFactor = scaleFactor;
        this.setFont(this.scale(UIManager.getFont("Label.font").deriveFont(1), scaleFactor));
        if (drawBorder) {
            this.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, this.getForeground()));
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setFont(this.scale(UIManager.getFont("Label.font").deriveFont(1), this.scaleFactor > 0.0 ? this.scaleFactor : 1.0));
    }

    protected Font scale(Font font, double factor) {
        int newSize = Math.round((float)((double)font.getSize() * factor));
        return font.deriveFont((float)newSize);
    }
}

