/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components;

import com.jtattoo.plaf.BaseTitleButton;
import com.jtattoo.plaf.DecorationHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.UIResource;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.ui.MainWindow;

public class TmmWindowDecorationPanel
extends JPanel {
    private static final long serialVersionUID = 2723090799541794214L;
    private Action closeAction;
    private Action iconifyAction;
    private Action restoreAction;
    private Action maximizeAction;
    private JButton iconifyButton;
    private JButton maxButton;
    private JButton closeButton;
    private Icon iconifyIcon;
    private Icon maximizeIcon;
    private Icon minimizeIcon;
    private Icon closeIcon;
    private Window window;
    private WindowListener windowListener;
    private PropertyChangeListener propertyChangeListener;
    private int state;
    private boolean wasMaximized;
    private boolean wasMaximizeError = false;
    private Border rootPaneBorder;

    public TmmWindowDecorationPanel() {
        this.setOpaque(false);
        this.state = -1;
        this.wasMaximized = false;
        this.rootPaneBorder = MainWindow.getActiveInstance().getRootPane().getBorder();
        this.iconifyIcon = UIManager.getIcon("InternalFrame.iconifyIcon");
        this.maximizeIcon = UIManager.getIcon("InternalFrame.maximizeIcon");
        this.minimizeIcon = UIManager.getIcon("InternalFrame.minimizeIcon");
        this.closeIcon = UIManager.getIcon("InternalFrame.closeIcon");
        this.createActions();
        this.createButtons();
        this.setLayout((LayoutManager)new MigLayout("insets 5 3 5 3", "[]", "[]push[]push[]"));
        this.add((Component)this.closeButton, "cell 0 0, center");
        this.add((Component)this.maxButton, "cell 0 1, center");
        this.add((Component)this.iconifyButton, "cell 0 2, center");
    }

    public void iconify() {
        Frame frame = this.getFrame();
        if (frame != null) {
            if (JTattooUtilities.isMac() && JTattooUtilities.getJavaVersion() >= 1.7) {
                DecorationHelper.setExtendedState((Frame)frame, (int)(this.state & 0xFFFFFFF9 | 1));
            } else {
                DecorationHelper.setExtendedState((Frame)frame, (int)(this.state | 1));
            }
        }
    }

    public void maximize() {
        Frame frame = this.getFrame();
        if (frame != null) {
            PropertyChangeListener[] pcl;
            this.validateMaximizedBounds();
            for (PropertyChangeListener aPcl1 : pcl = frame.getPropertyChangeListeners()) {
                aPcl1.propertyChange(new PropertyChangeEvent(this, "windowMaximize", Boolean.FALSE, Boolean.FALSE));
            }
            DecorationHelper.setExtendedState((Frame)frame, (int)(this.state | 6));
            for (PropertyChangeListener aPcl : pcl) {
                aPcl.propertyChange(new PropertyChangeEvent(this, "windowMaximized", Boolean.FALSE, Boolean.FALSE));
            }
        }
    }

    public void restore() {
        Frame frame = this.getFrame();
        if (frame != null) {
            PropertyChangeListener[] pcl;
            this.wasMaximizeError = false;
            for (PropertyChangeListener aPcl1 : pcl = frame.getPropertyChangeListeners()) {
                aPcl1.propertyChange(new PropertyChangeEvent(this, "windowRestore", Boolean.FALSE, Boolean.FALSE));
            }
            if ((this.state & 1) != 0) {
                DecorationHelper.setExtendedState((Frame)frame, (int)(this.state & 0xFFFFFFFE));
            } else {
                DecorationHelper.setExtendedState((Frame)frame, (int)(this.state & 0xFFFFFFF9));
            }
            for (PropertyChangeListener aPcl : pcl) {
                aPcl.propertyChange(new PropertyChangeEvent(this, "windowRestored", Boolean.FALSE, Boolean.FALSE));
            }
        }
    }

    public void close() {
        if (this.window != null) {
            this.window.dispatchEvent(new WindowEvent(this.window, 201));
        }
    }

    private Frame getFrame() {
        return MainWindow.getActiveInstance();
    }

    private void validateMaximizedBounds() {
        Frame frame = this.getFrame();
        if (frame != null && !this.wasMaximizeError) {
            GraphicsConfiguration gc = frame.getGraphicsConfiguration();
            Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
            Rectangle maxBounds = gc.getBounds();
            maxBounds.x = Math.max(0, screenInsets.left);
            maxBounds.y = Math.max(0, screenInsets.top);
            maxBounds.width -= screenInsets.left + screenInsets.right;
            maxBounds.height -= screenInsets.top + screenInsets.bottom;
            frame.setMaximizedBounds(maxBounds);
        }
    }

    private void createActions() {
        this.closeAction = new CloseAction();
        this.iconifyAction = new IconifyAction();
        this.restoreAction = new RestoreAction();
        this.maximizeAction = new MaximizeAction();
    }

    public void createButtons() {
        this.closeButton = new BaseTitleButton(this.closeAction, "Close", this.closeIcon, 1.0f);
        this.closeButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.maxButton = new BaseTitleButton(this.restoreAction, "Maximize", this.maximizeIcon, 1.0f);
        this.maxButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.iconifyButton = new BaseTitleButton(this.iconifyAction, "Iconify", this.iconifyIcon, 1.0f);
        this.iconifyButton.setBorder(new EmptyBorder(0, 0, 0, 0));
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.uninstallListeners();
        this.window = SwingUtilities.getWindowAncestor(this);
        if (this.window != null) {
            if (this.window instanceof Frame) {
                this.setState(DecorationHelper.getExtendedState((Frame)((Frame)this.window)));
            } else {
                this.setState(0);
            }
            this.setActive(JTattooUtilities.isWindowActive((Window)this.window));
            this.installListeners();
        }
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.uninstallListeners();
        this.window = null;
    }

    private void installListeners() {
        if (this.window != null) {
            this.windowListener = this.createWindowListener();
            this.window.addWindowListener(this.windowListener);
            this.propertyChangeListener = this.createWindowPropertyChangeListener();
            this.window.addPropertyChangeListener(this.propertyChangeListener);
        }
    }

    private void uninstallListeners() {
        if (this.window != null) {
            this.window.removeWindowListener(this.windowListener);
            this.window.removePropertyChangeListener(this.propertyChangeListener);
        }
    }

    private WindowListener createWindowListener() {
        return new WindowHandler();
    }

    private PropertyChangeListener createWindowPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    private void setActive(boolean flag) {
        if (this.getWindowDecorationStyle() == 1) {
            Boolean active = flag ? Boolean.TRUE : Boolean.FALSE;
            this.iconifyButton.putClientProperty("paintActive", active);
            this.closeButton.putClientProperty("paintActive", active);
            this.maxButton.putClientProperty("paintActive", active);
        }
        this.getRootPane().repaint();
    }

    private int getWindowDecorationStyle() {
        return DecorationHelper.getWindowDecorationStyle((JRootPane)this.getRootPane());
    }

    private void setState(int state) {
        this.setState(state, false);
    }

    private void setState(int state, boolean updateRegardless) {
        if (this.window != null && this.getWindowDecorationStyle() == 1) {
            if (this.state == state && !updateRegardless) {
                return;
            }
            Frame frame = this.getFrame();
            if (frame != null) {
                if ((state & 6) != 0 && (this.getRootPane().getBorder() == null || this.getRootPane().getBorder() instanceof UIResource) && frame.isShowing()) {
                    this.getRootPane().setBorder(null);
                }
                if (frame.isResizable()) {
                    if ((state & 6) != 0) {
                        this.updateMaxButton(this.restoreAction, this.minimizeIcon);
                        this.maximizeAction.setEnabled(false);
                        this.restoreAction.setEnabled(true);
                    } else {
                        this.updateMaxButton(this.maximizeAction, this.maximizeIcon);
                        this.maximizeAction.setEnabled(true);
                        this.restoreAction.setEnabled(false);
                    }
                    if (this.maxButton.getParent() == null || this.iconifyButton.getParent() == null) {
                        this.add(this.maxButton);
                        this.add(this.iconifyButton);
                        this.revalidate();
                        this.repaint();
                    }
                    this.maxButton.setText(null);
                } else {
                    this.maximizeAction.setEnabled(false);
                    this.restoreAction.setEnabled(false);
                    if (this.maxButton.getParent() != null) {
                        this.remove(this.maxButton);
                        this.revalidate();
                        this.repaint();
                    }
                }
                if ((state & 6) != 0) {
                    this.validateMaximizedBounds();
                    this.getRootPane().setBorder(null);
                    SwingUtilities.invokeLater(() -> {
                        GraphicsConfiguration gc = frame.getGraphicsConfiguration();
                        Insets screenInsets = Toolkit.getDefaultToolkit().getScreenInsets(gc);
                        Rectangle maxBounds = gc.getBounds();
                        maxBounds.width -= screenInsets.left + screenInsets.right;
                        maxBounds.height -= screenInsets.top + screenInsets.bottom;
                        if (frame.getWidth() != maxBounds.width || frame.getHeight() != maxBounds.height) {
                            this.restore();
                            this.wasMaximizeError = true;
                            frame.setMaximizedBounds(null);
                            this.maximize();
                        }
                    });
                }
            } else {
                this.maximizeAction.setEnabled(false);
                this.restoreAction.setEnabled(false);
                this.iconifyAction.setEnabled(false);
                this.remove(this.maxButton);
                this.remove(this.iconifyButton);
                this.revalidate();
                this.repaint();
            }
            this.closeAction.setEnabled(true);
            this.state = state;
        }
    }

    private void updateMaxButton(Action action, Icon icon) {
        this.maxButton.setAction(action);
        this.maxButton.setIcon(icon);
    }

    public void triggerMaxButton() {
        this.maxButton.getAction().actionPerformed(new ActionEvent(this, 1001, null));
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.getFrame() != null) {
            this.setState(DecorationHelper.getExtendedState((Frame)this.getFrame()));
        }
    }

    private class WindowHandler
    extends WindowAdapter {
        private WindowHandler() {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
            if (JTattooUtilities.isMac() && JTattooUtilities.getJavaVersion() >= 1.7 && TmmWindowDecorationPanel.this.wasMaximized) {
                SwingUtilities.invokeLater(TmmWindowDecorationPanel.this::maximize);
            }
        }

        @Override
        public void windowActivated(WindowEvent ev) {
            TmmWindowDecorationPanel.this.setActive(true);
        }

        @Override
        public void windowDeactivated(WindowEvent ev) {
            TmmWindowDecorationPanel.this.setActive(false);
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent pce) {
            String name = pce.getPropertyName();
            if ("resizable".equals(name) || "state".equals(name)) {
                Frame frame = TmmWindowDecorationPanel.this.getFrame();
                if (frame != null) {
                    TmmWindowDecorationPanel.this.setState(DecorationHelper.getExtendedState((Frame)frame), true);
                }
                if ("resizable".equals(name)) {
                    TmmWindowDecorationPanel.this.getRootPane().repaint();
                }
            } else if ("title".equals(name)) {
                TmmWindowDecorationPanel.this.repaint();
            } else if ("componentOrientation".equals(name)) {
                TmmWindowDecorationPanel.this.revalidate();
                TmmWindowDecorationPanel.this.repaint();
            }
            if ("windowRestored".equals(name)) {
                TmmWindowDecorationPanel.this.wasMaximized = false;
            } else if ("windowMaximized".equals(name)) {
                TmmWindowDecorationPanel.this.wasMaximized = true;
            }
            if ("windowRestore".equals(name)) {
                TmmWindowDecorationPanel.this.getRootPane().setBorder(TmmWindowDecorationPanel.this.rootPaneBorder);
            }
        }
    }

    private class MaximizeAction
    extends AbstractAction {
        private static final long serialVersionUID = -1988007147862446193L;

        public MaximizeAction() {
            super(UIManager.getString("MetalTitlePane.maximizeTitle"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TmmWindowDecorationPanel.this.maximize();
        }
    }

    private class RestoreAction
    extends AbstractAction {
        private static final long serialVersionUID = 1080414069482732579L;

        public RestoreAction() {
            super(UIManager.getString("MetalTitlePane.restoreTitle"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TmmWindowDecorationPanel.this.restore();
        }
    }

    private class IconifyAction
    extends AbstractAction {
        private static final long serialVersionUID = 7682300139513319195L;

        public IconifyAction() {
            super(UIManager.getString("MetalTitlePane.iconifyTitle"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TmmWindowDecorationPanel.this.iconify();
        }
    }

    private class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = 3463634837846413651L;

        public CloseAction() {
            super(UIManager.getString("MetalTitlePane.closeTitle"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TmmWindowDecorationPanel.this.close();
        }
    }
}

