/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.combobox;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import javax.swing.JComboBox;

public class AutocompleteComboBox<E>
extends JComboBox<E> {
    private static final long serialVersionUID = 6366300597464784607L;
    private EventList<E> items;
    private AutoCompleteSupport<E> autoCompleteSupport;

    public AutocompleteComboBox(Collection<E> items) {
        this.items = new BasicEventList();
        this.items.addAll(items);
        this.init();
    }

    public AutocompleteComboBox(E[] items) {
        this.items = GlazedLists.eventListOf((Object[])items);
        this.init();
    }

    private void init() {
        this.setEditable(true);
        this.autoCompleteSupport = AutoCompleteSupport.install((JComboBox)this, this.items);
        this.getEditor().getEditorComponent().addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                AutocompleteComboBox.this.repaint();
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
    }

    public AutoCompleteSupport<E> getAutoCompleteSupport() {
        return this.autoCompleteSupport;
    }
}

