/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.combobox;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.combobox.TmmCheckComboBoxItem;
import org.tinymediamanager.ui.components.combobox.TmmCheckComboBoxSelectionListener;

public class TmmCheckComboBox<E>
extends JComboBox<TmmCheckComboBoxItem<E>> {
    private static final long serialVersionUID = -7796247854176782396L;
    protected static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    protected List<TmmCheckComboBoxItem<E>> checkBoxes;
    protected Map<E, Boolean> selectedItems;
    protected List<TmmCheckComboBoxSelectionListener> changedListeners = new Vector<TmmCheckComboBoxSelectionListener>();
    protected Object nullObject = new Object();

    public TmmCheckComboBox() {
        this(new HashSet(), false);
    }

    public TmmCheckComboBox(List<E> items) {
        this(new LinkedHashSet<E>(items), false);
    }

    public TmmCheckComboBox(Set<E> items) {
        this(items, false);
    }

    public TmmCheckComboBox(E[] items) {
        this(new LinkedHashSet<E>(Arrays.asList(items)), false);
    }

    public void setItems(List<E> items) {
        this.resetObjs(new LinkedHashSet<E>(items), false);
    }

    protected TmmCheckComboBox(Set<E> objs, boolean selected) {
        this.resetObjs(objs, selected);
    }

    public void addSelectionChangedListener(TmmCheckComboBoxSelectionListener listener) {
        if (listener == null) {
            return;
        }
        this.changedListeners.add(listener);
    }

    public void removeSelectionChangedListener(TmmCheckComboBoxSelectionListener listener) {
        this.changedListeners.remove(listener);
    }

    protected void resetObjs(Set<E> items, boolean selected) {
        this.selectedItems = new LinkedHashMap<E, Boolean>();
        for (E item : items) {
            this.selectedItems.put(item, selected);
        }
        this.reset();
    }

    public List<E> getSelectedItems() {
        LinkedHashSet<E> ret = new LinkedHashSet<E>();
        for (Map.Entry<E, Boolean> entry : this.selectedItems.entrySet()) {
            E obj = entry.getKey();
            Boolean selected = entry.getValue();
            if (!selected.booleanValue()) continue;
            ret.add(obj);
        }
        return new ArrayList(ret);
    }

    public void setSelectedItems(Collection<E> items) {
        if (items == null) {
            return;
        }
        for (E item : items) {
            if (!this.selectedItems.containsKey(item)) continue;
            this.selectedItems.put(item, true);
        }
        this.reset();
        this.repaint();
    }

    public void setSelectedItems(E[] items) {
        this.setSelectedItems(Arrays.asList(items));
    }

    protected void reset() {
        this.removeAllItems();
        this.initCheckBoxes();
        this.addItem(new TmmCheckComboBoxItem(""));
        for (TmmCheckComboBoxItem<E> checkBox : this.checkBoxes) {
            this.addItem(checkBox);
        }
        this.setRenderer();
        this.addActionListener(this);
    }

    protected void setRenderer() {
        this.setRenderer(new CheckBoxRenderer(this.checkBoxes));
    }

    protected void initCheckBoxes() {
        TmmCheckComboBoxItem cb;
        this.checkBoxes = new Vector<TmmCheckComboBoxItem<E>>();
        boolean selectedAll = true;
        boolean selectedNone = true;
        for (Map.Entry<E, Boolean> entry : this.selectedItems.entrySet()) {
            E obj = entry.getKey();
            Boolean selected = entry.getValue();
            if (selected.booleanValue()) {
                selectedNone = false;
            } else {
                selectedAll = false;
            }
            cb = new TmmCheckComboBoxItem<E>(obj);
            cb.setSelected(selected);
            this.checkBoxes.add(cb);
        }
        cb = new TmmCheckComboBoxItem(BUNDLE.getString("Button.selectall"));
        cb.setSelected(selectedAll);
        this.checkBoxes.add(cb);
        cb = new TmmCheckComboBoxItem(BUNDLE.getString("Button.selectnone"));
        cb.setSelected(selectedNone);
        this.checkBoxes.add(cb);
    }

    protected void checkBoxSelectionChanged(int index) {
        int n = this.checkBoxes.size();
        if (index < 0 || index >= n) {
            return;
        }
        if (index < n - 2) {
            TmmCheckComboBoxItem<E> cb = this.checkBoxes.get(index);
            if (cb.getUserObject() == this.nullObject) {
                return;
            }
            if (cb.isSelected()) {
                cb.setSelected(false);
                this.selectedItems.put(cb.getUserObject(), false);
                this.checkBoxes.get(n - 2).setSelected(false);
                this.checkBoxes.get(n - 1).setSelected(this.getSelectedItems() == null);
            } else {
                cb.setSelected(true);
                this.selectedItems.put(cb.getUserObject(), true);
                List<E> sobjs = this.getSelectedItems();
                this.checkBoxes.get(n - 2).setSelected(sobjs != null && sobjs.size() == n - 2);
                this.checkBoxes.get(n - 1).setSelected(false);
            }
        } else if (index == n - 2) {
            for (E obj : this.selectedItems.keySet()) {
                if (obj == this.nullObject) continue;
                this.selectedItems.put(obj, true);
            }
            for (int i = 0; i < n - 1; ++i) {
                if (this.checkBoxes.get(i) == this.nullObject) continue;
                this.checkBoxes.get(i).setSelected(true);
            }
            this.checkBoxes.get(n - 1).setSelected(false);
        } else {
            for (E obj : this.selectedItems.keySet()) {
                this.selectedItems.put(obj, false);
            }
            for (int i = 0; i < n - 1; ++i) {
                this.checkBoxes.get(i).setSelected(false);
            }
            this.checkBoxes.get(n - 1).setSelected(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int sel = this.getSelectedIndex();
        if (sel == 0) {
            this.getUI().setPopupVisible(this, false);
        } else if (sel > 0) {
            this.checkBoxSelectionChanged(sel - 1);
            for (TmmCheckComboBoxSelectionListener listener : this.changedListeners) {
                listener.selectionChanged(sel - 1);
            }
        }
        this.setSelectedIndex(-1);
    }

    @Override
    public void setPopupVisible(boolean flag) {
    }

    protected class CheckBoxRenderer
    implements ListCellRenderer<TmmCheckComboBoxItem<E>> {
        protected final DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
        protected JSeparator separator;
        protected final List<TmmCheckComboBoxItem<E>> checkBoxes;

        public CheckBoxRenderer(List<TmmCheckComboBoxItem<E>> items) {
            this.checkBoxes = items;
            this.separator = new JSeparator(0);
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends TmmCheckComboBoxItem<E>> list, TmmCheckComboBoxItem<E> value, int index, boolean isSelected, boolean cellHasFocus) {
            String str;
            if (index > 0 && index <= this.checkBoxes.size()) {
                TmmCheckComboBoxItem cb = this.checkBoxes.get(index - 1);
                if (cb.getUserObject() == TmmCheckComboBox.this.nullObject) {
                    list.setToolTipText(null);
                    return this.separator;
                }
                if (isSelected) {
                    cb.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
                    cb.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
                    list.setToolTipText(this.checkBoxes.get(index - 1).getText());
                } else {
                    cb.setBackground(UIManager.getColor("ComboBox.background"));
                    cb.setForeground(UIManager.getColor("ComboBox.foreground"));
                }
                return cb;
            }
            list.setToolTipText(null);
            List objs = TmmCheckComboBox.this.getSelectedItems();
            Vector<String> strs = new Vector<String>();
            if (objs.isEmpty()) {
                str = "[] / " + BUNDLE.getString("ComboBox.select");
            } else {
                for (Object obj : objs) {
                    strs.add(obj.toString());
                }
                str = strs.toString();
            }
            return this.defaultRenderer.getListCellRendererComponent((JList<?>)list, str, index, isSelected, cellHasFocus);
        }
    }
}

