/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.treetable;

import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.Border;
import javax.swing.event.TreeModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.AbstractSettings;
import org.tinymediamanager.ui.ITmmUIFilter;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.tree.ITmmTreeFilter;
import org.tinymediamanager.ui.components.tree.TmmTreeDataProvider;
import org.tinymediamanager.ui.components.tree.TmmTreeModel;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.treetable.ConnectorTableModel;
import org.tinymediamanager.ui.components.treetable.ITmmTreeTableModel;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableCellRenderer;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableCheckRenderDataProvider;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableModel;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableRenderDataProvider;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableTreePathSupport;
import org.tinymediamanager.ui.tvshows.TvShowTreeCellRenderer;

public class TmmTreeTable
extends TmmTable {
    protected TmmTreeTableRenderDataProvider renderDataProvider = null;
    protected int selectedRow = -1;
    protected Boolean cachedRootVisible = true;
    protected Set<ITmmTreeFilter<TmmTreeNode>> treeFilters = new CopyOnWriteArraySet<ITmmTreeFilter<TmmTreeNode>>();
    protected ITmmTreeTableModel treeTableModel;
    protected PropertyChangeListener filterChangeListener;
    private int[] lastEditPosition;

    public TmmTreeTable(TmmTreeDataProvider<? extends TmmTreeNode> dataProvider, TmmTableFormat tableFormat) {
        this.treeTableModel = new TmmTreeTableModel(new TmmTreeModelConnector<TmmTreeNode>(dataProvider), tableFormat);
        ((TmmTreeModel)this.treeTableModel.getTreeModel()).getDataProvider().setTreeFilters(this.treeFilters);
        this.filterChangeListener = evt -> this.updateFiltering();
        this.setModel(this.treeTableModel);
        this.initTreeTable();
    }

    @Override
    public void addColumn(TableColumn aColumn) {
        if (aColumn.getIdentifier() == null && this.getModel() instanceof TmmTreeTableModel) {
            aColumn.setHeaderRenderer(new TmmTable.BottomBorderHeaderRenderer());
            TmmTreeTableModel tableModel = (TmmTreeTableModel)this.getModel();
            tableModel.setUpColumn(aColumn);
        }
        super.addColumn(aColumn);
    }

    protected void initTreeTable() {
        this.getColumnModel().getColumn(0).setCellRenderer(new TvShowTreeCellRenderer());
        this.getSelectionModel().addListSelectionListener(e -> {
            this.selectedRow = this.getSelectedRowCount() == 1 ? this.getSelectedRow() : -1;
        });
        this.setTableHeader(this.createTableHeader());
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setOpaque(false);
        this.setOpaque(false);
        this.setShowGrid(false);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        TableColumn tableColumn;
        TableCellRenderer renderer;
        int c = this.convertColumnIndexToModel(column);
        TableCellRenderer result = c == 0 ? ((renderer = (tableColumn = this.getColumnModel().getColumn(column)).getCellRenderer()) == null ? this.getDefaultRenderer(Object.class) : renderer) : super.getCellRenderer(row, column);
        return result;
    }

    public TmmTreeTableRenderDataProvider getRenderDataProvider() {
        return this.renderDataProvider;
    }

    public void setRenderDataProvider(TmmTreeTableRenderDataProvider provider) {
        if (provider != this.renderDataProvider) {
            TmmTreeTableRenderDataProvider old = this.renderDataProvider;
            this.renderDataProvider = provider;
            this.firePropertyChange("renderDataProvider", old, provider);
        }
    }

    TmmTreeTableTreePathSupport getTreePathSupport() {
        TmmTreeTableModel mdl = this.getTreeTableModel();
        if (mdl != null) {
            return mdl.getTreePathSupport();
        }
        return null;
    }

    public TmmTreeTableModel getTreeTableModel() {
        TableModel mdl = this.getModel();
        if (mdl instanceof TmmTreeTableModel) {
            return (TmmTreeTableModel)this.getModel();
        }
        return null;
    }

    public void expandRow(int row) {
        this.expandPath(this.treeTableModel.getLayout().getPathForRow(row));
    }

    public void collapseRow(int row) {
        this.collapsePath(this.treeTableModel.getLayout().getPathForRow(row));
    }

    public void expandPath(TreePath path) {
        this.getTreePathSupport().expandPath(path);
    }

    public boolean isExpanded(TreePath path) {
        return this.getTreePathSupport().isExpanded(path);
    }

    public void collapsePath(TreePath path) {
        this.getTreePathSupport().collapsePath(path);
    }

    boolean isTreeColumnIndex(int column) {
        int columnIndex = this.convertColumnIndexToModel(column);
        return columnIndex == 0;
    }

    public final AbstractLayoutCache getLayoutCache() {
        TmmTreeTableModel model = this.getTreeTableModel();
        if (model != null) {
            return model.getLayout();
        }
        return null;
    }

    public void setRootVisible(boolean val) {
        AbstractLayoutCache layoutCache;
        if (this.getTreeTableModel() == null) {
            this.cachedRootVisible = val;
        }
        if (val != this.isRootVisible() && (layoutCache = this.getLayoutCache()) != null) {
            TreePath rootPath;
            layoutCache.setRootVisible(val);
            if (layoutCache.getRowCount() > 0 && null != (rootPath = layoutCache.getPathForRow(0))) {
                layoutCache.treeStructureChanged(new TreeModelEvent((Object)this, rootPath));
            }
            this.firePropertyChange("rootVisible", !val, val);
        }
    }

    public boolean isRootVisible() {
        if (this.getLayoutCache() == null) {
            return this.cachedRootVisible;
        }
        return this.getLayoutCache().isRootVisible();
    }

    @Override
    public boolean editCellAt(int row, int column, EventObject e) {
        boolean isTreeColumn = this.isTreeColumnIndex(column);
        if (isTreeColumn && e instanceof MouseEvent) {
            MouseEvent me = (MouseEvent)e;
            AbstractLayoutCache layoutCache = this.getLayoutCache();
            if (layoutCache != null) {
                TreePath path = layoutCache.getPathForRow(this.convertRowIndexToModel(row));
                if (path != null && !this.getTreeTableModel().isLeaf(path.getLastPathComponent())) {
                    int handleWidth = TmmTreeTableCellRenderer.getExpansionHandleWidth();
                    Insets ins = this.getInsets();
                    int nd = path.getPathCount() - (this.isRootVisible() ? 1 : 2);
                    if (nd < 0) {
                        nd = 0;
                    }
                    int handleStart = ins.left + nd * TmmTreeTableCellRenderer.getNestingWidth();
                    int handleEnd = ins.left + handleStart + handleWidth;
                    int columnStart = this.getCellRect((int)row, (int)column, (boolean)false).x;
                    TableColumn tableColumn = this.getColumnModel().getColumn(column);
                    TableCellEditor columnCellEditor = tableColumn.getCellEditor();
                    if (me.getX() > ins.left && me.getX() >= (handleStart += columnStart) && me.getX() <= (handleEnd += columnStart) || me.getClickCount() > 1 && columnCellEditor == null) {
                        boolean expanded = layoutCache.isExpanded(path);
                        if (!expanded) {
                            this.getTreePathSupport().expandPath(path);
                            Object ourObject = path.getLastPathComponent();
                            int cCount = this.getTreeTableModel().getChildCount(ourObject);
                            if (cCount > 0) {
                                int lastRow = row;
                                for (int i = 0; i < cCount; ++i) {
                                    Object child = this.getTreeTableModel().getChild(ourObject, i);
                                    TreePath childPath = path.pathByAddingChild(child);
                                    int childRow = layoutCache.getRowForPath(childPath);
                                    if ((childRow = this.convertRowIndexToView(childRow)) <= lastRow) continue;
                                    lastRow = childRow;
                                }
                                int firstRow = row;
                                Rectangle rectLast = this.getCellRect(lastRow, 0, true);
                                Rectangle rectFirst = this.getCellRect(firstRow, 0, true);
                                Rectangle rectFull = new Rectangle(rectFirst.x, rectFirst.y, rectLast.x + rectLast.width - rectFirst.x, rectLast.y + rectLast.height - rectFirst.y);
                                this.scrollRectToVisible(rectFull);
                            }
                        } else {
                            this.getTreePathSupport().collapsePath(path);
                        }
                        return false;
                    }
                }
                if (this.checkAt(row, column, me)) {
                    return false;
                }
            }
        }
        boolean res = false;
        if (!isTreeColumn || e instanceof MouseEvent && row >= 0 && this.isEditEvent(row, column, (MouseEvent)e)) {
            res = super.editCellAt(row, column, e);
        }
        if (res && isTreeColumn && row >= 0 && null != this.getEditorComponent()) {
            this.configureTreeCellEditor(this.getEditorComponent(), row, column);
        }
        if (e == null && !res && isTreeColumn) {
            this.checkAt(row, column, null);
        }
        return res;
    }

    private boolean isEditEvent(int row, int column, MouseEvent me) {
        boolean noModifiers;
        if (me.getClickCount() > 1) {
            return true;
        }
        boolean bl = noModifiers = me.getModifiersEx() == 1024;
        if (this.lastEditPosition != null && this.selectedRow == row && noModifiers && this.lastEditPosition[0] == row && this.lastEditPosition[1] == column) {
            int handleWidth = TmmTreeTableCellRenderer.getExpansionHandleWidth();
            Insets ins = this.getInsets();
            AbstractLayoutCache layoutCache = this.getLayoutCache();
            if (layoutCache != null) {
                TreePath path = layoutCache.getPathForRow(this.convertRowIndexToModel(row));
                int nd = path.getPathCount() - (this.isRootVisible() ? 1 : 2);
                if (nd < 0) {
                    nd = 0;
                }
                int handleStart = ins.left + nd * TmmTreeTableCellRenderer.getNestingWidth();
                int handleEnd = ins.left + handleStart + handleWidth;
                int columnStart = this.getCellRect((int)row, (int)column, (boolean)false).x;
                handleStart += columnStart;
                if (me.getX() >= (handleEnd += columnStart)) {
                    this.lastEditPosition = null;
                    return true;
                }
            }
        }
        this.lastEditPosition = new int[]{row, column};
        return false;
    }

    protected final boolean checkAt(int row, int column, MouseEvent me) {
        TmmTreeTableRenderDataProvider render = this.getRenderDataProvider();
        TableCellRenderer tcr = this.getDefaultRenderer(Object.class);
        if (render instanceof TmmTreeTableCheckRenderDataProvider && tcr instanceof TmmTreeTableCellRenderer) {
            TmmTreeTableCheckRenderDataProvider crender = (TmmTreeTableCheckRenderDataProvider)render;
            TmmTreeTableCellRenderer ocr = (TmmTreeTableCellRenderer)tcr;
            Object value = this.getValueAt(row, column);
            if (value != null && crender.isCheckable(value) && crender.isCheckEnabled(value)) {
                boolean chBoxPosition = false;
                if (me == null) {
                    chBoxPosition = true;
                } else {
                    int handleWidth = TmmTreeTableCellRenderer.getExpansionHandleWidth();
                    int chWidth = ocr.getTheCheckBoxWidth();
                    Insets ins = this.getInsets();
                    AbstractLayoutCache layoutCache = this.getLayoutCache();
                    if (layoutCache != null) {
                        TreePath path = layoutCache.getPathForRow(this.convertRowIndexToModel(row));
                        int nd = path.getPathCount() - (this.isRootVisible() ? 1 : 2);
                        if (nd < 0) {
                            nd = 0;
                        }
                        int chStart = ins.left + nd * TmmTreeTableCellRenderer.getNestingWidth() + handleWidth;
                        int chEnd = chStart + chWidth;
                        boolean bl = chBoxPosition = me.getX() > ins.left && me.getX() >= chStart && me.getX() <= chEnd;
                    }
                }
                if (chBoxPosition) {
                    Boolean selected = crender.isSelected(value);
                    if (selected == null || Boolean.TRUE.equals(selected)) {
                        crender.setSelected(value, Boolean.FALSE);
                    } else {
                        crender.setSelected(value, Boolean.TRUE);
                    }
                    Rectangle r = this.getCellRect(row, column, true);
                    this.repaint(r.x, r.y, r.width, r.height);
                    return true;
                }
            }
        }
        return false;
    }

    protected void configureTreeCellEditor(Component editor, int row, int column) {
        if (!(editor instanceof JComponent)) {
            return;
        }
        TreeCellEditorBorder b = new TreeCellEditorBorder();
        AbstractLayoutCache layoutCache = this.getLayoutCache();
        if (layoutCache != null) {
            TreePath path = layoutCache.getPathForRow(this.convertRowIndexToModel(row));
            Object o = this.getValueAt(row, column);
            TmmTreeTableRenderDataProvider rdp = this.getRenderDataProvider();
            TableCellRenderer tcr = this.getDefaultRenderer(Object.class);
            if (rdp instanceof TmmTreeTableCheckRenderDataProvider && tcr instanceof TmmTreeTableCellRenderer) {
                TmmTreeTableCheckRenderDataProvider crender = (TmmTreeTableCheckRenderDataProvider)rdp;
                TmmTreeTableCellRenderer ocr = (TmmTreeTableCellRenderer)tcr;
                Object value = this.getValueAt(row, column);
                if (value != null && crender.isCheckable(value) && crender.isCheckEnabled(value)) {
                    b.checkWidth = ocr.getTheCheckBoxWidth();
                    b.checkBox = ocr.setUpCheckBox(crender, value, ocr.createCheckBox());
                }
            }
            b.icon = rdp.getIcon(o);
            b.nestingDepth = Math.max(0, path.getPathCount() - (this.isRootVisible() ? 1 : 2));
            b.isLeaf = this.getTreeTableModel().isLeaf(o);
            b.isExpanded = layoutCache.isExpanded(path);
            ((JComponent)editor).setBorder(b);
        }
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.calcRowHeight();
    }

    private void calcRowHeight() {
        int rHeight = 20;
        Font f = this.getFont();
        FontMetrics fm = this.getFontMetrics(f);
        int h = Math.max(fm.getHeight() + fm.getMaxDescent(), TmmTreeTableCellRenderer.getExpansionHandleHeight());
        rHeight = Math.max(rHeight, h) + 2;
        this.setRowHeight(rHeight);
    }

    public List<ITmmTreeFilter<TmmTreeNode>> getFilters() {
        return new ArrayList<ITmmTreeFilter<TmmTreeNode>>(this.treeFilters);
    }

    public void clearFilter() {
        for (ITmmTreeFilter<TmmTreeNode> filter : this.treeFilters) {
            filter.removePropertyChangeListener(this.filterChangeListener);
        }
        this.treeFilters.clear();
    }

    public void addFilter(ITmmTreeFilter<TmmTreeNode> newFilter) {
        newFilter.addPropertyChangeListener("treeFilterChanged", this.filterChangeListener);
        this.treeFilters.add(newFilter);
    }

    public void removeFilter(ITmmTreeFilter filter) {
        filter.removePropertyChangeListener(this.filterChangeListener);
        this.treeFilters.remove(filter);
    }

    void updateFiltering() {
        TreeModel model = this.treeTableModel.getTreeModel();
        if (model instanceof TmmTreeModel) {
            ((TmmTreeModel)model).updateSortingAndFiltering();
        }
        this.storeFilters();
        this.firePropertyChange("filterChanged", null, this.treeFilters);
    }

    public void setFilterValues(List<AbstractSettings.UIFilters> values) {
        boolean fireFilterChanged = false;
        for (AbstractSettings.UIFilters uiFilters : values) {
            if (StringUtils.isBlank((CharSequence)uiFilters.id) || uiFilters.state == ITmmUIFilter.FilterState.INACTIVE) continue;
            for (ITmmTreeFilter<TmmTreeNode> filter : this.treeFilters) {
                ITmmUIFilter uiFilter;
                if (!(filter instanceof ITmmUIFilter) || !(uiFilter = (ITmmUIFilter)((Object)filter)).getId().equals(uiFilters.id)) continue;
                uiFilter.setFilterState(uiFilters.state);
                uiFilter.setFilterValue(uiFilters.filterValue);
                fireFilterChanged = true;
            }
        }
        if (fireFilterChanged) {
            this.updateFiltering();
        }
    }

    public void storeFilters() {
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        if (!(this.getModel() instanceof TmmTreeTableModel)) {
            return null;
        }
        Point p = e.getPoint();
        int rowIndex = this.rowAtPoint(p);
        int colIndex = this.columnAtPoint(p);
        int realColumnIndex = this.convertColumnIndexToModel(colIndex) - 1;
        if (colIndex == 0) {
            return super.getToolTipText(e);
        }
        if (colIndex > 0) {
            TmmTreeTableModel treeTableModel = (TmmTreeTableModel)this.getModel();
            ConnectorTableModel tableModel = treeTableModel.getTableModel();
            return tableModel.getTooltipAt(rowIndex, realColumnIndex);
        }
        return null;
    }

    private class TmmTreeModelConnector<E extends TmmTreeNode>
    extends TmmTreeModel {
        public TmmTreeModelConnector(TmmTreeDataProvider<E> dataProvider) {
            super(null, dataProvider);
        }

        public void updateSortingAndFiltering(TmmTreeNode parent) {
            int[] selectedRows = TmmTreeTable.this.getSelectedRows();
            boolean structureChanged = this.performFilteringAndSortingRecursively(parent);
            if (structureChanged) {
                this.nodeStructureChanged((TreeNode)this.getRoot());
                TmmTreeTable.this.clearSelection();
                for (int row : selectedRows) {
                    TmmTreeTable.this.getSelectionModel().addSelectionInterval(row, row);
                }
            }
        }
    }

    private static class TreeCellEditorBorder
    implements Border {
        private Insets insets = new Insets(0, 0, 0, 0);
        private boolean isLeaf;
        private boolean isExpanded;
        private Icon icon;
        private int nestingDepth;
        private final int ICON_TEXT_GAP = new JLabel().getIconTextGap();
        private int checkWidth;
        private JCheckBox checkBox;

        private TreeCellEditorBorder() {
        }

        @Override
        public Insets getBorderInsets(Component c) {
            this.insets.left = this.nestingDepth * TmmTreeTableCellRenderer.getNestingWidth() + TmmTreeTableCellRenderer.getExpansionHandleWidth() + 1;
            this.insets.left = this.insets.left + (this.checkWidth + (this.icon != null ? this.icon.getIconWidth() + this.ICON_TEXT_GAP : 0));
            this.insets.top = 1;
            this.insets.right = 1;
            this.insets.bottom = 1;
            return this.insets;
        }

        @Override
        public boolean isBorderOpaque() {
            return false;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            int iconY;
            int iconX = this.nestingDepth * TmmTreeTableCellRenderer.getNestingWidth();
            if (!this.isLeaf) {
                Icon expIcon = this.isExpanded ? TmmTreeTableCellRenderer.getExpandedIcon() : TmmTreeTableCellRenderer.getCollapsedIcon();
                iconY = expIcon.getIconHeight() < height ? height / 2 - expIcon.getIconHeight() / 2 : 0;
                expIcon.paintIcon(c, g, iconX, iconY);
            }
            iconX += TmmTreeTableCellRenderer.getExpansionHandleWidth() + 1;
            if (null != this.checkBox) {
                Graphics chbg = g.create(iconX, y, this.checkWidth, height);
                this.checkBox.paint(chbg);
                chbg.dispose();
            }
            iconX += this.checkWidth;
            if (null != this.icon) {
                iconY = this.icon.getIconHeight() < height ? height / 2 - this.icon.getIconHeight() / 2 : 0;
                this.icon.paintIcon(c, g, iconX, iconY);
            }
        }
    }
}

