/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.treetable;

import javax.swing.ImageIcon;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.VariableHeightLayoutCache;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.treetable.ConnectorTableModel;
import org.tinymediamanager.ui.components.treetable.ITmmTreeTableModel;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableEventBroadcaster;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableTreePathSupport;

public class TmmTreeTableModel
implements ITmmTreeTableModel {
    private static String NODES_COLUMN_LABEL = "Nodes";
    private TreeModel treeModel;
    private ConnectorTableModel tableModel;
    private AbstractLayoutCache layout;
    private TmmTreeTableEventBroadcaster eventBroadcaster;
    private TmmTreeTableTreePathSupport treePathSupport;

    public TmmTreeTableModel(TreeModel treeModel, TmmTableFormat tableFormat) {
        this.treeModel = treeModel;
        this.tableModel = new ConnectorTableModel(tableFormat, this);
        this.layout = new VariableHeightLayoutCache();
        this.layout.setModel(this);
        this.layout.setRootVisible(true);
        this.treePathSupport = new TmmTreeTableTreePathSupport(this.layout);
        this.eventBroadcaster = new TmmTreeTableEventBroadcaster(this);
        this.treePathSupport.addTreeExpansionListener(this.eventBroadcaster);
        this.treePathSupport.addTreeWillExpandListener(this.eventBroadcaster);
        this.treeModel.addTreeModelListener(this.eventBroadcaster);
    }

    @Override
    public int getRowCount() {
        return this.layout.getRowCount();
    }

    @Override
    public int getColumnCount() {
        return this.tableModel.getColumnCount() + 1;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex == 0) {
            return NODES_COLUMN_LABEL;
        }
        return this.tableModel.getColumnName(columnIndex - 1);
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return Object.class;
        }
        return this.tableModel.getColumnClass(columnIndex - 1);
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return false;
        }
        return this.tableModel.isCellEditable(rowIndex, columnIndex - 1);
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TreePath path;
        Object result = columnIndex == 0 ? ((path = this.layout.getPathForRow(rowIndex)) != null ? path.getLastPathComponent() : null) : this.tableModel.getValueAt(rowIndex, columnIndex - 1);
        return result;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex != 0) {
            this.tableModel.setValueAt(aValue, rowIndex, columnIndex - 1);
        } else {
            this.setTreeValueAt(aValue, rowIndex);
        }
    }

    @Override
    public void addTableModelListener(TableModelListener l) {
        this.eventBroadcaster.addTableModelListener(l);
    }

    @Override
    public void removeTableModelListener(TableModelListener l) {
        this.eventBroadcaster.removeTableModelListener(l);
    }

    @Override
    public Object getRoot() {
        return this.treeModel.getRoot();
    }

    @Override
    public Object getChild(Object parent, int index) {
        return this.treeModel.getChild(parent, index);
    }

    @Override
    public int getChildCount(Object parent) {
        return this.treeModel.getChildCount(parent);
    }

    @Override
    public boolean isLeaf(Object node) {
        return null != node && this.treeModel.isLeaf(node);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        this.treeModel.valueForPathChanged(path, newValue);
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        return this.treeModel.getIndexOfChild(parent, child);
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.eventBroadcaster.addTreeModelListener(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.eventBroadcaster.removeTreeModelListener(l);
    }

    protected void setTreeValueAt(Object aValue, int rowIndex) {
    }

    @Override
    public final TmmTreeTableTreePathSupport getTreePathSupport() {
        return this.treePathSupport;
    }

    @Override
    public final AbstractLayoutCache getLayout() {
        return this.layout;
    }

    @Override
    public TreeModel getTreeModel() {
        return this.treeModel;
    }

    @Override
    public ConnectorTableModel getTableModel() {
        return this.tableModel;
    }

    public void setUpColumn(TableColumn column) {
        ImageIcon headerIcon;
        int columnIndex = column.getModelIndex() - 1;
        if (columnIndex < 0) {
            return;
        }
        TmmTableFormat tmmTableFormat = this.tableModel.getTableFormat();
        column.setIdentifier(tmmTableFormat.getColumnIdentifier(columnIndex));
        TableCellRenderer tableCellRenderer = tmmTableFormat.getCellRenderer(columnIndex);
        if (tableCellRenderer != null) {
            column.setCellRenderer(tableCellRenderer);
        }
        if ((headerIcon = tmmTableFormat.getHeaderIcon(columnIndex)) != null) {
            column.setHeaderValue(headerIcon);
        }
        if (column.getHeaderRenderer() instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)column.getHeaderRenderer()).setToolTipText(tmmTableFormat.getColumnName(columnIndex));
        }
        column.setResizable(tmmTableFormat.getColumnResizeable(columnIndex));
        column.setMinWidth(tmmTableFormat.getMinWidth(columnIndex));
    }
}

