/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.ReleaseInfo;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.images.Logo;

public class AboutDialog
extends TmmDialog {
    private static final long serialVersionUID = 2298570526828925319L;
    private static final Logger LOGGER = LoggerFactory.getLogger(AboutDialog.class);

    public AboutDialog() {
        super(BUNDLE.getString("tmm.about"), "aboutDialog");
        JPanel contentPanel = new JPanel();
        this.getContentPane().add((Component)contentPanel, "Center");
        contentPanel.setLayout((LayoutManager)new MigLayout("", "[][20lp:n][300lp,grow]", "[][10lp:n][][20lp:n][][10lp:n][][][10lp:n][][][][][]"));
        JLabel lblLogo = new JLabel("");
        lblLogo.setIcon(new Logo(96));
        contentPanel.add((Component)lblLogo, "cell 0 0 1 7,alignx left,aligny top");
        JLabel lblTinymediamanager = new JLabel("tinyMediaManager");
        TmmFontHelper.changeFont(lblTinymediamanager, 1.5, 1);
        contentPanel.add((Component)lblTinymediamanager, "cell 2 0,alignx center");
        JLabel lblByManuel = new JLabel("\u00a9 2012 - 2019 by Manuel Laggner");
        contentPanel.add((Component)lblByManuel, "cell 2 2,alignx center");
        JLabel lblVersion = new JLabel(BUNDLE.getString("tmm.version") + ": " + ReleaseInfo.getRealVersion());
        contentPanel.add((Component)lblVersion, "cell 2 4");
        JLabel lblBuild = new JLabel(BUNDLE.getString("tmm.builddate") + ": " + ReleaseInfo.getRealBuildDate());
        contentPanel.add((Component)lblBuild, "cell 2 6");
        JLabel lblHomepage = new JLabel(BUNDLE.getString("tmm.homepage"));
        contentPanel.add((Component)lblHomepage, "cell 0 7,alignx right");
        lblHomepage = new LinkLabel("https://www.tinymediamanager.org/");
        ((LinkLabel)lblHomepage).addActionListener(arg_0 -> AboutDialog.lambda$new$0((LinkLabel)lblHomepage, arg_0));
        contentPanel.add((Component)lblHomepage, "cell 2 7");
        JLabel lblThanksTo = new JLabel(BUNDLE.getString("tmm.thanksto"));
        contentPanel.add((Component)lblThanksTo, "cell 0 9,alignx right");
        JLabel lblMyronForHelping = new JLabel("Myron for helping me with coding, scrapers, localization, setup, everything...");
        contentPanel.add((Component)lblMyronForHelping, "cell 2 9");
        JLabel lblJoostzilla = new JLabel("Joostzilla for the UI design");
        contentPanel.add((Component)lblJoostzilla, "cell 2 10");
        JLabel lblTranslators = new JLabel("All our translators");
        contentPanel.add((Component)lblTranslators, "cell 2 11");
        JLabel lblLibs = new JLabel("The creators of all libs we've used");
        contentPanel.add((Component)lblLibs, "cell 2 12");
        JLabel lblTester = new JLabel("Everyone who tested and provided feedback");
        contentPanel.add((Component)lblTester, "cell 2 13");
        JButton okButton = new JButton();
        CloseAction action = new CloseAction();
        okButton.setAction(action);
        this.addDefaultButton(okButton);
    }

    private static /* synthetic */ void lambda$new$0(LinkLabel lblHomepage, ActionEvent arg0) {
        try {
            TmmUIHelper.browseUrl(lblHomepage.getText());
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)lblHomepage.getText(), "message.erroropenurl", new String[]{":", e.getLocalizedMessage()}));
        }
    }

    private class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = 4652946848116365706L;

        CloseAction() {
            this.putValue("Name", TmmDialog.BUNDLE.getString("Button.ok"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
            this.putValue("SwingLargeIconKey", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AboutDialog.this.setVisible(false);
        }
    }
}

