/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import hu.kazocsaba.imageviewer.ImageViewer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.nio.file.Path;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.border.EmptyBorder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.scraper.http.Url;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.dialogs.TmmDialog;

public class ImagePreviewDialog
extends TmmDialog {
    private static final long serialVersionUID = -7479476493187235867L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ImagePreviewDialog.class);
    private String imageUrl;
    private Path imagePath;
    private SwingWorker<BufferedImage, Void> worker;
    private ImageViewer imgViewer = new ImageViewer();
    private JLabel lblLoadingInfo;

    public ImagePreviewDialog(String urlToImage) {
        super("", "imagePreview");
        this.imageUrl = urlToImage;
        this.lblLoadingInfo = new JLabel(BUNDLE.getString("image.download"));
        this.lblLoadingInfo.setBorder(new EmptyBorder(10, 10, 10, 10));
        TmmFontHelper.changeFont((JComponent)this.lblLoadingInfo, 1.5);
        this.getContentPane().add((Component)this.lblLoadingInfo, "Center");
        this.setBottomPanel(new JPanel());
        this.worker = new ImageFetcher();
        this.worker.execute();
    }

    public ImagePreviewDialog(Path pathToImage) {
        super("", "imagePreview");
        this.imagePath = pathToImage;
        this.lblLoadingInfo = new JLabel(BUNDLE.getString("image.download"));
        this.lblLoadingInfo.setBorder(new EmptyBorder(10, 10, 10, 10));
        TmmFontHelper.changeFont((JComponent)this.lblLoadingInfo, 1.5);
        this.getContentPane().add((Component)this.lblLoadingInfo, "Center");
        this.setBottomPanel(new JPanel());
        this.worker = new ImageFetcherPath();
        this.worker.execute();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible) {
            GraphicsDevice gd = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
            int width = gd.getDisplayMode().getWidth();
            int height = gd.getDisplayMode().getHeight();
            this.setMaximumSize(new Dimension(width, height));
            this.pack();
            this.setLocationRelativeTo(MainWindow.getActiveInstance());
            super.setVisible(true);
        } else {
            if (this.worker != null && !this.worker.isDone()) {
                this.worker.cancel(true);
            }
            super.setVisible(false);
            this.dispose();
        }
    }

    protected class ImageFetcherPath
    extends SwingWorker<BufferedImage, Void> {
        protected ImageFetcherPath() {
        }

        @Override
        protected BufferedImage doInBackground() {
            try {
                return ImageUtils.createImage(ImagePreviewDialog.this.imagePath);
            }
            catch (Exception e) {
                LOGGER.warn("fetch image: " + e.getMessage());
                return null;
            }
        }

        @Override
        protected void done() {
            try {
                BufferedImage image = (BufferedImage)this.get();
                if (image == null) {
                    ImagePreviewDialog.this.lblLoadingInfo.setText(TmmDialog.BUNDLE.getString("image.download.failed"));
                    ImagePreviewDialog.this.pack();
                    return;
                }
                ImagePreviewDialog.this.imgViewer.setImage(image);
                JComponent comp = ImagePreviewDialog.this.imgViewer.getComponent();
                ImagePreviewDialog.this.getContentPane().removeAll();
                ImagePreviewDialog.this.getContentPane().add((Component)comp, "Center");
                ImagePreviewDialog.this.pack();
                ImagePreviewDialog.this.setLocationRelativeTo(MainWindow.getActiveInstance());
            }
            catch (Exception e) {
                LOGGER.warn("fetch image: " + e.getMessage());
            }
        }
    }

    protected class ImageFetcher
    extends SwingWorker<BufferedImage, Void> {
        protected ImageFetcher() {
        }

        @Override
        protected BufferedImage doInBackground() {
            try {
                Url url = new Url(ImagePreviewDialog.this.imageUrl);
                return ImageUtils.createImage(url.getBytesWithRetry(5));
            }
            catch (Exception e) {
                LOGGER.warn("fetch image: " + e.getMessage());
                return null;
            }
        }

        @Override
        protected void done() {
            try {
                BufferedImage image = (BufferedImage)this.get();
                if (image == null) {
                    ImagePreviewDialog.this.lblLoadingInfo.setText(TmmDialog.BUNDLE.getString("image.download.failed"));
                    ImagePreviewDialog.this.pack();
                    return;
                }
                ImagePreviewDialog.this.imgViewer.setImage(image);
                JComponent comp = ImagePreviewDialog.this.imgViewer.getComponent();
                ImagePreviewDialog.this.getContentPane().removeAll();
                ImagePreviewDialog.this.getContentPane().add((Component)comp, "Center");
                ImagePreviewDialog.this.pack();
                ImagePreviewDialog.this.setLocationRelativeTo(MainWindow.getActiveInstance());
            }
            catch (Exception e) {
                LOGGER.warn("fetch image: " + e.getMessage());
            }
        }
    }
}

