/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.dialogs;

import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.core.TmmModuleManager;
import org.tinymediamanager.ui.EqualsLayout;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.TmmSplitPane;
import org.tinymediamanager.ui.components.tree.TmmTree;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.tree.TmmTreeTextFilter;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.settings.TmmSettingsDataProvider;
import org.tinymediamanager.ui.settings.TmmSettingsNode;

public class SettingsDialog
extends TmmDialog {
    private static final long serialVersionUID = 2435834806519338339L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static JDialog instance;
    private TmmTree<TmmTreeNode> tree;
    private JSplitPane splitPane;
    private TmmTreeTextFilter<TmmTreeNode> tfFilter;

    public static JDialog getInstance() {
        if (instance == null) {
            instance = new SettingsDialog();
        }
        return instance;
    }

    private SettingsDialog() {
        super(BUNDLE.getString("tmm.settings"), "settings");
        this.initComponents();
        this.tree.addFilter(this.tfFilter);
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(true);
        this.tree.setRowHeight(0);
        this.tree.setCellRenderer(new SettingsTreeCellRenderer());
        this.tree.addTreeSelectionListener(e -> {
            TmmSettingsNode tmmSettingsNode;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            if (node != null && node.getUserObject() instanceof TmmSettingsNode && (tmmSettingsNode = (TmmSettingsNode)node.getUserObject()).getComponent() != null) {
                JScrollPane scrollPane = new JScrollPane(tmmSettingsNode.getComponent());
                scrollPane.getVerticalScrollBar().setUnitIncrement(16);
                this.splitPane.setRightComponent(scrollPane);
                this.revalidate();
            }
        });
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            this.tree.expandRow(i);
        }
        SwingUtilities.invokeLater(() -> {
            DefaultMutableTreeNode firstLeaf = (DefaultMutableTreeNode)((DefaultMutableTreeNode)this.tree.getModel().getRoot()).getFirstChild();
            this.tree.setSelectionPath(new TreePath(((DefaultMutableTreeNode)firstLeaf.getParent()).getPath()));
            this.tree.setSelectionPath(new TreePath(firstLeaf.getPath()));
            this.tree.requestFocus();
        });
    }

    private void initComponents() {
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout((LayoutManager)new MigLayout("", "[600lp:1000lp,grow]", "[600lp,grow]"));
        this.getContentPane().add((Component)contentPanel, "Center");
        this.splitPane = new TmmSplitPane();
        contentPanel.add((Component)this.splitPane, "cell 0 0, grow");
        JPanel panelLeft = new JPanel();
        this.splitPane.setLeftComponent(panelLeft);
        panelLeft.setLayout((LayoutManager)new MigLayout("", "[200lp:200lp,grow]", "[][400lp,grow]"));
        this.tfFilter = new TmmTreeTextFilter();
        panelLeft.add(this.tfFilter, "cell 0 0,grow");
        this.tfFilter.setColumns(10);
        JScrollPane scrollPaneLeft = new JScrollPane();
        panelLeft.add((Component)scrollPaneLeft, "cell 0 1,grow");
        this.tree = new TmmTree<TmmTreeNode>(new TmmSettingsDataProvider());
        scrollPaneLeft.setViewportView(this.tree);
        scrollPaneLeft.setHorizontalScrollBarPolicy(31);
        JPanel southPanel = new JPanel();
        this.getContentPane().add((Component)southPanel, "South");
        southPanel.setLayout((LayoutManager)new MigLayout("insets n 0 0 0, gap rel 0", "[grow][]", "[shrink 0][]"));
        JSeparator separator = new JSeparator();
        southPanel.add((Component)separator, "cell 0 0 2 1,growx");
        JPanel panelButtons = new JPanel();
        EqualsLayout layout = new EqualsLayout(5);
        layout.setMinWidth(100);
        panelButtons.setLayout(layout);
        panelButtons.setBorder(new EmptyBorder(4, 4, 4, 4));
        southPanel.add((Component)panelButtons, "cell 1 1,alignx left,aligny top");
        JButton okButton = new JButton(BUNDLE.getString("Button.close"));
        panelButtons.add(okButton);
        okButton.setAction(new CloseAction());
        this.getRootPane().setDefaultButton(okButton);
    }

    @Override
    public void setVisible(boolean visible) {
        if (!visible) {
            TmmModuleManager.getInstance().saveSettings();
        }
        super.setVisible(visible);
    }

    private class SettingsTreeCellRenderer
    implements TreeCellRenderer {
        private JLabel label;

        SettingsTreeCellRenderer() {
            this.label = new JLabel(){

                @Override
                public void updateUI() {
                    super.updateUI();
                    Object obj = UIManager.get("Tree.nodeBorder");
                    if (obj instanceof Border) {
                        this.setBorder((Border)obj);
                    }
                }
            };
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (selected) {
                this.label.setForeground(UIManager.getColor("Tree.selectionForeground"));
            } else {
                this.label.setForeground(UIManager.getColor("Tree.textForeground"));
            }
            this.label.setText(value.toString());
            this.label.invalidate();
            return this.label;
        }
    }

    private class CloseAction
    extends AbstractAction {
        private static final long serialVersionUID = 2386371884117941373L;

        CloseAction() {
            this.putValue("Name", BUNDLE.getString("Button.close"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
            this.putValue("SwingLargeIconKey", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SettingsDialog.this.setVisible(false);
        }
    }
}

