/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.MovieHelpers;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieScraperMetadataConfig;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieTrailer;
import org.tinymediamanager.core.threading.TmmTask;
import org.tinymediamanager.core.threading.TmmTaskHandle;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaScrapeOptions;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaCastMember;
import org.tinymediamanager.scraper.entities.MediaLanguages;
import org.tinymediamanager.scraper.entities.MediaTrailer;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.exceptions.UnsupportedMediaTypeException;
import org.tinymediamanager.scraper.mediaprovider.IMovieArtworkProvider;
import org.tinymediamanager.scraper.mediaprovider.IMovieMetadataProvider;
import org.tinymediamanager.scraper.mediaprovider.IMovieTrailerProvider;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.UTF8Control;

public class MovieChooserModel
extends AbstractModelObject {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieChooserModel.class);
    public static final MovieChooserModel emptyResult = new MovieChooserModel();
    private final Movie movieToScrape;
    private MediaScraper metadataProvider = null;
    private List<MediaScraper> artworkScrapers = null;
    private List<MediaScraper> trailerScrapers = null;
    private MediaLanguages language = null;
    private MediaSearchResult result = null;
    private MediaMetadata metadata = null;
    private float score = 0.0f;
    private String title = "";
    private String originalTitle = "";
    private String overview = "";
    private String year = "";
    private String combinedName = "";
    private String posterUrl = "";
    private String tagline = "";
    private List<Person> castMembers = new ArrayList<Person>();
    private boolean scraped = false;

    public MovieChooserModel(Movie movie, MediaScraper metadataProvider, List<MediaScraper> artworkScrapers, List<MediaScraper> trailerScrapers, MediaSearchResult result, MediaLanguages language) {
        this.movieToScrape = movie;
        this.metadataProvider = metadataProvider;
        this.artworkScrapers = artworkScrapers;
        this.trailerScrapers = trailerScrapers;
        this.result = result;
        this.language = language;
        this.score = result.getScore();
        this.setTitle(result.getTitle());
        this.setOriginalTitle(result.getOriginalTitle());
        if (result.getYear() != 0) {
            this.setYear(Integer.toString(result.getYear()));
        }
        this.setCombinedName();
    }

    private MovieChooserModel() {
        this.setTitle(BUNDLE.getString("chooser.nothingfound"));
        this.movieToScrape = null;
        this.combinedName = this.title;
    }

    public void setTitle(String title) {
        String oldValue = this.title;
        this.title = StrgUtils.getNonNullString((String)title);
        this.firePropertyChange("title", oldValue, this.title);
    }

    public void setOriginalTitle(String originalTitle) {
        String oldValue = this.originalTitle;
        this.originalTitle = StrgUtils.getNonNullString((String)originalTitle);
        this.firePropertyChange("originalTitle", oldValue, this.originalTitle);
    }

    public void setOverview(String overview) {
        String oldValue = this.overview;
        this.overview = StrgUtils.getNonNullString((String)overview);
        this.firePropertyChange("overview", oldValue, this.overview);
    }

    public void setCastMembers(List<Person> castMembers) {
        this.castMembers.clear();
        this.castMembers.addAll(castMembers);
        this.firePropertyChange("castMembers", null, castMembers);
    }

    public float getScore() {
        return this.score;
    }

    public String getTitle() {
        return this.title;
    }

    public String getOriginalTitle() {
        return this.originalTitle;
    }

    public String getOverview() {
        return this.overview;
    }

    public List<Person> getCastMembers() {
        return this.castMembers;
    }

    public String getPosterUrl() {
        return this.posterUrl;
    }

    public void setPosterUrl(String newValue) {
        String oldValue = this.posterUrl;
        this.posterUrl = StrgUtils.getNonNullString((String)newValue);
        this.firePropertyChange("posterUrl", oldValue, newValue);
    }

    public String getYear() {
        return this.year;
    }

    public void setYear(String year) {
        String oldValue = this.year;
        this.year = year;
        this.firePropertyChange("year", oldValue, this.year);
    }

    public void setCombinedName() {
        String oldValue = this.combinedName;
        this.combinedName = StringUtils.isNotBlank((CharSequence)this.getYear()) ? this.getTitle() + " (" + this.getYear() + ")" : this.getTitle();
        this.firePropertyChange("combinedName", oldValue, this.combinedName);
    }

    public String getCombinedName() {
        return this.combinedName;
    }

    public void scrapeMetaData() {
        try {
            this.setPosterUrl(this.result.getPosterUrl());
            MediaScrapeOptions options = new MediaScrapeOptions(MediaType.MOVIE);
            options.setResult(this.result);
            options.setLanguage(this.language.toLocale());
            options.setCountry(MovieModuleManager.SETTINGS.getCertificationCountry());
            LOGGER.info("=====================================================");
            LOGGER.info("Scraper metadata with scraper: " + this.metadataProvider.getMediaProvider().getProviderInfo().getId() + ", " + this.metadataProvider.getMediaProvider().getProviderInfo().getVersion());
            LOGGER.info(options.toString());
            LOGGER.info("=====================================================");
            try {
                this.metadata = ((IMovieMetadataProvider)this.metadataProvider.getMediaProvider()).getMetadata(options);
            }
            catch (ScrapeException e) {
                LOGGER.error("searchMovieFallback", (Throwable)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MovieChooser", "message.scrape.metadatamoviefailed", new String[]{":", e.getLocalizedMessage()}));
                return;
            }
            catch (MissingIdException e) {
                LOGGER.warn("missing id for scrape");
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, "MovieChooser", "scraper.error.missingid"));
                return;
            }
            catch (UnsupportedMediaTypeException ignored) {
                LOGGER.warn("unsupported media type: " + this.metadataProvider.getMediaProvider().getProviderInfo().getId());
                return;
            }
            this.setOriginalTitle(this.metadata.getOriginalTitle());
            ArrayList<Person> castMembers = new ArrayList<Person>();
            int i = 0;
            for (MediaCastMember castMember : this.metadata.getCastMembers(MediaCastMember.CastType.DIRECTOR)) {
                castMembers.add(new Person(castMember));
                if (++i < 2) continue;
                break;
            }
            i = 0;
            for (MediaCastMember castMember : this.metadata.getCastMembers(MediaCastMember.CastType.PRODUCER)) {
                castMembers.add(new Person(castMember));
                if (++i < 2) continue;
                break;
            }
            for (MediaCastMember castMember : this.metadata.getCastMembers(MediaCastMember.CastType.ACTOR)) {
                castMembers.add(new Person(castMember));
            }
            this.setCastMembers(castMembers);
            this.setOverview(this.metadata.getPlot());
            this.setTagline(this.metadata.getTagline());
            if (StringUtils.isBlank((CharSequence)this.posterUrl) && !this.metadata.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).isEmpty()) {
                this.setPosterUrl(((MediaArtwork)this.metadata.getMediaArt(MediaArtwork.MediaArtworkType.POSTER).get(0)).getPreviewUrl());
            }
            this.setScraped(true);
        }
        catch (Exception e) {
            LOGGER.error("scrapeMedia", (Throwable)e);
            MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MovieChooser", "message.scrape.threadcrashed", new String[]{":", e.getLocalizedMessage()}));
        }
    }

    public MediaMetadata getMetadata() {
        return this.metadata;
    }

    public boolean isDuplicate() {
        if (this == emptyResult) {
            return false;
        }
        for (Movie movie : MovieList.getInstance().getMovies()) {
            Object id;
            if (this.movieToScrape == movie || (id = movie.getId(this.result.getProviderId())) == null || !id.toString().equals(this.result.getId())) continue;
            return true;
        }
        return false;
    }

    public boolean isScraped() {
        return this.scraped;
    }

    private void setScraped(boolean newvalue) {
        boolean oldValue = this.scraped;
        this.scraped = newvalue;
        this.firePropertyChange("scraped", oldValue, newvalue);
    }

    public void setTagline(String newValue) {
        String oldValue = this.tagline;
        this.tagline = newValue;
        this.firePropertyChange("tagline", oldValue, newValue);
    }

    public String getTagline() {
        return this.tagline;
    }

    public void startArtworkScrapeTask(Movie movie, MovieScraperMetadataConfig config) {
        TmmTaskManager.getInstance().addUnnamedTask(new ArtworkScrapeTask(movie, config));
    }

    public void startTrailerScrapeTask(Movie movie) {
        TmmTaskManager.getInstance().addUnnamedTask(new TrailerScrapeTask(movie));
    }

    private class TrailerScrapeTask
    extends TmmTask {
        private Movie movieToScrape;

        public TrailerScrapeTask(Movie movie) {
            super(BUNDLE.getString("message.scrape.trailer") + " " + movie.getTitle(), 0, TmmTaskHandle.TaskType.BACKGROUND_TASK);
            this.movieToScrape = movie;
        }

        @Override
        protected void doInBackground() {
            if (!MovieChooserModel.this.scraped) {
                return;
            }
            ArrayList<MovieTrailer> trailer = new ArrayList<MovieTrailer>();
            MediaScrapeOptions options = new MediaScrapeOptions(MediaType.MOVIE);
            options.setMetadata(MovieChooserModel.this.metadata);
            options.setId("imdb", String.valueOf(MovieChooserModel.this.metadata.getId("imdb")));
            try {
                options.setTmdbId(Integer.parseInt(String.valueOf(MovieChooserModel.this.metadata.getId("tmdb"))));
            }
            catch (Exception e) {
                options.setTmdbId(0);
            }
            options.setLanguage(MovieChooserModel.this.language.toLocale());
            options.setCountry(MovieModuleManager.SETTINGS.getCertificationCountry());
            for (MediaScraper trailerScraper : MovieChooserModel.this.trailerScrapers) {
                try {
                    IMovieTrailerProvider trailerProvider = (IMovieTrailerProvider)trailerScraper.getMediaProvider();
                    List foundTrailers = trailerProvider.getTrailers(options);
                    for (MediaTrailer mediaTrailer : foundTrailers) {
                        MovieTrailer movieTrailer = new MovieTrailer(mediaTrailer);
                        trailer.add(movieTrailer);
                    }
                }
                catch (ScrapeException e) {
                    LOGGER.error("getTrailers {}", (Object)e.getMessage());
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)"MovieChooser", "message.scrape.movietrailerfailed", new String[]{":", e.getLocalizedMessage()}));
                }
                catch (MissingIdException | UnsupportedMediaTypeException e) {
                }
            }
            for (MediaFile mf : this.movieToScrape.getMediaFiles(MediaFileType.TRAILER)) {
                LOGGER.debug("adding local trailer " + mf.getFilename());
                MovieTrailer mt = new MovieTrailer();
                mt.setName(mf.getFilename());
                mt.setProvider("downloaded");
                mt.setQuality(mf.getVideoFormat());
                mt.setInNfo(false);
                mt.setUrl(mf.getFile().toUri().toString());
                trailer.add(0, mt);
            }
            this.movieToScrape.setTrailers(trailer);
            this.movieToScrape.saveToDb();
            this.movieToScrape.writeNFO();
            MovieHelpers.startAutomaticTrailerDownload(this.movieToScrape);
        }
    }

    private class ArtworkScrapeTask
    extends TmmTask {
        private Movie movieToScrape;
        private MovieScraperMetadataConfig config;

        public ArtworkScrapeTask(Movie movie, MovieScraperMetadataConfig config) {
            super(BUNDLE.getString("message.scrape.artwork") + " " + movie.getTitle(), 0, TmmTaskHandle.TaskType.BACKGROUND_TASK);
            this.movieToScrape = movie;
            this.config = config;
        }

        @Override
        protected void doInBackground() {
            if (!MovieChooserModel.this.scraped) {
                return;
            }
            ArrayList<MediaArtwork> artwork = new ArrayList<MediaArtwork>();
            MediaScrapeOptions options = new MediaScrapeOptions(MediaType.MOVIE);
            options.setArtworkType(MediaArtwork.MediaArtworkType.ALL);
            options.setMetadata(MovieChooserModel.this.metadata);
            options.setId("imdb", String.valueOf(MovieChooserModel.this.metadata.getId("imdb")));
            try {
                options.setTmdbId(Integer.parseInt(String.valueOf(MovieChooserModel.this.metadata.getId("tmdb"))));
            }
            catch (Exception e) {
                options.setTmdbId(0);
            }
            options.setLanguage(MovieModuleManager.SETTINGS.getImageScraperLanguage().toLocale());
            options.setCountry(MovieModuleManager.SETTINGS.getCertificationCountry());
            options.setFanartSize(MovieModuleManager.SETTINGS.getImageFanartSize());
            options.setPosterSize(MovieModuleManager.SETTINGS.getImagePosterSize());
            for (MediaScraper artworkScraper : MovieChooserModel.this.artworkScrapers) {
                IMovieArtworkProvider artworkProvider = (IMovieArtworkProvider)artworkScraper.getMediaProvider();
                try {
                    artwork.addAll(artworkProvider.getArtwork(options));
                }
                catch (ScrapeException e) {
                    LOGGER.error("getArtwork", (Throwable)e);
                    MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)this.movieToScrape, "message.scrape.movieartworkfailed", new String[]{":", e.getLocalizedMessage()}));
                }
                catch (MissingIdException missingIdException) {}
            }
            if (StringUtils.isNotBlank((CharSequence)MovieChooserModel.this.getPosterUrl())) {
                MediaArtwork ma = new MediaArtwork(MovieChooserModel.this.result.getProviderId(), MediaArtwork.MediaArtworkType.POSTER);
                ma.setDefaultUrl(MovieChooserModel.this.getPosterUrl());
                ma.setPreviewUrl(MovieChooserModel.this.getPosterUrl());
                artwork.add(ma);
            }
            this.movieToScrape.setArtwork(artwork, this.config);
        }
    }
}

