/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import java.awt.FontMetrics;
import java.text.Normalizer;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.function.Function;
import javax.swing.ImageIcon;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmDateFormat;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieComparator;
import org.tinymediamanager.core.movie.MovieEdition;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.util.StrgUtils;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.movies.MovieBorderTableCellRenderer;
import org.tinymediamanager.ui.renderer.DateTableCellRenderer;
import org.tinymediamanager.ui.renderer.RightAlignTableCellRenderer;

public class MovieTableFormat
extends TmmTableFormat<Movie> {
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieTableFormat() {
        MovieComparator movieComparator = new MovieComparator();
        MovieComparator originalTitleComparator = new MovieComparator(){

            @Override
            public int compare(Movie movie1, Movie movie2) {
                if (this.stringCollator != null) {
                    String titleMovie1 = Normalizer.normalize(movie1.getOriginalTitleSortable().toLowerCase(Locale.ROOT), Normalizer.Form.NFD);
                    String titleMovie2 = Normalizer.normalize(movie2.getOriginalTitleSortable().toLowerCase(Locale.ROOT), Normalizer.Form.NFD);
                    return this.stringCollator.compare(titleMovie1, titleMovie2);
                }
                return movie1.getOriginalTitleSortable().toLowerCase(Locale.ROOT).compareTo(movie2.getOriginalTitleSortable().toLowerCase(Locale.ROOT));
            }
        };
        TmmTableFormat.StringComparator stringComparator = new TmmTableFormat.StringComparator();
        TmmTableFormat.FloatComparator floatComparator = new TmmTableFormat.FloatComparator();
        TmmTableFormat.ImageComparator imageComparator = new TmmTableFormat.ImageComparator();
        TmmTableFormat.DateComparator dateComparator = new TmmTableFormat.DateComparator();
        TmmTableFormat.VideoFormatComparator videoFormatComparator = new TmmTableFormat.VideoFormatComparator();
        TmmTableFormat.FileSizeComparator fileSizeComparator = new TmmTableFormat.FileSizeComparator();
        TmmTableFormat.IntegerComparator integerComparator = new TmmTableFormat.IntegerComparator();
        TmmTableFormat.CertificationComparator certificationComparator = new TmmTableFormat.CertificationComparator();
        FontMetrics fontMetrics = this.getFontMetrics();
        TmmTableFormat.Column col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.title"), "title", movie -> movie, Movie.class);
        col.setColumnComparator(movieComparator);
        col.setCellRenderer(new MovieBorderTableCellRenderer());
        col.setColumnTooltip(Movie::getTitleSortable);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.originaltitle"), "originalTitle", movie -> movie, Movie.class);
        col.setColumnComparator(originalTitleComparator);
        col.setCellRenderer(new MovieBorderTableCellRenderer());
        col.setColumnTooltip(Movie::getOriginalTitleSortable);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.year"), "year", MediaEntity::getYear, Movie.class);
        col.setColumnComparator(integerComparator);
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("2000") * 1.3f));
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.filename"), "filename", movie -> movie.getMainVideoFile().getFilename(), String.class);
        col.setColumnComparator(stringComparator);
        col.setColumnResizeable(true);
        col.setColumnTooltip(movie -> movie.getMainVideoFile().getFilename());
        this.addColumn(col);
        Function<Movie, String> pathFunction = movie -> movie.getPathNIO().toString();
        col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.path"), "path", pathFunction, String.class);
        col.setColumnComparator(stringComparator);
        col.setColumnResizeable(true);
        col.setColumnTooltip(pathFunction);
        this.addColumn(col);
        Function<Movie, String> movieSetFunction = movie -> movie.getMovieSet() == null ? null : movie.getMovieSet().getTitle();
        col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.movieset"), "movieset", movieSetFunction, String.class);
        col.setColumnComparator(stringComparator);
        col.setColumnResizeable(true);
        col.setColumnTooltip(movieSetFunction);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.rating"), "rating", movie -> Float.valueOf(movie.getRating().getRating()), Float.class);
        col.setColumnComparator(floatComparator);
        col.setHeaderIcon(IconManager.RATING);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("99.9") * 1.2f));
        col.setColumnTooltip(movie -> movie.getRating().getRating() + " (" + movie.getRating().getVotes() + " " + BUNDLE.getString("metatag.votes") + ")");
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.votes"), "votes", movie -> movie.getRating().getVotes(), Integer.class);
        col.setColumnComparator(integerComparator);
        col.setHeaderIcon(IconManager.VOTES);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("1000000") * 1.2f));
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.certification"), "certification", Movie::getCertification, Certification.class);
        col.setColumnComparator(certificationComparator);
        col.setHeaderIcon(IconManager.CERTIFICATION);
        col.setColumnResizeable(true);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.dateadded"), "dateAdded", MediaEntity::getDateAdded, Date.class);
        col.setColumnComparator(dateComparator);
        col.setHeaderIcon(IconManager.DATE_ADDED);
        col.setCellRenderer(new DateTableCellRenderer());
        col.setColumnResizeable(false);
        try {
            Date date = StrgUtils.parseDate((String)"2012-12-12");
            col.setMinWidth((int)((float)fontMetrics.stringWidth(TmmDateFormat.SHORT_DATE_FORMAT.format(date)) * 1.2f));
        }
        catch (Exception date) {
            // empty catch block
        }
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.format"), "videoFormat", Movie::getMediaInfoVideoFormat, String.class);
        col.setColumnComparator(videoFormatComparator);
        col.setHeaderIcon(IconManager.VIDEO_FORMAT);
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("1080p") * 1.2f));
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.audio"), "audio", movie -> {
            MediaFile mediaFile;
            List<MediaFile> videos = movie.getMediaFiles(MediaFileType.VIDEO);
            if (videos.size() > 0 && StringUtils.isNotBlank((CharSequence)(mediaFile = videos.get(0)).getAudioCodec())) {
                return mediaFile.getAudioCodec() + " " + mediaFile.getAudioChannels();
            }
            return "";
        }, String.class);
        col.setColumnComparator(stringComparator);
        col.setHeaderIcon(IconManager.AUDIO);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("DTS 7ch") * 1.2f));
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.size"), "fileSize", movie -> {
            long size = 0L;
            for (MediaFile mf : movie.getMediaFiles(MediaFileType.VIDEO)) {
                size += mf.getFilesize();
            }
            return (int)((double)size / 1048576.0) + " M";
        }, String.class);
        col.setColumnComparator(fileSizeComparator);
        col.setHeaderIcon(IconManager.FILE_SIZE);
        col.setCellRenderer(new RightAlignTableCellRenderer());
        col.setColumnResizeable(false);
        col.setMinWidth((int)((float)fontMetrics.stringWidth("50000M") * 1.2f));
        this.addColumn(col);
        Function<Movie, String> movieEditionFunction = movie -> movie.getEdition() == null || movie.getEdition() == MovieEdition.NONE ? null : movie.getEdition().toString();
        col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.edition"), "edition", movieEditionFunction, String.class);
        col.setColumnComparator(stringComparator);
        col.setHeaderIcon(IconManager.EDITION);
        col.setColumnTooltip(movieEditionFunction);
        this.addColumn(col);
        Function<Movie, String> mediaSourceFunction = movie -> movie.getMediaSource() == null ? null : movie.getMediaSource().toString();
        col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.source"), "mediaSource", mediaSourceFunction, String.class);
        col.setColumnComparator(stringComparator);
        col.setHeaderIcon(IconManager.SOURCE);
        col.setColumnTooltip(mediaSourceFunction);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.3d"), "video3d", movie -> this.getCheckIcon(movie.isVideoIn3D()), ImageIcon.class);
        col.setColumnComparator(imageComparator);
        col.setHeaderIcon(IconManager.VIDEO_3D);
        col.setColumnResizeable(false);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, BUNDLE.getString("tmm.nfo"), "nfo", movie -> this.getCheckIcon(movie.getHasNfoFile()), ImageIcon.class);
        col.setColumnComparator(imageComparator);
        col.setHeaderIcon(IconManager.NFO);
        col.setColumnResizeable(false);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, BUNDLE.getString("tmm.images"), "images", movie -> this.getCheckIcon(movie.getHasImages()), ImageIcon.class);
        col.setColumnComparator(imageComparator);
        col.setHeaderIcon(IconManager.IMAGES);
        col.setColumnResizeable(false);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, BUNDLE.getString("tmm.trailer"), "trailer", movie -> this.getCheckIcon(movie.getHasTrailer()), ImageIcon.class);
        col.setColumnComparator(imageComparator);
        col.setHeaderIcon(IconManager.TRAILER);
        col.setColumnResizeable(false);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, BUNDLE.getString("tmm.subtitles"), "subtitles", movie -> this.getCheckIcon(movie.hasSubtitles()), ImageIcon.class);
        col.setColumnComparator(imageComparator);
        col.setHeaderIcon(IconManager.SUBTITLES);
        col.setColumnResizeable(false);
        this.addColumn(col);
        col = new TmmTableFormat.Column(this, BUNDLE.getString("metatag.watched"), "watched", movie -> this.getCheckIcon(movie.isWatched()), ImageIcon.class);
        col.setColumnComparator(imageComparator);
        col.setHeaderIcon(IconManager.WATCHED);
        col.setColumnResizeable(false);
        this.addColumn(col);
    }
}

