/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import net.miginfocom.swing.MigLayout;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.thirdparty.KodiRPC;
import org.tinymediamanager.ui.AbstractTmmUIModule;
import org.tinymediamanager.ui.components.MainTabbedPane;
import org.tinymediamanager.ui.components.PopupMenuScroller;
import org.tinymediamanager.ui.movies.MovieSelectionModel;
import org.tinymediamanager.ui.movies.actions.DebugDumpMovieAction;
import org.tinymediamanager.ui.movies.actions.MovieAssignMovieSetAction;
import org.tinymediamanager.ui.movies.actions.MovieBatchEditAction;
import org.tinymediamanager.ui.movies.actions.MovieChangeDatasourceAction;
import org.tinymediamanager.ui.movies.actions.MovieCleanUpFilesAction;
import org.tinymediamanager.ui.movies.actions.MovieClearImageCacheAction;
import org.tinymediamanager.ui.movies.actions.MovieCreateOfflineAction;
import org.tinymediamanager.ui.movies.actions.MovieDeleteAction;
import org.tinymediamanager.ui.movies.actions.MovieDownloadMissingArtworkAction;
import org.tinymediamanager.ui.movies.actions.MovieEditAction;
import org.tinymediamanager.ui.movies.actions.MovieExportAction;
import org.tinymediamanager.ui.movies.actions.MovieFindMissingAction;
import org.tinymediamanager.ui.movies.actions.MovieMediaInformationAction;
import org.tinymediamanager.ui.movies.actions.MovieReadNfoAction;
import org.tinymediamanager.ui.movies.actions.MovieRebuildImageCacheAction;
import org.tinymediamanager.ui.movies.actions.MovieRemoveAction;
import org.tinymediamanager.ui.movies.actions.MovieRenameAction;
import org.tinymediamanager.ui.movies.actions.MovieRenamePreviewAction;
import org.tinymediamanager.ui.movies.actions.MovieRewriteNfoAction;
import org.tinymediamanager.ui.movies.actions.MovieSelectedScrapeAction;
import org.tinymediamanager.ui.movies.actions.MovieSelectedScrapeMetadataAction;
import org.tinymediamanager.ui.movies.actions.MovieSingleScrapeAction;
import org.tinymediamanager.ui.movies.actions.MovieSubtitleDownloadAction;
import org.tinymediamanager.ui.movies.actions.MovieSubtitleSearchAction;
import org.tinymediamanager.ui.movies.actions.MovieSyncSelectedTraktTvAction;
import org.tinymediamanager.ui.movies.actions.MovieSyncTraktTvAction;
import org.tinymediamanager.ui.movies.actions.MovieSyncWatchedTraktTvAction;
import org.tinymediamanager.ui.movies.actions.MovieToggleWatchedFlagAction;
import org.tinymediamanager.ui.movies.actions.MovieTrailerDownloadAction;
import org.tinymediamanager.ui.movies.actions.MovieUnscrapedScrapeAction;
import org.tinymediamanager.ui.movies.actions.MovieUpdateAction;
import org.tinymediamanager.ui.movies.actions.MovieUpdateDatasourceAction;
import org.tinymediamanager.ui.movies.actions.MovieUpdateSingleDatasourceAction;
import org.tinymediamanager.ui.movies.dialogs.MovieFilterDialog;
import org.tinymediamanager.ui.movies.panels.MovieArtworkPanel;
import org.tinymediamanager.ui.movies.panels.MovieCastPanel;
import org.tinymediamanager.ui.movies.panels.MovieInformationPanel;
import org.tinymediamanager.ui.movies.panels.MovieListPanel;
import org.tinymediamanager.ui.movies.panels.MovieMediaInformationPanel;
import org.tinymediamanager.ui.movies.panels.MovieTrailerPanel;
import org.tinymediamanager.ui.movies.settings.MovieSettingsNode;
import org.tinymediamanager.ui.settings.TmmSettingsNode;
import org.tinymediamanager.ui.thirdparty.KodiRPCMenu;

public class MovieUIModule
extends AbstractTmmUIModule {
    private static final String ID = "movies";
    private static MovieUIModule instance = null;
    private final MovieListPanel listPanel = new MovieListPanel();
    private final MovieSelectionModel selectionModel = this.listPanel.getSelectionModel();
    private TmmSettingsNode settingsNode;
    private final MovieFilterDialog movieFilterDialog;

    private MovieUIModule() {
        ((AbstractTmmUIModule)this).listPanel = this.listPanel;
        this.detailPanel = new JPanel();
        this.detailPanel.setOpaque(false);
        this.detailPanel.setLayout((LayoutManager)new MigLayout("insets 0", "[grow]", "[grow]"));
        JPanel dataPanel = new JPanel();
        dataPanel.setOpaque(false);
        dataPanel.setLayout(new CardLayout());
        this.detailPanel.add((Component)dataPanel, "cell 0 0, grow");
        MainTabbedPane tabbedPane = new MainTabbedPane(){
            private static final long serialVersionUID = 1234548865608767661L;

            @Override
            public void updateUI() {
                this.putClientProperty("leftBorder", "half");
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                super.updateUI();
            }
        };
        tabbedPane.add(BUNDLE.getString("metatag.details"), new MovieInformationPanel(this.selectionModel));
        tabbedPane.add(BUNDLE.getString("metatag.cast"), new MovieCastPanel(this.selectionModel));
        tabbedPane.add(BUNDLE.getString("metatag.mediafiles"), new MovieMediaInformationPanel(this.selectionModel));
        tabbedPane.add(BUNDLE.getString("metatag.artwork"), new MovieArtworkPanel(this.selectionModel));
        tabbedPane.add(BUNDLE.getString("metatag.trailer"), new MovieTrailerPanel(this.selectionModel));
        dataPanel.add(tabbedPane);
        this.movieFilterDialog = new MovieFilterDialog(this.selectionModel);
        this.createActions();
        this.createPopupMenu();
        this.registerAccelerators();
        this.settingsNode = new MovieSettingsNode();
        this.init();
    }

    private void init() {
        if (MovieModuleManager.SETTINGS.isStoreUiFilters()) {
            SwingUtilities.invokeLater(() -> {
                MovieList.getInstance().searchDuplicates();
                this.selectionModel.setFilterValues(MovieModuleManager.SETTINGS.getUiFilters());
            });
        }
        if (MovieModuleManager.SETTINGS.isStoreUiSorting()) {
            this.selectionModel.sortMovies(MovieModuleManager.SETTINGS.getSortColumn(), MovieModuleManager.SETTINGS.isSortAscending());
        }
        this.listPanel.init();
    }

    public static MovieUIModule getInstance() {
        if (instance == null) {
            instance = new MovieUIModule();
        }
        return instance;
    }

    public MovieSelectionModel getSelectionModel() {
        return this.selectionModel;
    }

    private void createActions() {
        this.searchAction = this.createAndRegisterAction(MovieSingleScrapeAction.class);
        this.editAction = this.createAndRegisterAction(MovieEditAction.class);
        this.updateAction = this.createAndRegisterAction(MovieUpdateDatasourceAction.class);
        this.renameAction = this.createAndRegisterAction(MovieRenameAction.class);
    }

    private void createPopupMenu() {
        this.popupMenu = new JPopupMenu();
        this.popupMenu.add(this.createAndRegisterAction(MovieSingleScrapeAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieSelectedScrapeAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieUnscrapedScrapeAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieSelectedScrapeMetadataAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieAssignMovieSetAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieDownloadMissingArtworkAction.class));
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createAndRegisterAction(MovieUpdateAction.class));
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createAndRegisterAction(MovieEditAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieBatchEditAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieChangeDatasourceAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieToggleWatchedFlagAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieRewriteNfoAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieReadNfoAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieRenameAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieRenamePreviewAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieMediaInformationAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieExportAction.class));
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createAndRegisterAction(MovieTrailerDownloadAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieSubtitleSearchAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieSubtitleDownloadAction.class));
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createAndRegisterAction(MovieSyncTraktTvAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieSyncWatchedTraktTvAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieSyncSelectedTraktTvAction.class));
        final JMenu kodiRPCMenu = KodiRPCMenu.KodiMenuRightClickMovies();
        this.popupMenu.add(kodiRPCMenu);
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createAndRegisterAction(MovieCleanUpFilesAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieClearImageCacheAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieRebuildImageCacheAction.class));
        this.popupMenu.addSeparator();
        this.popupMenu.add(this.createAndRegisterAction(MovieRemoveAction.class));
        this.popupMenu.add(this.createAndRegisterAction(MovieDeleteAction.class));
        if (Globals.isDebug()) {
            JMenu debugMenu = new JMenu("Debug");
            debugMenu.add(new DebugDumpMovieAction());
            this.popupMenu.addSeparator();
            this.popupMenu.add(debugMenu);
        }
        this.popupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                kodiRPCMenu.setText(KodiRPC.getInstance().getVersion());
                if (KodiRPC.getInstance().isConnected()) {
                    kodiRPCMenu.setEnabled(true);
                } else {
                    kodiRPCMenu.setEnabled(false);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.listPanel.setPopupMenu(this.popupMenu);
        this.updatePopupMenu = new JPopupMenu();
        PopupMenuScroller.setScrollerFor(this.updatePopupMenu, 20, 25, 2, 5);
        this.updatePopupMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                MovieUIModule.this.updatePopupMenu.removeAll();
                MovieUIModule.this.updatePopupMenu.add(MovieUIModule.this.createAndRegisterAction(MovieUpdateDatasourceAction.class));
                MovieUIModule.this.updatePopupMenu.addSeparator();
                for (String ds : MovieModuleManager.SETTINGS.getMovieDataSource()) {
                    MovieUIModule.this.updatePopupMenu.add(new MovieUpdateSingleDatasourceAction(ds));
                }
                MovieUIModule.this.updatePopupMenu.addSeparator();
                MovieUIModule.this.updatePopupMenu.add(MovieUIModule.this.createAndRegisterAction(MovieUpdateAction.class));
                MovieUIModule.this.updatePopupMenu.addSeparator();
                MovieUIModule.this.updatePopupMenu.add(MovieUIModule.this.createAndRegisterAction(MovieFindMissingAction.class));
                MovieUIModule.this.updatePopupMenu.add(MovieUIModule.this.createAndRegisterAction(MovieCreateOfflineAction.class));
                MovieUIModule.this.updatePopupMenu.pack();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.searchPopupMenu = new JPopupMenu();
        this.searchPopupMenu.add(this.createAndRegisterAction(MovieSingleScrapeAction.class));
        this.searchPopupMenu.add(this.createAndRegisterAction(MovieSelectedScrapeAction.class));
        this.searchPopupMenu.add(this.createAndRegisterAction(MovieUnscrapedScrapeAction.class));
        this.searchPopupMenu.add(this.createAndRegisterAction(MovieSelectedScrapeMetadataAction.class));
        this.editPopupMenu = new JPopupMenu();
        this.editPopupMenu.add(this.createAndRegisterAction(MovieEditAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(MovieBatchEditAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(MovieChangeDatasourceAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(MovieToggleWatchedFlagAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(MovieRewriteNfoAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(MovieReadNfoAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(MovieRenameAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(MovieRenamePreviewAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(MovieMediaInformationAction.class));
        this.editPopupMenu.addSeparator();
        this.editPopupMenu.add(this.createAndRegisterAction(MovieSyncTraktTvAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(MovieSyncSelectedTraktTvAction.class));
        this.editPopupMenu.add(this.createAndRegisterAction(MovieSyncWatchedTraktTvAction.class));
        this.editPopupMenu.addSeparator();
        this.editPopupMenu.add(this.createAndRegisterAction(MovieCleanUpFilesAction.class));
        this.editPopupMenu.addSeparator();
        this.editPopupMenu.add(this.createAndRegisterAction(MovieExportAction.class));
        this.renamePopupMenu = new JPopupMenu();
        this.renamePopupMenu.add(this.createAndRegisterAction(MovieRenameAction.class));
        this.renamePopupMenu.add(this.createAndRegisterAction(MovieRenamePreviewAction.class));
    }

    @Override
    public String getModuleId() {
        return ID;
    }

    @Override
    public JPanel getTabPanel() {
        return this.listPanel;
    }

    @Override
    public String getTabTitle() {
        return BUNDLE.getString("tmm.movies");
    }

    @Override
    public JPanel getDetailPanel() {
        return this.detailPanel;
    }

    @Override
    public Action getSearchAction() {
        return this.searchAction;
    }

    @Override
    public JPopupMenu getSearchMenu() {
        return this.searchPopupMenu;
    }

    @Override
    public Action getEditAction() {
        return this.editAction;
    }

    @Override
    public JPopupMenu getEditMenu() {
        return this.editPopupMenu;
    }

    @Override
    public Action getUpdateAction() {
        return this.updateAction;
    }

    @Override
    public JPopupMenu getUpdateMenu() {
        return this.updatePopupMenu;
    }

    @Override
    public Action getRenameAction() {
        return this.renameAction;
    }

    @Override
    public JPopupMenu getRenameMenu() {
        return this.renamePopupMenu;
    }

    @Override
    public TmmSettingsNode getSettingsNode() {
        return this.settingsNode;
    }

    public void setFilterDialogVisible(boolean selected) {
        this.movieFilterDialog.setVisible(selected);
    }
}

