/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.movies.dialogs.MovieBulkEditorDialog;

public class MovieBatchEditAction
extends TmmAction {
    private static final long serialVersionUID = -3974602352019088416L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieBatchEditAction() {
        this.putValue("Name", BUNDLE.getString("movie.bulkedit"));
        this.putValue("ShortDescription", BUNDLE.getString("movie.bulkedit.desc"));
        this.putValue("SmallIcon", IconManager.EDIT);
        this.putValue("SwingLargeIconKey", IconManager.EDIT);
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(66, 3));
    }

    @Override
    protected void processAction(ActionEvent e) {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        MovieBulkEditorDialog editor = new MovieBulkEditorDialog(selectedMovies);
        editor.setLocationRelativeTo(MainWindow.getActiveInstance());
        editor.pack();
        editor.setVisible(true);
    }
}

