/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.movies.dialogs.MovieEditorDialog;

public class MovieEditAction
extends TmmAction {
    private static final long serialVersionUID = -8473181347332963044L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    @Deprecated
    public MovieEditAction(boolean withTitle) {
        if (withTitle) {
            this.putValue("Name", BUNDLE.getString("movie.edit"));
        }
        this.putValue("SwingLargeIconKey", IconManager.EDIT);
        this.putValue("SmallIcon", IconManager.EDIT);
        this.putValue("ShortDescription", BUNDLE.getString("movie.edit"));
    }

    public MovieEditAction() {
        this.putValue("Name", BUNDLE.getString("movie.edit"));
        this.putValue("SwingLargeIconKey", IconManager.EDIT);
        this.putValue("SmallIcon", IconManager.EDIT);
        this.putValue("ShortDescription", BUNDLE.getString("movie.edit"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(69, 3));
    }

    @Override
    protected void processAction(ActionEvent e) {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        int selectedCount = selectedMovies.size();
        int index = 0;
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        do {
            Movie movie = (Movie)selectedMovies.get(index);
            MovieEditorDialog dialogMovieEditor = new MovieEditorDialog(movie, index, selectedCount);
            dialogMovieEditor.setVisible(true);
            if (!dialogMovieEditor.isContinueQueue()) break;
            if (dialogMovieEditor.isNavigateBack()) {
                --index;
                continue;
            }
            ++index;
        } while (index < selectedCount);
    }
}

