/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.tinymediamanager.Globals;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tasks.ImageCacheTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieRebuildImageCacheAction
extends TmmAction {
    private static final long serialVersionUID = -5089957097690621345L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieRebuildImageCacheAction() {
        this.putValue("Name", BUNDLE.getString("movie.rebuildimagecache"));
        this.putValue("ShortDescription", BUNDLE.getString("movie.rebuildimagecache"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        if (!Globals.settings.isImageCache()) {
            JOptionPane.showMessageDialog(null, BUNDLE.getString("tmm.imagecache.notactivated"));
            return;
        }
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        ArrayList<MediaFile> imageFiles = new ArrayList<MediaFile>();
        for (Movie movie : selectedMovies) {
            imageFiles.addAll(movie.getImagesToCache());
        }
        ImageCacheTask task = new ImageCacheTask(imageFiles);
        TmmTaskManager.getInstance().addUnnamedTask(task);
    }
}

