/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.tasks.MovieRenameTask;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;

public class MovieRenameAction
extends TmmAction {
    private static final long serialVersionUID = 4804592958868052533L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieRenameAction() {
        this.putValue("Name", BUNDLE.getString("movie.rename"));
        this.putValue("ShortDescription", BUNDLE.getString("movie.rename"));
        this.putValue("AcceleratorKey", KeyStroke.getKeyStroke(82, 3));
    }

    @Override
    protected void processAction(ActionEvent e) {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        if (!TmmProperties.getInstance().getPropertyAsBoolean("movie.hiderenamehint").booleanValue()) {
            JCheckBox checkBox = new JCheckBox(BUNDLE.getString("tmm.donotshowagain"));
            TmmFontHelper.changeFont((JComponent)checkBox, TmmFontHelper.L1);
            checkBox.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
            Object[] params = new Object[]{BUNDLE.getString("movie.rename.desc"), checkBox};
            int answer = JOptionPane.showConfirmDialog(MainWindow.getActiveInstance(), params, BUNDLE.getString("movie.rename"), 0);
            if (checkBox.isSelected()) {
                TmmProperties.getInstance().putProperty("movie.hiderenamehint", String.valueOf(checkBox.isSelected()));
            }
            if (answer != 0) {
                return;
            }
        }
        MovieRenameTask renameTask = new MovieRenameTask(selectedMovies);
        if (TmmTaskManager.getInstance().addMainTask(renameTask)) {
            JOptionPane.showMessageDialog(null, BUNDLE.getString("onlyoneoperation"));
        }
    }
}

