/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javax.swing.JOptionPane;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.actions.TmmAction;
import org.tinymediamanager.ui.movies.MovieUIModule;
import org.tinymediamanager.ui.movies.dialogs.MovieSubtitleChooserDialog;

public class MovieSubtitleSearchAction
extends TmmAction {
    private static final long serialVersionUID = -6006932119900795735L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());

    public MovieSubtitleSearchAction() {
        this.putValue("Name", BUNDLE.getString("movie.search.subtitle"));
        this.putValue("SmallIcon", IconManager.SUBTITLE);
        this.putValue("SwingLargeIconKey", IconManager.SUBTITLE);
        this.putValue("ShortDescription", BUNDLE.getString("movie.search.subtitle"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        ArrayList<Movie> selectedMovies = new ArrayList<Movie>(MovieUIModule.getInstance().getSelectionModel().getSelectedMovies());
        if (selectedMovies.isEmpty()) {
            JOptionPane.showMessageDialog(MainWindow.getActiveInstance(), BUNDLE.getString("tmm.nothingselected"));
            return;
        }
        for (Movie movie : selectedMovies) {
            if (movie.isDisc()) continue;
            for (MediaFile mediaFile : movie.getMediaFiles(MediaFileType.VIDEO)) {
                MovieSubtitleChooserDialog dialogMovieSubtitleChooser = new MovieSubtitleChooserDialog(movie, mediaFile, selectedMovies.size() > 1);
                if (dialogMovieSubtitleChooser.showDialog()) continue;
                return;
            }
        }
    }
}

