/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.movie.MovieEdition;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.trakttv.SyncTraktTvTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.UTF8Control;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.combobox.AutocompleteComboBox;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.moviesets.actions.MovieSetAddAction;

public class MovieBulkEditorDialog
extends TmmDialog {
    private static final long serialVersionUID = -8515248604267310279L;
    private static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages", new UTF8Control());
    private MovieList movieList = MovieList.getInstance();
    private List<Movie> moviesToEdit;
    private boolean changed = false;
    private JComboBox cbMovieSet;

    public MovieBulkEditorDialog(List<Movie> movies) {
        super(BUNDLE.getString("movie.edit"), "movieBatchEditor");
        JPanel panelContent = new JPanel();
        this.getContentPane().add((Component)panelContent, "Center");
        panelContent.setLayout((LayoutManager)new MigLayout("", "[][100lp,grow][][][]", "[][][][][][][][][][][][]"));
        TmmLabel lblGenresT = new TmmLabel(BUNDLE.getString("metatag.genre"));
        panelContent.add((Component)lblGenresT, "cell 0 0,alignx right");
        AutocompleteComboBox<MediaGenres> cbGenres = new AutocompleteComboBox<MediaGenres>(MediaGenres.values());
        cbGenres.setEditable(true);
        panelContent.add(cbGenres, "cell 1 0, growx, wmin 0");
        JButton btnAddGenre = new JButton("");
        btnAddGenre.setIcon(IconManager.ADD_INV);
        btnAddGenre.setMargin(new Insets(2, 2, 2, 2));
        btnAddGenre.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            MediaGenres genre = null;
            Object item = cbGenres.getSelectedItem();
            if (item instanceof MediaGenres) {
                genre = (MediaGenres)item;
            }
            if (item instanceof String) {
                genre = MediaGenres.getGenre((String)((String)item));
            }
            if (genre != null) {
                for (Movie movie : this.moviesToEdit) {
                    movie.addGenre(genre);
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnAddGenre, "cell 2 0");
        JButton btnRemoveGenre = new JButton("");
        btnRemoveGenre.setIcon(IconManager.REMOVE_INV);
        btnRemoveGenre.setMargin(new Insets(2, 2, 2, 2));
        btnRemoveGenre.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            MediaGenres genre = null;
            Object item = cbGenres.getSelectedItem();
            if (item instanceof MediaGenres) {
                genre = (MediaGenres)item;
            }
            if (item instanceof String) {
                genre = MediaGenres.getGenre((String)((String)item));
            }
            if (genre != null) {
                for (Movie movie : this.moviesToEdit) {
                    movie.removeGenre(genre);
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnRemoveGenre, "cell 3 0");
        JButton btnRemoveAllGenres = new JButton("");
        btnRemoveAllGenres.setIcon(IconManager.DELETE);
        btnRemoveAllGenres.setMargin(new Insets(2, 2, 2, 2));
        btnRemoveAllGenres.addActionListener(e -> {
            if (this.isDeleteConfirmed(BUNDLE.getString("metatag.genre"))) {
                this.changed = true;
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (Movie movie : this.moviesToEdit) {
                    movie.removeAllGenres();
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        panelContent.add((Component)btnRemoveAllGenres, "cell 4 0");
        TmmLabel lblTagsT = new TmmLabel(BUNDLE.getString("metatag.tags"));
        panelContent.add((Component)lblTagsT, "cell 0 1,alignx right");
        AutocompleteComboBox<Object> cbTags = new AutocompleteComboBox<Object>(this.movieList.getTagsInMovies().toArray());
        cbTags.setEditable(true);
        panelContent.add(cbTags, "cell 1 1, growx, wmin 0");
        JButton btnAddTag = new JButton("");
        btnAddTag.setIcon(IconManager.ADD_INV);
        btnAddTag.setMargin(new Insets(2, 2, 2, 2));
        btnAddTag.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            String tag = (String)cbTags.getSelectedItem();
            if (StringUtils.isBlank((CharSequence)tag)) {
                return;
            }
            for (Movie movie : this.moviesToEdit) {
                movie.addToTags(tag);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnAddTag, "cell 2 1");
        JButton btnRemoveTag = new JButton("");
        btnRemoveTag.setIcon(IconManager.REMOVE_INV);
        btnRemoveTag.setMargin(new Insets(2, 2, 2, 2));
        btnRemoveTag.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            String tag = (String)cbTags.getSelectedItem();
            for (Movie movie : this.moviesToEdit) {
                movie.removeFromTags(tag);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnRemoveTag, "cell 3 1");
        JButton btnRemoveAllTags = new JButton("");
        btnRemoveAllTags.setIcon(IconManager.DELETE);
        btnRemoveAllTags.setMargin(new Insets(2, 2, 2, 2));
        btnRemoveAllTags.addActionListener(e -> {
            if (this.isDeleteConfirmed(BUNDLE.getString("metatag.tags"))) {
                this.changed = true;
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (Movie movie : this.moviesToEdit) {
                    movie.removeAllTags();
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        panelContent.add((Component)btnRemoveAllTags, "cell 4 1");
        TmmLabel lblEditionT = new TmmLabel(BUNDLE.getString("metatag.edition"));
        panelContent.add((Component)lblEditionT, "cell 0 2,alignx right");
        AutocompleteComboBox<MovieEdition> cbEdition = new AutocompleteComboBox<MovieEdition>(MovieEdition.values());
        panelContent.add(cbEdition, "cell 1 2,growx");
        JButton btnMovieEdition = new JButton("");
        btnMovieEdition.setIcon(IconManager.APPLY_INV);
        btnMovieEdition.setMargin(new Insets(2, 2, 2, 2));
        btnMovieEdition.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            MovieEdition edition = null;
            Object item = cbEdition.getSelectedItem();
            if (item instanceof MovieEdition) {
                edition = (MovieEdition)((Object)((Object)item));
            }
            if (item instanceof String) {
                edition = MovieEdition.getMovieEdition((String)item);
            }
            if (edition != null) {
                for (Movie movie : this.moviesToEdit) {
                    movie.setEdition(edition);
                }
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnMovieEdition, "cell 2 2");
        TmmLabel lblCertificationT = new TmmLabel(BUNDLE.getString("metatag.certification"));
        panelContent.add((Component)lblCertificationT, "cell 0 3,alignx right");
        JComboBox<Certification> cbCertification = new JComboBox<Certification>();
        for (Certification cert : Certification.getCertificationsforCountry((CountryCode)MovieModuleManager.SETTINGS.getCertificationCountry())) {
            cbCertification.addItem(cert);
        }
        panelContent.add(cbCertification, "cell 1 3,growx");
        JButton btnCertification = new JButton("");
        btnCertification.setMargin(new Insets(2, 2, 2, 2));
        btnCertification.setIcon(IconManager.APPLY_INV);
        btnCertification.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            Certification cert = (Certification)cbCertification.getSelectedItem();
            for (Movie movie : this.moviesToEdit) {
                movie.setCertification(cert);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnCertification, "cell 2 3");
        TmmLabel lblMovieSetT = new TmmLabel(BUNDLE.getString("metatag.movieset"));
        panelContent.add((Component)lblMovieSetT, "cell 0 4,alignx right");
        this.cbMovieSet = new JComboBox();
        panelContent.add((Component)this.cbMovieSet, "cell 1 4,growx,wmin 0");
        JButton btnSetMovieSet = new JButton("");
        btnSetMovieSet.setMargin(new Insets(2, 2, 2, 2));
        btnSetMovieSet.setIcon(IconManager.APPLY_INV);
        btnSetMovieSet.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            Object obj = this.cbMovieSet.getSelectedItem();
            for (Movie movie : this.moviesToEdit) {
                if (obj instanceof String) {
                    movie.removeFromMovieSet();
                }
                if (!(obj instanceof MovieSet)) continue;
                MovieSet movieSet = (MovieSet)obj;
                if (movie.getMovieSet() == movieSet) continue;
                movie.removeFromMovieSet();
                movie.setMovieSet(movieSet);
                movieSet.insertMovie(movie);
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnSetMovieSet, "cell 2 4");
        JButton btnNewMovieset = new JButton("");
        btnNewMovieset.setMargin(new Insets(2, 2, 2, 2));
        btnNewMovieset.setAction(new MovieSetAddAction());
        panelContent.add((Component)btnNewMovieset, "cell 3 4 2 1,growx");
        TmmLabel lblWatchedT = new TmmLabel(BUNDLE.getString("metatag.watched"));
        panelContent.add((Component)lblWatchedT, "cell 0 5,alignx right");
        JCheckBox chckbxWatched = new JCheckBox("");
        panelContent.add((Component)chckbxWatched, "cell 1 5,aligny top");
        JButton btnWatched = new JButton("");
        btnWatched.setMargin(new Insets(2, 2, 2, 2));
        btnWatched.setIcon(IconManager.APPLY_INV);
        btnWatched.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (Movie movie : this.moviesToEdit) {
                movie.setWatched(chckbxWatched.isSelected());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnWatched, "cell 2 5");
        TmmLabel lblVideo3DT = new TmmLabel(BUNDLE.getString("metatag.3d"));
        panelContent.add((Component)lblVideo3DT, "cell 0 6,alignx right");
        JCheckBox chckbxVideo3D = new JCheckBox("");
        panelContent.add((Component)chckbxVideo3D, "cell 1 6");
        JButton btnVideo3D = new JButton("");
        btnVideo3D.setMargin(new Insets(2, 2, 2, 2));
        btnVideo3D.setIcon(IconManager.APPLY_INV);
        btnVideo3D.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (Movie movie : this.moviesToEdit) {
                movie.setVideoIn3D(chckbxVideo3D.isSelected());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnVideo3D, "cell 2 6");
        TmmLabel lblMediasourceT = new TmmLabel(BUNDLE.getString("metatag.source"));
        panelContent.add((Component)lblMediasourceT, "cell 0 7,alignx right");
        JComboBox<MediaSource> cbMediaSource = new JComboBox<MediaSource>(MediaSource.values());
        panelContent.add(cbMediaSource, "cell 1 7,growx");
        JButton btnMediaSource = new JButton("");
        btnMediaSource.setMargin(new Insets(2, 2, 2, 2));
        btnMediaSource.setIcon(IconManager.APPLY_INV);
        btnMediaSource.addActionListener(e -> {
            this.changed = true;
            Object obj = cbMediaSource.getSelectedItem();
            if (obj instanceof MediaSource) {
                MediaSource mediaSource = (MediaSource)((Object)((Object)obj));
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (Movie movie : this.moviesToEdit) {
                    movie.setMediaSource(mediaSource);
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
        });
        panelContent.add((Component)btnMediaSource, "cell 2 7");
        TmmLabel lblLanguageT = new TmmLabel(BUNDLE.getString("metatag.language"));
        panelContent.add((Component)lblLanguageT, "cell 0 8,alignx right");
        JTextField tfLanguage = new JTextField();
        panelContent.add((Component)tfLanguage, "cell 1 8,growx");
        tfLanguage.setColumns(10);
        JButton btnLanguage = new JButton("");
        btnLanguage.setMargin(new Insets(2, 2, 2, 2));
        btnLanguage.setIcon(IconManager.APPLY_INV);
        btnLanguage.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (Movie movie : this.moviesToEdit) {
                movie.setSpokenLanguages(tfLanguage.getText());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnLanguage, "cell 2 8");
        TmmLabel lblCountryT = new TmmLabel(BUNDLE.getString("metatag.country"));
        panelContent.add((Component)lblCountryT, "cell 0 9,alignx trailing");
        JTextField tfCountry = new JTextField();
        panelContent.add((Component)tfCountry, "cell 1 9,growx");
        tfCountry.setColumns(10);
        JButton btnCountry = new JButton("");
        btnCountry.setMargin(new Insets(2, 2, 2, 2));
        btnCountry.setIcon(IconManager.APPLY_INV);
        btnCountry.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (Movie movie : this.moviesToEdit) {
                movie.setCountry(tfCountry.getText());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnCountry, "cell 2 9");
        TmmLabel lblSorttitleT = new TmmLabel(BUNDLE.getString("metatag.sorttitle"));
        panelContent.add((Component)lblSorttitleT, "flowx,cell 0 10,alignx right");
        JLabel lblSorttitleInfo = new JLabel(IconManager.HINT);
        lblSorttitleInfo.setToolTipText(BUNDLE.getString("edit.setsorttitle.desc"));
        panelContent.add((Component)lblSorttitleInfo, "cell 0 10");
        JButton btnSetSorttitle = new JButton(BUNDLE.getString("edit.setsorttitle"));
        btnSetSorttitle.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (Movie movie : this.moviesToEdit) {
                movie.setSortTitle(movie.getTitleSortable());
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnSetSorttitle, "cell 1 10");
        JButton btnClearSorttitle = new JButton(BUNDLE.getString("edit.clearsorttitle"));
        btnClearSorttitle.addActionListener(e -> {
            this.changed = true;
            this.setCursor(Cursor.getPredefinedCursor(3));
            for (Movie movie : this.moviesToEdit) {
                movie.setSortTitle("");
            }
            this.setCursor(Cursor.getPredefinedCursor(0));
        });
        panelContent.add((Component)btnClearSorttitle, "cell 1 11");
        JButton btnClose = new JButton(BUNDLE.getString("Button.close"));
        btnClose.setIcon(IconManager.APPLY_INV);
        btnClose.addActionListener(arg0 -> {
            if (this.changed) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                for (Movie movie : this.moviesToEdit) {
                    movie.writeNFO();
                    movie.saveToDb();
                }
                this.setCursor(Cursor.getPredefinedCursor(0));
            }
            this.setVisible(false);
        });
        this.addDefaultButton(btnClose);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (MovieBulkEditorDialog.this.changed) {
                    for (Movie movie : MovieBulkEditorDialog.this.moviesToEdit) {
                        movie.writeNFO();
                        movie.saveToDb();
                    }
                    if (MovieModuleManager.SETTINGS.getSyncTrakt()) {
                        SyncTraktTvTask task = new SyncTraktTvTask(MovieBulkEditorDialog.this.moviesToEdit, null);
                        TmmTaskManager.getInstance().addUnnamedTask(task);
                    }
                }
            }
        });
        this.setMovieSets();
        this.moviesToEdit = movies;
        PropertyChangeListener listener = evt -> {
            if ("addedMovieSet".equals(evt.getPropertyName())) {
                this.setMovieSets();
            }
        };
        this.movieList.addPropertyChangeListener(listener);
    }

    private void setMovieSets() {
        MovieSet selectedMovieSet = null;
        Object obj = this.cbMovieSet.getSelectedItem();
        if (obj instanceof MovieSet) {
            selectedMovieSet = (MovieSet)obj;
        }
        this.cbMovieSet.removeAllItems();
        this.cbMovieSet.addItem("");
        for (MovieSet movieSet : this.movieList.getSortedMovieSetList()) {
            this.cbMovieSet.addItem(movieSet);
        }
        if (selectedMovieSet != null) {
            this.cbMovieSet.setSelectedItem(selectedMovieSet);
        }
    }

    private boolean isDeleteConfirmed(String attribute) {
        int dialogResult = JOptionPane.showConfirmDialog(null, MessageFormat.format(BUNDLE.getString("message.bulkedit.delete"), attribute), BUNDLE.getString("message.bulkedit.warning"), 0);
        return dialogResult == 0;
    }
}

