/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.swing.AutoCompleteSupport;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JLayer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpinnerDateModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Property;
import org.jdesktop.observablecollections.ObservableCollections;
import org.jdesktop.swingbinding.JListBinding;
import org.jdesktop.swingbinding.JTableBinding;
import org.jdesktop.swingbinding.SwingBindings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.MediaSource;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.entities.Rating;
import org.tinymediamanager.core.movie.MovieEdition;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.core.movie.entities.MovieTrailer;
import org.tinymediamanager.core.threading.TmmTaskManager;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.scraper.entities.Certification;
import org.tinymediamanager.scraper.entities.CountryCode;
import org.tinymediamanager.scraper.entities.MediaGenres;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.trakttv.SyncTraktTvTask;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.ShadowLayerUI;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.UIConstants;
import org.tinymediamanager.ui.components.ImageLabel;
import org.tinymediamanager.ui.components.LinkLabel;
import org.tinymediamanager.ui.components.MainTabbedPane;
import org.tinymediamanager.ui.components.MediaIdTable;
import org.tinymediamanager.ui.components.MediaRatingTable;
import org.tinymediamanager.ui.components.PersonTable;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.components.combobox.AutocompleteComboBox;
import org.tinymediamanager.ui.components.datepicker.DatePicker;
import org.tinymediamanager.ui.components.datepicker.YearSpinner;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.dialogs.IdEditorDialog;
import org.tinymediamanager.ui.dialogs.ImageChooserDialog;
import org.tinymediamanager.ui.dialogs.PersonEditorDialog;
import org.tinymediamanager.ui.dialogs.RatingEditorDialog;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.panels.MediaFileEditorPanel;

public class MovieEditorDialog
extends TmmDialog {
    private static final long serialVersionUID = -286251957529920347L;
    private static final Logger LOGGER = LoggerFactory.getLogger(MovieEditorDialog.class);
    private static final Insets BUTTON_MARGIN = UIConstants.SMALL_BUTTON_MARGIN;
    private static final String ORIGINAL_IMAGE_SIZE = "originalImageSize";
    private Movie movieToEdit;
    private MovieList movieList = MovieList.getInstance();
    private List<MediaGenres> genres = ObservableCollections.observableList(new ArrayList());
    private List<MovieTrailer> trailers = ObservableCollections.observableList(new ArrayList());
    private List<String> tags = ObservableCollections.observableList(new ArrayList());
    private EventList<MediaIdTable.MediaId> ids;
    private EventList<MediaRatingTable.MediaRating> ratings;
    private List<MediaFile> mediaFiles = new ArrayList<MediaFile>();
    private List<String> extrathumbs = null;
    private List<String> extrafanarts = null;
    private Rating userRating;
    private boolean continueQueue = true;
    private boolean navigateBack = false;
    private int queueIndex;
    private int queueSize;
    private EventList<Person> cast;
    private EventList<Person> producers;
    private EventList<Person> directors;
    private EventList<Person> writers;
    private JTextField tfTitle;
    private JTextField tfOriginalTitle;
    private YearSpinner spYear;
    private JTextArea taPlot;
    private ImageLabel lblPoster;
    private ImageLabel lblFanart;
    private JSpinner spRuntime;
    private JTextField tfProductionCompanies;
    private JList<MediaGenres> listGenres;
    private AutocompleteComboBox<MediaGenres> cbGenres;
    private AutoCompleteSupport<MediaGenres> cbGenresAutoCompleteSupport;
    private JSpinner spRating;
    private JComboBox<Certification> cbCertification;
    private JCheckBox cbWatched;
    private JTextField tfTagline;
    private JTextField tfNote;
    private JCheckBox chckbxVideo3D;
    private AutocompleteComboBox<String> cbTags;
    private AutoCompleteSupport<String> cbTagsAutoCompleteSupport;
    private JList<String> listTags;
    private JSpinner spDateAdded;
    private JComboBox cbMovieSet;
    private JTextField tfSorttitle;
    private JTextField tfSpokenLanguages;
    private JTextField tfCountry;
    private DatePicker dpReleaseDate;
    private JSpinner spTop250;
    private AutocompleteComboBox<MediaSource> cbSource;
    private MediaFileEditorPanel mediaFilesPanel;
    private AutocompleteComboBox<MovieEdition> cbEdition;
    private JTextField tfPoster;
    private JTextField tfFanart;
    private JTextField tfLogo;
    private JTextField tfClearLogo;
    private JTextField tfBanner;
    private JTextField tfClearArt;
    private JTextField tfThumb;
    private JTextField tfDisc;
    private JTextField tfKeyart;
    private ImageLabel lblLogo;
    private ImageLabel lblClearlogo;
    private ImageLabel lblBanner;
    private ImageLabel lblClearart;
    private ImageLabel lblThumb;
    private ImageLabel lblDisc;
    private ImageLabel lblKeyart;
    private TmmTable tableIds;
    private TmmTable tableRatings;
    private TmmTable tableTrailer;
    private TmmTable tableActors;
    private TmmTable tableProducers;
    private TmmTable tableDirectors;
    private TmmTable tableWriters;
    private LinkLabel lblPosterSize = new LinkLabel();
    private LinkLabel lblFanartSize = new LinkLabel();
    private LinkLabel lblLogoSize = new LinkLabel();
    private LinkLabel lblClearlogoSize = new LinkLabel();
    private LinkLabel lblBannerSize = new LinkLabel();
    private LinkLabel lblClearartSize = new LinkLabel();
    private LinkLabel lblThumbSize = new LinkLabel();
    private LinkLabel lblDiscSize = new LinkLabel();
    private LinkLabel lblKeyartSize = new LinkLabel();

    public MovieEditorDialog(Movie movie, int queueIndex, int queueSize) {
        super(BUNDLE.getString("movie.edit") + (queueSize > 1 ? " " + (queueIndex + 1) + "/" + queueSize : "") + "  < " + movie.getPathNIO() + " >", "movieEditor");
        this.cast = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(Person.class));
        this.producers = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(Person.class));
        this.directors = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(Person.class));
        this.writers = new ObservableElementList((EventList)GlazedLists.threadSafeList((EventList)new BasicEventList()), GlazedLists.beanConnector(Person.class));
        this.movieToEdit = movie;
        this.queueIndex = queueIndex;
        this.queueSize = queueSize;
        this.ids = MediaIdTable.convertIdMapToEventList(this.movieToEdit.getIds());
        this.ratings = MediaRatingTable.convertRatingMapToEventList(this.movieToEdit.getRatings(), false);
        this.userRating = this.movieToEdit.getRating("user");
        for (MediaFile mf : movie.getMediaFiles()) {
            this.mediaFiles.add(new MediaFile(mf));
        }
        this.initComponents();
        this.bindingGroup = this.initDataBindings();
        int year = this.movieToEdit.getYear();
        List availableCertifications = Certification.getCertificationsforCountry((CountryCode)MovieModuleManager.SETTINGS.getCertificationCountry());
        if (!availableCertifications.contains(this.movieToEdit.getCertification())) {
            availableCertifications.add(0, this.movieToEdit.getCertification());
        }
        for (Certification cert : availableCertifications) {
            this.cbCertification.addItem(cert);
        }
        this.tfTitle.setText(this.movieToEdit.getTitle());
        this.tfOriginalTitle.setText(this.movieToEdit.getOriginalTitle());
        this.tfSorttitle.setText(this.movieToEdit.getSortTitle());
        this.spYear.setValue(year);
        this.spDateAdded.setValue(this.movieToEdit.getDateAdded());
        this.tfPoster.setText(this.movieToEdit.getArtworkUrl(MediaFileType.POSTER));
        this.tfFanart.setText(this.movieToEdit.getArtworkUrl(MediaFileType.FANART));
        this.tfLogo.setText(this.movieToEdit.getArtworkUrl(MediaFileType.LOGO));
        this.tfClearLogo.setText(this.movieToEdit.getArtworkUrl(MediaFileType.CLEARLOGO));
        this.tfClearArt.setText(this.movieToEdit.getArtworkUrl(MediaFileType.CLEARART));
        this.tfThumb.setText(this.movieToEdit.getArtworkUrl(MediaFileType.THUMB));
        this.tfDisc.setText(this.movieToEdit.getArtworkUrl(MediaFileType.DISC));
        this.tfBanner.setText(this.movieToEdit.getArtworkUrl(MediaFileType.BANNER));
        this.tfKeyart.setText(this.movieToEdit.getArtworkUrl(MediaFileType.KEYART));
        this.lblPoster.setImagePath(this.movieToEdit.getArtworkFilename(MediaFileType.POSTER));
        this.lblFanart.setImagePath(this.movieToEdit.getArtworkFilename(MediaFileType.FANART));
        this.lblLogo.setImagePath(this.movieToEdit.getArtworkFilename(MediaFileType.LOGO));
        this.lblClearlogo.setImagePath(this.movieToEdit.getArtworkFilename(MediaFileType.CLEARLOGO));
        this.lblClearart.setImagePath(this.movieToEdit.getArtworkFilename(MediaFileType.CLEARART));
        this.lblThumb.setImagePath(this.movieToEdit.getArtworkFilename(MediaFileType.THUMB));
        this.lblDisc.setImagePath(this.movieToEdit.getArtworkFilename(MediaFileType.DISC));
        this.lblBanner.setImagePath(this.movieToEdit.getArtworkFilename(MediaFileType.BANNER));
        this.lblKeyart.setImagePath(this.movieToEdit.getArtworkFilename(MediaFileType.KEYART));
        this.cbEdition.setSelectedItem((Object)this.movieToEdit.getEdition());
        this.cbCertification.setSelectedItem(this.movieToEdit.getCertification());
        this.chckbxVideo3D.setSelected(this.movieToEdit.isVideoIn3D());
        this.cbSource.setSelectedItem((Object)this.movieToEdit.getMediaSource());
        this.cbWatched.setSelected(this.movieToEdit.isWatched());
        this.tfTagline.setText(this.movieToEdit.getTagline());
        this.taPlot.setText(this.movieToEdit.getPlot());
        this.taPlot.setCaretPosition(0);
        this.spRuntime.setValue(this.movieToEdit.getRuntime());
        this.spTop250.setValue(movie.getTop250());
        this.tfProductionCompanies.setText(this.movieToEdit.getProductionCompany());
        this.tfSpokenLanguages.setText(this.movieToEdit.getSpokenLanguages());
        this.tfCountry.setText(this.movieToEdit.getCountry());
        this.spRating.setModel(new SpinnerNumberModel(this.userRating.getRating(), 0.0, 10.0, 0.1));
        this.tfNote.setText(this.movieToEdit.getNote());
        for (Person origCast : this.movieToEdit.getActors()) {
            this.cast.add((Object)new Person(origCast));
        }
        for (Person origProducer : this.movieToEdit.getProducers()) {
            this.producers.add((Object)new Person(origProducer));
        }
        for (Person origDirector : this.movieToEdit.getDirectors()) {
            this.directors.add((Object)new Person(origDirector));
        }
        for (Person origWriter : this.movieToEdit.getWriters()) {
            this.writers.add((Object)new Person(origWriter));
        }
        this.genres.addAll(this.movieToEdit.getGenres());
        this.trailers.addAll(this.movieToEdit.getTrailer());
        for (String tag : this.movieToEdit.getTags()) {
            if (!StringUtils.isNotBlank((CharSequence)tag)) continue;
            this.tags.add(tag);
        }
        if (MovieModuleManager.SETTINGS.isImageExtraThumbs()) {
            this.extrathumbs = new ArrayList<String>(this.movieToEdit.getExtraThumbs());
        }
        if (MovieModuleManager.SETTINGS.isImageExtraFanart()) {
            this.extrafanarts = new ArrayList<String>(this.movieToEdit.getExtraFanarts());
        }
        for (MovieSet movieSet : this.movieList.getSortedMovieSetList()) {
            this.cbMovieSet.addItem(movieSet);
            if (this.movieToEdit.getMovieSet() != movieSet) continue;
            this.cbMovieSet.setSelectedItem(movieSet);
        }
        this.tableTrailer.getColumnModel().getColumn(0).setHeaderValue(BUNDLE.getString("metatag.nfo"));
        this.tableTrailer.getColumnModel().getColumn(1).setHeaderValue(BUNDLE.getString("metatag.name"));
        this.tableTrailer.getColumnModel().getColumn(2).setHeaderValue(BUNDLE.getString("metatag.source"));
        this.tableTrailer.getColumnModel().getColumn(3).setHeaderValue(BUNDLE.getString("metatag.quality"));
        this.tableTrailer.getColumnModel().getColumn(4).setHeaderValue(BUNDLE.getString("metatag.url"));
        this.tableTrailer.getColumnModel().getColumn(0).setMaxWidth(55);
        this.tableTrailer.adjustColumnPreferredWidths(5);
        this.tableRatings.adjustColumnPreferredWidths(5);
        this.tableTrailer.getModel().addTableModelListener(arg0 -> {
            int row;
            MovieTrailer changedTrailer;
            if (arg0.getColumn() == 0 && (changedTrailer = this.trailers.get(row = arg0.getFirstRow())).getInNfo().booleanValue()) {
                for (MovieTrailer trailer : this.trailers) {
                    if (trailer == changedTrailer) continue;
                    trailer.setInNfo(Boolean.FALSE);
                }
            }
        });
    }

    private void initComponents() {
        MainTabbedPane tabbedPane = new MainTabbedPane(){
            private static final long serialVersionUID = 71548865608767532L;

            @Override
            public void updateUI() {
                this.putClientProperty("bottomBorder", Boolean.FALSE);
                super.updateUI();
            }
        };
        JLayer<JComponent> rootLayer = new JLayer<JComponent>(tabbedPane, new ShadowLayerUI());
        this.getContentPane().add(rootLayer, "Center");
        JPanel details1Panel = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("metatag.details"), details1Panel);
        details1Panel.setLayout((LayoutManager)new MigLayout("", "[][grow][50lp:75lp][][60lp:75lp][100lp:n][50lp:75lp,grow][25lp:n][200lp:250lp,grow]", "[][][][][100lp:175lp][][][][][][][75lp:100lp][]"));
        TmmLabel lblTitle = new TmmLabel(BUNDLE.getString("metatag.title"));
        details1Panel.add((Component)lblTitle, "cell 0 0,alignx right");
        this.tfTitle = new JTextField();
        details1Panel.add((Component)this.tfTitle, "flowx,cell 1 0 6 1,growx,wmin 0");
        this.lblPoster = new ImageLabel();
        this.lblPoster.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieEditorDialog.this, new HashMap<String, Object>(MovieEditorDialog.this.movieToEdit.getIds()), ImageChooserDialog.ImageType.POSTER, MovieEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieEditorDialog.this.lblPoster, null, null, MediaType.MOVIE);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                MovieEditorDialog.this.updateArtworkUrl(MovieEditorDialog.this.lblPoster, MovieEditorDialog.this.tfPoster);
            }
        });
        this.lblPoster.setCursor(Cursor.getPredefinedCursor(12));
        details1Panel.add((Component)new TmmLabel(BUNDLE.getString("mediafiletype.poster")), "cell 8 0");
        details1Panel.add((Component)this.lblPosterSize, "cell 8 0");
        details1Panel.add((Component)this.lblPoster, "cell 8 1 1 6,grow");
        this.lblPoster.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(this.lblPosterSize, this.lblPoster, MediaFileType.POSTER));
        TmmLabel lblOriginalTitle = new TmmLabel(BUNDLE.getString("metatag.originaltitle"));
        details1Panel.add((Component)lblOriginalTitle, "cell 0 1,alignx right");
        this.tfOriginalTitle = new JTextField();
        details1Panel.add((Component)this.tfOriginalTitle, "cell 1 1 6 1,growx,wmin 0");
        TmmLabel lblSorttitle = new TmmLabel(BUNDLE.getString("metatag.sorttitle"));
        details1Panel.add((Component)lblSorttitle, "cell 0 2,alignx right");
        this.tfSorttitle = new JTextField();
        details1Panel.add((Component)this.tfSorttitle, "cell 1 2 6 1,growx,wmin 0");
        TmmLabel lblTagline = new TmmLabel(BUNDLE.getString("metatag.tagline"));
        details1Panel.add((Component)lblTagline, "cell 0 3,alignx right,aligny top");
        this.tfTagline = new JTextField();
        details1Panel.add((Component)this.tfTagline, "cell 1 3 6 1,growx,wmin 0");
        TmmLabel lblPlot = new TmmLabel(BUNDLE.getString("metatag.plot"));
        details1Panel.add((Component)lblPlot, "cell 0 4,alignx right,aligny top");
        JScrollPane scrollPanePlot = new JScrollPane();
        details1Panel.add((Component)scrollPanePlot, "cell 1 4 6 1,grow,wmin 0");
        this.taPlot = new JTextArea();
        this.taPlot.setLineWrap(true);
        this.taPlot.setWrapStyleWord(true);
        this.taPlot.setForeground(UIManager.getColor("TextField.foreground"));
        scrollPanePlot.setViewportView(this.taPlot);
        TmmLabel lblYear = new TmmLabel(BUNDLE.getString("metatag.year"));
        details1Panel.add((Component)lblYear, "cell 0 5,alignx right");
        this.spYear = new YearSpinner();
        details1Panel.add((Component)this.spYear, "cell 1 5,growx");
        TmmLabel lblReleaseDate = new TmmLabel(BUNDLE.getString("metatag.releasedate"));
        details1Panel.add((Component)lblReleaseDate, "cell 3 5,alignx right");
        this.dpReleaseDate = new DatePicker(this.movieToEdit.getReleaseDate());
        details1Panel.add((Component)this.dpReleaseDate, "cell 4 5 2 1,growx");
        TmmLabel lblCompany = new TmmLabel(BUNDLE.getString("metatag.production"));
        details1Panel.add((Component)lblCompany, "cell 0 6,alignx right");
        this.tfProductionCompanies = new JTextField();
        details1Panel.add((Component)this.tfProductionCompanies, "cell 1 6 6 1,growx,wmin 0");
        TmmLabel lblCountry = new TmmLabel(BUNDLE.getString("metatag.country"));
        details1Panel.add((Component)lblCountry, "cell 0 7,alignx right");
        this.tfCountry = new JTextField();
        details1Panel.add((Component)this.tfCountry, "cell 1 7 6 1,growx,wmin 0");
        TmmLabel lblSpokenLanguages = new TmmLabel(BUNDLE.getString("metatag.spokenlanguages"));
        details1Panel.add((Component)lblSpokenLanguages, "cell 0 8,alignx right");
        this.tfSpokenLanguages = new JTextField();
        details1Panel.add((Component)this.tfSpokenLanguages, "cell 1 8 6 1,growx,wmin 0");
        TmmLabel lblCertification = new TmmLabel(BUNDLE.getString("metatag.certification"));
        details1Panel.add((Component)lblCertification, "cell 0 9,alignx right");
        this.cbCertification = new JComboBox();
        details1Panel.add(this.cbCertification, "cell 1 9,growx");
        this.cbCertification.setSelectedItem(this.movieToEdit.getCertification());
        TmmLabel lblRating = new TmmLabel(BUNDLE.getString("metatag.userrating"));
        details1Panel.add((Component)lblRating, "cell 0 10,alignx right");
        this.spRating = new JSpinner();
        details1Panel.add((Component)this.spRating, "cell 1 10,growx");
        TmmLabel lblRatingsT = new TmmLabel(BUNDLE.getString("metatag.ratings"));
        details1Panel.add((Component)lblRatingsT, "flowy,cell 0 11,alignx right,aligny top");
        JScrollPane scrollPaneRatings = new JScrollPane();
        details1Panel.add((Component)scrollPaneRatings, "cell 1 11 5 1,grow,wmin 0");
        this.tableRatings = new MediaRatingTable(this.ratings);
        this.tableRatings.configureScrollPane(scrollPaneRatings);
        scrollPaneRatings.setViewportView(this.tableRatings);
        TmmLabel lblTop = new TmmLabel(BUNDLE.getString("metatag.top250"));
        details1Panel.add((Component)lblTop, "cell 3 10,alignx right,aligny top");
        this.spTop250 = new JSpinner();
        details1Panel.add((Component)this.spTop250, "cell 4 10,growx");
        this.lblFanart = new ImageLabel();
        this.lblFanart.setCursor(Cursor.getPredefinedCursor(12));
        this.lblFanart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieEditorDialog.this, new HashMap<String, Object>(MovieEditorDialog.this.movieToEdit.getIds()), ImageChooserDialog.ImageType.FANART, MovieEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieEditorDialog.this.lblFanart, MovieEditorDialog.this.extrathumbs, MovieEditorDialog.this.extrafanarts, MediaType.MOVIE);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                MovieEditorDialog.this.updateArtworkUrl(MovieEditorDialog.this.lblFanart, MovieEditorDialog.this.tfFanart);
            }
        });
        details1Panel.add((Component)new TmmLabel(BUNDLE.getString("mediafiletype.fanart")), "cell 8 8");
        details1Panel.add((Component)this.lblFanartSize, "cell 8 8");
        details1Panel.add((Component)this.lblFanart, "cell 8 9 1 4,grow");
        this.lblFanart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(this.lblFanartSize, this.lblFanart, MediaFileType.FANART));
        JButton btnAddRating = new JButton(new AddRatingAction());
        btnAddRating.setMargin(BUTTON_MARGIN);
        details1Panel.add((Component)btnAddRating, "cell 0 11,alignx right,aligny top");
        JButton btnRemoveRating = new JButton(new RemoveRatingAction());
        btnRemoveRating.setMargin(BUTTON_MARGIN);
        details1Panel.add((Component)btnRemoveRating, "cell 0 11,alignx right,aligny top");
        JButton btnPlay = new JButton(IconManager.PLAY_INV);
        btnPlay.setFocusable(false);
        btnPlay.addActionListener(e -> {
            MediaFile mf = this.movieToEdit.getMainVideoFile();
            try {
                TmmUIHelper.openFile(mf.getFileAsPath());
            }
            catch (Exception ex) {
                LOGGER.error("open file - {}", (Object)e);
                MessageManager.instance.pushMessage(new Message(Message.MessageLevel.ERROR, (Object)mf, "message.erroropenfile", new String[]{":", ex.getLocalizedMessage()}));
            }
        });
        details1Panel.add((Component)btnPlay, "cell 1 0 6 1");
        TmmLabel lblNoteT = new TmmLabel(BUNDLE.getString("metatag.note"));
        details1Panel.add((Component)lblNoteT, "cell 0 12,alignx trailing");
        this.tfNote = new JTextField();
        details1Panel.add((Component)this.tfNote, "cell 1 12 6 1,growx");
        JPanel details2Panel = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("metatag.details2"), details2Panel);
        details2Panel.setLayout((LayoutManager)new MigLayout("", "[][][20lp:50lp][][50lp:100lp][20lp:n][][300lp:300lp]", "[][][][][][pref!][20lp:n][100lp:150lp,grow][][grow 200]"));
        TmmLabel lblDateAdded = new TmmLabel(BUNDLE.getString("metatag.dateadded"));
        details2Panel.add((Component)lblDateAdded, "cell 0 0,alignx right");
        this.spDateAdded = new JSpinner(new SpinnerDateModel());
        details2Panel.add((Component)this.spDateAdded, "cell 1 0,growx");
        TmmLabel lblWatched = new TmmLabel(BUNDLE.getString("metatag.watched"));
        details2Panel.add((Component)lblWatched, "flowx,cell 3 0");
        TmmLabel label = new TmmLabel(BUNDLE.getString("metatag.ids"));
        details2Panel.add((Component)label, "flowy,cell 6 0 1 3,alignx right,aligny top");
        JScrollPane scrollPaneIds = new JScrollPane();
        details2Panel.add((Component)scrollPaneIds, "cell 7 0 1 6,growx");
        this.tableIds = new MediaIdTable(this.ids);
        this.tableIds.configureScrollPane(scrollPaneIds);
        scrollPaneIds.setViewportView(this.tableIds);
        TmmLabel lblSourceT = new TmmLabel(BUNDLE.getString("metatag.source"));
        details2Panel.add((Component)lblSourceT, "cell 0 1,alignx right");
        this.cbSource = new AutocompleteComboBox<MediaSource>(MediaSource.values());
        details2Panel.add(this.cbSource, "cell 1 1,growx");
        label = new TmmLabel("3D");
        details2Panel.add((Component)label, "flowx,cell 3 1");
        TmmLabel lblEditionT = new TmmLabel(BUNDLE.getString("metatag.edition"));
        details2Panel.add((Component)lblEditionT, "cell 0 2,alignx right");
        this.cbEdition = new AutocompleteComboBox<MovieEdition>(MovieEdition.values());
        details2Panel.add(this.cbEdition, "cell 1 2 3 1");
        TmmLabel lblRuntime = new TmmLabel(BUNDLE.getString("metatag.runtime"));
        details2Panel.add((Component)lblRuntime, "cell 0 3,alignx right");
        this.spRuntime = new JSpinner();
        details2Panel.add((Component)this.spRuntime, "flowx,cell 1 3,growx");
        JLabel lblMin = new JLabel(BUNDLE.getString("metatag.minutes"));
        details2Panel.add((Component)lblMin, "cell 1 3");
        TmmLabel lblMovieSet = new TmmLabel(BUNDLE.getString("metatag.movieset"));
        details2Panel.add((Component)lblMovieSet, "cell 0 4,alignx right");
        this.cbMovieSet = new JComboBox();
        this.cbMovieSet.addItem("");
        details2Panel.add((Component)this.cbMovieSet, "cell 1 4 4 1, growx, wmin 0");
        TmmLabel lblGenres = new TmmLabel(BUNDLE.getString("metatag.genre"));
        details2Panel.add((Component)lblGenres, "flowy,cell 0 7,alignx right,aligny top");
        JScrollPane scrollPaneGenres = new JScrollPane();
        details2Panel.add((Component)scrollPaneGenres, "cell 1 7 4 1,grow");
        this.listGenres = new JList();
        scrollPaneGenres.setViewportView(this.listGenres);
        this.cbGenres = new AutocompleteComboBox<MediaGenres>(MediaGenres.values());
        this.cbGenresAutoCompleteSupport = this.cbGenres.getAutoCompleteSupport();
        InputMap im = this.cbGenres.getInputMap(1);
        Object enterAction = im.get(KeyStroke.getKeyStroke(10, 0));
        this.cbGenres.getActionMap().put(enterAction, new AddGenreAction());
        details2Panel.add(this.cbGenres, "cell 1 8 4 1, growx, wmin 0");
        TmmLabel lblTags = new TmmLabel(BUNDLE.getString("metatag.tags"));
        details2Panel.add((Component)lblTags, "flowy,cell 6 7,alignx right,aligny top");
        JScrollPane scrollPaneTags = new JScrollPane();
        details2Panel.add((Component)scrollPaneTags, "cell 7 7,grow");
        this.listTags = new JList();
        scrollPaneTags.setViewportView(this.listTags);
        this.cbTags = new AutocompleteComboBox<String>(this.movieList.getTagsInMovies());
        this.cbTagsAutoCompleteSupport = this.cbTags.getAutoCompleteSupport();
        im = this.cbTags.getInputMap(1);
        enterAction = im.get(KeyStroke.getKeyStroke(10, 0));
        this.cbTags.getActionMap().put(enterAction, new AddTagAction());
        details2Panel.add(this.cbTags, "cell 7 8, growx, wmin 0");
        JButton btnAddGenre = new JButton(new AddGenreAction());
        btnAddGenre.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnAddGenre, "cell 0 7,alignx right,aligny top");
        JButton btnRemoveGenre = new JButton(new RemoveGenreAction());
        btnRemoveGenre.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnRemoveGenre, "cell 0 7,alignx right,aligny top");
        JButton btnMoveGenreUp = new JButton(new MoveGenreUpAction());
        btnMoveGenreUp.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnMoveGenreUp, "cell 0 7,alignx right,aligny top");
        JButton btnMoveGenreDown = new JButton(new MoveGenreDownAction());
        btnMoveGenreDown.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnMoveGenreDown, "cell 0 7,alignx right,aligny top");
        JButton btnAddTag = new JButton(new AddTagAction());
        btnAddTag.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnAddTag, "cell 6 7,alignx right,aligny top");
        JButton btnRemoveTag = new JButton(new RemoveTagAction());
        btnRemoveTag.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnRemoveTag, "cell 6 7,alignx right,aligny top");
        JButton btnMoveTagUp = new JButton(new MoveTagUpAction());
        btnMoveTagUp.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnMoveTagUp, "cell 6 7,alignx right,aligny top");
        JButton btnMoveTagDown = new JButton(new MoveTagDownAction());
        btnMoveTagDown.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnMoveTagDown, "cell 6 7,alignx right,aligny top");
        JButton btnAddId = new JButton(new AddIdAction());
        btnAddId.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnAddId, "cell 6 0 1 3,alignx right,aligny top");
        JButton btnRemoveId = new JButton(new RemoveIdAction());
        btnRemoveId.setMargin(BUTTON_MARGIN);
        details2Panel.add((Component)btnRemoveId, "cell 6 0 1 3,alignx right,aligny top");
        this.cbWatched = new JCheckBox("");
        details2Panel.add((Component)this.cbWatched, "cell 3 0");
        this.chckbxVideo3D = new JCheckBox("");
        details2Panel.add((Component)this.chckbxVideo3D, "cell 3 1");
        JPanel crewPanel = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("movie.edit.castandcrew"), null, crewPanel, null);
        crewPanel.setLayout((LayoutManager)new MigLayout("", "[][150lp:300lp,grow][20lp:n][][150lp:300lp,grow]", "[100lp:250lp,grow][20lp:n][100lp:200lp,grow][grow]"));
        TmmLabel lblActors = new TmmLabel(BUNDLE.getString("metatag.actors"));
        crewPanel.add((Component)lblActors, "flowy,cell 0 0,alignx right,aligny top");
        JScrollPane scrollPane = new JScrollPane();
        crewPanel.add((Component)scrollPane, "cell 1 0,grow");
        this.tableActors = new PersonTable(this.cast, true);
        this.tableActors.configureScrollPane(scrollPane);
        TmmLabel lblProducers = new TmmLabel(BUNDLE.getString("metatag.producers"));
        crewPanel.add((Component)lblProducers, "flowy,cell 3 0,alignx right,aligny top");
        scrollPane = new JScrollPane();
        crewPanel.add((Component)scrollPane, "cell 4 0,grow");
        this.tableProducers = new PersonTable(this.producers, true);
        this.tableProducers.configureScrollPane(scrollPane);
        TmmLabel lblDirectorsT = new TmmLabel(BUNDLE.getString("metatag.directors"));
        crewPanel.add((Component)lblDirectorsT, "flowy,cell 0 2,alignx right,aligny top");
        scrollPane = new JScrollPane();
        crewPanel.add((Component)scrollPane, "cell 1 2,grow");
        this.tableDirectors = new PersonTable(this.directors, true);
        this.tableDirectors.configureScrollPane(scrollPane);
        TmmLabel lblWritersT = new TmmLabel(BUNDLE.getString("metatag.writers"));
        crewPanel.add((Component)lblWritersT, "flowy,cell 3 2,alignx right,aligny top");
        scrollPane = new JScrollPane();
        crewPanel.add((Component)scrollPane, "cell 4 2,grow");
        this.tableWriters = new PersonTable(this.writers, true);
        this.tableWriters.configureScrollPane(scrollPane);
        JButton btnAddActor = new JButton(new AddActorAction());
        btnAddActor.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnAddActor, "cell 0 0,alignx right");
        JButton btnRemoveActor = new JButton(new RemoveActorAction());
        btnRemoveActor.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnRemoveActor, "cell 0 0,alignx right");
        JButton btnMoveActorUp = new JButton(new MoveActorUpAction());
        btnMoveActorUp.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnMoveActorUp, "cell 0 0,alignx right");
        JButton btnMoveActorDown = new JButton(new MoveActorDownAction());
        btnMoveActorDown.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnMoveActorDown, "cell 0 0,alignx right,aligny top");
        JButton btnAddProducer = new JButton(new AddProducerAction());
        btnAddProducer.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnAddProducer, "cell 3 0,alignx right");
        JButton btnRemoveProducer = new JButton(new RemoveProducerAction());
        btnRemoveProducer.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnRemoveProducer, "cell 3 0,alignx right");
        JButton btnMoveProducerUp = new JButton(new MoveProducerUpAction());
        btnMoveProducerUp.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnMoveProducerUp, "cell 3 0,alignx right");
        JButton btnMoveProducerDown = new JButton(new MoveProducerDownAction());
        btnMoveProducerDown.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnMoveProducerDown, "cell 3 0,alignx right,aligny top");
        JButton btnAddDirector = new JButton(new AddDirectorAction());
        btnAddDirector.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnAddDirector, "cell 0 2,alignx right");
        JButton btnRemoveDirector = new JButton(new RemoveDirectorAction());
        btnRemoveDirector.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnRemoveDirector, "cell 0 2,alignx right");
        JButton btnMoveDirectorUp = new JButton(new MoveDirectorUpAction());
        btnMoveDirectorUp.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnMoveDirectorUp, "cell 0 2,alignx right");
        JButton btnMoveDirectorDown = new JButton(new MoveDirectorDownAction());
        btnMoveDirectorDown.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnMoveDirectorDown, "cell 0 2,alignx right,aligny top");
        JButton btnAddWriter = new JButton(new AddWriterAction());
        btnAddWriter.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnAddWriter, "cell 3 2,alignx right");
        JButton btnRemoveWriter = new JButton(new RemoveWriterAction());
        btnRemoveWriter.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnRemoveWriter, "cell 3 2,alignx right");
        JButton btnMoveWriterUp = new JButton(new MoveWriterUpAction());
        btnMoveWriterUp.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnMoveWriterUp, "cell 3 2,alignx right");
        JButton btnMoveWriterDown = new JButton(new MoveWriterDownAction());
        btnMoveWriterDown.setMargin(BUTTON_MARGIN);
        crewPanel.add((Component)btnMoveWriterDown, "cell 3 2,alignx right,aligny top");
        JPanel artworkPanel = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("metatag.extraartwork"), null, artworkPanel, null);
        artworkPanel.setLayout((LayoutManager)new MigLayout("", "[200lp:300lp,grow][20lp:n][200lp:300lp,grow][20lp:n][100lp:200lp,grow]", "[][100lp:125lp,grow][20lp:n][][100lp:125lp,grow][20lp:n][][100lp:150lp,grow]"));
        TmmLabel lblLogoT = new TmmLabel(BUNDLE.getString("mediafiletype.logo"));
        artworkPanel.add((Component)lblLogoT, "cell 0 0");
        artworkPanel.add((Component)this.lblLogoSize, "cell 0 0");
        this.lblLogo = new ImageLabel();
        this.lblLogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieEditorDialog.this, new HashMap<String, Object>(MovieEditorDialog.this.movieToEdit.getIds()), ImageChooserDialog.ImageType.LOGO, MovieEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieEditorDialog.this.lblLogo, null, null, MediaType.MOVIE);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                MovieEditorDialog.this.updateArtworkUrl(MovieEditorDialog.this.lblLogo, MovieEditorDialog.this.tfLogo);
            }
        });
        this.lblLogo.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblLogo, "cell 0 1,grow");
        this.lblLogo.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(this.lblLogoSize, this.lblLogo, MediaFileType.LOGO));
        TmmLabel lblKeyartT = new TmmLabel(BUNDLE.getString("mediafiletype.keyart"));
        artworkPanel.add((Component)lblKeyartT, "cell 4 0");
        artworkPanel.add((Component)this.lblKeyartSize, "cell 4 0");
        this.lblKeyart = new ImageLabel();
        this.lblKeyart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieEditorDialog.this, new HashMap<String, Object>(MovieEditorDialog.this.movieToEdit.getIds()), ImageChooserDialog.ImageType.KEYART, MovieEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieEditorDialog.this.lblKeyart, null, null, MediaType.MOVIE);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                MovieEditorDialog.this.updateArtworkUrl(MovieEditorDialog.this.lblKeyart, MovieEditorDialog.this.tfKeyart);
            }
        });
        this.lblKeyart.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblKeyart, "cell 4 1 1 4,grow");
        this.lblKeyart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(this.lblKeyartSize, this.lblKeyart, MediaFileType.KEYART));
        TmmLabel lblClearlogoT = new TmmLabel(BUNDLE.getString("mediafiletype.clearlogo"));
        artworkPanel.add((Component)lblClearlogoT, "cell 2 0");
        artworkPanel.add((Component)this.lblClearlogoSize, "cell 2 0");
        this.lblClearlogo = new ImageLabel();
        this.lblClearlogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieEditorDialog.this, new HashMap<String, Object>(MovieEditorDialog.this.movieToEdit.getIds()), ImageChooserDialog.ImageType.CLEARLOGO, MovieEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieEditorDialog.this.lblClearlogo, null, null, MediaType.MOVIE);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                MovieEditorDialog.this.updateArtworkUrl(MovieEditorDialog.this.lblClearlogo, MovieEditorDialog.this.tfClearLogo);
            }
        });
        this.lblClearlogo.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblClearlogo, "cell 2 1,grow");
        this.lblClearlogo.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(this.lblClearlogoSize, this.lblClearlogo, MediaFileType.CLEARLOGO));
        TmmLabel lblBannerT = new TmmLabel(BUNDLE.getString("mediafiletype.banner"));
        artworkPanel.add((Component)lblBannerT, "cell 0 3");
        artworkPanel.add((Component)this.lblBannerSize, "cell 0 3");
        this.lblBanner = new ImageLabel();
        this.lblBanner.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieEditorDialog.this, new HashMap<String, Object>(MovieEditorDialog.this.movieToEdit.getIds()), ImageChooserDialog.ImageType.BANNER, MovieEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieEditorDialog.this.lblBanner, null, null, MediaType.MOVIE);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                MovieEditorDialog.this.updateArtworkUrl(MovieEditorDialog.this.lblBanner, MovieEditorDialog.this.tfBanner);
            }
        });
        this.lblBanner.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblBanner, "cell 0 4 3 1,grow");
        this.lblBanner.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(this.lblBannerSize, this.lblBanner, MediaFileType.BANNER));
        TmmLabel lblClearartT = new TmmLabel("ClearArt");
        artworkPanel.add((Component)lblClearartT, "cell 0 6");
        artworkPanel.add((Component)this.lblClearartSize, "cell 0 6");
        this.lblClearart = new ImageLabel();
        this.lblClearart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieEditorDialog.this, new HashMap<String, Object>(MovieEditorDialog.this.movieToEdit.getIds()), ImageChooserDialog.ImageType.CLEARART, MovieEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieEditorDialog.this.lblClearart, null, null, MediaType.MOVIE);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                MovieEditorDialog.this.updateArtworkUrl(MovieEditorDialog.this.lblClearart, MovieEditorDialog.this.tfClearArt);
            }
        });
        this.lblClearart.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblClearart, "cell 0 7,grow");
        this.lblClearart.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(this.lblClearartSize, this.lblClearart, MediaFileType.CLEARART));
        TmmLabel lblThumbT = new TmmLabel("Thumb");
        artworkPanel.add((Component)lblThumbT, "cell 2 6");
        artworkPanel.add((Component)this.lblThumbSize, "cell 2 6");
        this.lblThumb = new ImageLabel();
        this.lblThumb.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieEditorDialog.this, new HashMap<String, Object>(MovieEditorDialog.this.movieToEdit.getIds()), ImageChooserDialog.ImageType.THUMB, MovieEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieEditorDialog.this.lblThumb, null, null, MediaType.MOVIE);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                MovieEditorDialog.this.updateArtworkUrl(MovieEditorDialog.this.lblThumb, MovieEditorDialog.this.tfThumb);
            }
        });
        this.lblThumb.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblThumb, "cell 2 7,grow");
        this.lblThumb.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(this.lblThumbSize, this.lblThumb, MediaFileType.THUMB));
        TmmLabel lblDiscT = new TmmLabel("Disc");
        artworkPanel.add((Component)lblDiscT, "cell 4 6");
        artworkPanel.add((Component)this.lblDiscSize, "cell 4 6");
        this.lblDisc = new ImageLabel();
        this.lblDisc.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImageChooserDialog dialog = new ImageChooserDialog(MovieEditorDialog.this, new HashMap<String, Object>(MovieEditorDialog.this.movieToEdit.getIds()), ImageChooserDialog.ImageType.DISC, MovieEditorDialog.this.movieList.getDefaultArtworkScrapers(), MovieEditorDialog.this.lblDisc, null, null, MediaType.MOVIE);
                dialog.setLocationRelativeTo(MainWindow.getActiveInstance());
                dialog.setVisible(true);
                MovieEditorDialog.this.updateArtworkUrl(MovieEditorDialog.this.lblDisc, MovieEditorDialog.this.tfDisc);
            }
        });
        this.lblDisc.setCursor(Cursor.getPredefinedCursor(12));
        artworkPanel.add((Component)this.lblDisc, "cell 4 7,grow");
        this.lblDisc.addPropertyChangeListener(ORIGINAL_IMAGE_SIZE, e -> this.setImageSizeAndCreateLink(this.lblDiscSize, this.lblDisc, MediaFileType.DISC));
        JPanel artworkAndTrailerPanel = new JPanel();
        tabbedPane.addTab(BUNDLE.getString("edit.artworkandtrailer"), null, artworkAndTrailerPanel, null);
        artworkAndTrailerPanel.setLayout((LayoutManager)new MigLayout("", "[][grow]", "[][][][][][][][][][20lp:n][250lp]"));
        TmmLabel lblPosterT = new TmmLabel(BUNDLE.getString("mediafiletype.poster"));
        artworkAndTrailerPanel.add((Component)lblPosterT, "cell 0 0,alignx right");
        this.tfPoster = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfPoster, "cell 1 0,growx");
        TmmLabel lblFanartT = new TmmLabel(BUNDLE.getString("mediafiletype.fanart"));
        artworkAndTrailerPanel.add((Component)lblFanartT, "cell 0 1,alignx right");
        this.tfFanart = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfFanart, "cell 1 1,growx");
        lblLogoT = new TmmLabel(BUNDLE.getString("mediafiletype.logo"));
        artworkAndTrailerPanel.add((Component)lblLogoT, "cell 0 2,alignx right");
        this.tfLogo = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfLogo, "cell 1 2,growx");
        TmmLabel lblClearLogoT = new TmmLabel(BUNDLE.getString("mediafiletype.clearlogo"));
        artworkAndTrailerPanel.add((Component)lblClearLogoT, "cell 0 3,alignx right");
        this.tfClearLogo = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfClearLogo, "cell 1 3,growx");
        lblBannerT = new TmmLabel(BUNDLE.getString("mediafiletype.banner"));
        artworkAndTrailerPanel.add((Component)lblBannerT, "cell 0 4,alignx right");
        this.tfBanner = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfBanner, "cell 1 4,growx");
        TmmLabel lblClearArtT = new TmmLabel(BUNDLE.getString("mediafiletype.clearart"));
        artworkAndTrailerPanel.add((Component)lblClearArtT, "cell 0 5,alignx right");
        this.tfClearArt = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfClearArt, "cell 1 5,growx");
        lblThumbT = new TmmLabel(BUNDLE.getString("mediafiletype.thumb"));
        artworkAndTrailerPanel.add((Component)lblThumbT, "cell 0 6,alignx right");
        this.tfThumb = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfThumb, "cell 1 6,growx");
        lblDiscT = new TmmLabel(BUNDLE.getString("mediafiletype.disc"));
        artworkAndTrailerPanel.add((Component)lblDiscT, "cell 0 7,alignx trailing");
        this.tfDisc = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfDisc, "cell 1 7,growx");
        lblKeyartT = new TmmLabel(BUNDLE.getString("mediafiletype.keyart"));
        artworkAndTrailerPanel.add((Component)lblKeyartT, "cell 0 8,alignx trailing");
        this.tfKeyart = new JTextField();
        artworkAndTrailerPanel.add((Component)this.tfKeyart, "cell 1 8,growx");
        TmmLabel lblTrailer = new TmmLabel(BUNDLE.getString("metatag.trailer"));
        artworkAndTrailerPanel.add((Component)lblTrailer, "flowy,cell 0 10,alignx right,aligny top");
        JButton btnAddTrailer = new JButton(new AddTrailerAction());
        btnAddTrailer.setMargin(BUTTON_MARGIN);
        artworkAndTrailerPanel.add((Component)btnAddTrailer, "cell 0 10,alignx right,aligny top");
        JButton btnRemoveTrailer = new JButton(new RemoveTrailerAction());
        btnRemoveTrailer.setMargin(BUTTON_MARGIN);
        artworkAndTrailerPanel.add((Component)btnRemoveTrailer, "cell 0 10,alignx right,aligny top");
        JScrollPane scrollPaneTrailer = new JScrollPane();
        artworkAndTrailerPanel.add((Component)scrollPaneTrailer, "cell 1 10 7 1,grow");
        this.tableTrailer = new TmmTable();
        this.tableTrailer.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.tableTrailer.configureScrollPane(scrollPaneTrailer);
        scrollPaneTrailer.setViewportView(this.tableTrailer);
        this.mediaFilesPanel = new MediaFileEditorPanel(this.mediaFiles);
        tabbedPane.addTab(BUNDLE.getString("metatag.mediafiles"), null, this.mediaFilesPanel, null);
        this.mediaFilesPanel.setLayout((LayoutManager)new MigLayout("", "[400lp:500lp,grow,fill]", "[300lp:400lp,grow,fill]"));
        if (this.queueSize > 1) {
            JButton btnAbort = new JButton(new AbortQueueAction());
            this.addButton(btnAbort);
            if (this.queueIndex > 0) {
                JButton backButton = new JButton(new NavigateBackAction());
                this.addButton(backButton);
            }
        }
        JButton cancelButton = new JButton(new DiscardAction());
        this.addButton(cancelButton);
        JButton okButton = new JButton(new ChangeMovieAction());
        this.addDefaultButton(okButton);
    }

    private void updateArtworkUrl(ImageLabel imageLabel, JTextField textField) {
        if (StringUtils.isNotBlank((CharSequence)imageLabel.getImageUrl())) {
            textField.setText(imageLabel.getImageUrl());
        }
    }

    public boolean isContinueQueue() {
        return this.continueQueue;
    }

    public boolean isNavigateBack() {
        return this.navigateBack;
    }

    public boolean showDialog() {
        this.setLocationRelativeTo(MainWindow.getActiveInstance());
        this.setVisible(true);
        return this.continueQueue;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.mediaFilesPanel.unbindBindings();
        this.dpReleaseDate.cleanup();
    }

    protected BindingGroup initDataBindings() {
        JListBinding jListBinding = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.genres, this.listGenres);
        jListBinding.bind();
        JTableBinding jTableBinding_1 = SwingBindings.createJTableBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.trailers, (JTable)this.tableTrailer);
        BeanProperty trailerBeanProperty = BeanProperty.create((String)"inNfo");
        jTableBinding_1.addColumnBinding((Property)trailerBeanProperty).setColumnClass(Boolean.class);
        BeanProperty trailerBeanProperty_1 = BeanProperty.create((String)"name");
        jTableBinding_1.addColumnBinding((Property)trailerBeanProperty_1);
        BeanProperty trailerBeanProperty_2 = BeanProperty.create((String)"provider");
        jTableBinding_1.addColumnBinding((Property)trailerBeanProperty_2);
        BeanProperty trailerBeanProperty_3 = BeanProperty.create((String)"quality");
        jTableBinding_1.addColumnBinding((Property)trailerBeanProperty_3);
        BeanProperty trailerBeanProperty_4 = BeanProperty.create((String)"url");
        jTableBinding_1.addColumnBinding((Property)trailerBeanProperty_4);
        jTableBinding_1.bind();
        JListBinding jListBinding_1 = SwingBindings.createJListBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ, this.tags, this.listTags);
        jListBinding_1.bind();
        BindingGroup bindingGroup = new BindingGroup();
        bindingGroup.addBinding((Binding)jListBinding);
        bindingGroup.addBinding((Binding)jTableBinding_1);
        bindingGroup.addBinding((Binding)jListBinding_1);
        return bindingGroup;
    }

    private void setImageSizeAndCreateLink(LinkLabel lblSize, ImageLabel imageLabel, MediaFileType type) {
        TmmUIHelper.createLinkForImage(lblSize, imageLabel);
        Dimension dimension = this.movieToEdit.getArtworkDimension(type);
        if (dimension.width == 0 && dimension.height == 0) {
            lblSize.setText(imageLabel.getOriginalImageSize().width + "x" + imageLabel.getOriginalImageSize().height);
        } else {
            lblSize.setText(dimension.width + "x" + dimension.height);
        }
    }

    private class MoveWriterDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -6564146895819191932L;

        public MoveWriterDownAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.movewriterdown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableWriters.getSelectedRow();
            if (row < MovieEditorDialog.this.writers.size() - 1) {
                Collections.rotate(MovieEditorDialog.this.writers.subList(row, row + 2), -1);
                MovieEditorDialog.this.tableWriters.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class MoveWriterUpAction
    extends AbstractAction {
        private static final long serialVersionUID = 5775423424097844658L;

        public MoveWriterUpAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.movewriterup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableWriters.getSelectedRow();
            if (row > 0) {
                Collections.rotate(MovieEditorDialog.this.writers.subList(row - 1, row + 1), 1);
                MovieEditorDialog.this.tableWriters.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class RemoveWriterAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079826920821356196L;

        public RemoveWriterAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.writer.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableWriters.getSelectedRow();
            if (row > -1) {
                row = MovieEditorDialog.this.tableWriters.convertRowIndexToModel(row);
                MovieEditorDialog.this.writers.remove(row);
            }
        }
    }

    private class AddWriterAction
    extends AbstractAction {
        private static final long serialVersionUID = -8929331442958057771L;

        public AddWriterAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.writer.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Person person = new Person(Person.Type.DIRECTOR, BUNDLE.getString("writer.name.unknown"), "Writer");
            PersonEditorDialog dialog = new PersonEditorDialog(SwingUtilities.getWindowAncestor(MovieEditorDialog.this.tableWriters), BUNDLE.getString("cast.writer.add"), person);
            dialog.setVisible(true);
            if (StringUtils.isNotBlank((CharSequence)person.getName()) && !person.getName().equals(BUNDLE.getString("writer.name.unknown"))) {
                MovieEditorDialog.this.writers.add(0, (Object)person);
            }
        }
    }

    private class MoveDirectorDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -6564146895819191932L;

        public MoveDirectorDownAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.movedirectordown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableDirectors.getSelectedRow();
            if (row < MovieEditorDialog.this.directors.size() - 1) {
                Collections.rotate(MovieEditorDialog.this.directors.subList(row, row + 2), -1);
                MovieEditorDialog.this.tableDirectors.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class MoveDirectorUpAction
    extends AbstractAction {
        private static final long serialVersionUID = 5775423424097844658L;

        public MoveDirectorUpAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.movedirectorup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableDirectors.getSelectedRow();
            if (row > 0) {
                Collections.rotate(MovieEditorDialog.this.directors.subList(row - 1, row + 1), 1);
                MovieEditorDialog.this.tableDirectors.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class RemoveDirectorAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079826920821356196L;

        public RemoveDirectorAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.director.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableDirectors.getSelectedRow();
            if (row > -1) {
                row = MovieEditorDialog.this.tableDirectors.convertRowIndexToModel(row);
                MovieEditorDialog.this.directors.remove(row);
            }
        }
    }

    private class AddDirectorAction
    extends AbstractAction {
        private static final long serialVersionUID = -8929331442958057771L;

        public AddDirectorAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.director.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Person person = new Person(Person.Type.DIRECTOR, BUNDLE.getString("director.name.unknown"), "Director");
            PersonEditorDialog dialog = new PersonEditorDialog(SwingUtilities.getWindowAncestor(MovieEditorDialog.this.tableDirectors), BUNDLE.getString("cast.director.add"), person);
            dialog.setVisible(true);
            if (StringUtils.isNotBlank((CharSequence)person.getName()) && !person.getName().equals(BUNDLE.getString("director.name.unknown"))) {
                MovieEditorDialog.this.directors.add(0, (Object)person);
            }
        }
    }

    private class MoveTagDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -1135108943010008069L;

        public MoveTagDownAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.movetagdown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.listTags.getSelectedIndex();
            if (row < MovieEditorDialog.this.tags.size() - 1) {
                Collections.rotate(MovieEditorDialog.this.tags.subList(row, row + 2), -1);
                MovieEditorDialog.this.listTags.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class MoveTagUpAction
    extends AbstractAction {
        private static final long serialVersionUID = -6855661707692602266L;

        public MoveTagUpAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.movetagup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.listTags.getSelectedIndex();
            if (row > 0) {
                Collections.rotate(MovieEditorDialog.this.tags.subList(row - 1, row + 1), 1);
                MovieEditorDialog.this.listTags.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class MoveGenreDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -1135108943010008069L;

        public MoveGenreDownAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.movegenredown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.listGenres.getSelectedIndex();
            if (row < MovieEditorDialog.this.genres.size() - 1) {
                Collections.rotate(MovieEditorDialog.this.genres.subList(row, row + 2), -1);
                MovieEditorDialog.this.listGenres.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class MoveGenreUpAction
    extends AbstractAction {
        private static final long serialVersionUID = -6855661707692602266L;

        public MoveGenreUpAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.movegenreup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.listGenres.getSelectedIndex();
            if (row > 0) {
                Collections.rotate(MovieEditorDialog.this.genres.subList(row - 1, row + 1), 1);
                MovieEditorDialog.this.listGenres.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class MoveProducerDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -1135108943010008069L;

        public MoveProducerDownAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.moveproducerdown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableProducers.getSelectedRow();
            if (row < MovieEditorDialog.this.producers.size() - 1) {
                Collections.rotate(MovieEditorDialog.this.producers.subList(row, row + 2), -1);
                MovieEditorDialog.this.tableProducers.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class MoveProducerUpAction
    extends AbstractAction {
        private static final long serialVersionUID = -6855661707692602266L;

        public MoveProducerUpAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.moveproducerup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableProducers.getSelectedRow();
            if (row > 0) {
                Collections.rotate(MovieEditorDialog.this.producers.subList(row - 1, row + 1), 1);
                MovieEditorDialog.this.tableProducers.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class MoveActorDownAction
    extends AbstractAction {
        private static final long serialVersionUID = -6564146895819191932L;

        public MoveActorDownAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.moveactordown"));
            this.putValue("SmallIcon", IconManager.ARROW_DOWN_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableActors.getSelectedRow();
            if (row < MovieEditorDialog.this.cast.size() - 1) {
                Collections.rotate(MovieEditorDialog.this.cast.subList(row, row + 2), -1);
                MovieEditorDialog.this.tableActors.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        }
    }

    private class MoveActorUpAction
    extends AbstractAction {
        private static final long serialVersionUID = 5775423424097844658L;

        public MoveActorUpAction() {
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.moveactorup"));
            this.putValue("SmallIcon", IconManager.ARROW_UP_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableActors.getSelectedRow();
            if (row > 0) {
                Collections.rotate(MovieEditorDialog.this.cast.subList(row - 1, row + 1), 1);
                MovieEditorDialog.this.tableActors.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        }
    }

    private class NavigateBackAction
    extends AbstractAction {
        private static final long serialVersionUID = -1652218154720642310L;

        public NavigateBackAction() {
            this.putValue("Name", BUNDLE.getString("Button.back"));
            this.putValue("SmallIcon", IconManager.BACK_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieEditorDialog.this.navigateBack = true;
            MovieEditorDialog.this.setVisible(false);
        }
    }

    private class AbortQueueAction
    extends AbstractAction {
        private static final long serialVersionUID = -7652218354710642510L;

        public AbortQueueAction() {
            this.putValue("Name", BUNDLE.getString("Button.abortqueue"));
            this.putValue("ShortDescription", BUNDLE.getString("movie.edit.abortqueue.desc"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieEditorDialog.this.continueQueue = false;
            MovieEditorDialog.this.setVisible(false);
        }
    }

    private class RemoveTagAction
    extends AbstractAction {
        private static final long serialVersionUID = -1580945350962234235L;

        public RemoveTagAction() {
            this.putValue("ShortDescription", BUNDLE.getString("tag.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List selectedTags = MovieEditorDialog.this.listTags.getSelectedValuesList();
            for (String tag : selectedTags) {
                MovieEditorDialog.this.tags.remove(tag);
            }
        }
    }

    private class AddTagAction
    extends AbstractAction {
        private static final long serialVersionUID = 9160043031922897785L;

        public AddTagAction() {
            this.putValue("ShortDescription", BUNDLE.getString("tag.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField tf;
            String selectedText;
            String newTag = (String)MovieEditorDialog.this.cbTags.getSelectedItem();
            if (StringUtils.isBlank((CharSequence)newTag)) {
                return;
            }
            Component editorComponent = MovieEditorDialog.this.cbTags.getEditor().getEditorComponent();
            if (editorComponent instanceof JTextField && (selectedText = (tf = (JTextField)editorComponent).getSelectedText()) != null) {
                tf.setSelectionStart(0);
                tf.setSelectionEnd(0);
                tf.setCaretPosition(tf.getText().length());
                return;
            }
            boolean tagFound = false;
            for (String tag : MovieEditorDialog.this.tags) {
                if (!tag.equals(newTag)) continue;
                tagFound = true;
                break;
            }
            if (!tagFound) {
                MovieEditorDialog.this.tags.add(newTag);
                if (editorComponent instanceof JTextField) {
                    MovieEditorDialog.this.cbTagsAutoCompleteSupport.setFirstItem((Object)"");
                    MovieEditorDialog.this.cbTags.setSelectedIndex(0);
                    MovieEditorDialog.this.cbTagsAutoCompleteSupport.removeFirstItem();
                }
            }
        }
    }

    private class RemoveTrailerAction
    extends AbstractAction {
        private static final long serialVersionUID = -6956921050689930101L;

        public RemoveTrailerAction() {
            this.putValue("ShortDescription", BUNDLE.getString("trailer.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableTrailer.getSelectedRow();
            if (row > -1) {
                row = MovieEditorDialog.this.tableTrailer.convertRowIndexToModel(row);
                MovieEditorDialog.this.trailers.remove(row);
            }
        }
    }

    private class AddTrailerAction
    extends AbstractAction {
        private static final long serialVersionUID = -4446154040952056823L;

        public AddTrailerAction() {
            this.putValue("ShortDescription", BUNDLE.getString("trailer.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieTrailer trailer = new MovieTrailer();
            trailer.setName("unknown");
            trailer.setProvider("unknown");
            trailer.setQuality("unknown");
            trailer.setUrl("http://");
            MovieEditorDialog.this.trailers.add(0, trailer);
        }
    }

    private class RemoveGenreAction
    extends AbstractAction {
        private static final long serialVersionUID = 2733654945906747720L;

        public RemoveGenreAction() {
            this.putValue("ShortDescription", BUNDLE.getString("genre.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List selectedGenres = MovieEditorDialog.this.listGenres.getSelectedValuesList();
            for (MediaGenres genre : selectedGenres) {
                MovieEditorDialog.this.genres.remove(genre);
            }
        }
    }

    private class AddGenreAction
    extends AbstractAction {
        private static final long serialVersionUID = 176474809593575743L;

        public AddGenreAction() {
            this.putValue("ShortDescription", BUNDLE.getString("genre.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTextField tf;
            String selectedText;
            MediaGenres newGenre = null;
            Object item = MovieEditorDialog.this.cbGenres.getSelectedItem();
            Component editorComponent = MovieEditorDialog.this.cbGenres.getEditor().getEditorComponent();
            if (editorComponent instanceof JTextField && (selectedText = (tf = (JTextField)editorComponent).getSelectedText()) != null) {
                tf.setSelectionStart(0);
                tf.setSelectionEnd(0);
                tf.setCaretPosition(tf.getText().length());
                return;
            }
            if (item instanceof MediaGenres) {
                newGenre = (MediaGenres)item;
            }
            if (item instanceof String) {
                newGenre = MediaGenres.getGenre((String)((String)item));
            }
            if (newGenre != null && !MovieEditorDialog.this.genres.contains(newGenre)) {
                MovieEditorDialog.this.genres.add(newGenre);
                if (editorComponent instanceof JTextField) {
                    MovieEditorDialog.this.cbGenresAutoCompleteSupport.setFirstItem(null);
                    MovieEditorDialog.this.cbGenres.setSelectedIndex(0);
                    MovieEditorDialog.this.cbGenresAutoCompleteSupport.removeFirstItem();
                }
            }
        }
    }

    private class RemoveProducerAction
    extends AbstractAction {
        private static final long serialVersionUID = -3907776089614305086L;

        public RemoveProducerAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.producer.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableProducers.getSelectedRow();
            if (row > -1) {
                row = MovieEditorDialog.this.tableProducers.convertRowIndexToModel(row);
                MovieEditorDialog.this.producers.remove(row);
            }
        }
    }

    private class AddProducerAction
    extends AbstractAction {
        private static final long serialVersionUID = -8834531637996987853L;

        public AddProducerAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.producer.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Person producer = new Person(Person.Type.PRODUCER, BUNDLE.getString("producer.name.unknown"), BUNDLE.getString("producer.role.unknown"));
            PersonEditorDialog dialog = new PersonEditorDialog(SwingUtilities.getWindowAncestor(MovieEditorDialog.this.tableProducers), BUNDLE.getString("cast.producer.add"), producer);
            dialog.setVisible(true);
            if (StringUtils.isNotBlank((CharSequence)producer.getName()) && !producer.getName().equals(BUNDLE.getString("producer.name.unknown"))) {
                MovieEditorDialog.this.producers.add(0, (Object)producer);
            }
        }
    }

    private class RemoveActorAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079826970827356996L;

        public RemoveActorAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.actor.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableActors.getSelectedRow();
            if (row > -1) {
                row = MovieEditorDialog.this.tableActors.convertRowIndexToModel(row);
                MovieEditorDialog.this.cast.remove(row);
            }
        }
    }

    private class AddActorAction
    extends AbstractAction {
        private static final long serialVersionUID = 2903255414153349267L;

        public AddActorAction() {
            this.putValue("ShortDescription", BUNDLE.getString("cast.actor.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Person actor = new Person(Person.Type.ACTOR, BUNDLE.getString("cast.actor.unknown"), BUNDLE.getString("cast.role.unknown"));
            PersonEditorDialog dialog = new PersonEditorDialog(SwingUtilities.getWindowAncestor(MovieEditorDialog.this.tableActors), BUNDLE.getString("cast.actor.add"), actor);
            dialog.setVisible(true);
            if (StringUtils.isNotBlank((CharSequence)actor.getName()) && !actor.getName().equals(BUNDLE.getString("cast.actor.unknown"))) {
                MovieEditorDialog.this.cast.add(0, (Object)actor);
            }
        }
    }

    private class RemoveIdAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079826950827356996L;

        public RemoveIdAction() {
            this.putValue("ShortDescription", BUNDLE.getString("id.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableIds.getSelectedRow();
            if (row > -1) {
                row = MovieEditorDialog.this.tableIds.convertRowIndexToModel(row);
                MovieEditorDialog.this.ids.remove(row);
            }
        }
    }

    private class AddIdAction
    extends AbstractAction {
        private static final long serialVersionUID = 2903255414553349267L;

        public AddIdAction() {
            this.putValue("ShortDescription", BUNDLE.getString("id.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaIdTable.MediaId mediaId = new MediaIdTable.MediaId();
            IdEditorDialog dialog = new IdEditorDialog(SwingUtilities.getWindowAncestor(MovieEditorDialog.this.tableIds), BUNDLE.getString("id.add"), mediaId, ScraperType.MOVIE);
            dialog.setVisible(true);
            if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{mediaId.key, mediaId.value})) {
                MovieEditorDialog.this.ids.add((Object)mediaId);
            }
        }
    }

    private class RemoveRatingAction
    extends AbstractAction {
        private static final long serialVersionUID = -7079821950827356996L;

        public RemoveRatingAction() {
            this.putValue("ShortDescription", BUNDLE.getString("rating.remove"));
            this.putValue("SmallIcon", IconManager.REMOVE_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int row = MovieEditorDialog.this.tableRatings.getSelectedRow();
            if (row > -1) {
                row = MovieEditorDialog.this.tableRatings.convertRowIndexToModel(row);
                MovieEditorDialog.this.ratings.remove(row);
            }
        }
    }

    private class AddRatingAction
    extends AbstractAction {
        private static final long serialVersionUID = 2903255414533349267L;

        public AddRatingAction() {
            this.putValue("ShortDescription", BUNDLE.getString("rating.add"));
            this.putValue("SmallIcon", IconManager.ADD_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MediaRatingTable.MediaRating mediaRating = new MediaRatingTable.MediaRating("");
            mediaRating.maxValue = 10;
            mediaRating.votes = 1;
            RatingEditorDialog dialog = new RatingEditorDialog(SwingUtilities.getWindowAncestor(MovieEditorDialog.this.tableRatings), BUNDLE.getString("rating.add"), mediaRating);
            dialog.setVisible(true);
            if (StringUtils.isNotBlank((CharSequence)mediaRating.key) && mediaRating.value > 0.0f && mediaRating.maxValue > 0 && mediaRating.votes > 0) {
                MovieEditorDialog.this.ratings.add((Object)mediaRating);
            }
        }
    }

    private class DiscardAction
    extends AbstractAction {
        private static final long serialVersionUID = -5581329896797961536L;

        public DiscardAction() {
            this.putValue("Name", BUNDLE.getString("Button.cancel"));
            this.putValue("ShortDescription", BUNDLE.getString("edit.discard"));
            this.putValue("SmallIcon", IconManager.CANCEL_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieEditorDialog.this.setVisible(false);
        }
    }

    private class ChangeMovieAction
    extends AbstractAction {
        private static final long serialVersionUID = -3767744690599233490L;

        public ChangeMovieAction() {
            this.putValue("Name", BUNDLE.getString("Button.ok"));
            this.putValue("ShortDescription", BUNDLE.getString("movie.change"));
            this.putValue("SmallIcon", IconManager.APPLY_INV);
            this.putValue("SwingLargeIconKey", IconManager.APPLY_INV);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            MovieEditorDialog.this.movieToEdit.setTitle(MovieEditorDialog.this.tfTitle.getText());
            MovieEditorDialog.this.movieToEdit.setOriginalTitle(MovieEditorDialog.this.tfOriginalTitle.getText());
            MovieEditorDialog.this.movieToEdit.setTagline(MovieEditorDialog.this.tfTagline.getText());
            MovieEditorDialog.this.movieToEdit.setPlot(MovieEditorDialog.this.taPlot.getText());
            MovieEditorDialog.this.movieToEdit.setYear((Integer)MovieEditorDialog.this.spYear.getValue());
            MovieEditorDialog.this.movieToEdit.setReleaseDate(MovieEditorDialog.this.dpReleaseDate.getDate());
            MovieEditorDialog.this.movieToEdit.setRuntime((Integer)MovieEditorDialog.this.spRuntime.getValue());
            MovieEditorDialog.this.movieToEdit.setTop250((Integer)MovieEditorDialog.this.spTop250.getValue());
            MovieEditorDialog.this.movieToEdit.setWatched(MovieEditorDialog.this.cbWatched.isSelected());
            MovieEditorDialog.this.movieToEdit.setSpokenLanguages(MovieEditorDialog.this.tfSpokenLanguages.getText());
            MovieEditorDialog.this.movieToEdit.setCountry(MovieEditorDialog.this.tfCountry.getText());
            MovieEditorDialog.this.movieToEdit.setVideoIn3D(MovieEditorDialog.this.chckbxVideo3D.isSelected());
            MovieEditorDialog.this.movieToEdit.setNote(MovieEditorDialog.this.tfNote.getText());
            Object movieEdition = MovieEditorDialog.this.cbEdition.getSelectedItem();
            if (movieEdition instanceof MovieEdition) {
                MovieEditorDialog.this.movieToEdit.setEdition((MovieEdition)((Object)movieEdition));
            } else if (movieEdition instanceof String) {
                MovieEditorDialog.this.movieToEdit.setEdition(MovieEdition.getMovieEdition((String)movieEdition));
            } else {
                MovieEditorDialog.this.movieToEdit.setEdition(MovieEdition.NONE);
            }
            Object mediaSource = MovieEditorDialog.this.cbSource.getSelectedItem();
            if (mediaSource instanceof MediaSource) {
                MovieEditorDialog.this.movieToEdit.setMediaSource((MediaSource)((Object)mediaSource));
            } else if (mediaSource instanceof String) {
                MovieEditorDialog.this.movieToEdit.setMediaSource(MediaSource.getMediaSource((String)mediaSource));
            } else {
                MovieEditorDialog.this.movieToEdit.setMediaSource(MediaSource.UNKNOWN);
            }
            for (Iterator id : MovieEditorDialog.this.ids) {
                try {
                    Integer n = Integer.parseInt(((MediaIdTable.MediaId)((Object)id)).value);
                    MovieEditorDialog.this.movieToEdit.setId(((MediaIdTable.MediaId)((Object)id)).key, n);
                }
                catch (NumberFormatException numberFormatException) {
                    MovieEditorDialog.this.movieToEdit.setId(((MediaIdTable.MediaId)((Object)id)).key, ((MediaIdTable.MediaId)((Object)id)).value);
                }
            }
            ArrayList removeIds = new ArrayList();
            for (Map.Entry entry : MovieEditorDialog.this.movieToEdit.getIds().entrySet()) {
                MediaIdTable.MediaId id = new MediaIdTable.MediaId((String)entry.getKey());
                if (MovieEditorDialog.this.ids.contains((Object)id)) continue;
                removeIds.add(entry.getKey());
            }
            for (String string : removeIds) {
                MovieEditorDialog.this.movieToEdit.setId(string, null);
            }
            Object certification = MovieEditorDialog.this.cbCertification.getSelectedItem();
            if (certification instanceof Certification) {
                MovieEditorDialog.this.movieToEdit.setCertification((Certification)certification);
            }
            MediaFileEditorPanel.syncMediaFiles(MovieEditorDialog.this.mediaFiles, MovieEditorDialog.this.movieToEdit.getMediaFiles());
            MovieEditorDialog.this.movieToEdit.fireEventForChangedMediaInformation();
            if (StringUtils.isNotEmpty((CharSequence)MovieEditorDialog.this.tfPoster.getText()) && !MovieEditorDialog.this.tfPoster.getText().equals(MovieEditorDialog.this.movieToEdit.getArtworkUrl(MediaFileType.POSTER))) {
                MovieEditorDialog.this.movieToEdit.setArtworkUrl(MovieEditorDialog.this.tfPoster.getText(), MediaFileType.POSTER);
                MovieEditorDialog.this.movieToEdit.downloadArtwork(MediaFileType.POSTER);
            } else if (StringUtils.isEmpty((CharSequence)MovieEditorDialog.this.tfPoster.getText())) {
                MovieEditorDialog.this.movieToEdit.removeArtworkUrl(MediaFileType.POSTER);
            }
            if (StringUtils.isNotEmpty((CharSequence)MovieEditorDialog.this.tfFanart.getText()) && !MovieEditorDialog.this.tfFanart.getText().equals(MovieEditorDialog.this.movieToEdit.getArtworkUrl(MediaFileType.FANART))) {
                MovieEditorDialog.this.movieToEdit.setArtworkUrl(MovieEditorDialog.this.tfFanart.getText(), MediaFileType.FANART);
                MovieEditorDialog.this.movieToEdit.downloadArtwork(MediaFileType.FANART);
            } else if (StringUtils.isEmpty((CharSequence)MovieEditorDialog.this.tfFanart.getText())) {
                MovieEditorDialog.this.movieToEdit.removeArtworkUrl(MediaFileType.FANART);
            }
            if (StringUtils.isNotEmpty((CharSequence)MovieEditorDialog.this.tfLogo.getText()) && !MovieEditorDialog.this.tfLogo.getText().equals(MovieEditorDialog.this.movieToEdit.getArtworkUrl(MediaFileType.LOGO))) {
                MovieEditorDialog.this.movieToEdit.setArtworkUrl(MovieEditorDialog.this.tfLogo.getText(), MediaFileType.LOGO);
                MovieEditorDialog.this.movieToEdit.downloadArtwork(MediaFileType.LOGO);
            } else if (StringUtils.isEmpty((CharSequence)MovieEditorDialog.this.tfLogo.getText())) {
                MovieEditorDialog.this.movieToEdit.removeArtworkUrl(MediaFileType.LOGO);
            }
            if (StringUtils.isNotEmpty((CharSequence)MovieEditorDialog.this.tfClearLogo.getText()) && !MovieEditorDialog.this.tfClearLogo.getText().equals(MovieEditorDialog.this.movieToEdit.getArtworkUrl(MediaFileType.CLEARLOGO))) {
                MovieEditorDialog.this.movieToEdit.setArtworkUrl(MovieEditorDialog.this.tfClearLogo.getText(), MediaFileType.CLEARLOGO);
                MovieEditorDialog.this.movieToEdit.downloadArtwork(MediaFileType.CLEARLOGO);
            } else if (StringUtils.isEmpty((CharSequence)MovieEditorDialog.this.tfClearLogo.getText())) {
                MovieEditorDialog.this.movieToEdit.removeArtworkUrl(MediaFileType.CLEARLOGO);
            }
            if (StringUtils.isNotEmpty((CharSequence)MovieEditorDialog.this.tfBanner.getText()) && !MovieEditorDialog.this.tfBanner.getText().equals(MovieEditorDialog.this.movieToEdit.getArtworkUrl(MediaFileType.BANNER))) {
                MovieEditorDialog.this.movieToEdit.setArtworkUrl(MovieEditorDialog.this.tfBanner.getText(), MediaFileType.BANNER);
                MovieEditorDialog.this.movieToEdit.downloadArtwork(MediaFileType.BANNER);
            } else if (StringUtils.isEmpty((CharSequence)MovieEditorDialog.this.tfBanner.getText())) {
                MovieEditorDialog.this.movieToEdit.removeArtworkUrl(MediaFileType.BANNER);
            }
            if (StringUtils.isNotEmpty((CharSequence)MovieEditorDialog.this.tfClearArt.getText()) && !MovieEditorDialog.this.tfClearArt.getText().equals(MovieEditorDialog.this.movieToEdit.getArtworkUrl(MediaFileType.CLEARART))) {
                MovieEditorDialog.this.movieToEdit.setArtworkUrl(MovieEditorDialog.this.tfClearArt.getText(), MediaFileType.CLEARART);
                MovieEditorDialog.this.movieToEdit.downloadArtwork(MediaFileType.CLEARART);
            } else if (StringUtils.isEmpty((CharSequence)MovieEditorDialog.this.tfClearArt.getText())) {
                MovieEditorDialog.this.movieToEdit.removeArtworkUrl(MediaFileType.CLEARART);
            }
            if (StringUtils.isNotEmpty((CharSequence)MovieEditorDialog.this.tfThumb.getText()) && !MovieEditorDialog.this.tfThumb.getText().equals(MovieEditorDialog.this.movieToEdit.getArtworkUrl(MediaFileType.THUMB))) {
                MovieEditorDialog.this.movieToEdit.setArtworkUrl(MovieEditorDialog.this.tfThumb.getText(), MediaFileType.THUMB);
                MovieEditorDialog.this.movieToEdit.downloadArtwork(MediaFileType.THUMB);
            } else if (StringUtils.isEmpty((CharSequence)MovieEditorDialog.this.tfThumb.getText())) {
                MovieEditorDialog.this.movieToEdit.removeArtworkUrl(MediaFileType.THUMB);
            }
            if (StringUtils.isNotEmpty((CharSequence)MovieEditorDialog.this.tfDisc.getText()) && !MovieEditorDialog.this.tfDisc.getText().equals(MovieEditorDialog.this.movieToEdit.getArtworkUrl(MediaFileType.DISC))) {
                MovieEditorDialog.this.movieToEdit.setArtworkUrl(MovieEditorDialog.this.tfDisc.getText(), MediaFileType.DISC);
                MovieEditorDialog.this.movieToEdit.downloadArtwork(MediaFileType.DISC);
            } else if (StringUtils.isEmpty((CharSequence)MovieEditorDialog.this.tfDisc.getText())) {
                MovieEditorDialog.this.movieToEdit.removeArtworkUrl(MediaFileType.DISC);
            }
            if (StringUtils.isNotEmpty((CharSequence)MovieEditorDialog.this.tfKeyart.getText()) && !MovieEditorDialog.this.tfKeyart.getText().equals(MovieEditorDialog.this.movieToEdit.getArtworkUrl(MediaFileType.KEYART))) {
                MovieEditorDialog.this.movieToEdit.setArtworkUrl(MovieEditorDialog.this.tfKeyart.getText(), MediaFileType.KEYART);
                MovieEditorDialog.this.movieToEdit.downloadArtwork(MediaFileType.KEYART);
            } else if (StringUtils.isEmpty((CharSequence)MovieEditorDialog.this.tfKeyart.getText())) {
                MovieEditorDialog.this.movieToEdit.removeArtworkUrl(MediaFileType.KEYART);
            }
            if (!(MovieEditorDialog.this.extrathumbs == null || MovieEditorDialog.this.extrathumbs.size() == MovieEditorDialog.this.movieToEdit.getExtraThumbs().size() && MovieEditorDialog.this.extrathumbs.containsAll(MovieEditorDialog.this.movieToEdit.getExtraThumbs()) && MovieEditorDialog.this.movieToEdit.getExtraThumbs().containsAll(MovieEditorDialog.this.extrathumbs))) {
                MovieEditorDialog.this.movieToEdit.setExtraThumbs(MovieEditorDialog.this.extrathumbs);
                MovieEditorDialog.this.movieToEdit.downloadArtwork(MediaFileType.EXTRATHUMB);
            }
            if (!(MovieEditorDialog.this.extrafanarts == null || MovieEditorDialog.this.extrafanarts.size() == MovieEditorDialog.this.movieToEdit.getExtraFanarts().size() && MovieEditorDialog.this.extrafanarts.containsAll(MovieEditorDialog.this.movieToEdit.getExtraFanarts()) && MovieEditorDialog.this.movieToEdit.getExtraFanarts().containsAll(MovieEditorDialog.this.extrafanarts))) {
                MovieEditorDialog.this.movieToEdit.setExtraFanarts(MovieEditorDialog.this.extrafanarts);
                MovieEditorDialog.this.movieToEdit.downloadArtwork(MediaFileType.EXTRAFANART);
            }
            MovieEditorDialog.this.movieToEdit.setProductionCompany(MovieEditorDialog.this.tfProductionCompanies.getText());
            MovieEditorDialog.this.movieToEdit.setActors((List<Person>)MovieEditorDialog.this.cast);
            MovieEditorDialog.this.movieToEdit.setProducers((List<Person>)MovieEditorDialog.this.producers);
            MovieEditorDialog.this.movieToEdit.setDirectors((List<Person>)MovieEditorDialog.this.directors);
            MovieEditorDialog.this.movieToEdit.setWriters((List<Person>)MovieEditorDialog.this.writers);
            MovieEditorDialog.this.movieToEdit.setGenres(MovieEditorDialog.this.genres);
            MovieEditorDialog.this.movieToEdit.removeAllTrailers();
            for (MovieTrailer trailer : MovieEditorDialog.this.trailers) {
                MovieEditorDialog.this.movieToEdit.addTrailer(trailer);
            }
            MovieEditorDialog.this.movieToEdit.setTags(MovieEditorDialog.this.tags);
            MovieEditorDialog.this.movieToEdit.setDateAdded((Date)MovieEditorDialog.this.spDateAdded.getValue());
            MovieEditorDialog.this.movieToEdit.setSortTitle(MovieEditorDialog.this.tfSorttitle.getText());
            Object object = MovieEditorDialog.this.cbMovieSet.getSelectedItem();
            if (object instanceof String) {
                MovieEditorDialog.this.movieToEdit.removeFromMovieSet();
            }
            if (object instanceof MovieSet) {
                MovieSet movieSet = (MovieSet)object;
                if (MovieEditorDialog.this.movieToEdit.getMovieSet() != movieSet) {
                    MovieEditorDialog.this.movieToEdit.removeFromMovieSet();
                    MovieEditorDialog.this.movieToEdit.setMovieSet(movieSet);
                    movieSet.insertMovie(MovieEditorDialog.this.movieToEdit);
                }
            }
            HashMap<String, Rating> newRatings = new HashMap<String, Rating>();
            if ((Double)MovieEditorDialog.this.spRating.getValue() > 0.0) {
                newRatings.put("user", new Rating("user", (Double)MovieEditorDialog.this.spRating.getValue(), 1, 10));
            }
            for (MediaRatingTable.MediaRating mediaRating : MovieEditorDialog.this.ratings) {
                if (!StringUtils.isNotBlank((CharSequence)mediaRating.key) || !(mediaRating.value > 0.0f)) continue;
                newRatings.put(mediaRating.key, new Rating(mediaRating.key, mediaRating.value, mediaRating.votes, mediaRating.maxValue));
            }
            MovieEditorDialog.this.movieToEdit.setRatings(newRatings);
            MovieEditorDialog.this.movieToEdit.writeNFO();
            MovieEditorDialog.this.movieToEdit.saveToDb();
            if (MovieModuleManager.SETTINGS.getSyncTrakt()) {
                SyncTraktTvTask task = new SyncTraktTvTask(Collections.singletonList(MovieEditorDialog.this.movieToEdit), null);
                TmmTaskManager.getInstance().addUnnamedTask(task);
            }
            MovieEditorDialog.this.setVisible(false);
        }
    }
}

