/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractMovieUIFilter;

public class MovieCastFilter
extends AbstractMovieUIFilter {
    private JTextField textField;

    @Override
    public String getId() {
        return "movieCast";
    }

    @Override
    public String getFilterValueAsString() {
        return this.textField.getText();
    }

    @Override
    public void setFilterValue(Object value) {
        if (value instanceof String) {
            this.textField.setText((String)value);
        }
    }

    @Override
    public boolean accept(Movie movie) {
        Matcher matcher;
        String name = this.textField.getText();
        if (StringUtils.isBlank((CharSequence)name)) {
            return true;
        }
        Pattern pattern = Pattern.compile("(?i)" + Pattern.quote(name));
        for (Person director : movie.getDirectors()) {
            if (!StringUtils.isNotEmpty((CharSequence)director.getName()) || !(matcher = pattern.matcher(director.getName())).find()) continue;
            return true;
        }
        for (Person writer : movie.getWriters()) {
            if (!StringUtils.isNotEmpty((CharSequence)writer.getName()) || !(matcher = pattern.matcher(writer.getName())).find()) continue;
            return true;
        }
        for (Person cast : movie.getActors()) {
            if (!StringUtils.isNotEmpty((CharSequence)cast.getName()) || !(matcher = pattern.matcher(cast.getName())).find()) continue;
            return true;
        }
        for (Person producer : movie.getProducers()) {
            if (!StringUtils.isNotEmpty((CharSequence)producer.getName()) || !(matcher = pattern.matcher(producer.getName())).find()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(BUNDLE.getString("movieextendedsearch.cast"));
    }

    @Override
    protected JComponent createFilterComponent() {
        this.textField = new JTextField();
        return this.textField;
    }
}

